/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.adminserver;

import java.security.AccessController;
import java.security.PrivilegedAction;
import weblogic.deploy.beans.factory.DeploymentBeanFactory;
import weblogic.deploy.common.Debug;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.EditChangesValidationException;
import weblogic.management.provider.EditFailedException;
import weblogic.management.provider.EditNotEditorException;
import weblogic.management.provider.EditSaveChangesFailedException;
import weblogic.management.provider.EditWaitTimedOutException;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.StackTraceUtils;

public final class EditAccessHelper {
    private final EditAccess delegate = ManagementServiceRestricted.getEditAccess(kernelId);
    private static final int MAX_EDIT_SESSION_DURATION = 120000;
    private static final int MAX_WAIT_TIME_TO_ACQUIRE_EDIT_SESSION = 0;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    private EditAccessHelper() {
    }

    public static EditAccessHelper getInstance(AuthenticatedSubject authenticatedSubject) {
        SecurityServiceManager.checkKernelIdentity((AuthenticatedSubject)authenticatedSubject);
        return Maker.HELPER;
    }

    public final boolean isEditorExclusive() {
        return this.delegate.isEditorExclusive();
    }

    public final long getEditorExpirationTime() {
        return this.delegate.getEditorExpirationTime();
    }

    public final boolean isPendingChange() {
        return this.delegate.isPendingChange();
    }

    public final DomainMBean startEditSession(boolean bl) throws ManagementException {
        DomainMBean domainMBean;
        try {
            domainMBean = this.delegate.startEdit(0, 120000, bl);
        }
        catch (EditWaitTimedOutException editWaitTimedOutException) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Failed to get an edit session lock: " + editWaitTimedOutException.toString());
            }
            throw editWaitTimedOutException;
        }
        catch (EditFailedException editFailedException) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Failed to get an edit session: " + editFailedException.toString());
            }
            throw editFailedException;
        }
        return domainMBean;
    }

    public final void saveEditSessionChanges() throws ManagementException {
        try {
            this.delegate.saveChanges();
        }
        catch (EditNotEditorException editNotEditorException) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Tried to save an edit session when not holding the edit lock: " + editNotEditorException.toString());
            }
            throw editNotEditorException;
        }
        catch (EditSaveChangesFailedException editSaveChangesFailedException) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Attempt to save changes of an edit session failed: " + editSaveChangesFailedException.toString());
            }
            throw editSaveChangesFailedException;
        }
        catch (EditChangesValidationException editChangesValidationException) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Validation when attempting to save edit session changes failed: " + editChangesValidationException.toString());
            }
            throw editChangesValidationException;
        }
    }

    public final void activateEditSessionChanges(long l) throws ManagementException {
        try {
            this.delegate.activateChanges(l);
        }
        catch (EditNotEditorException editNotEditorException) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Tried to activate an edit session when not holding the edit lock: " + editNotEditorException.toString());
            }
            throw editNotEditorException;
        }
        catch (EditFailedException editFailedException) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Attempt to activate changes of an edit session failed: " + editFailedException.toString());
            }
            throw editFailedException;
        }
    }

    public final void stopEditSession(AuthenticatedSubject authenticatedSubject) throws ManagementException {
        if (!this.isCurrentEditor(authenticatedSubject)) {
            return;
        }
        Object object = SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                ManagementException managementException = null;
                try {
                    EditAccessHelper.this.delegate.stopEdit();
                }
                catch (EditNotEditorException editNotEditorException) {
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("Tried to stop an edit session when not holding the edit lock: " + editNotEditorException.toString());
                    }
                    managementException = editNotEditorException;
                }
                catch (EditFailedException editFailedException) {
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("Edit session failure when attempting to stop an edit session: " + editFailedException.toString());
                    }
                    managementException = editFailedException;
                }
                return managementException;
            }
        });
        if (object instanceof ManagementException) {
            throw (ManagementException)((Object)object);
        }
    }

    public final void cancelActivateSession(AuthenticatedSubject authenticatedSubject) throws ManagementException {
        if (!this.isCurrentEditor(authenticatedSubject)) {
            return;
        }
        Object object = SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                ManagementException managementException = null;
                try {
                    EditAccessHelper.this.delegate.cancelActivate();
                }
                catch (Throwable throwable) {
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("Edit session failure when attempting to cancel activate session: " + throwable.toString());
                    }
                    managementException = throwable instanceof ManagementException ? (ManagementException)throwable : new ManagementException(throwable.getMessage(), throwable);
                }
                return managementException;
            }
        });
        if (object instanceof ManagementException) {
            throw (ManagementException)((Object)object);
        }
    }

    public final void cancelEditSession(AuthenticatedSubject authenticatedSubject) {
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Object var1_1;
                block2: {
                    var1_1 = null;
                    try {
                        EditAccessHelper.this.delegate.cancelEdit();
                    }
                    catch (EditFailedException editFailedException) {
                        if (!Debug.isDeploymentDebugEnabled()) break block2;
                        Debug.deploymentDebug("Edit session failure when attempting  to cancel an edit session: " + editFailedException.toString());
                    }
                }
                return var1_1;
            }
        });
    }

    public final void undoUnactivatedChanges(AuthenticatedSubject authenticatedSubject) throws ManagementException {
        Object object = SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                ManagementException managementException = null;
                try {
                    EditAccessHelper.this.delegate.undoUnactivatedChanges();
                }
                catch (EditFailedException editFailedException) {
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("Edit session failure when attempting to undo unactivated changes of an edit session: " + editFailedException.toString());
                    }
                    managementException = editFailedException;
                }
                catch (EditNotEditorException editNotEditorException) {
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("Edit session failure when attempting to undo unactivated changes of an edit session: " + editNotEditorException.toString());
                    }
                    managementException = editNotEditorException;
                }
                return managementException;
            }
        });
        if (object instanceof ManagementException) {
            throw (ManagementException)((Object)object);
        }
    }

    public final boolean isCurrentEditor(AuthenticatedSubject authenticatedSubject) {
        String string = this.delegate.getEditor();
        if (string == null) {
            return false;
        }
        return authenticatedSubject != null && string.equals(SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject));
    }

    private final DomainMBean getEditDomainBean() {
        block4: {
            try {
                return this.delegate.getDomainBean();
            }
            catch (EditNotEditorException editNotEditorException) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("Edit session failure when attempting to retrieve the domain mbean: " + editNotEditorException.toString());
                }
            }
            catch (EditFailedException editFailedException) {
                if (!Debug.isDeploymentDebugEnabled()) break block4;
                Debug.deploymentDebug("Edit session failure when attempting to retrieve the domain mbean: " + editFailedException.toString());
            }
        }
        return null;
    }

    public final DomainMBean getEditDomainBean(AuthenticatedSubject authenticatedSubject) {
        if (this.isCurrentEditor(authenticatedSubject)) {
            return this.getEditDomainBean();
        }
        return null;
    }

    public void rollback(final AppDeploymentMBean appDeploymentMBean, final DeploymentBeanFactory deploymentBeanFactory, final AuthenticatedSubject authenticatedSubject) {
        Object object = SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Object var1_1 = null;
                DomainMBean domainMBean = EditAccessHelper.this.getEditDomainBean(authenticatedSubject);
                if (domainMBean == null) {
                    return var1_1;
                }
                try {
                    try {
                        deploymentBeanFactory.setEditableDomain(domainMBean, true);
                        deploymentBeanFactory.removeMBean(appDeploymentMBean);
                    }
                    catch (ManagementException managementException) {
                        Debug.deploymentLogger.debug("Failed to remove mbeans for failed deployment of : " + appDeploymentMBean.getName() + " due to " + StackTraceUtils.throwable2StackTrace((Throwable)managementException));
                        Object var5_4 = null;
                        deploymentBeanFactory.resetEditableDomain();
                    }
                    Object var5_3 = null;
                    deploymentBeanFactory.resetEditableDomain();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    deploymentBeanFactory.resetEditableDomain();
                    throw throwable;
                }
                return var1_1;
            }
        });
    }

    static final class Maker {
        static final EditAccessHelper HELPER = new EditAccessHelper();

        Maker() {
        }
    }
}

