/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.adminserver.operations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import weblogic.application.ApplicationFileManager;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.InstallDir;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.config.DescriptorParser;
import weblogic.deploy.api.tools.ModuleInfo;
import weblogic.deploy.api.tools.SessionHelper;
import weblogic.deploy.beans.factory.DeploymentBeanFactory;
import weblogic.deploy.beans.factory.InvalidTargetException;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.Deployment;
import weblogic.deploy.internal.adminserver.DeploymentManager;
import weblogic.deploy.internal.adminserver.EditAccessHelper;
import weblogic.deploy.internal.adminserver.operations.ActivateOperation;
import weblogic.deploy.internal.adminserver.operations.DistributeOperation;
import weblogic.deploy.internal.adminserver.operations.OperationHelper;
import weblogic.deploy.internal.adminserver.operations.RedeployOperation;
import weblogic.deploy.internal.adminserver.operations.RemoveOperation;
import weblogic.deploy.internal.adminserver.operations.UpdateOperation;
import weblogic.deploy.service.datatransferhandlers.SourceCache;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.jms.module.DefaultingHelper;
import weblogic.logging.Loggable;
import weblogic.management.ApplicationException;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.DeploymentTaskRuntime;
import weblogic.management.deploy.internal.DeployerRuntimeImpl;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.DeploymentServerService;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public abstract class AbstractOperation {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final weblogic.application.DeploymentManager appDeploymentManager = weblogic.application.DeploymentManager.getDeploymentManager();
    protected static final DeploymentManager deploymentManager = DeploymentManager.getInstance(kernelId);
    protected final DeploymentBeanFactory beanFactory = DeploymentServerService.getDeploymentBeanFactory();
    protected int taskType;
    protected DeploymentTaskRuntimeMBean deploymentTask = null;
    protected Deployment deployment = null;
    protected final EditAccessHelper editAccessHelper = deploymentManager.getEditAccessHelper(kernelId);
    protected boolean controlOperation = false;
    protected File moduleArchive;
    protected File plan;
    protected DeploymentPlanBean planBean;
    protected InstallDir paths;
    protected DeploymentOptions options;
    private AuthenticatedSubject authSubject;
    private static int nextDelegateId = 0;
    private static final String DELEGATE_PREFIX = "_DELEGATE_";

    AbstractOperation() {
    }

    protected boolean isRemote(DeploymentData deploymentData) {
        return deploymentData.isRemote();
    }

    protected boolean isThinClient(DeploymentData deploymentData) {
        return deploymentData.isThinClient();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeploymentTaskRuntimeMBean execute(String string, String string2, String string3, DeploymentData deploymentData, String string4, boolean bl, AuthenticatedSubject authenticatedSubject) throws ManagementException {
        this.authSubject = authenticatedSubject;
        if (this.isRemote(deploymentData) || this.isThinClient(deploymentData)) {
            if (string != null) {
                this.moduleArchive = new File(string);
            }
            if (deploymentData.getDeploymentPlan() != null) {
                this.plan = new File(ConfigHelper.normalize(deploymentData.getDeploymentPlan()));
            }
            this.options = deploymentData.getDeploymentOptions();
            this.parsePlan();
            if (this.moduleArchive != null) {
                string2 = ConfigHelper.getAppName(this.options, this.moduleArchive, this.planBean);
            }
            this.setupPaths(string2);
            if (this.paths != null) {
                if (this.paths.getPlan() != null) {
                    deploymentData.setDeploymentPlan(this.paths.getPlan().getPath());
                }
                deploymentData.setConfigDirectory(this.paths.getConfigDir().getPath());
                deploymentData.setRootDirectory(this.paths.getInstallDir().getPath());
            }
            this.setVersionInfo(string2);
            this.setupDDPaths(deploymentData);
        }
        if (this.isControlOperation()) {
            return this.executeControlOperation(string, string2, string3, deploymentData, string4, bl, authenticatedSubject);
        }
        boolean bl2 = this.editAccessHelper.isCurrentEditor(authenticatedSubject);
        long l = this.editAccessHelper.getEditorExpirationTime();
        if (bl2 && l > 0L && l < System.currentTimeMillis() && (deploymentData == null || deploymentData.getDeploymentOptions() == null || !deploymentData.getDeploymentOptions().usesExpiredLock())) {
            bl2 = false;
        }
        boolean bl3 = deploymentData != null && deploymentData.usesNonExclusiveLock();
        boolean bl4 = this.editAccessHelper.isEditorExclusive();
        boolean bl5 = false;
        if (AbstractOperation.isDebugEnabled()) {
            this.debugSay("Deployment operation lock settings:  acquire lock in non-exclusive mode?: " + bl3 + ", caller owns lock?: " + bl2 + "', as exclusive editor:? " + bl4);
        }
        boolean bl6 = false;
        try {
            DeploymentOptions deploymentOptions;
            DomainMBean domainMBean;
            if (bl2) {
                if (bl4) {
                    String string5 = DeployerRuntimeLogger.exclusiveModeLock();
                    throw new ManagementException(string5);
                }
                domainMBean = this.editAccessHelper.getEditDomainBean(authenticatedSubject);
                if (!bl3) {
                    String string6 = DeployerRuntimeLogger.nonExclusiveModeLock();
                    throw new ManagementException(string6);
                }
                bl5 = true;
            } else {
                if (AbstractOperation.isDebugEnabled()) {
                    this.debugSay("Caller does not own edit lock - deployment subsystem acquiring edit lock in exlusive mode for " + string2);
                }
                domainMBean = this.editAccessHelper.startEditSession(!bl3);
            }
            this.beanFactory.setEditableDomain(domainMBean, bl2);
            AppDeploymentMBean appDeploymentMBean = this.updateConfigurationAndInitializeDeployment(string, string2, string3, deploymentData, string4, domainMBean, authenticatedSubject, bl2);
            if (appDeploymentMBean.isAutoDeployedApp() && deploymentData != null && !(deploymentOptions = deploymentData.getDeploymentOptions()).isOperationInitiatedByAutoDeployPoller()) {
                throw new DeploymentException(this.getAutoDeployErrorMsg(appDeploymentMBean.getName()));
            }
            this.postTaskCreationConfigurationUpdate(appDeploymentMBean, string2, this.deploymentTask.getDeploymentData());
            if (bl5) {
                ((DeploymentTaskRuntime)this.deploymentTask).setPendingActivation(true);
            }
            if (bl2) {
                this.mergeWithExistingOperationsOnSameApp();
            }
            if (!bl2 || bl5) {
                this.editAccessHelper.saveEditSessionChanges();
            }
            if (!bl2) {
                this.editAccessHelper.activateEditSessionChanges(deploymentData.getTimeOut());
            }
            this.beanFactory.resetEditableDomain();
            if (!bl2 && bl) {
                bl6 = true;
                this.deploymentTask.start();
            }
            return this.deploymentTask;
        }
        catch (Throwable throwable) {
            if (!bl6) {
                deploymentManager.deploymentFailedBeforeStart(this.deployment, throwable, bl2, authenticatedSubject, this.controlOperation);
            }
            if (this.deployment == null) {
                OperationHelper.logTaskFailed(string2, this.taskType, throwable);
            }
            if (throwable instanceof ManagementException) {
                throw (ManagementException)throwable;
            }
            throw new ManagementException(throwable);
        }
    }

    public DeploymentTaskRuntime getTaskRuntime() {
        return (DeploymentTaskRuntime)this.deploymentTask;
    }

    public void rollback(AuthenticatedSubject authenticatedSubject) {
    }

    protected String getAutoDeployErrorMsg(String string) {
        return string;
    }

    protected DeploymentTaskRuntimeMBean executeControlOperation(String string, String string2, String string3, DeploymentData deploymentData, String string4, boolean bl, AuthenticatedSubject authenticatedSubject) throws ManagementException {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        boolean bl2 = false;
        try {
            this.updateConfigurationAndInitializeDeployment(string, string2, string3, deploymentData, string4, domainMBean, authenticatedSubject, false);
            if (bl) {
                bl2 = true;
                this.deploymentTask.start();
            }
            return this.deploymentTask;
        }
        catch (Throwable throwable) {
            if (!bl2) {
                deploymentManager.deploymentFailedBeforeStart(this.deployment, throwable, false, authenticatedSubject, this.controlOperation);
            }
            if (this.deployment == null) {
                OperationHelper.logTaskFailed(string2, this.taskType, throwable);
            }
            if (throwable instanceof ManagementException) {
                throw (ManagementException)throwable;
            }
            throw new ManagementException(throwable);
        }
    }

    private AppDeploymentMBean updateConfigurationAndInitializeDeployment(String string, String string2, String string3, DeploymentData deploymentData, String string4, DomainMBean domainMBean, AuthenticatedSubject authenticatedSubject, boolean bl) throws ManagementException {
        string = OperationHelper.normalizePaths(string, deploymentData);
        if (deploymentData.getDeploymentOptions() != null && deploymentData.getDeploymentOptions().isDefaultSubmoduleTargets()) {
            this.defaultSubModuleTargets(string2, string, deploymentData, domainMBean);
        }
        AppDeploymentMBean appDeploymentMBean = this.updateConfiguration(string, string2, string3, deploymentData, string4, bl);
        AbstractOperation.doDeploymentTypeValidations(domainMBean, string2, deploymentData, appDeploymentMBean);
        this.createRuntimeObjects(string, string4, appDeploymentMBean, deploymentData, this.getCreateTaskType(), domainMBean, authenticatedSubject, bl);
        return appDeploymentMBean;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void defaultSubModuleTargets(String string, String string2, DeploymentData deploymentData, DomainMBean domainMBean) throws ManagementException {
        SessionHelper sessionHelper;
        block20: {
            block19: {
                sessionHelper = null;
                AppDeploymentMBean appDeploymentMBean = null;
                boolean bl = false;
                try {
                    try {
                        Object object;
                        int n;
                        Object[] objectArray;
                        File file = null;
                        if (string2 != null) {
                            file = new File(string2);
                        } else {
                            appDeploymentMBean = AppDeploymentHelper.lookupAppOrLib(string, domainMBean);
                            bl = true;
                            if (appDeploymentMBean == null) {
                                Object var23_10 = null;
                                if (sessionHelper == null) return;
                                sessionHelper.close();
                                return;
                            }
                            file = new File(appDeploymentMBean.getSourcePath());
                        }
                        if (!this.hasJMSModules(file)) {
                            break block19;
                        }
                        if (!bl) {
                            appDeploymentMBean = AppDeploymentHelper.lookupAppOrLib(string, domainMBean);
                        }
                        if (AbstractOperation.isDebugEnabled()) {
                            this.debugSay(file + " has JMS modules");
                        }
                        sessionHelper = SessionHelper.getInstance(SessionHelper.getDisconnectedDeploymentManager());
                        sessionHelper.setApplication(file);
                        sessionHelper.setPlan(this.plan);
                        sessionHelper.inspect();
                        boolean bl2 = false;
                        ModuleInfo moduleInfo = sessionHelper.getModuleInfo();
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        if (moduleInfo.getType().getValue() == WebLogicModuleType.JMS.getValue()) {
                            arrayList.add(moduleInfo);
                            bl2 = true;
                        } else if (moduleInfo.getType().getValue() == WebLogicModuleType.EAR.getValue()) {
                            objectArray = moduleInfo.getSubModules();
                            for (n = 0; n < objectArray.length; ++n) {
                                object = objectArray[n];
                                if (((ModuleInfo)object).getType().getValue() != WebLogicModuleType.JMS.getValue()) continue;
                                arrayList.add(object);
                            }
                        }
                        objectArray = this.getTargetMBeans(domainMBean, deploymentData);
                        for (n = 0; n < arrayList.size(); ++n) {
                            object = (ModuleInfo)arrayList.get(n);
                            if (appDeploymentMBean != null && this.checkAppTargetting(appDeploymentMBean, ((ModuleInfo)object).getName(), sessionHelper)) continue;
                            Map map = this.getDefaultJMSTargets(domainMBean, (TargetMBean[])objectArray, ((ModuleInfo)object).getName(), sessionHelper);
                            for (String string3 : map.keySet()) {
                                TargetMBean[] targetMBeanArray = (TargetMBean[])map.get(string3);
                                for (int i = 0; i < targetMBeanArray.length; ++i) {
                                    TargetMBean targetMBean = targetMBeanArray[i];
                                    String string4 = ((ModuleInfo)object).getName();
                                    if (bl2) {
                                        string4 = null;
                                    }
                                    if (deploymentData.isSubModuleTargeted(string4, string3)) continue;
                                    deploymentData.addSubModuleTarget(string4, string3, new String[]{targetMBean.getName()});
                                }
                            }
                        }
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw new ManagementException(throwable);
                    }
                }
                catch (Throwable throwable) {
                    Object var23_13 = null;
                    if (sessionHelper == null) throw throwable;
                    sessionHelper.close();
                    throw throwable;
                }
            }
            Object var23_11 = null;
            if (sessionHelper == null) return;
            sessionHelper.close();
            return;
        }
        Object var23_12 = null;
        if (sessionHelper == null) return;
        sessionHelper.close();
    }

    private Map getDefaultJMSTargets(DomainMBean domainMBean, TargetMBean[] targetMBeanArray, String string, SessionHelper sessionHelper) throws ConfigurationException {
        JMSBean jMSBean = null;
        try {
            jMSBean = sessionHelper.getJMSDescriptor(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (jMSBean == null) {
            return null;
        }
        return DefaultingHelper.getJMSDefaultTargets(jMSBean, domainMBean, targetMBeanArray);
    }

    private boolean checkAppTargetting(AppDeploymentMBean appDeploymentMBean, String string, SessionHelper sessionHelper) {
        if (sessionHelper.getDeployableObject().getType().getValue() == ModuleType.EAR.getValue()) {
            SubDeploymentMBean[] subDeploymentMBeanArray = appDeploymentMBean.getSubDeployments();
            for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
                SubDeploymentMBean subDeploymentMBean = subDeploymentMBeanArray[i];
                if (!subDeploymentMBean.getName().equals(string)) continue;
                return this.checkIfTargeted(subDeploymentMBean);
            }
        } else {
            SubDeploymentMBean[] subDeploymentMBeanArray = appDeploymentMBean.getSubDeployments();
            if (subDeploymentMBeanArray != null && subDeploymentMBeanArray.length != 0) {
                return true;
            }
        }
        return false;
    }

    private boolean checkIfTargeted(SubDeploymentMBean subDeploymentMBean) {
        SubDeploymentMBean[] subDeploymentMBeanArray = subDeploymentMBean.getSubDeployments();
        return subDeploymentMBeanArray != null && subDeploymentMBeanArray.length != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasJMSModules(File var1_1) {
        block14: {
            block13: {
                if (var1_1.isFile() && var1_1.getPath().endsWith("-jms.xml")) {
                    return true;
                }
                var2_2 = null;
                try {
                    try {
                        var3_3 = ApplicationFileManager.newInstance(var1_1);
                        var2_2 = var3_3.getVirtualJarFile();
                        var4_5 = var2_2.entries();
                        while (var4_5.hasNext()) {
                            var5_6 = (JarEntry)var4_5.next();
                            if (!var5_6.getName().endsWith("-jms.xml")) continue;
                            if (AbstractOperation.isDebugEnabled()) {
                                this.debugSay(" found JMS module: " + var5_6.getName());
                            }
                            var6_7 = true;
                            var8_8 = null;
                            if (var2_2 == null) return var6_7;
                            break block13;
                        }
                        break block14;
                    }
                    catch (IOException var3_4) {
                        var8_10 = null;
                        if (var2_2 == null) return false;
                        try {
                            var2_2.close();
                            return false;
                        }
                        catch (IOException var9_14) {
                            return false;
                        }
                    }
                }
                catch (Throwable var7_16) {
                    var8_11 = null;
                    if (var2_2 == null) throw var7_16;
                    ** try [egrp 2[TRYBLOCK] [6 : 148->157)] { 
lbl34:
                    // 1 sources

                    var2_2.close();
                    throw var7_16;
lbl36:
                    // 1 sources

                    catch (IOException var9_15) {
                        // empty catch block
                    }
                    throw var7_16;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 148->157)] { 
lbl41:
            // 1 sources

            var2_2.close();
            return var6_7;
lbl43:
            // 1 sources

            catch (IOException var9_12) {
                // empty catch block
            }
            return var6_7;
        }
        var8_9 = null;
        if (var2_2 == null) return false;
        try {}
        catch (IOException var9_13) {}
        var2_2.close();
        return false;
        return false;
    }

    private TargetMBean[] getTargetMBeans(DomainMBean domainMBean, DeploymentData deploymentData) {
        String[] stringArray = deploymentData.getTargets();
        if (stringArray == null || stringArray.length < 1) {
            stringArray = new String[]{domainMBean.getAdminServerName()};
        }
        HashSet<TargetMBean> hashSet = new HashSet<TargetMBean>();
        TargetMBean[] targetMBeanArray = domainMBean.getTargets();
        for (int i = 0; i < stringArray.length; ++i) {
            TargetMBean targetMBean = this.findTarget(stringArray[i], targetMBeanArray);
            if (targetMBean == null) continue;
            hashSet.add(targetMBean);
        }
        return hashSet.toArray(new TargetMBean[0]);
    }

    private TargetMBean findTarget(String string, TargetMBean[] targetMBeanArray) {
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            if (!targetMBean.getName().equals(string)) continue;
            return targetMBean;
        }
        return null;
    }

    private static void doDeploymentTypeValidations(DomainMBean domainMBean, String string, DeploymentData deploymentData, AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        OperationHelper.validateAutoDeployTarget(domainMBean, string, deploymentData);
        OperationHelper.validateSplitDirTarget(domainMBean, string, deploymentData);
        if (AbstractOperation.isInternalApp(string)) {
            Loggable loggable = DeployerRuntimeLogger.logNoOpOnInternalAppLoggable((String)appDeploymentMBean.getName());
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    private boolean isControlOperation() {
        return this.controlOperation;
    }

    private static boolean isInternalApp(String string) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        AppDeploymentMBean appDeploymentMBean = domainMBean.lookupAppDeployment(string);
        return null == appDeploymentMBean ? false : appDeploymentMBean.isInternalApp();
    }

    protected boolean removeBeans() {
        return false;
    }

    protected int getCreateTaskType() {
        return this.taskType;
    }

    protected abstract AppDeploymentMBean updateConfiguration(String var1, String var2, String var3, DeploymentData var4, String var5, boolean var6) throws ManagementException;

    protected void postTaskCreationConfigurationUpdate(AppDeploymentMBean appDeploymentMBean, String string, DeploymentData deploymentData) throws ManagementException {
    }

    protected static final void addAdminServerAsDefaultTarget(DeploymentData deploymentData) {
        if (deploymentData == null) {
            return;
        }
        if (deploymentData.isActionFromDeployer()) {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            if (!deploymentData.hasTargets()) {
                deploymentData.addGlobalTarget(runtimeAccess.getServerName());
            }
        }
    }

    protected final AppDeploymentMBean createOrReconcileMBeans(String string, String string2, DeploymentData deploymentData, String string3, AppDeploymentMBean appDeploymentMBean, String string4) throws ManagementException {
        try {
            if (appDeploymentMBean == null) {
                appDeploymentMBean = this.createMBeans(string, string2, deploymentData, string3);
                this.setStagingMode(string4, appDeploymentMBean);
            } else {
                this.reconcileMBeans(deploymentData, appDeploymentMBean);
            }
            if (AbstractOperation.isDebugEnabled()) {
                this.debugSay("Deploying app " + appDeploymentMBean.getApplicationName() + (appDeploymentMBean.getVersionIdentifier() == null ? "" : " versionId: " + appDeploymentMBean.getVersionIdentifier()) + " with path: " + appDeploymentMBean.getAbsoluteSourcePath());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidSourceLoggable((String)string, (String)string2, (String)fileNotFoundException.getMessage());
            loggable.log();
            if (deploymentData.isNewApplication() && appDeploymentMBean != null) {
                this.beanFactory.removeMBean(appDeploymentMBean);
            }
            throw new ManagementException(loggable.getMessage(), (Throwable)fileNotFoundException);
        }
        catch (ApplicationException applicationException) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidAppLoggable((String)string, (String)string2, (String)applicationException.getMessage());
            loggable.log();
            throw new ManagementException(loggable.getMessage(), (Throwable)((Object)applicationException));
        }
        return appDeploymentMBean;
    }

    protected final AppDeploymentMBean createMBeans(String string, String string2, DeploymentData deploymentData, String string3) throws FileNotFoundException, ManagementException {
        AppDeploymentMBean appDeploymentMBean;
        File file = new File(string);
        if (AbstractOperation.isDebugEnabled()) {
            this.debugSay("Creating mbeans for " + string);
        }
        deploymentData.setNewApp(true);
        String string4 = ApplicationVersionUtils.getApplicationId(string2, string3);
        try {
            appDeploymentMBean = this.beanFactory.createAppDeploymentMBean(string4, file, deploymentData);
        }
        catch (InvalidTargetException invalidTargetException) {
            String string5 = DeployerRuntimeLogger.invalidTarget();
            throw new ManagementException(string5, (Throwable)invalidTargetException);
        }
        return appDeploymentMBean;
    }

    protected final void validateAllTargets(AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData, String string, String string2, String string3) throws DeploymentException {
        String[] stringArray = deploymentData.getGlobalTargets();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isValidTarget(stringArray[i], appDeploymentMBean)) continue;
            String string4 = ApplicationVersionUtils.getApplicationId(string, string2);
            Loggable loggable = DeployerRuntimeLogger.logInvalidTargetForOperationLoggable((String)string4, (String)stringArray[i], (String)string3);
            throw new DeploymentException(loggable.getMessage());
        }
    }

    private boolean isValidTarget(String string, AppDeploymentMBean appDeploymentMBean) {
        TargetMBean[] targetMBeanArray = appDeploymentMBean.getTargets();
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            return false;
        }
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            if (targetMBean.getName().equals(string)) {
                return true;
            }
            if (!(targetMBean instanceof ClusterMBean)) continue;
            ClusterMBean clusterMBean = (ClusterMBean)targetMBeanArray[i];
            ServerMBean[] serverMBeanArray = clusterMBean.getServers();
            for (int j = 0; j < serverMBeanArray.length; ++j) {
                if (!serverMBeanArray[j].getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private void deleteFailedApplication(AppDeploymentMBean appDeploymentMBean) {
        appDeploymentManager.getMBeanFactory().cleanupMBeans(this.beanFactory.getEditableDomain(), appDeploymentMBean.getAppMBean());
    }

    protected final void reconcileMBeans(DeploymentData deploymentData, AppDeploymentMBean appDeploymentMBean) throws ApplicationException, FileNotFoundException, ManagementException {
        this.reconcileMBeans(deploymentData, appDeploymentMBean, false);
    }

    protected void reconcileMBeans(DeploymentData deploymentData, AppDeploymentMBean appDeploymentMBean, boolean bl) throws ApplicationException, FileNotFoundException, ManagementException {
        Object object;
        String string;
        boolean bl2 = false;
        if (!OperationHelper.hasFiles(deploymentData)) {
            if (deploymentData.getDeploymentPlan() != null) {
                File file;
                string = deploymentData.getConfigDirectory();
                if (string != null && ((object = (file = new File(string)).list()) == null || ((String[])object).length == 0)) {
                    string = null;
                }
                appDeploymentMBean.setPlanDir(string);
                appDeploymentMBean.setPlanPath(deploymentData.getDeploymentPlan());
                bl2 = true;
            } else if (!bl && appDeploymentMBean.getPlanPath() != null) {
                appDeploymentMBean.setPlanPath(null);
                appDeploymentMBean.setPlanDir(null);
                bl2 = true;
            }
        }
        if (deploymentData.getAltDescriptorPath() != null) {
            appDeploymentMBean.setAltDescriptorPath(deploymentData.getAltDescriptorPath());
            bl2 = true;
        }
        if (deploymentData.getAltWLSDescriptorPath() != null) {
            appDeploymentMBean.setAltWLSDescriptorPath(deploymentData.getAltWLSDescriptorPath());
            bl2 = true;
        }
        if (deploymentData.getIsNameFromSource()) {
            deploymentData.setFile(null);
        }
        if ((string = deploymentData.getSecurityModel()) != null && string.length() > 0 && !string.equals(appDeploymentMBean.getSecurityDDModel())) {
            DeployerRuntimeLogger.logDiffSecurityModelIgnoredForRedeploy((String)ApplicationVersionUtils.getDisplayName(appDeploymentMBean), (String)appDeploymentMBean.getSecurityDDModel(), (String)string);
        }
        if (deploymentData.getDeploymentPrincipalName() != null) {
            appDeploymentMBean.setDeploymentPrincipalName(deploymentData.getDeploymentPrincipalName());
            bl2 = true;
        }
        if (AbstractOperation.isDebugEnabled()) {
            this.debugSay("Reloading mbeans for " + appDeploymentMBean.getAbsoluteSourcePath());
        }
        try {
            this.beanFactory.addTargetsInDeploymentData(deploymentData, appDeploymentMBean);
        }
        catch (InvalidTargetException invalidTargetException) {
            object = DeployerRuntimeLogger.invalidTarget();
            throw new ManagementException((String)object, (Throwable)invalidTargetException);
        }
        if (bl2) {
            SourceCache.updateDescriptorsInCache(appDeploymentMBean);
        }
    }

    protected static final void debugDeployer(String string) {
        Debug.deploymentDebug(string);
    }

    private void setStagingMode(String string, AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        if (string != null) {
            if (!(string.equals("nostage") || string.equals("stage") || string.equals("external_stage"))) {
                Loggable loggable = DeployerRuntimeLogger.logInvalidStagingModeLoggable((String)string);
                loggable.log();
                this.deleteFailedApplication(appDeploymentMBean);
                throw new ManagementException(loggable.getMessage());
            }
            if (AbstractOperation.isDebugEnabled()) {
                this.debugSay("Staging Mode is " + string);
            }
            appDeploymentMBean.setStagingMode(string);
        }
    }

    protected final void printDebugStartMessage(String string, String string2, String string3, DeploymentData deploymentData, String string4, String string5, String string6) {
        if (AbstractOperation.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string5);
            stringBuffer.append(" invoked with:\n");
            if (string != null) {
                stringBuffer.append("  Path = <" + string + ">\n");
            }
            stringBuffer.append("  name = <" + string2 + ">\n");
            if (string3 != null) {
                stringBuffer.append("  version = <" + string3 + ">\n");
            }
            if (string6 != null) {
                stringBuffer.append("  StagingMode = <" + string6 + ">\n");
            }
            if (deploymentData != null) {
                stringBuffer.append("  info = <" + deploymentData.toString() + ">\n");
            }
            stringBuffer.append("  id = <" + string4 + ">\n");
            this.debugSay(stringBuffer.toString());
        }
    }

    protected final void createRuntimeObjects(String string, String string2, AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData, int n, DomainMBean domainMBean, AuthenticatedSubject authenticatedSubject, boolean bl) throws ManagementException {
        this.deploymentTask = this.createAndRegisterDeploymentTaskRuntime(string, string2, appDeploymentMBean, deploymentData, n, domainMBean);
        if (bl) {
            ((DeploymentTaskRuntime)this.deploymentTask).setSubject(authenticatedSubject);
        }
        ((DeploymentTaskRuntime)this.deploymentTask).setAdminOperation(this);
        this.deployment = deploymentManager.createDeployment(string2, deploymentData, n, (DeploymentTaskRuntime)this.deploymentTask, domainMBean, false, authenticatedSubject, bl, this.controlOperation, false);
    }

    private DeploymentTaskRuntime createAndRegisterDeploymentTaskRuntime(String string, String string2, AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData, int n, DomainMBean domainMBean) throws ManagementException {
        DeployerRuntimeImpl deployerRuntimeImpl = deploymentManager.getDeployerRuntime();
        DeploymentTaskRuntime deploymentTaskRuntime = new DeploymentTaskRuntime(string, appDeploymentMBean, deploymentData, string2, n, domainMBean, this.controlOperation, false);
        deployerRuntimeImpl.registerTaskRuntime(string2, deploymentTaskRuntime);
        return deploymentTaskRuntime;
    }

    protected static final void invalidateCache(BasicDeploymentMBean basicDeploymentMBean) {
        SourceCache.invalidateCache(basicDeploymentMBean);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parsePlan() throws ManagementException {
        if (this.planBean != null) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                if (this.plan != null) {
                    fileInputStream = new FileInputStream(this.plan);
                }
                if (fileInputStream != null) {
                    this.planBean = DescriptorParser.parseDeploymentPlan(fileInputStream);
                }
            }
            catch (IOException iOException) {
                throw new ManagementException((Throwable)iOException);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                if (fileInputStream == null) throw throwable;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (fileInputStream == null) return;
        ((InputStream)fileInputStream).close();
        return;
    }

    protected void setupPaths(String string) throws ManagementException {
        try {
            if (this.moduleArchive == null) {
                return;
            }
            this.moduleArchive = ConfigHelper.normalize(this.moduleArchive).getCanonicalFile();
            this.paths = new InstallDir(string, ConfigHelper.getAppRootFromPlan(this.planBean));
            this.paths.setArchive(this.moduleArchive);
            if (this.plan != null) {
                this.paths.setPlan(this.plan.getCanonicalFile());
            }
            ConfigHelper.initPlanDirFromPlan(this.planBean, this.paths);
            if (this.planBean != null && this.planBean.getConfigRoot() != null) {
                this.paths.setConfigDir(new File(this.planBean.getConfigRoot()).getCanonicalFile());
            }
        }
        catch (IOException iOException) {
            throw new ManagementException((Throwable)iOException);
        }
    }

    protected boolean isSameOperationType(AbstractOperation abstractOperation) {
        return this.getClass().equals(abstractOperation.getClass());
    }

    protected final boolean areTargetsSame(AbstractOperation abstractOperation) {
        DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
        DeploymentData deploymentData = deploymentTaskRuntime.getDeploymentData();
        DeploymentTaskRuntime deploymentTaskRuntime2 = abstractOperation.getTaskRuntime();
        DeploymentData deploymentData2 = deploymentTaskRuntime2.getDeploymentData();
        List<String> list = Arrays.asList(deploymentData.getGlobalTargets());
        List<String> list2 = Arrays.asList(deploymentData2.getGlobalTargets());
        boolean bl = ((Object)list).equals(list2);
        if (AbstractOperation.isDebugEnabled()) {
            this.debugSay(" Global Targets are same : " + bl);
        }
        if (!bl) {
            return false;
        }
        bl = ((Object)deploymentData.getAllModuleTargets()).equals(deploymentData2.getAllModuleTargets());
        if (AbstractOperation.isDebugEnabled()) {
            this.debugSay(" Module Targets are same : " + bl);
        }
        if (!bl) {
            return false;
        }
        bl = ((Object)deploymentData.getAllSubModuleTargets()).equals(deploymentData2.getAllSubModuleTargets());
        if (AbstractOperation.isDebugEnabled()) {
            this.debugSay(" Submodule Targets are same : " + bl);
            this.debugSay(" Targets are same : " + bl);
        }
        return bl;
    }

    protected final void setAsDelegatorTo(AbstractOperation abstractOperation) throws DeploymentException {
        DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(deploymentTaskRuntime.getId());
        DeploymentManager.getInstance(kernelId).removeDeploymentsForTasks(arrayList);
        DeploymentTaskRuntime deploymentTaskRuntime2 = abstractOperation.getTaskRuntime();
        deploymentTaskRuntime2.addDelegator(deploymentTaskRuntime);
    }

    protected void removeSelf() throws DeploymentException {
        DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(deploymentTaskRuntime.getId());
        DeploymentManager.getInstance(kernelId).removeDeploymentsForTasks(arrayList);
        deploymentTaskRuntime.updateAllTargetsWithSuccessForMerging();
    }

    protected final void mergeWithSameOperationType(AbstractOperation abstractOperation) throws ManagementException {
        if (!this.isSameOperationType(abstractOperation)) {
            return;
        }
        if (this.areTargetsSame(abstractOperation)) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug(" Operation '" + this + "' is same type and has same targets as '" + abstractOperation + "'");
            }
            this.setAsDelegatorTo(abstractOperation);
        } else {
            String string;
            AbstractOperation abstractOperation2 = this.createCopy();
            DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
            DeploymentData deploymentData = deploymentTaskRuntime.getDeploymentData();
            DeploymentTaskRuntime deploymentTaskRuntime2 = abstractOperation.getTaskRuntime();
            DeploymentData deploymentData2 = deploymentTaskRuntime2.getDeploymentData();
            DeploymentData deploymentData3 = deploymentData.copy();
            deploymentData3.addGlobalTargets(deploymentData2.getGlobalTargets());
            if (deploymentData2.hasModuleTargets()) {
                deploymentData3.addOrUpdateModuleTargets(deploymentData2.getAllModuleTargets());
            }
            if (deploymentData2.hasSubModuleTargets()) {
                deploymentData3.addOrUpdateSubModuleTargets(deploymentData2.getAllSubModuleTargets());
            }
            if (deploymentData2.hasFiles()) {
                deploymentData3.addFiles(deploymentData2.getFiles());
            }
            if ((string = deploymentData2.getDeploymentPlan()) != null) {
                deploymentData3.setDeploymentPlan(string);
            }
            String string2 = deploymentTaskRuntime.getSource();
            String string3 = DELEGATE_PREFIX + nextDelegateId++;
            AuthenticatedSubject authenticatedSubject = this.authSubject;
            abstractOperation2.createRuntimeObjects(string2, string3, (AppDeploymentMBean)deploymentTaskRuntime.getDeploymentMBean(), deploymentData3, this.getCreateTaskType(), this.editAccessHelper.getEditDomainBean(authenticatedSubject), authenticatedSubject, true);
            ArrayList<AbstractOperation> arrayList = new ArrayList<AbstractOperation>();
            arrayList.add(this);
            arrayList.add(abstractOperation);
            abstractOperation2.setAsDelegateTo(arrayList);
            if (AbstractOperation.isDebugEnabled()) {
                this.debugSay(" Operations '" + this + "' and '" + abstractOperation + "' are merged to '" + abstractOperation2 + "'");
            }
        }
    }

    protected final void createCopyAndConstructNewRuntime() throws ManagementException {
        AbstractOperation abstractOperation = this.createCopy();
        DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
        DeploymentData deploymentData = deploymentTaskRuntime.getDeploymentData();
        String string = deploymentTaskRuntime.getSource();
        String string2 = DELEGATE_PREFIX + nextDelegateId++;
        AuthenticatedSubject authenticatedSubject = this.authSubject;
        abstractOperation.createRuntimeObjects(string, string2, (AppDeploymentMBean)deploymentTaskRuntime.getDeploymentMBean(), deploymentData, this.getCreateTaskType(), this.editAccessHelper.getEditDomainBean(authenticatedSubject), authenticatedSubject, true);
        ArrayList<AbstractOperation> arrayList = new ArrayList<AbstractOperation>();
        arrayList.add(this);
        abstractOperation.setAsDelegateTo(arrayList);
    }

    protected void setAsDelegateTo(List list) throws DeploymentException {
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
        for (AbstractOperation abstractOperation : list) {
            DeploymentTaskRuntime deploymentTaskRuntime2 = abstractOperation.getTaskRuntime();
            arrayList.add(deploymentTaskRuntime2.getId());
            deploymentTaskRuntime.addDelegator(deploymentTaskRuntime2);
        }
        DeploymentManager.getInstance(kernelId).removeDeploymentsForTasks(arrayList);
    }

    protected abstract AbstractOperation createCopy();

    protected final void mergeUndeployWithDistributeOrDeployOrRedeploy(AbstractOperation abstractOperation) throws ManagementException {
        if (!(this instanceof RemoveOperation)) {
            throw new DeploymentException("current operation must be undeploy");
        }
        if (!(abstractOperation instanceof DistributeOperation || abstractOperation instanceof RedeployOperation || abstractOperation instanceof ActivateOperation)) {
            throw new DeploymentException("other operation must be one of distribute or redeploy or deploy operations");
        }
        if (this.areTargetsSame(abstractOperation)) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Targets are same. So, cancelling operations");
            }
            this.removeSelf();
            abstractOperation.removeSelf();
        } else {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Targets are not same. So, making redeploy operation and keeing undeploy operation with some targets");
            }
            boolean bl = this.haveCommonTargets(abstractOperation);
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("operations '" + this + "' and '" + abstractOperation + "' have common targets: " + bl);
            }
            if (bl) {
                DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
                DeploymentData deploymentData = deploymentTaskRuntime.getDeploymentData();
                DeploymentTaskRuntime deploymentTaskRuntime2 = abstractOperation.getTaskRuntime();
                DeploymentData deploymentData2 = deploymentTaskRuntime2.getDeploymentData();
                deploymentData.removeCommonTargets(deploymentData2, true);
                if (deploymentData.hasNoTargets()) {
                    abstractOperation.createCopyAndConstructNewRuntime();
                    this.removeSelf();
                } else if (deploymentData2.hasNoTargets()) {
                    this.createCopyAndConstructNewRuntime();
                    abstractOperation.removeSelf();
                } else {
                    this.createCopyAndConstructNewRuntime();
                    abstractOperation.createCopyAndConstructNewRuntime();
                }
            }
        }
    }

    protected void mergeWithUndeploy(AbstractOperation abstractOperation) throws ManagementException {
        if (AbstractOperation.isDebugEnabled()) {
            this.debugSay("Invoking mergeWithUndeploy(" + abstractOperation + ")...");
        }
        if (!(abstractOperation instanceof RemoveOperation)) {
            throw new DeploymentException("Other operation '" + abstractOperation + "' is not RemoveOperation");
        }
    }

    protected void mergeWithRedeploy(AbstractOperation abstractOperation) throws ManagementException {
        if (AbstractOperation.isDebugEnabled()) {
            this.debugSay("Invoking mergeWithRedeploy(" + abstractOperation + ")...");
        }
        if (!(abstractOperation instanceof RedeployOperation)) {
            throw new DeploymentException("Other operation '" + abstractOperation + "' is not RedeployOperation");
        }
    }

    protected void mergeWithDeploy(AbstractOperation abstractOperation) throws ManagementException {
        if (AbstractOperation.isDebugEnabled()) {
            this.debugSay("Invoking mergeWithDeploy(" + abstractOperation + ")...");
        }
        if (!(abstractOperation instanceof ActivateOperation)) {
            throw new DeploymentException("Other operation '" + abstractOperation + "' is not ActivateOperation");
        }
    }

    protected void mergeWithUpdate(AbstractOperation abstractOperation) throws ManagementException {
        if (AbstractOperation.isDebugEnabled()) {
            this.debugSay("Invoking mergeWithUpdate(" + abstractOperation + ")...");
        }
        if (!(abstractOperation instanceof UpdateOperation)) {
            throw new DeploymentException("Other operation '" + abstractOperation + "' is not UpdateOperation");
        }
    }

    protected void mergeWithDistribute(AbstractOperation abstractOperation) throws ManagementException {
        if (AbstractOperation.isDebugEnabled()) {
            this.debugSay("Invoking mergeWithDistribute(" + abstractOperation + ")...");
        }
        if (!(abstractOperation instanceof DistributeOperation)) {
            throw new DeploymentException("Other operation '" + abstractOperation + "' is not DistributeOperation");
        }
    }

    private boolean haveCommonTargets(AbstractOperation abstractOperation) {
        DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
        DeploymentData deploymentData = deploymentTaskRuntime.getDeploymentData();
        DeploymentTaskRuntime deploymentTaskRuntime2 = abstractOperation.getTaskRuntime();
        DeploymentData deploymentData2 = deploymentTaskRuntime2.getDeploymentData();
        return AbstractOperation.haveCommonTargets(deploymentData, deploymentData2);
    }

    private static boolean haveCommonTargets(DeploymentData deploymentData, DeploymentData deploymentData2) {
        if (AbstractOperation.haveCommonGlobalTargets(deploymentData, deploymentData2)) {
            return true;
        }
        if (AbstractOperation.haveCommonModuleTargets(deploymentData, deploymentData2)) {
            return true;
        }
        return AbstractOperation.haveCommonSubModuleTargets(deploymentData, deploymentData2);
    }

    private static boolean haveCommonGlobalTargets(DeploymentData deploymentData, DeploymentData deploymentData2) {
        String[] stringArray = deploymentData.getGlobalTargets();
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        ExtendedArrayList extendedArrayList = new ExtendedArrayList(stringArray);
        String[] stringArray2 = deploymentData2.getGlobalTargets();
        if (stringArray2 == null || stringArray2.length == 0) {
            return false;
        }
        return extendedArrayList.containsOne(stringArray2);
    }

    private static boolean haveCommonModuleTargets(DeploymentData deploymentData, DeploymentData deploymentData2) {
        Map map = deploymentData.getAllModuleTargets();
        Map map2 = deploymentData2.getAllModuleTargets();
        if (map2.isEmpty() || map.isEmpty()) {
            return false;
        }
        Set set = map2.keySet();
        for (String string : set) {
            if (!map.containsKey(string)) continue;
            String[] stringArray = (String[])map2.get(string);
            ExtendedArrayList extendedArrayList = new ExtendedArrayList((String[])map.get(string));
            if (!extendedArrayList.containsOne(stringArray)) continue;
            return true;
        }
        return false;
    }

    private static boolean haveCommonSubModuleTargets(DeploymentData deploymentData, DeploymentData deploymentData2) {
        Map map = deploymentData.getAllSubModuleTargets();
        Map map2 = deploymentData2.getAllSubModuleTargets();
        if (map2.isEmpty() || map.isEmpty()) {
            return false;
        }
        Set set = map2.keySet();
        for (String string : set) {
            Map map3;
            Map map4;
            if (!map.containsKey(string) || (map4 = (Map)map2.get(string)) == null || map4.isEmpty() || (map3 = (Map)map.get(string)) == null || map3.isEmpty()) continue;
            for (String string2 : map4.keySet()) {
                if (!map3.containsKey(string2)) continue;
                String[] stringArray = (String[])map4.get(string2);
                ExtendedArrayList extendedArrayList = new ExtendedArrayList((String[])map3.get(string2));
                if (!extendedArrayList.containsOne(stringArray)) continue;
                return true;
            }
        }
        return false;
    }

    private static void mergeOperationsOnAppAgain(String string) throws ManagementException {
        AbstractOperation abstractOperation;
        List list = DeploymentManager.getInstance(kernelId).getExistingOperationsOnApp(string);
        if (AbstractOperation.isDebugEnabled()) {
            Debug.deploymentDebug(" <merge2> Found Same Operations : " + list);
        }
        if (list == null || list.size() < 2) {
            return;
        }
        if (list.size() > 2) {
            throw new ManagementException("Contains more than two operations after merge");
        }
        AbstractOperation abstractOperation2 = (AbstractOperation)list.get(0);
        if (abstractOperation2.haveCommonTargets(abstractOperation = (AbstractOperation)list.get(1))) {
            abstractOperation2.mergeWithOperation(abstractOperation);
        }
    }

    private void mergeWithExistingOperationsOnSameApp() throws ManagementException {
        List list = DeploymentManager.getInstance(kernelId).getExistingOperationsOnSameApp(this);
        list.remove(this);
        if (AbstractOperation.isDebugEnabled()) {
            this.debugSay(" Found Same Operations : " + list);
        }
        if (list.isEmpty()) {
            return;
        }
        AbstractOperation abstractOperation = (AbstractOperation)list.get(0);
        DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
        AppDeploymentMBean appDeploymentMBean = deploymentTaskRuntime.getAppDeploymentMBean();
        String string = appDeploymentMBean == null ? null : appDeploymentMBean.getName();
        this.mergeWithOperation(abstractOperation);
        if (string != null) {
            AbstractOperation.mergeOperationsOnAppAgain(string);
        }
    }

    private void mergeWithOperation(AbstractOperation abstractOperation) throws ManagementException {
        if (this == abstractOperation) {
            return;
        }
        if (abstractOperation instanceof ActivateOperation) {
            this.mergeWithDeploy(abstractOperation);
        } else if (abstractOperation instanceof DistributeOperation) {
            this.mergeWithDistribute(abstractOperation);
        } else if (abstractOperation instanceof UpdateOperation) {
            this.mergeWithUpdate(abstractOperation);
        } else if (abstractOperation instanceof RedeployOperation) {
            this.mergeWithRedeploy(abstractOperation);
        } else if (abstractOperation instanceof RemoveOperation) {
            this.mergeWithUndeploy(abstractOperation);
        }
    }

    private void setVersionInfo(String string) {
        if (this.options.getPlanVersion() != null) {
            return;
        }
        String string2 = null;
        String string3 = ApplicationVersionUtils.getVersionId(string);
        if (string3 != null) {
            string2 = ApplicationVersionUtils.getPlanVersion(string3);
        }
        this.setPlanVersion(string2);
    }

    private void setPlanVersion(String string) {
        if (string != null) {
            this.options.setPlanVersion(string);
        } else if (this.options.getPlanVersion() == null && this.planBean != null) {
            this.options.setPlanVersion(this.planBean.getVersion());
        }
        this.assertPlanVersionValid();
    }

    private void assertPlanVersionValid() {
        if (this.planBean != null) {
            String string = this.planBean.getVersion();
            String string2 = this.options.getPlanVersion();
            if (string == null || string2 == null) {
                return;
            }
            if (string != string2) {
                throw new IllegalArgumentException(SPIDeployerLogger.versionMismatchPlan((String)string, (String)string2));
            }
        }
    }

    public void undoChangesTriggeredByUser() {
        if (this.deployment == null) {
            return;
        }
        deploymentManager.undoChangesTriggeredByUser(this.deployment);
    }

    protected static boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    protected void debugSay(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(").append(this).append("): ").append(string);
        Debug.deploymentDebug(stringBuffer.toString());
    }

    protected void setupDDPaths(DeploymentData deploymentData) {
    }

    private static class ExtendedArrayList
    extends ArrayList {
        ExtendedArrayList(Collection collection) {
            super(collection);
        }

        ExtendedArrayList(String[] stringArray) {
            this(stringArray != null ? Arrays.asList(stringArray) : Collections.EMPTY_LIST);
        }

        boolean containsOne(String[] stringArray) {
            if (this.isEmpty()) {
                return false;
            }
            if (stringArray == null || stringArray.length == 0) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.contains(stringArray[i])) continue;
                return true;
            }
            return false;
        }
    }
}

