/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.adminserver.operations;

import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.internal.adminserver.operations.AbstractOperation;
import weblogic.deploy.internal.adminserver.operations.OperationHelper;
import weblogic.logging.Loggable;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.DeploymentTaskRuntime;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;

public class ActivateOperation
extends AbstractOperation {
    private boolean removeBeansOnFailure = false;
    private boolean redeployWithSource = false;
    private AppDeploymentMBean createdApp = null;

    public ActivateOperation() {
        this.taskType = 1;
    }

    public ActivateOperation(boolean bl) {
        this();
        this.redeployWithSource = bl;
    }

    protected AppDeploymentMBean updateConfiguration(String string, String string2, String string3, DeploymentData deploymentData, String string4, boolean bl) throws ManagementException {
        AppDeploymentMBean appDeploymentMBean;
        String string5 = null;
        String string6 = OperationHelper.getAppName(string2, deploymentData, string);
        String string7 = OperationHelper.getTaskString(this.taskType);
        DomainMBean domainMBean = this.beanFactory.getEditableDomain();
        boolean bl2 = deploymentData.getDeploymentOptions().isNoVersion();
        OperationHelper.assertNameIsNonNull(string6, string7);
        if (ActivateOperation.isDebugEnabled()) {
            this.printDebugStartMessage(string, string6, string5, deploymentData, string4, string7, string3);
        }
        if (!bl2) {
            string5 = OperationHelper.getAndValidateVersionIdWithSrc(deploymentData, string2, string, string6);
        }
        if ((appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(domainMBean, string6, string5)) != null) {
            if (string == null) {
                appDeploymentMBean = OperationHelper.getActiveVersionIfNeeded(domainMBean, string5, appDeploymentMBean, string6, deploymentData, string7);
                string5 = appDeploymentMBean.getVersionIdentifier();
                if (!bl2) {
                    OperationHelper.validateSourceVersion(appDeploymentMBean, deploymentData, string6);
                }
            }
            OperationHelper.validateNonVersionWithVersion(string5, appDeploymentMBean, string6, string7);
            OperationHelper.assertNoChangeInStagingMode(string3, appDeploymentMBean);
            OperationHelper.validateTargets(domainMBean, deploymentData, appDeploymentMBean, string7);
            OperationHelper.validatePath(string, appDeploymentMBean);
        } else {
            OperationHelper.validateRetireTimeout(domainMBean, string6, string5, deploymentData);
            OperationHelper.validateVersionIdFormat(string6, string5);
            OperationHelper.validateVersionWithNonVersion(domainMBean, string5, string6, string7);
            if (!OperationHelper.isLibrary(deploymentData)) {
                OperationHelper.validateMaxAppVersions(domainMBean, string6, string5);
                OperationHelper.validateVersionTargets(domainMBean, string6, deploymentData, string5);
            }
            OperationHelper.validateVersionStagingAndPath(domainMBean, string, string6, string5);
            OperationHelper.assertSourceIsNonNull(string, string6, string5);
            if (!bl) {
                this.removeBeansOnFailure = true;
            }
        }
        OperationHelper.validateDeployWhileRetire(string6, string5, appDeploymentMBean);
        if (string != null) {
            ActivateOperation.addAdminServerAsDefaultTarget(deploymentData);
            appDeploymentMBean = this.createOrReconcileMBeans(string, string6, deploymentData, string5, appDeploymentMBean, string3);
            if (this.removeBeans()) {
                this.createdApp = appDeploymentMBean;
            }
            ActivateOperation.invalidateCache(appDeploymentMBean);
        }
        OperationHelper.validateModuleType(string6, string5, appDeploymentMBean);
        return appDeploymentMBean;
    }

    protected AbstractOperation createCopy() {
        return new ActivateOperation();
    }

    protected void mergeWithUndeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithUndeploy(abstractOperation);
        abstractOperation.mergeUndeployWithDistributeOrDeployOrRedeploy(this);
    }

    protected void mergeWithRedeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithRedeploy(abstractOperation);
        abstractOperation.mergeWithDeploy(this);
    }

    protected void mergeWithDeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithDeploy(abstractOperation);
        this.mergeWithSameOperationType(abstractOperation);
    }

    protected void mergeWithUpdate(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithUpdate(abstractOperation);
        DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
        DeploymentData deploymentData = deploymentTaskRuntime.getDeploymentData();
        DeploymentTaskRuntime deploymentTaskRuntime2 = this.getTaskRuntime();
        DeploymentData deploymentData2 = deploymentTaskRuntime2.getDeploymentData();
        if (deploymentData.hasFiles()) {
            deploymentData.setPlanUpdate(deploymentData2.isPlanUpdate());
        }
        deploymentData.setDeploymentPlan(deploymentData2.getDeploymentPlan());
        deploymentData.addGlobalTargets(deploymentData2.getGlobalTargets());
        if (deploymentData2.hasModuleTargets()) {
            deploymentData.addOrUpdateModuleTargets(deploymentData2.getAllModuleTargets());
        }
        if (deploymentData2.hasSubModuleTargets()) {
            deploymentData.addOrUpdateSubModuleTargets(deploymentData2.getAllSubModuleTargets());
        }
        abstractOperation.setAsDelegatorTo(this);
    }

    protected void mergeWithDistribute(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithDistribute(abstractOperation);
        if (!this.areTargetsSame(abstractOperation)) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
            DeploymentData deploymentData = deploymentTaskRuntime.getDeploymentData();
            DeploymentTaskRuntime deploymentTaskRuntime2 = this.getTaskRuntime();
            DeploymentData deploymentData2 = deploymentTaskRuntime2.getDeploymentData();
            deploymentData.setDeploymentPlan(deploymentData2.getDeploymentPlan());
            deploymentData.addGlobalTargets(deploymentData2.getGlobalTargets());
            if (deploymentData2.hasModuleTargets()) {
                deploymentData.addOrUpdateModuleTargets(deploymentData2.getAllModuleTargets());
            }
            if (deploymentData2.hasSubModuleTargets()) {
                deploymentData.addOrUpdateSubModuleTargets(deploymentData2.getAllSubModuleTargets());
            }
        }
        abstractOperation.setAsDelegatorTo(this);
    }

    protected boolean isSameOperationType(AbstractOperation abstractOperation) {
        return abstractOperation instanceof ActivateOperation;
    }

    protected void checkVersionSupport(DeploymentData deploymentData, String string, String string2) throws ManagementException {
        OperationHelper.validateVersionForDeprecatedOp(deploymentData, string, string2, 7);
    }

    protected boolean removeBeans() {
        return this.removeBeansOnFailure;
    }

    public void rollback(AuthenticatedSubject authenticatedSubject) {
        if (this.removeBeans() && this.createdApp != null) {
            this.editAccessHelper.rollback(this.createdApp, this.beanFactory, authenticatedSubject);
        }
        this.createdApp = null;
    }

    protected String getAutoDeployErrorMsg(String string) {
        Loggable loggable = DeployerRuntimeLogger.invalidRedeployOnAutodeployedAppLoggable((String)string);
        return loggable.getMessage();
    }
}

