/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.adminserver.operations;

import java.security.AccessController;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.internal.adminserver.operations.AbstractOperation;
import weblogic.deploy.internal.adminserver.operations.OperationHelper;
import weblogic.deploy.service.DeploymentRequest;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.internal.DeployerRuntimeImpl;
import weblogic.management.deploy.internal.DeploymentServerService;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public abstract class BaseRetireOperation
extends AbstractOperation {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public BaseRetireOperation() {
        this.controlOperation = true;
    }

    public final DeploymentTaskRuntimeMBean executeControlOperation(String string, String string2, String string3, DeploymentData deploymentData, String string4, boolean bl, AuthenticatedSubject authenticatedSubject) throws ManagementException {
        try {
            String string5 = OperationHelper.ensureAppName(string2);
            String string6 = OperationHelper.getTaskString(this.taskType);
            String string7 = OperationHelper.getVersionIdFromData(deploymentData, string2);
            DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
            OperationHelper.assertNameIsNonNull(string5, string6);
            if (BaseRetireOperation.isDebugEnabled()) {
                this.printDebugStartMessage(string, string5, string7, deploymentData, string4, string6, string3);
            }
            AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(domainMBean, string5, string7);
            OperationHelper.assertAppIsNonNull(appDeploymentMBean, string5, string7, string6);
            this.createRuntimeObjects(string, string4, appDeploymentMBean, deploymentData, this.getCreateTaskType(), domainMBean, authenticatedSubject, true);
            DeployerRuntimeImpl deployerRuntimeImpl = (DeployerRuntimeImpl)DeploymentServerService.getDeployerRuntime();
            deployerRuntimeImpl.registerTaskRuntime(string4, this.deploymentTask);
            BaseRetireOperation.createAndInitDeploymentRequest();
            if (bl) {
                this.deploymentTask.start();
            }
            return this.deploymentTask;
        }
        catch (Throwable throwable) {
            deploymentManager.deploymentFailedBeforeStart(this.deployment, throwable);
            OperationHelper.logTaskFailed(string2, this.taskType, throwable);
            if (throwable instanceof ManagementException) {
                throw (ManagementException)throwable;
            }
            throw new ManagementException(throwable.getMessage(), throwable);
        }
    }

    protected final AppDeploymentMBean updateConfiguration(String string, String string2, String string3, DeploymentData deploymentData, String string4, boolean bl) throws ManagementException {
        return null;
    }

    private static void createAndInitDeploymentRequest() throws ManagementException {
        DeploymentRequest deploymentRequest = DeploymentService.getDeploymentService().createDeploymentRequest();
        deploymentManager.addDeploymentsTo(deploymentRequest, null);
    }

    protected boolean isRemote(DeploymentData deploymentData) {
        return false;
    }
}

