/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.adminserver.operations;

import java.io.FileNotFoundException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.internal.adminserver.operations.AbstractOperation;
import weblogic.deploy.internal.adminserver.operations.OperationHelper;
import weblogic.logging.Loggable;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.DeploymentTaskRuntime;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;

public final class DistributeOperation
extends AbstractOperation {
    private boolean removeBeansOnFailure = false;
    private AppDeploymentMBean createdApp = null;

    public DistributeOperation() {
        this.taskType = 6;
    }

    protected final AppDeploymentMBean updateConfiguration(String string, String string2, String string3, DeploymentData deploymentData, String string4, boolean bl) throws ManagementException {
        AppDeploymentMBean appDeploymentMBean;
        String string5 = null;
        String string6 = OperationHelper.getAppName(string2, deploymentData, string);
        String string7 = OperationHelper.getTaskString(this.taskType);
        DomainMBean domainMBean = this.beanFactory.getEditableDomain();
        boolean bl2 = deploymentData.getDeploymentOptions().isNoVersion();
        OperationHelper.assertNameIsNonNull(string6, string7);
        if (!bl2) {
            string5 = OperationHelper.getAndValidateVersionIdWithSrc(deploymentData, null, string, string6);
        }
        if (DistributeOperation.isDebugEnabled()) {
            this.printDebugStartMessage(string, string6, string5, deploymentData, string4, string7, string3);
        }
        if ((appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(this.beanFactory.getEditableDomain(), string6, string5)) != null) {
            OperationHelper.validateNonVersionWithVersion(string5, appDeploymentMBean, string6, string7);
            OperationHelper.validateTargets(domainMBean, deploymentData, appDeploymentMBean, string7);
            OperationHelper.assertNoChangeInStagingMode(string3, appDeploymentMBean);
            OperationHelper.validatePath(string, appDeploymentMBean);
            appDeploymentMBean = this.createOrReconcileMBeans(string, string6, deploymentData, string5, appDeploymentMBean, string3);
        } else {
            OperationHelper.validateRetireTimeout(domainMBean, string6, string5, deploymentData);
            OperationHelper.validateVersionWithNonVersion(domainMBean, string5, string6, string7);
            DistributeOperation.addAdminServerAsDefaultTarget(deploymentData);
            OperationHelper.assertSourceIsNonNull(string, string6, string5);
            if (!bl) {
                this.removeBeansOnFailure = true;
            }
            this.createdApp = appDeploymentMBean = this.createMBeansForDistribute(appDeploymentMBean, string5, string6, string, deploymentData, string3);
        }
        return appDeploymentMBean;
    }

    protected AbstractOperation createCopy() {
        return new DistributeOperation();
    }

    protected void mergeWithUndeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithUndeploy(abstractOperation);
        abstractOperation.mergeUndeployWithDistributeOrDeployOrRedeploy(this);
    }

    protected void mergeWithRedeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithRedeploy(abstractOperation);
        abstractOperation.mergeWithDistribute(this);
    }

    protected void mergeWithDeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithDeploy(abstractOperation);
        abstractOperation.mergeWithDistribute(this);
    }

    protected void mergeWithUpdate(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithUpdate(abstractOperation);
        DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
        DeploymentData deploymentData = deploymentTaskRuntime.getDeploymentData();
        DeploymentTaskRuntime deploymentTaskRuntime2 = this.getTaskRuntime();
        DeploymentData deploymentData2 = deploymentTaskRuntime2.getDeploymentData();
        if (deploymentData.hasFiles()) {
            deploymentData.setPlanUpdate(deploymentData2.isPlanUpdate());
        }
        deploymentData.setDeploymentPlan(deploymentData2.getDeploymentPlan());
        deploymentData.addGlobalTargets(deploymentData2.getGlobalTargets());
        if (deploymentData2.hasModuleTargets()) {
            deploymentData.addOrUpdateModuleTargets(deploymentData2.getAllModuleTargets());
        }
        if (deploymentData2.hasSubModuleTargets()) {
            deploymentData.addOrUpdateSubModuleTargets(deploymentData2.getAllSubModuleTargets());
        }
        abstractOperation.setAsDelegatorTo(this);
    }

    protected void mergeWithDistribute(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithDistribute(abstractOperation);
        this.mergeWithSameOperationType(abstractOperation);
    }

    private AppDeploymentMBean createMBeansForDistribute(AppDeploymentMBean appDeploymentMBean, String string, String string2, String string3, DeploymentData deploymentData, String string4) throws ManagementException {
        try {
            appDeploymentMBean = this.createMBeans(string3, string2, deploymentData, string);
            if (string4 != null) {
                appDeploymentMBean.setStagingMode(string4);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidSourceLoggable((String)string3, (String)string2, (String)fileNotFoundException.getMessage());
            loggable.log();
            if (appDeploymentMBean != null) {
                this.beanFactory.removeMBean(appDeploymentMBean);
            }
            throw new ManagementException(loggable.getMessage(), (Throwable)fileNotFoundException);
        }
        return appDeploymentMBean;
    }

    protected final boolean removeBeans() {
        return this.removeBeansOnFailure;
    }

    public void rollback(AuthenticatedSubject authenticatedSubject) {
        if (this.removeBeans() && this.createdApp != null) {
            this.editAccessHelper.rollback(this.createdApp, this.beanFactory, authenticatedSubject);
        }
        this.createdApp = null;
    }

    protected String getAutoDeployErrorMsg(String string) {
        Loggable loggable = DeployerRuntimeLogger.invalidDistributeOnAutodeployedAppLoggable((String)string);
        return loggable.getMessage();
    }
}

