/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.adminserver.operations;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.shared.ModuleType;
import weblogic.application.ApplicationFileManager;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.beans.factory.InvalidTargetException;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.logging.Loggable;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DeploymentConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.LibraryMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.DeployerRuntimeTextTextFormatter;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.ApplicationRuntimeState;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.RetirementManager;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;
import weblogic.utils.FileUtils;

public class OperationHelper {
    private static final AppRuntimeStateManager appRTStateMgr = AppRuntimeStateManager.getManager();
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static DeployerRuntimeTextTextFormatter textformatter = new DeployerRuntimeTextTextFormatter();

    static boolean isLibrary(DeploymentData deploymentData) {
        return deploymentData != null && deploymentData.getDeploymentOptions() != null && deploymentData.getDeploymentOptions().isLibrary();
    }

    static String getAppName(String string, DeploymentData deploymentData, String string2) throws ManagementException {
        if (OperationHelper.isLibrary(deploymentData)) {
            return OperationHelper.getAndValidateLibraryName(string, deploymentData, string2);
        }
        return OperationHelper.ensureAppName(string);
    }

    private static String getAndValidateLibraryName(String string, DeploymentData deploymentData, String string2) throws ManagementException {
        String string3 = OperationHelper.ensureAppName(string);
        String string4 = OperationHelper.getLibNameFromSource(string, string2);
        if (string3 == null || string3.equals("")) {
            if (string4 != null && !string4.equals("")) {
                return string4;
            }
            return OperationHelper.getDefaultLibNameFromSource(string2, deploymentData);
        }
        if (string4 == null || string4.equals("")) {
            return string3;
        }
        if (!string4.equals(string3)) {
            Loggable loggable = DeployerRuntimeLogger.logLibNameMismatchLoggable((String)string3, (String)string4, (String)string2);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
        if (OperationHelper.isDebugEnabled()) {
            OperationHelper.debug("lib name = <" + string3 + ">");
        }
        return string3;
    }

    private static String getLibNameFromSource(String string, String string2) throws ManagementException {
        OperationHelper.validateSource(string, string2);
        return ApplicationVersionUtils.getLibName(string2);
    }

    private static String getDefaultLibNameFromSource(String string, DeploymentData deploymentData) throws ManagementException {
        try {
            String string2 = new File(string).getCanonicalFile().getName();
            int n = string2.indexOf(46);
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            deploymentData.setIsNameFromSource(true);
            return string2;
        }
        catch (IOException iOException) {
            Loggable loggable = DeployerRuntimeLogger.logNoLibNameLoggable((String)string);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    private static String getArchiveVersionIdFromData(DeploymentData deploymentData, String string) {
        String string2 = null;
        if (deploymentData != null && deploymentData.getDeploymentOptions() != null) {
            String string3 = deploymentData.getDeploymentOptions().getLibSpecVersion();
            String string4 = deploymentData.getDeploymentOptions().getLibImplVersion();
            string2 = OperationHelper.isLibrary(deploymentData) && (string3 != null || string4 != null) ? ApplicationVersionUtils.getLibVersionId(string3, string4) : deploymentData.getDeploymentOptions().getArchiveVersion();
        }
        if (string2 == null) {
            return ApplicationVersionUtils.getVersionId(string);
        }
        return string2;
    }

    static String getVersionIdFromData(DeploymentData deploymentData, String string) throws ManagementException {
        return OperationHelper.getCompositeVersionId(string, OperationHelper.getArchiveVersionIdFromData(deploymentData, string), deploymentData);
    }

    private static String getArchiveVersionIdFromSource(String string, DeploymentData deploymentData, String string2) throws ManagementException {
        OperationHelper.validateSource(string2, string);
        return OperationHelper.isLibrary(deploymentData) ? ApplicationVersionUtils.getLibVersionId(string) : ApplicationVersionUtils.getManifestVersion(string);
    }

    private static String getCompositeVersionId(String string, String string2, DeploymentData deploymentData) throws ManagementException {
        String string3 = null;
        string3 = ApplicationVersionUtils.getPlanVersion(string2);
        if (string3 != null) {
            return string2;
        }
        if (deploymentData != null && deploymentData.getDeploymentOptions() != null) {
            string3 = deploymentData.getDeploymentOptions().getPlanVersion();
        }
        if (string2 == null && string3 != null) {
            Loggable loggable = DeployerRuntimeLogger.logPlanVersionNotAllowedLoggable((String)string, (String)string3);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
        return ApplicationVersionUtils.getVersionId(string2, string3);
    }

    static String getAndValidateVersionIdWithSrc(DeploymentData deploymentData, String string, String string2, String string3) throws ManagementException {
        String string4 = OperationHelper.getArchiveVersionIdFromData(deploymentData, string);
        String string5 = null;
        if (string2 != null) {
            String string6 = OperationHelper.getArchiveVersionIdFromSource(string2, deploymentData, string3);
            if (string4 == null) {
                string5 = OperationHelper.getCompositeVersionId(string3, string6, deploymentData);
            } else {
                String string7 = ApplicationVersionUtils.getLibSpecVersion(string4);
                String string8 = ApplicationVersionUtils.getLibSpecVersion(string6);
                String string9 = ApplicationVersionUtils.getLibImplVersion(string4);
                String string10 = ApplicationVersionUtils.getLibImplVersion(string6);
                if (string8 != null && string7 != null && !string7.equals(string8) || string10 != null && string9 != null && !string9.equals(string10)) {
                    Loggable loggable = OperationHelper.logAppVersionMismatchLoggable(string3, deploymentData, string4, string6);
                    loggable.log();
                    throw new ManagementException(loggable.getMessage());
                }
                String string11 = string9 == null && string10 == null ? (string8 == null ? string7 : string8) : ApplicationVersionUtils.getLibVersionId(string8 == null ? string7 : string8, string10 == null ? string9 : string10);
                string5 = OperationHelper.getCompositeVersionId(string3, string11, deploymentData);
            }
        }
        if (string5 != null) {
            Debug.deploymentLogger.debug("new app version = <" + string5 + ">");
        }
        return string5;
    }

    private static Loggable logAppVersionMismatchLoggable(String string, DeploymentData deploymentData, String string2, String string3) {
        if (OperationHelper.isLibrary(deploymentData)) {
            String string4 = ApplicationVersionUtils.getLibSpecVersion(string2);
            string4 = string4 == null ? "" : string4;
            String string5 = ApplicationVersionUtils.getLibImplVersion(string2);
            string5 = string5 == null ? "" : string5;
            String string6 = ApplicationVersionUtils.getLibSpecVersion(string3);
            string6 = string6 == null ? "" : string6;
            String string7 = ApplicationVersionUtils.getLibImplVersion(string3);
            string7 = string7 == null ? "" : string7;
            return DeployerRuntimeLogger.logLibVersionMismatchLoggable((String)string, (String)string4, (String)string5, (String)string6, (String)string7);
        }
        return DeployerRuntimeLogger.logAppVersionMismatchLoggable((String)string, (String)string2, (String)string3);
    }

    static boolean undeployAllVersions(DeploymentData deploymentData) {
        return deploymentData != null && deploymentData.getDeploymentOptions() != null && deploymentData.getDeploymentOptions().isUndeployAllVersions();
    }

    static AppDeploymentMBean getActiveVersionIfNeeded(DomainMBean domainMBean, String string, AppDeploymentMBean appDeploymentMBean, String string2, DeploymentData deploymentData, String string3) throws ManagementException {
        AppDeploymentMBean appDeploymentMBean2 = appDeploymentMBean;
        if (string == null && appDeploymentMBean.getVersionIdentifier() != null) {
            appDeploymentMBean2 = ApplicationVersionUtils.getActiveAppDeployment(domainMBean, string2, OperationHelper.isAdminMode(deploymentData));
            if (OperationHelper.undeployAllVersions(deploymentData)) {
                if (appDeploymentMBean2 != null) {
                    DeployerRuntimeLogger.logRemoveAllActiveAppVersion((String)string3, (String)"allversions", (String)string2, (String)appDeploymentMBean2.getVersionIdentifier());
                }
            } else {
                if (appDeploymentMBean2 == null) {
                    Loggable loggable = DeployerRuntimeLogger.logNoActiveAppLoggable((String)string2, (String)string3);
                    loggable.log();
                    throw new ManagementException(loggable.getMessage());
                }
                DeployerRuntimeLogger.logActiveAppVersionWarning((String)string2, (String)appDeploymentMBean2.getVersionIdentifier(), (String)string3);
            }
        }
        return appDeploymentMBean2;
    }

    static AppDeploymentMBean getActiveVersion(DomainMBean domainMBean, AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData) throws ManagementException {
        if (appDeploymentMBean == null || appDeploymentMBean.getVersionIdentifier() != null) {
            return null;
        }
        return ApplicationVersionUtils.getActiveAppDeployment(domainMBean, appDeploymentMBean.getApplicationName(), OperationHelper.isAdminMode(deploymentData));
    }

    private static void validateSource(String string, String string2) throws ManagementException {
        if (string2 == null || string2.equals("")) {
            return;
        }
        if (!new File(string2).exists()) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidSourceLoggable((String)string2, (String)string, (String)"No application files exist");
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void validateVersionForDeprecatedOp(DeploymentData deploymentData, String string, String string2, int n) throws ManagementException {
        String string3 = OperationHelper.getArchiveVersionIdFromData(deploymentData, string);
        if (string3 != null) {
            Loggable loggable = DeployerRuntimeLogger.logVersionNotAllowedForDeprecatedOpLoggable((String)ApplicationVersionUtils.getDisplayName(OperationHelper.ensureAppName(string), string3), (String)string2, (String)OperationHelper.getTaskString(n));
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void validateMaxAppVersions(DomainMBean domainMBean, String string, String string2) throws ManagementException {
        if (string2 == null || string2.equals("")) {
            return;
        }
        AppDeploymentMBean[] appDeploymentMBeanArray = ApplicationVersionUtils.getAppDeployments(domainMBean, string, true);
        DeploymentConfigurationMBean deploymentConfigurationMBean = domainMBean.getDeploymentConfiguration();
        if (deploymentConfigurationMBean == null) {
            Loggable loggable = DeployerRuntimeLogger.logFailedToObtainConfigLoggable();
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
        int n = deploymentConfigurationMBean.getMaxAppVersions();
        if (appDeploymentMBeanArray != null && appDeploymentMBeanArray.length >= n) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
                String string3 = appDeploymentMBeanArray[i].getVersionIdentifier();
                if (string2.equals(string3)) {
                    return;
                }
                stringBuffer.append(string3);
                if (i == appDeploymentMBeanArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            Loggable loggable = DeployerRuntimeLogger.logMaxAppVersionsExceededLoggable((String)ApplicationVersionUtils.getDisplayName(string, string2), (String)string, (int)n, (String)stringBuffer.toString());
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void validateVersionIdFormat(String string, String string2) throws ManagementException {
        if (string2 == null || string2.equals("")) {
            return;
        }
        if (string2.length() > 215) {
            Loggable loggable = DeployerRuntimeLogger.logVersionIdLengthExceededLoggable((String)string, (String)ApplicationVersionUtils.getDisplayVersionId(string2), (int)215);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
        if (!ApplicationVersionUtils.isVersionIdValid(string2)) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidVersionIdLoggable((String)string, (String)ApplicationVersionUtils.getDisplayVersionId(string2));
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void validateSourceVersion(AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData, String string) throws ManagementException {
        String string2 = ApplicationVersionUtils.getArchiveVersion(appDeploymentMBean);
        String string3 = OperationHelper.getArchiveVersionIdFromSource(appDeploymentMBean.getAbsoluteSourcePath(), deploymentData, string);
        if (string2 != null && !string2.equals(string3)) {
            Loggable loggable = DeployerRuntimeLogger.logAppVersionMismatch2Loggable((String)appDeploymentMBean.getApplicationName(), (String)string2, (String)string3);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void validateNonVersionWithVersion(String string, AppDeploymentMBean appDeploymentMBean, String string2, String string3) throws ManagementException {
        if (string == null && appDeploymentMBean.getVersionIdentifier() != null) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidAppVersion2Loggable((String)string2, (String)appDeploymentMBean.getVersionIdentifier(), (String)string3);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void validateVersionWithNonVersion(DomainMBean domainMBean, String string, String string2, String string3) throws ManagementException {
        AppDeploymentMBean appDeploymentMBean;
        if (string != null && (appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(domainMBean, string2, null)) != null && appDeploymentMBean.getVersionIdentifier() == null) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidAppVersionLoggable((String)string2, (String)string, (String)string3);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void validateRetireTimeout(DomainMBean domainMBean, String string, String string2, DeploymentData deploymentData) throws ManagementException {
        AppDeploymentMBean appDeploymentMBean;
        if (!deploymentData.getDeploymentOptions().isRetireGracefully() && deploymentData.getDeploymentOptions().getRetireTime() > -1 && (appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(domainMBean, string, null)) == null) {
            throw new ManagementException(DeployerRuntimeLogger.invalidRetireTimeout((String)string, (String)string2, (int)deploymentData.getDeploymentOptions().getRetireTime()));
        }
    }

    static void validateVersionStagingAndPath(DomainMBean domainMBean, String string, String string2, String string3) throws ManagementException {
        if (string2 == null || string3 == null) {
            return;
        }
        AppDeploymentMBean[] appDeploymentMBeanArray = ApplicationVersionUtils.getAppDeployments(domainMBean, string2);
        if (appDeploymentMBeanArray == null) {
            return;
        }
        try {
            String string4 = new File(string).getCanonicalPath();
            for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
                if (!"nostage".equals(appDeploymentMBeanArray[i].getStagingMode()) || !OperationHelper.isSameCanonicalPaths(string4, appDeploymentMBeanArray[i])) continue;
                Loggable loggable = DeployerRuntimeLogger.logInvalidNewSource2Loggable((String)string2, (String)string3, (String)string4, (String)appDeploymentMBeanArray[i].getVersionIdentifier());
                loggable.log();
                throw new ManagementException(loggable.getMessage());
            }
        }
        catch (IOException iOException) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidSourceLoggable((String)string, (String)ApplicationVersionUtils.getDisplayName(string2, string3), (String)iOException.getMessage());
            loggable.log();
            throw new ManagementException(loggable.getMessage(), (Throwable)iOException);
        }
    }

    static void validateVersionTargets(DomainMBean domainMBean, String string, DeploymentData deploymentData, String string2) throws ManagementException {
        if (string2 == null || deploymentData == null || !deploymentData.hasTargets()) {
            return;
        }
        AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(domainMBean, string, null);
        if (appDeploymentMBean != null && appDeploymentMBean.getVersionIdentifier() != null) {
            Set set;
            Set set2 = TargetHelper.getAllTargetedServers(appDeploymentMBean);
            try {
                set = deploymentData.getAllTargetedServers(deploymentData.getAllLogicalTargets(), domainMBean);
            }
            catch (Throwable throwable) {
                if (OperationHelper.isDebugEnabled()) {
                    OperationHelper.debug("Cannot obtain targeted servers for " + string + " from " + deploymentData, throwable);
                }
                return;
            }
            if (!set2.containsAll(set) || !set.containsAll(set2)) {
                Loggable loggable = DeployerRuntimeLogger.logInvalidTargetsForAppVersionLoggable((String)string, (String)string2, (String)set2.toString(), (String)set.toString());
                loggable.log();
                throw new ManagementException(loggable.getMessage());
            }
        }
    }

    static void validateTargets(DomainMBean domainMBean, DeploymentData deploymentData, AppDeploymentMBean appDeploymentMBean, String string) throws ManagementException {
        if (!deploymentData.hasTargets()) {
            return;
        }
        OperationHelper.checkForClusterTargetSubset(domainMBean, deploymentData, appDeploymentMBean, string);
        OperationHelper.checkForTargetListSubset(appDeploymentMBean, deploymentData);
    }

    static void checkForTargetListSubset(AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData) {
        Map map = OperationHelper.createTargetMap(appDeploymentMBean);
        if (deploymentData.getGlobalTargets().length != 0) {
            Set set = (Set)map.get(appDeploymentMBean.getName());
            Object object = OperationHelper.createTargetSet(deploymentData.getGlobalTargets());
            OperationHelper.verifyTargets(appDeploymentMBean.getApplicationIdentifier(), set, (Set)object);
        }
        if (deploymentData.hasModuleTargets()) {
            for (Object object : deploymentData.getAllModuleTargets().keySet()) {
                Set set = OperationHelper.createTargetSet((String[])deploymentData.getAllModuleTargets().get(object));
                Set set2 = (Set)map.get(appDeploymentMBean.getName());
                if (map.keySet().contains(object)) {
                    set2 = (Set)map.get(object);
                }
                OperationHelper.verifyTargets((String)object, set2, set);
            }
        }
    }

    static void checkForClusterTargetSubset(DomainMBean domainMBean, DeploymentData deploymentData, AppDeploymentMBean appDeploymentMBean, String string) throws ManagementException {
        OperationHelper.checkForClusterTargetSubset(domainMBean, deploymentData, appDeploymentMBean, string, false);
    }

    static void checkForClusterTargetSubset(DomainMBean domainMBean, DeploymentData deploymentData, AppDeploymentMBean appDeploymentMBean, String string, boolean bl) throws ManagementException {
        if (OperationHelper.isAppHasClusterTargets(appDeploymentMBean)) {
            String[] stringArray = deploymentData.getGlobalTargets();
            List list = OperationHelper.getAppClusterTargets(appDeploymentMBean);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            OperationHelper.checkTargetsPartOfCluster(domainMBean, appDeploymentMBean.getApplicationIdentifier(), list, arrayList, string, bl);
        }
    }

    private static List getAppClusterTargets(AppDeploymentMBean appDeploymentMBean) {
        ArrayList<TargetMBean> arrayList = new ArrayList<TargetMBean>();
        TargetMBean[] targetMBeanArray = appDeploymentMBean.getTargets();
        if (targetMBeanArray != null) {
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                if (!(targetMBeanArray[i] instanceof ClusterMBean)) continue;
                arrayList.add(targetMBeanArray[i]);
            }
        }
        return arrayList;
    }

    private static void checkTargetsPartOfCluster(DomainMBean domainMBean, String string, List list, List list2, String string2, boolean bl) throws ManagementException {
        for (String string3 : list2) {
            ServerMBean serverMBean = domainMBean.lookupServer(string3);
            if (serverMBean == null) continue;
            for (ClusterMBean clusterMBean : list) {
                Set set = clusterMBean.getServerNames();
                if (!set.contains(string3) || list2.contains(clusterMBean.getName())) continue;
                if (bl) {
                    DeployerRuntimeLogger.logPartialClusterTarget((String)string, (String)clusterMBean.getName(), (String)string3, (String)string2);
                    continue;
                }
                Loggable loggable = DeployerRuntimeLogger.logInvalidIndividualTargetLoggable((String)string, (String)clusterMBean.getName(), (String)string3, (String)string2);
                throw new ManagementException(loggable.getMessage());
            }
        }
    }

    private static boolean isAppHasClusterTargets(AppDeploymentMBean appDeploymentMBean) {
        TargetMBean[] targetMBeanArray = appDeploymentMBean.getTargets();
        if (targetMBeanArray != null) {
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                if (!(targetMBeanArray[i] instanceof ClusterMBean)) continue;
                return true;
            }
        }
        return false;
    }

    static Map createTargetMap(AppDeploymentMBean appDeploymentMBean) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        hashMap.put(appDeploymentMBean.getName(), OperationHelper.createTargetSet(appDeploymentMBean.getTargets()));
        SubDeploymentMBean[] subDeploymentMBeanArray = appDeploymentMBean.getSubDeployments();
        if (subDeploymentMBeanArray != null) {
            for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
                hashMap.put(subDeploymentMBeanArray[i].getName(), OperationHelper.createTargetSet(subDeploymentMBeanArray[i].getTargets()));
            }
        }
        return hashMap;
    }

    static void verifyTargets(String string, Set set, Set set2) {
        if (!set2.containsAll(set) && OperationHelper.containsAny(set2, set)) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidTargetSubsetLoggable((String)string, (String)set.toString(), (String)set2.toString());
            loggable.log();
        }
    }

    private static boolean containsAny(Set set, Set set2) {
        for (Object e : set2) {
            if (!set.contains(e)) continue;
            return true;
        }
        return false;
    }

    static Set createTargetSet(TargetMBean[] targetMBeanArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            hashSet.add(targetMBeanArray[i].getName());
        }
        return hashSet;
    }

    static Set createTargetSet(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        return hashSet;
    }

    static boolean isOnlyAdminServerTarget(DomainMBean domainMBean, DeploymentData deploymentData) throws ManagementException {
        if (null == deploymentData) {
            return true;
        }
        if (!deploymentData.hasTargets()) {
            return true;
        }
        try {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(domainMBean.getAdminServerName());
            Set set = deploymentData.getAllTargetedServers(deploymentData.getAllLogicalTargets(), domainMBean);
            if (!hashSet.equals(set)) {
                return false;
            }
        }
        catch (InvalidTargetException invalidTargetException) {
            // empty catch block
        }
        return true;
    }

    static void validateAutoDeployTarget(DomainMBean domainMBean, String string, DeploymentData deploymentData) throws ManagementException {
        AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(domainMBean, string, null);
        if (null != appDeploymentMBean && appDeploymentMBean.isAutoDeployedApp() && !OperationHelper.isOnlyAdminServerTarget(domainMBean, deploymentData)) {
            Loggable loggable = DeployerRuntimeLogger.logNoReTargetOnAutoDeployedAppLoggable((String)string);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void validateSplitDirTarget(DomainMBean domainMBean, String string, DeploymentData deploymentData) throws ManagementException {
        AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(domainMBean, string, null);
        if (null != appDeploymentMBean) {
            try {
                ApplicationFileManager applicationFileManager = ApplicationFileManager.newInstance(appDeploymentMBean.getAbsoluteSourcePath());
                if (applicationFileManager.isSplitDirectory() && !OperationHelper.isOnlyAdminServerTarget(domainMBean, deploymentData)) {
                    Loggable loggable = DeployerRuntimeLogger.logNoReTargetOnSplitDirAppLoggable((String)string);
                    loggable.log();
                    throw new ManagementException(loggable.getMessage());
                }
                OperationHelper.isOnlyAdminServerTarget(domainMBean, deploymentData);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void validateDeployWhileRetire(String string, String string2, AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        if (!RetirementManager.cancelIfNeeded(string, string2)) {
            Loggable loggable = DeployerRuntimeLogger.logActivateWhileRetireInProgressLoggable((String)ApplicationVersionUtils.getDisplayName(appDeploymentMBean));
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void validateUndeployWhileRetire(String string, String string2, AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData, String string3) throws ManagementException {
        if (OperationHelper.isRetirementTask(string3)) {
            return;
        }
        if (OperationHelper.isGracefulProdToAdmin(deploymentData)) {
            if (RetirementManager.isRetirementInProgress(string, string2)) {
                Loggable loggable = DeployerRuntimeLogger.logGracefulUndeployWhileRetireInProgressLoggable((String)ApplicationVersionUtils.getDisplayName(string, string2));
                loggable.log();
                throw new ManagementException(loggable.getMessage());
            }
        } else {
            RetirementManager.cancelIfNeeded(string, string2);
        }
    }

    static void validateModuleType(String string, String string2, AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        if (!(string2 == null || DeployHelper.isModuleType(appDeploymentMBean, ModuleType.EAR) || DeployHelper.isModuleType(appDeploymentMBean, ModuleType.WAR) || appDeploymentMBean instanceof LibraryMBean)) {
            String string3 = appDeploymentMBean.getModuleType();
            Loggable loggable = DeployerRuntimeLogger.logModuleTypeNotSupportedLoggable((String)ApplicationVersionUtils.getDisplayName(string, string2), (String)(string3 == null ? null : string3.toUpperCase(Locale.US)), (String)"EAR, WAR (Webapps, including stateless Webservices)");
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void validatePath(String string, AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        block4: {
            if (string == null) {
                return;
            }
            try {
                String string2 = new File(string).getCanonicalPath();
                if (!OperationHelper.isSameCanonicalPaths(string2, appDeploymentMBean)) {
                    Loggable loggable = DeployerRuntimeLogger.logInvalidNewSourceLoggable((String)string2, (String)ApplicationVersionUtils.getDisplayName(appDeploymentMBean), (String)appDeploymentMBean.getAbsoluteSourcePath());
                    loggable.log();
                    throw new ManagementException(loggable.getMessage());
                }
            }
            catch (IOException iOException) {
                if ("nostage".equals(appDeploymentMBean.getStagingMode())) break block4;
                Loggable loggable = DeployerRuntimeLogger.logInvalidSourceLoggable((String)string, (String)ApplicationVersionUtils.getDisplayName(appDeploymentMBean), (String)iOException.getMessage());
                loggable.log();
                throw new ManagementException(loggable.getMessage(), (Throwable)iOException);
            }
        }
    }

    static boolean isGracefulProdToAdmin(DeploymentData deploymentData) {
        if (deploymentData == null || deploymentData.getDeploymentOptions() == null) {
            return false;
        }
        return deploymentData.getDeploymentOptions().isGracefulProductionToAdmin();
    }

    static boolean isSameCanonicalPaths(String string, AppDeploymentMBean appDeploymentMBean) throws IOException {
        String string2 = appDeploymentMBean.getAbsoluteSourcePath();
        if (string2 == null && string != null) {
            return false;
        }
        if (string2 == null && string == null) {
            return true;
        }
        String string3 = new File(string2).getCanonicalPath();
        if (OperationHelper.isDebugEnabled()) {
            OperationHelper.debug("Validating new path, " + string + ", against configured path, " + string3);
        }
        return string.equals(string3);
    }

    static void assertModeIsStage(AppDeploymentMBean appDeploymentMBean, String string) throws ManagementException {
        String string2 = appDeploymentMBean.getStagingMode();
        if (string2 != null && !string2.equals("stage")) {
            Loggable loggable = DeployerRuntimeLogger.logErrorStagingModeLoggable((String)string, (String)string2);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void assertAppIsNonNull(AppDeploymentMBean appDeploymentMBean, String string, String string2, String string3) throws ManagementException {
        if (appDeploymentMBean == null) {
            Loggable loggable = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().isRestartRequired() ? DeployerRuntimeLogger.logNullAppNonDynamicLoggable((String)ApplicationVersionUtils.getDisplayName(string, string2), (String)string3) : DeployerRuntimeLogger.logNullAppLoggable((String)ApplicationVersionUtils.getDisplayName(string, string2), (String)string3);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void assertAppIsActive(AppDeploymentMBean appDeploymentMBean, String string, String string2, String string3) throws ManagementException {
        if (appDeploymentMBean == null) {
            return;
        }
        String string4 = appRTStateMgr.getCurrentState(appDeploymentMBean);
        if (string4 != null && (string4.equals("STATE_RETIRED") || string4.equals("STATE_UPDATE_PENDING"))) {
            Loggable loggable = DeployerRuntimeLogger.logNonActiveAppLoggable((String)ApplicationVersionUtils.getDisplayName(string, string2), (String)string4, (String)string3);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void assertAppIsNotRetired(AppDeploymentMBean appDeploymentMBean, String string, String string2, String string3) throws ManagementException {
        if (appDeploymentMBean == null) {
            return;
        }
        String string4 = appRTStateMgr.getCurrentState(appDeploymentMBean);
        if (string4 != null && string4.equals("STATE_RETIRED")) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidAppStateLoggable((String)ApplicationVersionUtils.getDisplayName(string, string2), (String)string4, (String)string3);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void assertNameIsNonNull(String string, String string2) throws ManagementException {
        if (string == null) {
            Loggable loggable = DeployerRuntimeLogger.logNullAppLoggable((String)"null", (String)string2);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void assertSourceIsNonNull(String string, String string2, String string3) throws ManagementException {
        if (string == null) {
            Loggable loggable = DeployerRuntimeLogger.logNoSourceLoggable((String)ApplicationVersionUtils.getDisplayName(string2, string3));
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void assertInfoIsNonNull(DeploymentData deploymentData, String string, String string2) throws ManagementException {
        if (deploymentData == null || !deploymentData.hasFiles()) {
            Loggable loggable = DeployerRuntimeLogger.logNullInfoLoggable((String)ApplicationVersionUtils.getDisplayName(string, string2));
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void assertNoChangeInStagingMode(String string, AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        if (string != null && appDeploymentMBean.getStagingMode() != null && !string.equals(appDeploymentMBean.getStagingMode())) {
            Loggable loggable = DeployerRuntimeLogger.logMisMatchStagingModeLoggable((String)ApplicationVersionUtils.getDisplayName(appDeploymentMBean), (String)appDeploymentMBean.getStagingMode(), (String)string);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    static void assertTargetIsNonNull(DeploymentData deploymentData) throws ManagementException {
        if (deploymentData != null && deploymentData.hasTargets()) {
            return;
        }
        String string = DeployerRuntimeLogger.operationRequiresTarget();
        throw new ManagementException(string);
    }

    static void assertPlanIsNonNull(DeploymentData deploymentData) throws ManagementException {
        if (deploymentData != null && deploymentData.getDeploymentPlan() != null) {
            return;
        }
        String string = DeployerRuntimeLogger.operationRequiresPlan();
        throw new ManagementException(string);
    }

    static boolean isAdminMode(DeploymentData deploymentData) {
        if (deploymentData == null || deploymentData.getDeploymentOptions() == null) {
            return false;
        }
        return deploymentData.getDeploymentOptions().isTestMode();
    }

    public static void setAdminMode(AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData, String string) throws ManagementException {
        if (appDeploymentMBean == null) {
            if (OperationHelper.isDebugEnabled()) {
                OperationHelper.debug("OperationHelper.setAdminMode(): Deployment is null");
            }
            return;
        }
        if (OperationHelper.isDebugEnabled()) {
            OperationHelper.debug("OperationHelper.setAdminMode(): For application = " + appDeploymentMBean.getName() + ", defaultState = " + string);
        }
        boolean bl = OperationHelper.isAdminMode(deploymentData);
        if (OperationHelper.isDebugEnabled()) {
            OperationHelper.debug("OperationHelper.setAdminMode(): AdminMode from deployData: " + bl);
        }
        String string2 = bl ? "STATE_ADMIN" : string;
        OperationHelper.setState(appDeploymentMBean, deploymentData, string2);
    }

    public static void setState(AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData, String string) throws ManagementException {
        if (appDeploymentMBean == null) {
            return;
        }
        OperationHelper.resetUnconfiguredTargets(appDeploymentMBean);
        if (OperationHelper.isDebugEnabled()) {
            OperationHelper.debug("OperationHelper.setState(): Setting intended state for app : " + appDeploymentMBean.getName() + " to : " + string);
        }
        appRTStateMgr.setState(appDeploymentMBean.getName(), deploymentData.getAllLogicalTargets().toArray(new String[0]), string);
        deploymentData.setIntendedState(string);
    }

    private static void resetUnconfiguredTargets(AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        ApplicationRuntimeState applicationRuntimeState = appRTStateMgr.get(appDeploymentMBean.getName());
        if (applicationRuntimeState != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Map map = applicationRuntimeState.getAppTargetState();
            if (map != null) {
                Object object;
                Set set = DeployHelper.getAllTargetNames(appDeploymentMBean);
                if (OperationHelper.isDebugEnabled()) {
                    object = "";
                    for (String string : set) {
                        object = (String)object + string + " ";
                    }
                    OperationHelper.debug("Targets assoc with " + appDeploymentMBean.getName() + ": " + (String)object);
                }
                object = map.keySet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string;
                    string = (String)iterator.next();
                    if (set.contains(string)) continue;
                    arrayList.add(string);
                    if (!OperationHelper.isDebugEnabled()) continue;
                    OperationHelper.debug("Resetting intended state for " + appDeploymentMBean.getName() + " on target " + string);
                }
            }
            if (!arrayList.isEmpty()) {
                appRTStateMgr.resetState(appDeploymentMBean.getName(), arrayList.toArray(new String[0]));
            }
        }
    }

    static boolean hasFiles(DeploymentData deploymentData) {
        return deploymentData.getFiles() != null && deploymentData.getFiles().length > 0;
    }

    static String ensureAppName(String string) {
        return ApplicationVersionUtils.getApplicationName(string);
    }

    static void validateRedeploySource(String string, String string2, AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        if (string2 == null) {
            Loggable loggable = DeployerRuntimeLogger.logRedeployWithSrcNotAllowedForNonVersionLoggable((String)string);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
        if (appDeploymentMBean != null && string2.equals(appDeploymentMBean.getVersionIdentifier())) {
            Loggable loggable = DeployerRuntimeLogger.logRedeployWithSrcNotAllowedForSameVersionLoggable((String)ApplicationVersionUtils.getDisplayName(appDeploymentMBean));
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    public static void logTaskFailed(String string, int n) {
        OperationHelper.logTaskFailed(string, OperationHelper.getTaskString(n));
    }

    public static void logTaskFailed(String string, int n, Throwable throwable) {
        OperationHelper.logTaskFailed(string, OperationHelper.getTaskString(n), throwable);
    }

    public static String getTaskString(int n) {
        switch (n) {
            case 1: {
                return textformatter.messageActivate();
            }
            case 11: {
                return textformatter.messageDeploy();
            }
            case 3: {
                return textformatter.messageDeactivate();
            }
            case 12: {
                return textformatter.messageUndeploy();
            }
            case 7: {
                return textformatter.messageStart();
            }
            case 8: {
                return textformatter.messageStop();
            }
            case 4: {
                return textformatter.messageRemove();
            }
            case 6: {
                return textformatter.messageDistribute();
            }
            case 5: {
                return textformatter.messageUnprepare();
            }
            case 9: {
                return textformatter.messageRedeploy();
            }
            case 10: {
                return textformatter.messageUpdate();
            }
            case 13: {
                return textformatter.messageRetire();
            }
        }
        throw new AssertionError();
    }

    private static boolean isRetirementTask(String string) {
        return RetirementManager.isRetireTaskId(string);
    }

    private static void logTaskFailed(String string, String string2, Throwable throwable) {
        if (throwable == null) {
            if (string != null) {
                DeployerRuntimeLogger.logTaskFailed((String)ApplicationVersionUtils.getDisplayName(string), (String)string2);
            } else {
                DeployerRuntimeLogger.logTaskFailedNoApp((String)string2);
            }
        } else if (string != null) {
            DeployerRuntimeLogger.logTaskFailedWithError((String)ApplicationVersionUtils.getDisplayName(string), (String)string2, (String)throwable.getMessage());
        } else {
            DeployerRuntimeLogger.logTaskFailedNoAppWithError((String)string2, (String)throwable.getMessage());
        }
    }

    private static void logTaskFailed(String string, String string2) {
        OperationHelper.logTaskFailed(string, string2, null);
    }

    public static void assertNoMixedTargeting(DeploymentData deploymentData) throws ManagementException {
        if (deploymentData != null && !deploymentData.hasFiles() && !deploymentData.isTargetsFromConfig() && deploymentData.hasSubModuleTargets() && deploymentData.hasModuleTargets()) {
            Thread.dumpStack();
            throw new ManagementException(DeployerRuntimeLogger.mixedTargetError());
        }
    }

    public static void assertNoChangedAltDDs(DeploymentData deploymentData) throws ManagementException {
        if (deploymentData != null) {
            String string = deploymentData.getAltDescriptorPath();
            String string2 = deploymentData.getAltWLSDescriptorPath();
            if (string != null && !string.equals("")) {
                throw new ManagementException(DeployerRuntimeLogger.invalidAltDDDuringRedeploy());
            }
            if (string2 != null && !string2.equals("")) {
                throw new ManagementException(DeployerRuntimeLogger.invalidAltDDDuringRedeploy());
            }
        }
    }

    public static String normalizePaths(String string, DeploymentData deploymentData) {
        string = OperationHelper.normalize(string);
        deploymentData.setRootDirectory(OperationHelper.normalize(deploymentData.getRootDirectory()));
        deploymentData.setDeploymentPlan(OperationHelper.normalize(deploymentData.getDeploymentPlan()));
        deploymentData.setConfigDirectory(OperationHelper.normalize(deploymentData.getConfigDirectory()));
        return string;
    }

    private static String normalize(String string) {
        return FileUtils.normalize((String)string);
    }

    private static void debug(String string, Throwable throwable) {
        Debug.deploymentDebug(string, throwable);
    }

    private static void debug(String string) {
        Debug.deploymentDebug(string);
    }

    private static boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }
}

