/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.adminserver.operations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.internal.adminserver.operations.AbstractOperation;
import weblogic.deploy.internal.adminserver.operations.DeployOperation;
import weblogic.deploy.internal.adminserver.operations.OperationHelper;
import weblogic.j2ee.J2EEUtils;
import weblogic.logging.Loggable;
import weblogic.management.ApplicationException;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.DeploymentTaskRuntime;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.FileUtils;

public final class RedeployOperation
extends AbstractOperation {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public RedeployOperation() {
        this.taskType = 9;
    }

    protected String getAutoDeployErrorMsg(String string) {
        Loggable loggable = DeployerRuntimeLogger.invalidRedeployOnAutodeployedAppLoggable((String)string);
        return loggable.getMessage();
    }

    protected final AppDeploymentMBean updateConfiguration(String string, String string2, String string3, DeploymentData deploymentData, String string4, boolean bl) throws ManagementException {
        AppDeploymentMBean appDeploymentMBean;
        String string5 = OperationHelper.getAppName(string2, deploymentData, string);
        String string6 = OperationHelper.getVersionIdFromData(deploymentData, string2);
        String string7 = OperationHelper.getTaskString(this.taskType);
        DomainMBean domainMBean = this.beanFactory.getEditableDomain();
        if (RedeployOperation.isDebugEnabled()) {
            this.printDebugStartMessage(string, string5, string6, deploymentData, string4, string7, string3);
        }
        OperationHelper.assertNameIsNonNull(string5, string7);
        if (string6 != null) {
            appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(domainMBean, string5, string6);
        } else {
            appDeploymentMBean = ApplicationVersionUtils.getActiveAppDeployment(domainMBean, string5);
            if (appDeploymentMBean == null) {
                appDeploymentMBean = ApplicationVersionUtils.getActiveAppDeployment(domainMBean, string5, true);
            }
        }
        try {
            OperationHelper.assertAppIsNonNull(appDeploymentMBean, string5, string6, string7);
            OperationHelper.assertAppIsActive(appDeploymentMBean, string5, string6, string7);
            RedeployOperation.checkUpdateForArchiveApp(deploymentData, appDeploymentMBean);
            OperationHelper.validateTargets(domainMBean, deploymentData, appDeploymentMBean, string7);
            if (string != null) {
                AppDeploymentMBean appDeploymentMBean2 = new DeployOperation().updateConfiguration(string, string2, string3, deploymentData, string4, bl);
                this.taskType = 1;
                return appDeploymentMBean2;
            }
            OperationHelper.assertNoMixedTargeting(deploymentData);
            OperationHelper.assertNoChangedAltDDs(deploymentData);
            appDeploymentMBean = OperationHelper.getActiveVersionIfNeeded(domainMBean, string6, appDeploymentMBean, string5, deploymentData, string7);
            this.reconcileMBeans(deploymentData, appDeploymentMBean, true);
            return appDeploymentMBean;
        }
        catch (ApplicationException applicationException) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidAppLoggable((String)appDeploymentMBean.getAbsoluteSourcePath(), (String)string5, (String)applicationException.getMessage());
            loggable.log();
            throw new ManagementException(loggable.getMessage(), (Throwable)((Object)applicationException));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidSourceLoggable((String)appDeploymentMBean.getAbsoluteSourcePath(), (String)string5, (String)fileNotFoundException.getMessage());
            loggable.log();
            throw new ManagementException(loggable.getMessage(), (Throwable)fileNotFoundException);
        }
    }

    protected final void postTaskCreationConfigurationUpdate(AppDeploymentMBean appDeploymentMBean, String string, DeploymentData deploymentData) throws ManagementException {
        if (deploymentData.getDelete()) {
            try {
                String string2 = ManagementService.getRuntimeAccess(kernelId).getServer().getUploadDirectoryName();
                string2 = new File(string2).getCanonicalPath().toLowerCase();
                String string3 = new File(appDeploymentMBean.getAbsoluteSourcePath()).getCanonicalPath().toLowerCase();
                if (string3.startsWith(string2)) {
                    File file = new File(appDeploymentMBean.getAbsoluteSourcePath());
                    String[] stringArray = deploymentData.getFiles();
                    for (int i = 0; i < stringArray.length; ++i) {
                        File file2 = new File(file, stringArray[i]);
                        if (RedeployOperation.isDebugEnabled()) {
                            RedeployOperation.debugDeployer("Removing " + file2.getPath() + " from upload dir");
                        }
                        FileUtils.remove((File)file2);
                    }
                }
            }
            catch (IOException iOException) {
                throw new ManagementException((Throwable)iOException);
            }
        }
    }

    protected AbstractOperation createCopy() {
        return new RedeployOperation();
    }

    protected void mergeWithUndeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithDeploy(abstractOperation);
        abstractOperation.mergeUndeployWithDistributeOrDeployOrRedeploy(this);
    }

    protected void mergeWithRedeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithRedeploy(abstractOperation);
        this.mergeWithSameOperationType(abstractOperation);
    }

    protected void mergeWithDeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithDeploy(abstractOperation);
        if (!this.areTargetsSame(abstractOperation)) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
            DeploymentData deploymentData = deploymentTaskRuntime.getDeploymentData();
            DeploymentTaskRuntime deploymentTaskRuntime2 = this.getTaskRuntime();
            DeploymentData deploymentData2 = deploymentTaskRuntime2.getDeploymentData();
            deploymentData.setDeploymentPlan(deploymentData2.getDeploymentPlan());
            deploymentData.addGlobalTargets(deploymentData2.getGlobalTargets());
            if (deploymentData2.hasModuleTargets()) {
                deploymentData.addOrUpdateModuleTargets(deploymentData2.getAllModuleTargets());
            }
            if (deploymentData2.hasSubModuleTargets()) {
                deploymentData.addOrUpdateSubModuleTargets(deploymentData2.getAllSubModuleTargets());
            }
        }
        abstractOperation.setAsDelegatorTo(this);
    }

    protected void mergeWithUpdate(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithUpdate(abstractOperation);
        DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
        DeploymentData deploymentData = deploymentTaskRuntime.getDeploymentData();
        DeploymentTaskRuntime deploymentTaskRuntime2 = this.getTaskRuntime();
        DeploymentData deploymentData2 = deploymentTaskRuntime2.getDeploymentData();
        if (deploymentData.hasFiles()) {
            deploymentData.setPlanUpdate(deploymentData2.isPlanUpdate());
        }
        deploymentData.setDeploymentPlan(deploymentData2.getDeploymentPlan());
        deploymentData.addGlobalTargets(deploymentData2.getGlobalTargets());
        if (deploymentData2.hasModuleTargets()) {
            deploymentData.addOrUpdateModuleTargets(deploymentData2.getAllModuleTargets());
        }
        if (deploymentData2.hasSubModuleTargets()) {
            deploymentData.addOrUpdateSubModuleTargets(deploymentData2.getAllSubModuleTargets());
        }
        abstractOperation.setAsDelegatorTo(this);
    }

    protected void mergeWithDistribute(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithDistribute(abstractOperation);
        if (!this.areTargetsSame(abstractOperation)) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime();
            DeploymentData deploymentData = deploymentTaskRuntime.getDeploymentData();
            DeploymentTaskRuntime deploymentTaskRuntime2 = this.getTaskRuntime();
            DeploymentData deploymentData2 = deploymentTaskRuntime2.getDeploymentData();
            deploymentData.setDeploymentPlan(deploymentData2.getDeploymentPlan());
            deploymentData.addGlobalTargets(deploymentData2.getGlobalTargets());
            if (deploymentData2.hasModuleTargets()) {
                deploymentData.addOrUpdateModuleTargets(deploymentData2.getAllModuleTargets());
            }
            if (deploymentData2.hasSubModuleTargets()) {
                deploymentData.addOrUpdateSubModuleTargets(deploymentData2.getAllSubModuleTargets());
            }
        }
        abstractOperation.setAsDelegatorTo(this);
    }

    private static void checkUpdateForArchiveApp(DeploymentData deploymentData, AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        File file;
        if (deploymentData == null) {
            return;
        }
        if ((OperationHelper.hasFiles(deploymentData) || deploymentData.hasModuleTargets()) && (file = new File(appDeploymentMBean.getAbsoluteSourcePath())).isFile() && J2EEUtils.isValidArchiveName(file.getName())) {
            Loggable loggable = appDeploymentMBean.getVersionIdentifier() == null ? DeployerRuntimeLogger.logPartialRedeployOfArchiveLoggable((String)appDeploymentMBean.getName()) : DeployerRuntimeLogger.logPartialRedeployOfVersionedArchiveLoggable((String)ApplicationVersionUtils.getDisplayName(appDeploymentMBean));
            throw new DeploymentException(loggable.getMessage());
        }
    }
}

