/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.adminserver.operations;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.beans.factory.InvalidTargetException;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.adminserver.operations.AbstractOperation;
import weblogic.deploy.internal.adminserver.operations.OperationHelper;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.DeploymentTaskRuntime;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.ApplicationRuntimeState;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.RetirementManager;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StringUtils;

public final class RemoveOperation
extends AbstractOperation {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final String taskName;

    public RemoveOperation(int n) {
        this.taskType = 4;
        this.taskName = OperationHelper.getTaskString(n);
    }

    public final DeploymentTaskRuntimeMBean execute(String string, String string2, String string3, DeploymentData deploymentData, String string4, boolean bl, AuthenticatedSubject authenticatedSubject) throws ManagementException {
        String string5 = OperationHelper.ensureAppName(string2);
        String string6 = OperationHelper.getVersionIdFromData(deploymentData, string2);
        if (RemoveOperation.isDebugEnabled()) {
            this.printDebugStartMessage(string, string5, string6, deploymentData, string4, this.taskName, string3);
        }
        if (string6 != null && string6.length() > 0) {
            return super.execute(string, string2, string3, deploymentData, string4, bl, authenticatedSubject);
        }
        ArrayList arrayList = OperationHelper.undeployAllVersions(deploymentData) ? this.getNonActiveAppVersions(string2) : this.getRetiredAppVersions(string2);
        if (arrayList == null || arrayList.size() == 0) {
            return super.execute(string, string2, string3, deploymentData, string4, bl, authenticatedSubject);
        }
        boolean bl2 = this.editAccessHelper.isCurrentEditor(authenticatedSubject);
        try {
            if (bl2 && this.editAccessHelper.getEditDomainBean(authenticatedSubject) == null) {
                bl2 = false;
            }
            if (!bl2) {
                this.editAccessHelper.startEditSession(false);
            }
        }
        catch (ManagementException managementException) {
            deploymentManager.deploymentFailedBeforeStart(this.deployment, managementException, bl2, authenticatedSubject, this.controlOperation);
            throw managementException;
        }
        deploymentData.getDeploymentOptions().setUseNonexclusiveLock(true);
        DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = null;
        AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getActiveAppDeployment(string5);
        if (appDeploymentMBean != null) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("RemoveOperation.execute active app " + appDeploymentMBean);
            }
            deploymentTaskRuntimeMBean = super.execute(string, appDeploymentMBean.getName(), string3, deploymentData, string4, bl, authenticatedSubject);
        }
        DeploymentData deploymentData2 = new DeploymentData();
        deploymentData2.getDeploymentOptions().setUseNonexclusiveLock(true);
        for (AppDeploymentMBean appDeploymentMBean2 : arrayList) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("RemoveOperation.execute other app " + appDeploymentMBean2);
            }
            DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean2 = new RemoveOperation(this.taskType).execute(null, appDeploymentMBean2.getName(), appDeploymentMBean2.getStagingMode(), deploymentData2, RetirementManager.getRetireTaskId(appDeploymentMBean2.getName()), true, authenticatedSubject);
            if (deploymentTaskRuntimeMBean != null) continue;
            deploymentTaskRuntimeMBean = deploymentTaskRuntimeMBean2;
        }
        if (!bl2) {
            try {
                this.editAccessHelper.saveEditSessionChanges();
                this.editAccessHelper.activateEditSessionChanges(deploymentData.getTimeOut());
            }
            catch (ManagementException managementException) {
                deploymentManager.deploymentFailedBeforeStart(this.deployment, managementException, bl2, authenticatedSubject, this.controlOperation);
                throw managementException;
            }
        }
        return deploymentTaskRuntimeMBean;
    }

    protected String getAutoDeployErrorMsg(String string) {
        Loggable loggable = DeployerRuntimeLogger.invalidUndeployOnAutodeployedAppLoggable((String)string);
        return loggable.getMessage();
    }

    protected final AppDeploymentMBean updateConfiguration(String string, String string2, String string3, DeploymentData deploymentData, String string4, boolean bl) throws ManagementException {
        String string5 = OperationHelper.ensureAppName(string2);
        String string6 = OperationHelper.getVersionIdFromData(deploymentData, string2);
        DomainMBean domainMBean = this.beanFactory.getEditableDomain();
        OperationHelper.assertNameIsNonNull(string2, this.taskName);
        AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(domainMBean, string5, string6);
        OperationHelper.assertAppIsNonNull(appDeploymentMBean, string5, string6, this.taskName);
        this.verifyIfTargetsAreValid(string5, string6, deploymentData, appDeploymentMBean);
        appDeploymentMBean = OperationHelper.getActiveVersionIfNeeded(domainMBean, string6, appDeploymentMBean, string5, deploymentData, this.taskName);
        string6 = appDeploymentMBean.getVersionIdentifier();
        OperationHelper.validateUndeployWhileRetire(string5, string6, appDeploymentMBean, deploymentData, string4);
        return appDeploymentMBean;
    }

    protected final void postTaskCreationConfigurationUpdate(AppDeploymentMBean appDeploymentMBean, String string, DeploymentData deploymentData) throws ManagementException {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        AppDeploymentMBean appDeploymentMBean2 = ApplicationVersionUtils.getAppDeployment(domainMBean, appDeploymentMBean.getName(), null);
        if (appDeploymentMBean2 == null && Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("RemoveOperation.postTaskCreationConfigurationUpdate gets null AppMBean from runtime tree for " + appDeploymentMBean.getName() + " !!!");
        }
        ((DeploymentTaskRuntime)this.deploymentTask).initMBeans(appDeploymentMBean2);
        try {
            this.beanFactory.removeTargetsInDeploymentData(deploymentData, appDeploymentMBean);
        }
        catch (InvalidTargetException invalidTargetException) {
            Loggable loggable = DeployerRuntimeLogger.logAppNotTargetedLoggable((String)invalidTargetException.getMessage(), (String)string);
            throw new ManagementException(loggable.getMessage());
        }
        if (TargetHelper.getAllTargetedServers(appDeploymentMBean).isEmpty()) {
            String string2 = appDeploymentMBean.getName();
            this.beanFactory.removeMBean(appDeploymentMBean);
            RemoveOperation.invalidateCache(appDeploymentMBean);
        }
    }

    protected AbstractOperation createCopy() {
        return new RemoveOperation(this.taskType);
    }

    protected void mergeWithUndeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithUndeploy(abstractOperation);
        this.mergeWithSameOperationType(abstractOperation);
    }

    protected void mergeWithRedeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithRedeploy(abstractOperation);
        abstractOperation.mergeWithUndeploy(this);
    }

    protected void mergeWithDeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithDeploy(abstractOperation);
        abstractOperation.mergeWithUndeploy(this);
    }

    protected void mergeWithUpdate(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithUpdate(abstractOperation);
        abstractOperation.mergeWithUndeploy(this);
    }

    protected void mergeWithDistribute(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithDistribute(abstractOperation);
        abstractOperation.mergeWithUndeploy(this);
    }

    private ArrayList getNonActiveAppVersions(String string) {
        String string2 = OperationHelper.ensureAppName(string);
        AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getActiveAppDeployment(string2);
        if (appDeploymentMBean != null && appDeploymentMBean.getVersionIdentifier() == null) {
            return null;
        }
        AppDeploymentMBean[] appDeploymentMBeanArray = ApplicationVersionUtils.getAppDeployments(string2);
        if (appDeploymentMBeanArray == null || appDeploymentMBeanArray.length == 0 || appDeploymentMBeanArray[0].getVersionIdentifier() == null) {
            return null;
        }
        ArrayList<AppDeploymentMBean> arrayList = new ArrayList<AppDeploymentMBean>();
        for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
            if (appDeploymentMBean != null && appDeploymentMBeanArray[i].getName().equals(appDeploymentMBean.getName())) continue;
            if (AppRuntimeStateManager.getManager().isRetiredVersion(appDeploymentMBeanArray[i])) {
                DeployerRuntimeLogger.logRemoveAllRetiredAppVersion((String)this.taskName, (String)"allversions", (String)string2, (String)appDeploymentMBeanArray[i].getVersionIdentifier());
            } else {
                DeployerRuntimeLogger.logRemoveAllRetiringAppVersion((String)this.taskName, (String)"allversions", (String)string2, (String)appDeploymentMBeanArray[i].getVersionIdentifier());
            }
            arrayList.add(appDeploymentMBeanArray[i]);
        }
        return arrayList;
    }

    private ArrayList getRetiredAppVersions(String string) {
        String string2 = OperationHelper.ensureAppName(string);
        AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getActiveAppDeployment(string2);
        if (appDeploymentMBean != null && appDeploymentMBean.getVersionIdentifier() == null) {
            return null;
        }
        AppDeploymentMBean[] appDeploymentMBeanArray = ApplicationVersionUtils.getAppDeployments(string2);
        if (appDeploymentMBeanArray == null || appDeploymentMBeanArray.length == 0 || appDeploymentMBeanArray[0].getVersionIdentifier() == null) {
            return null;
        }
        ArrayList<AppDeploymentMBean> arrayList = new ArrayList<AppDeploymentMBean>();
        for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
            if (appDeploymentMBean != null && appDeploymentMBeanArray[i].getName().equals(appDeploymentMBean.getName())) continue;
            if (AppRuntimeStateManager.getManager().isRetiredVersion(appDeploymentMBeanArray[i])) {
                DeployerRuntimeLogger.logRemoveRetiredAppVersion((String)this.taskName, (String)string2, (String)appDeploymentMBeanArray[i].getVersionIdentifier());
                arrayList.add(appDeploymentMBeanArray[i]);
                continue;
            }
            DeployerRuntimeLogger.logRetiringAppVersionNotRemoved((String)this.taskName, (String)string2, (String)appDeploymentMBeanArray[i].getVersionIdentifier());
        }
        return arrayList;
    }

    private void verifyIfTargetsAreValid(String string, String string2, DeploymentData deploymentData, AppDeploymentMBean appDeploymentMBean) throws DeploymentException, ManagementException {
        if (deploymentData == null) {
            return;
        }
        if (deploymentData.hasModuleTargets()) {
            this.verifyModuleTargets(appDeploymentMBean, deploymentData.getAllModuleTargets());
        }
        if (deploymentData.getGlobalTargets().length > 0) {
            OperationHelper.checkForClusterTargetSubset(this.beanFactory.getEditableDomain(), deploymentData, appDeploymentMBean, this.taskName);
            this.verifyForPinnedDeployment(string, string2, deploymentData, appDeploymentMBean);
        }
    }

    private void verifyModuleTargets(AppDeploymentMBean appDeploymentMBean, Map map) throws DeploymentException {
        String string = appDeploymentMBean.getName();
        ApplicationRuntimeState applicationRuntimeState = AppRuntimeStateManager.getManager().get(string);
        if (applicationRuntimeState == null) {
            return;
        }
        Map map2 = applicationRuntimeState.getModules();
        Map map3 = OperationHelper.createTargetMap(appDeploymentMBean);
        Set set = map2.keySet();
        for (String string2 : map.keySet()) {
            Loggable loggable;
            Object object;
            if (!set.contains(string2) && !map3.keySet().contains(string2)) {
                object = StringUtils.join((String[])AppRuntimeStateManager.getManager().getModuleIds(string), (String)",");
                loggable = DeployerRuntimeLogger.logNoSuchModuleLoggable((String)string, (String)string2, (String)object);
                throw new DeploymentException(loggable.getMessage());
            }
            object = map3.keySet();
            loggable = (Loggable)map.get(string2);
            if (object.contains(string2)) {
                this.compareTargetNames(string2, (String[])loggable, (Set)map3.get(string2));
                continue;
            }
            this.compareTargetNames(string2, (String[])loggable, (Set)map3.get(string));
        }
    }

    private void compareTargetNames(String string, String[] stringArray, Set set) throws DeploymentException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (set.contains(stringArray[i])) continue;
            Loggable loggable = DeployerRuntimeLogger.logAppNotTargetedLoggable((String)stringArray[i], (String)string);
            throw new DeploymentException(loggable.getMessage());
        }
    }

    private void verifyForPinnedDeployment(String string, String string2, DeploymentData deploymentData, AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        int n;
        DomainMBean domainMBean = this.beanFactory.getEditableDomain();
        ClusterMBean[] clusterMBeanArray = domainMBean.getClusters();
        if (clusterMBeanArray == null || clusterMBeanArray.length == 0) {
            return;
        }
        String[] stringArray = deploymentData.getGlobalTargets();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        HashMap<Object, List> hashMap = new HashMap<Object, List>();
        TargetMBean[] targetMBeanArray = appDeploymentMBean.getTargets();
        for (n = 0; n < clusterMBeanArray.length; ++n) {
            ClusterMBean clusterMBean = clusterMBeanArray[n];
            Object object = this.getPinnedServers(clusterMBean, targetMBeanArray);
            if (object.isEmpty()) continue;
            hashMap.put(clusterMBean, (List)object);
        }
        if (hashMap.isEmpty()) {
            return;
        }
        for (n = 0; n < stringArray.length; ++n) {
            for (Object object : hashMap.keySet()) {
                Set set;
                List list = (List)hashMap.get(object);
                if (list.contains(stringArray[n]) || !(set = object.getServerNames()).contains(stringArray[n])) continue;
                String string3 = ApplicationVersionUtils.getApplicationId(string, string2);
                Loggable loggable = DeployerRuntimeLogger.logInvalidTargetForPinnedAppUndeployLoggable((String)string3, (String)stringArray[n], (String)this.taskName);
                throw new DeploymentException(loggable.getMessage());
            }
        }
    }

    private List getPinnedServers(ClusterMBean clusterMBean, TargetMBean[] targetMBeanArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (targetMBeanArray != null) {
            Set set = clusterMBean.getServerNames();
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                String string;
                if (!(targetMBeanArray[i] instanceof ServerMBean) || !set.contains(string = targetMBeanArray[i].getName())) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    protected void defaultSubModuleTargets(String string, String string2, DeploymentData deploymentData, DomainMBean domainMBean) throws ManagementException {
    }

    protected boolean isRemote(DeploymentData deploymentData) {
        return false;
    }
}

