/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.adminserver.operations;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.internal.adminserver.operations.AbstractOperation;
import weblogic.deploy.internal.adminserver.operations.OperationHelper;
import weblogic.deploy.service.datatransferhandlers.SourceCache;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.logging.Loggable;
import weblogic.management.ApplicationException;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;

public class UpdateOperation
extends AbstractOperation {
    public UpdateOperation() {
        this.taskType = 10;
    }

    protected String getAutoDeployErrorMsg(String string) {
        Loggable loggable = DeployerRuntimeLogger.invalidRedeployOnAutodeployedAppLoggable((String)string);
        return loggable.getMessage();
    }

    protected AppDeploymentMBean updateConfiguration(String string, String string2, String string3, DeploymentData deploymentData, String string4, boolean bl) throws ManagementException {
        String string5 = OperationHelper.ensureAppName(string2);
        String string6 = OperationHelper.getVersionIdFromData(deploymentData, string2);
        String string7 = OperationHelper.getTaskString(this.taskType);
        DomainMBean domainMBean = this.beanFactory.getEditableDomain();
        if (UpdateOperation.isDebugEnabled()) {
            this.printDebugStartMessage(string, string5, string6, deploymentData, string4, string7, string3);
        }
        OperationHelper.assertNameIsNonNull(string5, string7);
        AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(domainMBean, string5, string6);
        try {
            OperationHelper.assertAppIsNonNull(appDeploymentMBean, string5, string6, string7);
            OperationHelper.assertInfoIsNonNull(deploymentData, string5, string6);
            OperationHelper.assertPlanIsNonNull(deploymentData);
            appDeploymentMBean = OperationHelper.getActiveVersionIfNeeded(domainMBean, string6, appDeploymentMBean, string5, deploymentData, string7);
            this.reconcileMBeans(deploymentData, appDeploymentMBean);
            return appDeploymentMBean;
        }
        catch (ApplicationException applicationException) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidAppLoggable((String)appDeploymentMBean.getAbsoluteSourcePath(), (String)string5, (String)applicationException.getMessage());
            loggable.log();
            throw new ManagementException(loggable.getMessage(), (Throwable)((Object)applicationException));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Loggable loggable = DeployerRuntimeLogger.logInvalidSourceLoggable((String)appDeploymentMBean.getAbsoluteSourcePath(), (String)string5, (String)fileNotFoundException.getMessage());
            loggable.log();
            throw new ManagementException(loggable.getMessage(), (Throwable)fileNotFoundException);
        }
    }

    protected void reconcileMBeans(DeploymentData deploymentData, AppDeploymentMBean appDeploymentMBean, boolean bl) throws ApplicationException, FileNotFoundException, ManagementException {
        File file;
        String[] stringArray;
        super.reconcileMBeans(deploymentData, appDeploymentMBean, bl);
        String string = deploymentData.getConfigDirectory();
        if (string != null && ((stringArray = (file = new File(string)).list()) == null || stringArray.length == 0)) {
            string = null;
        }
        appDeploymentMBean.setPlanDir(string);
        appDeploymentMBean.setPlanPath(deploymentData.getDeploymentPlan());
        SourceCache.updateDescriptorsInCache(appDeploymentMBean);
    }

    protected AbstractOperation createCopy() {
        return new UpdateOperation();
    }

    protected void mergeWithUndeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithUndeploy(abstractOperation);
        throw new DeploymentException("UpdateOperation cannot be merged with UndeployOperation");
    }

    protected void mergeWithRedeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithRedeploy(abstractOperation);
        abstractOperation.mergeWithUpdate(this);
    }

    protected void mergeWithDeploy(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithDeploy(abstractOperation);
        abstractOperation.mergeWithUpdate(this);
    }

    protected void mergeWithUpdate(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithUpdate(abstractOperation);
        this.mergeWithSameOperationType(abstractOperation);
    }

    protected void mergeWithDistribute(AbstractOperation abstractOperation) throws ManagementException {
        super.mergeWithDistribute(abstractOperation);
        abstractOperation.mergeWithUpdate(this);
    }

    protected void setupDDPaths(DeploymentData deploymentData) {
        int n;
        if (this.planBean == null || deploymentData == null || deploymentData.hasFiles()) {
            return;
        }
        ModuleOverrideBean[] moduleOverrideBeanArray = this.planBean.getModuleOverrides();
        if (moduleOverrideBeanArray == null) {
            return;
        }
        String string = null;
        for (n = 0; n < moduleOverrideBeanArray.length; ++n) {
            if (!this.planBean.rootModule(moduleOverrideBeanArray[n].getModuleName())) continue;
            string = moduleOverrideBeanArray[n].getModuleName();
            break;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
            n = moduleOverrideBeanArray[i].getModuleName().equals(string) ? 1 : 0;
            ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBeanArray[i].getModuleDescriptors();
            if (moduleDescriptorBeanArray == null) continue;
            for (int j = 0; j < moduleDescriptorBeanArray.length; ++j) {
                String string2 = moduleDescriptorBeanArray[j].getUri();
                if (n == 0) {
                    string2 = moduleOverrideBeanArray[i].getModuleName() + "/" + string2;
                }
                if (!this.hasOverrides(moduleDescriptorBeanArray[j], string2, deploymentData) || arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        deploymentData.setFile(arrayList.toArray(new String[arrayList.size()]));
    }

    private boolean hasOverrides(ModuleDescriptorBean moduleDescriptorBean, String string, DeploymentData deploymentData) {
        if (moduleDescriptorBean.getVariableAssignments() != null && moduleDescriptorBean.getVariableAssignments().length > 0) {
            return true;
        }
        if (moduleDescriptorBean.isExternal() && deploymentData.getConfigDirectory() != null) {
            File file = new File(deploymentData.getConfigDirectory(), string);
            return file.exists();
        }
        return false;
    }
}

