/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.diagnostics;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import weblogic.application.utils.XMLWriter;
import weblogic.deploy.internal.diagnostics.ImageProvider;
import weblogic.deploy.service.internal.adminserver.AdminDeploymentServiceImageProvider;
import weblogic.deploy.service.internal.targetserver.TargetDeploymentServiceImageProvider;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.management.deploy.DeploymentTaskImageProvider;
import weblogic.management.deploy.internal.AppRuntimeStateImageProvider;

public class DeploymentImageSource
implements ImageSource {
    private boolean timedOut = false;
    private ImageProvider[] ips = null;

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        XMLWriter xMLWriter = null;
        try {
            try {
                xMLWriter = new XMLWriter(new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8")));
                xMLWriter.addElement("deployment");
                this.ips = IPFactory.getProviders();
                for (int i = 0; i < this.ips.length && !this.timedOut; ++i) {
                    this.ips[i].writeDiagnosticImage(xMLWriter);
                }
                Object var5_5 = null;
                if (xMLWriter != null) {
                    xMLWriter.finish();
                }
            }
            catch (IOException iOException) {
                throw new ImageSourceCreationException((Throwable)iOException);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (xMLWriter != null) {
                xMLWriter.finish();
            }
            throw throwable;
        }
    }

    public void timeoutImageCreation() {
        this.timedOut = true;
        for (int i = 0; i < this.ips.length && !this.timedOut; ++i) {
            this.ips[i].timeoutImageCreation();
        }
    }

    private static class IPFactory {
        private IPFactory() {
        }

        public static ImageProvider[] getProviders() {
            return new ImageProvider[]{new AppRuntimeStateImageProvider(), new DeploymentTaskImageProvider(), new AdminDeploymentServiceImageProvider(), new TargetDeploymentServiceImageProvider()};
        }
    }
}

