/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver;

import weblogic.application.ApplicationContext;
import weblogic.application.Deployment;
import weblogic.application.ModuleListener;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.common.Debug;
import weblogic.deploy.compatibility.NotificationBroadcaster;
import weblogic.deploy.container.DeploymentContext;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.utils.StackTraceUtils;

public class AppContainerInvoker
implements Deployment {
    private final Deployment delegate;
    private DeploymentState state;
    private final String id;
    private static final AppRuntimeStateManager appRTStateMgr = AppRuntimeStateManager.getManager();

    AppContainerInvoker(Deployment deployment, BasicDeploymentMBean basicDeploymentMBean, DeploymentState deploymentState) {
        this.delegate = deployment;
        this.state = deploymentState;
        this.id = basicDeploymentMBean.getName();
    }

    private void debug(String string) {
        Debug.deploymentDebug(string);
    }

    private boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    public void setStateRef(DeploymentState deploymentState) {
        this.state = deploymentState;
    }

    public Deployment getDelegate() {
        return this.delegate;
    }

    public void prepare(DeploymentContext deploymentContext) throws DeploymentException {
        this.sendJMXNotification("preparing");
        try {
            if (this.isDebugEnabled()) {
                this.debug("Calling app container 'prepare' for '" + this.id + "'");
            }
            this.delegate.prepare(deploymentContext);
            if (this.state != null) {
                this.state.setCurrentState(((Object)ModuleListener.STATE_PREPARED).toString());
            }
        }
        catch (Throwable throwable) {
            this.sendJMXNotification("failed");
            throw this.getOrCreateDeploymentException(throwable);
        }
        this.sendJMXNotification("prepared");
    }

    public void activate(DeploymentContext deploymentContext) throws DeploymentException {
        this.sendJMXNotification("activating");
        try {
            if (this.isDebugEnabled()) {
                this.debug("Calling app container 'activate' for '" + this.id + "'");
            }
            this.delegate.activate(deploymentContext);
            if (this.state != null) {
                this.state.setCurrentState(((Object)ModuleListener.STATE_ADMIN).toString());
            }
        }
        catch (Throwable throwable) {
            this.sendJMXNotification("failed");
            throw this.getOrCreateDeploymentException(throwable);
        }
    }

    public void deactivate(DeploymentContext deploymentContext) throws DeploymentException {
        this.sendJMXNotification("deactivating");
        try {
            if (this.isDebugEnabled()) {
                this.debug("Calling app container 'deactivate' for '" + this.id + "'");
            }
            this.delegate.deactivate(deploymentContext);
            if (this.state != null) {
                this.state.setCurrentState(((Object)ModuleListener.STATE_PREPARED).toString());
            }
        }
        catch (Throwable throwable) {
            this.sendJMXNotification("failed");
            throw this.getOrCreateDeploymentException(throwable);
        }
        this.sendJMXNotification("deactivated");
    }

    public void unprepare(DeploymentContext deploymentContext) throws DeploymentException {
        this.sendJMXNotification("unpreparing");
        try {
            if (this.isDebugEnabled()) {
                this.debug("Calling app container 'unprepare' for '" + this.id + "'");
            }
            this.delegate.unprepare(deploymentContext);
            if (this.state != null) {
                this.state.setCurrentState(((Object)ModuleListener.STATE_NEW).toString());
            }
        }
        catch (Throwable throwable) {
            this.sendJMXNotification("failed");
            throw this.getOrCreateDeploymentException(throwable);
        }
        this.sendJMXNotification("unprepared");
    }

    public void remove(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.isDebugEnabled()) {
            this.debug("Calling app container 'remove' for '" + this.id + "'");
        }
        try {
            this.delegate.remove(deploymentContext);
        }
        catch (Throwable throwable) {
            throw this.getOrCreateDeploymentException(throwable);
        }
    }

    public void prepareUpdate(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.isDebugEnabled()) {
            this.debug("Calling app container 'prepareUpdate' for '" + this.id + "'");
        }
        try {
            this.delegate.prepareUpdate(deploymentContext);
            if (this.state != null) {
                this.state.setCurrentState(((Object)ModuleListener.STATE_UPDATE_PENDING).toString());
            }
        }
        catch (Throwable throwable) {
            throw this.getOrCreateDeploymentException(throwable);
        }
    }

    public void activateUpdate(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.isDebugEnabled()) {
            this.debug("Calling app container 'activateUpdate' for '" + this.id + "'");
        }
        try {
            this.delegate.activateUpdate(deploymentContext);
            if (this.state != null) {
                this.state.setCurrentState(((Object)ModuleListener.STATE_ACTIVE).toString());
            }
        }
        catch (Throwable throwable) {
            throw this.getOrCreateDeploymentException(throwable);
        }
    }

    public void rollbackUpdate(DeploymentContext deploymentContext) {
        block4: {
            if (this.isDebugEnabled()) {
                this.debug("Calling app container 'rollbackUpdate' for '" + this.id + "'");
            }
            try {
                this.delegate.rollbackUpdate(deploymentContext);
                if (this.state != null) {
                    this.state.setCurrentState(((Object)ModuleListener.STATE_ACTIVE).toString());
                }
            }
            catch (Throwable throwable) {
                if (!this.isDebugEnabled()) break block4;
                this.debug("App container 'rollbackUpdate' for id '" + this.id + "' failed - " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
        }
    }

    public void adminToProduction(DeploymentContext deploymentContext) throws DeploymentException {
        try {
            if (this.isDebugEnabled()) {
                this.debug("Calling app container 'adminToProd' for '" + this.id + "'");
            }
            this.delegate.adminToProduction(deploymentContext);
            if (this.state != null) {
                this.state.setCurrentState(((Object)ModuleListener.STATE_ACTIVE).toString());
            }
            this.setActiveAppVersionIfNeeded();
        }
        catch (Throwable throwable) {
            this.sendJMXNotification("failed");
            throw this.getOrCreateDeploymentException(throwable);
        }
        this.sendJMXNotification("activated");
    }

    public void gracefulProductionToAdmin(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.isDebugEnabled()) {
            this.debug("Calling app container 'graceful prodToAdmin' for '" + this.id + "'");
        }
        try {
            this.delegate.gracefulProductionToAdmin(deploymentContext);
            if (this.state != null) {
                this.state.setCurrentState(((Object)ModuleListener.STATE_ADMIN).toString());
            }
        }
        catch (Throwable throwable) {
            throw this.getOrCreateDeploymentException(throwable);
        }
    }

    public void forceProductionToAdmin(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.isDebugEnabled()) {
            this.debug("Calling app container 'force prodToAdmin' for '" + this.id + "'");
        }
        try {
            this.delegate.forceProductionToAdmin(deploymentContext);
            if (this.state != null) {
                this.state.setCurrentState(((Object)ModuleListener.STATE_ADMIN).toString());
            }
        }
        catch (Throwable throwable) {
            throw this.getOrCreateDeploymentException(throwable);
        }
    }

    public void stop(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.isDebugEnabled()) {
            this.debug("Calling app container 'stop' for '" + this.id + "'");
        }
        try {
            this.delegate.stop(deploymentContext);
        }
        catch (Throwable throwable) {
            throw this.getOrCreateDeploymentException(throwable);
        }
    }

    public void start(DeploymentContext deploymentContext) throws DeploymentException {
        if (this.isDebugEnabled()) {
            this.debug("Calling app container 'start' for '" + this.id + "'");
        }
        try {
            this.delegate.start(deploymentContext);
        }
        catch (Throwable throwable) {
            throw this.getOrCreateDeploymentException(throwable);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.delegate.getApplicationContext();
    }

    private void sendJMXNotification(String string) {
        if (this.state != null) {
            NotificationBroadcaster.sendAppNotification(string, this.id, null);
            this.state.addAppXition(string);
        }
    }

    private void setActiveAppVersionIfNeeded() {
        if (ApplicationVersionUtils.getVersionId(this.id) == null) {
            return;
        }
        try {
            appRTStateMgr.setActiveVersion(this.id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private DeploymentException getOrCreateDeploymentException(Throwable throwable) {
        if (throwable instanceof DeploymentException) {
            return (DeploymentException)((Object)throwable);
        }
        return new DeploymentException("Unexpected error encountered", throwable);
    }
}

