/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import weblogic.application.Deployment;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.event.DeploymentEvent;
import weblogic.deploy.event.DeploymentEventManager;
import weblogic.deploy.internal.DeploymentVersion;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.targetserver.BasicDeployment;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.DeploymentContextImpl;
import weblogic.deploy.internal.targetserver.DeploymentManager;
import weblogic.deploy.internal.targetserver.datamanagement.AppData;
import weblogic.deploy.internal.targetserver.datamanagement.Data;
import weblogic.deploy.internal.targetserver.operations.AbstractOperation;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.ApplicationRuntimeState;
import weblogic.management.deploy.internal.MBeanConverter;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public class AppDeployment
extends BasicDeployment {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public AppDeployment(AppDeploymentMBean appDeploymentMBean) {
        super(appDeploymentMBean);
    }

    private AppDeploymentMBean getAppDeploymentMBean() {
        return (AppDeploymentMBean)this.getDeploymentMBean();
    }

    public void verifyAppVersionSecurity(AbstractOperation abstractOperation) throws DeploymentException {
        AppDeploymentMBean appDeploymentMBean;
        if (AppDeployment.isDebugEnabled()) {
            AppDeployment.debug("BasicDeployment.verifyAppVersionSecurity(" + this.name + ")");
        }
        if ((appDeploymentMBean = this.getAppDeploymentMBean()) != null && appDeploymentMBean.getVersionIdentifier() != null && !SecurityServiceManager.isApplicationVersioningSupported((String)"weblogicDEFAULT")) {
            Loggable loggable = SlaveDeployerLogger.logSecurityRealmDoesNotSupportAppVersioningLoggable((String)"weblogicDEFAULT", (String)ApplicationVersionUtils.getDisplayName(appDeploymentMBean));
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
    }

    private void updateAggregateDeploymentVersion() {
        DeploymentVersion deploymentVersion;
        String string = this.getAppDeploymentMBean().getName();
        ApplicationRuntimeState applicationRuntimeState = AppRuntimeStateManager.getManager().get(string);
        if (applicationRuntimeState != null && (deploymentVersion = applicationRuntimeState.getDeploymentVersion()) != null) {
            DeploymentManager.getInstance().addOrUpdateTargetDeploymentVersion(string, deploymentVersion);
        }
    }

    public void prepare() throws IOException, DeploymentException {
        AppDeploymentMBean appDeploymentMBean = this.getAppDeploymentMBean();
        if (!DeployHelper.isOkToTransition(appDeploymentMBean, server, "STATE_PREPARED")) {
            return;
        }
        if (AppDeployment.isDebugEnabled()) {
            AppDeployment.debug("Preparing " + this.name);
        }
        try {
            try {
                DeploymentContextImpl deploymentContextImpl;
                this.stageFilesForStatic();
                this.staticDeployValidationForNonVersion();
                MBeanConverter.setupNew81MBean(appDeploymentMBean);
                this.fireVetoableDeploymentEvent();
                Deployment deployment = this.createDeployment(appDeploymentMBean, null);
                appDeploymentMBean.setDeploymentPlanDescriptor(this.parsePlan());
                if (this.task == null) {
                    deploymentContextImpl = DeployHelper.createDeploymentContext(appDeploymentMBean);
                    deploymentContextImpl.setStaticDeploymentOperation(true);
                    deploymentContextImpl.setStoppedModules(AppRuntimeStateManager.getManager().getStoppedModuleIds(appDeploymentMBean.getName(), serverName));
                } else {
                    deploymentContextImpl = this.task.getDeploymentContext();
                }
                deploymentContextImpl.setAdminModeTransition(true);
                this.startLifecycleStateManager();
                this.relayStagingState(this.getStagingState());
                this.updateAggregateDeploymentVersion();
                try {
                    try {
                        deployment.prepare(deploymentContextImpl);
                    }
                    catch (Throwable throwable) {
                        this.failDeployment();
                        throw throwable;
                    }
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.finishLifecycleStateManager();
                    throw throwable;
                }
                this.finishLifecycleStateManager();
                this.fireDeployedDeploymentEvent();
            }
            catch (Throwable throwable) {
                this.failDeployment();
                this.finishLifecycleStateManager();
                DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
                SlaveDeployerLogger.logIntialPrepareApplicationFailedLoggable((String)this.name, (Exception)((Object)deploymentException)).log();
                throw deploymentException;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            throw throwable;
        }
    }

    private void staticDeployValidationForNonVersion() throws DeploymentException {
        AppDeploymentMBean appDeploymentMBean = this.getAppDeploymentMBean();
        String string = appDeploymentMBean.getVersionIdentifier();
        if (string != null && string.length() != 0) {
            return;
        }
        String string2 = ApplicationVersionUtils.getManifestVersion(this.getLocalAppFileOrDir().getAbsolutePath());
        if (string2 != null && string2.length() != 0) {
            Loggable loggable = SlaveDeployerLogger.logStaticDeploymentOfNonVersionAppCheckLoggable((String)this.getName());
            throw new DeploymentException(loggable.getMessage());
        }
    }

    private void failDeployment() {
        if (this.getState() == null) {
            this.setState(new DeploymentState(this.deploymentMBean.getName(), "__Lifecycle_taskid__", 0));
        }
        this.getState().setCurrentState("STATE_FAILED", true);
    }

    public DeploymentPlanBean parsePlan() throws DeploymentException {
        try {
            AppDeploymentMBean appDeploymentMBean = this.getAppDeploymentMBean();
            if (!appDeploymentMBean.isInternalApp()) {
                appDeploymentMBean.setDeploymentPlanDescriptor(null);
            }
            return appDeploymentMBean.getDeploymentPlanDescriptor();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DeploymentException(illegalArgumentException.toString(), illegalArgumentException);
        }
    }

    public static File getFile(AppDeploymentMBean appDeploymentMBean) {
        File file;
        if (DeployHelper.getStagingMode(serverName, appDeploymentMBean).equals("nostage")) {
            String string = appDeploymentMBean.getAbsoluteSourcePath();
            file = new File(string);
        } else {
            file = new File(appDeploymentMBean.getLocalSourcePath());
        }
        return file;
    }

    public void removeDeployment() {
        AppDeploymentMBean appDeploymentMBean = this.getAppDeploymentMBean();
        if (appDeploymentMBean != null) {
            this.deploymentManager.removeDeployment(appDeploymentMBean);
        }
    }

    public void updateDescriptorsPathInfo() {
        AppData appData = (AppData)this.getLocalData();
        appData.updateDescriptorsPathInfo(this.getAppDeploymentMBean());
    }

    private void fireDeployedDeploymentEvent() {
        AppDeploymentMBean appDeploymentMBean = this.getAppDeploymentMBean();
        DeploymentEventManager.sendDeploymentEvent(DeploymentEvent.create(this, DeploymentEvent.APP_DEPLOYED, appDeploymentMBean, true, null, TargetHelper.getTargetNames(appDeploymentMBean.getTargets())));
    }

    protected Data createLocalData() {
        AppDeploymentMBean appDeploymentMBean = this.getAppDeploymentMBean();
        String string = DeployHelper.getStagingMode(serverName, appDeploymentMBean);
        return new AppData(appDeploymentMBean, this, string, appDeploymentMBean.getLocalSourcePath(), null);
    }

    public String getRelativePlanPath() throws IOException {
        AppData appData = (AppData)this.getLocalData();
        return appData.getRelativePlanPath();
    }
}

