/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import weblogic.application.Deployment;
import weblogic.application.ModuleListener;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.TargetUtils;
import weblogic.deploy.container.DeploymentContext;
import weblogic.deploy.event.DeploymentEventManager;
import weblogic.deploy.event.VetoableDeploymentEvent;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.targetserver.AppContainerInvoker;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.DeploymentContextImpl;
import weblogic.deploy.internal.targetserver.DeploymentManager;
import weblogic.deploy.internal.targetserver.OrderedDeployments;
import weblogic.deploy.internal.targetserver.datamanagement.Data;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdateRequestInfo;
import weblogic.deploy.internal.targetserver.operations.AbstractOperation;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.deploy.internal.targetserver.state.ListenerFactory;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.ApplicationRuntimeState;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;

public abstract class BasicDeployment {
    protected BasicDeploymentMBean deploymentMBean;
    protected final String name;
    protected final String appId;
    private final File localAppFileOrDir;
    private AppContainerInvoker appctrInvoker;
    protected boolean isStaticDeployment = false;
    private GracefulAdminModeHandler gracefulAdminModeHandler = new GracefulAdminModeHandler();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    protected static final ServerMBean server = ManagementService.getRuntimeAccess(kernelId).getServer();
    protected static final String serverName = server.getName();
    protected static final ClusterMBean cluster = server.getCluster();
    protected final weblogic.application.DeploymentManager deploymentManager = weblogic.application.DeploymentManager.getDeploymentManager();
    protected AbstractOperation task;
    private DeploymentState state;
    private ModuleListener ml;
    private Data localData = null;

    public BasicDeployment(BasicDeploymentMBean basicDeploymentMBean) {
        this.deploymentMBean = basicDeploymentMBean;
        this.name = ApplicationVersionUtils.getDisplayName(this.deploymentMBean);
        this.appId = basicDeploymentMBean.getName();
        this.localData = this.createLocalData();
        this.localAppFileOrDir = this.localData.getSourceFile();
        this.dump();
    }

    public void setStatic() {
        this.isStaticDeployment = true;
    }

    public void dump() {
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug("Basic Deployment name: " + this.name);
            BasicDeployment.debug("Staging location: " + this.localAppFileOrDir);
        }
    }

    public String getName() {
        return this.name;
    }

    public abstract void verifyAppVersionSecurity(AbstractOperation var1) throws DeploymentException;

    public void setTask(AbstractOperation abstractOperation) {
        if (this.task != null) {
            this.task = abstractOperation;
        }
    }

    public AbstractOperation getTask() {
        return this.task;
    }

    public Deployment findDeployment() {
        return this.appctrInvoker;
    }

    public void verifyLocalApp() throws DeploymentException {
        if (!this.localAppFileOrDir.exists()) {
            String string = DeployerRuntimeLogger.noAppFilesExist((String)this.localAppFileOrDir.toString());
            throw new DeploymentException(DeployerRuntimeLogger.logInvalidSourceLoggable((String)this.localAppFileOrDir.getAbsolutePath(), (String)this.getName(), (String)string).getMessage());
        }
    }

    public Deployment createDeployment(BasicDeploymentMBean basicDeploymentMBean, DeploymentState deploymentState) throws DeploymentException {
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug("Creating Deployment with Path " + this.localAppFileOrDir);
        }
        this.verifyLocalApp();
        this.appctrInvoker = new AppContainerInvoker(this.deploymentManager.createDeployment(basicDeploymentMBean, this.localAppFileOrDir), basicDeploymentMBean, deploymentState);
        this.setStateRef(deploymentState);
        return this.appctrInvoker;
    }

    public abstract void removeDeployment();

    public abstract void prepare() throws IOException, DeploymentException;

    private void activate(DeploymentContext deploymentContext) throws DeploymentException {
        try {
            Deployment deployment = this.findDeployment();
            if (deployment != null) {
                if (!TargetHelper.isTargetedLocaly(this.deploymentMBean)) {
                    if (BasicDeployment.isDebugEnabled()) {
                        BasicDeployment.debug("server not targeted");
                    }
                    return;
                }
                if (BasicDeployment.isDebugEnabled()) {
                    BasicDeployment.debug("Activate for app=" + this.name);
                }
                if (deploymentContext == null) {
                    deploymentContext = this.task == null || this.task.getDeploymentContext() == null ? DeployHelper.createDeploymentContext(this.deploymentMBean) : this.task.getDeploymentContext();
                }
                deployment.activate(deploymentContext);
            }
        }
        catch (Throwable throwable) {
            DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
            SlaveDeployerLogger.logSetActivationStateFailedLoggable((String)this.name, (boolean)true, (Exception)((Object)deploymentException)).log();
            throw deploymentException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gracefulProductionToAdmin(Deployment deployment, DeploymentContext deploymentContext) throws DeploymentException {
        if (!DeployHelper.isActiveState(deployment)) {
            return;
        }
        AdminModeCallback adminModeCallback = this.gracefulAdminModeHandler.create();
        if (adminModeCallback == null) {
            return;
        }
        if (deploymentContext == null) {
            deploymentContext = this.task == null || this.task.getDeploymentContext() == null ? DeployHelper.createDeploymentContext(this.deploymentMBean) : this.task.getDeploymentContext();
        }
        ((DeploymentContextImpl)deploymentContext).setAdminModeCallback(adminModeCallback);
        try {
            deployment.gracefulProductionToAdmin(deploymentContext);
            adminModeCallback.waitForCompletion(0L);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!this.gracefulAdminModeHandler.isInterrupted()) {
                this.gracefulAdminModeHandler.remove(adminModeCallback);
            }
            throw throwable;
        }
        if (!this.gracefulAdminModeHandler.isInterrupted()) {
            this.gracefulAdminModeHandler.remove(adminModeCallback);
        }
    }

    public void forceProductionToAdmin(Deployment deployment, long l, DeploymentContext deploymentContext) throws DeploymentException {
        if (!DeployHelper.isActiveState(deployment) && !DeployHelper.isAdminState(deployment)) {
            return;
        }
        this.gracefulAdminModeHandler.notifyPending();
        if (l > 0L) {
            AdminModeCallback adminModeCallback = new AdminModeCallback();
            if (deploymentContext == null) {
                deploymentContext = this.task == null || this.task.getDeploymentContext() == null ? DeployHelper.createDeploymentContext(this.deploymentMBean) : this.task.getDeploymentContext();
            }
            ((DeploymentContextImpl)deploymentContext).setAdminModeCallback(adminModeCallback);
            deployment.forceProductionToAdmin(deploymentContext);
            adminModeCallback.waitForCompletion(l);
        } else {
            ((DeploymentContextImpl)deploymentContext).setAdminModeCallback(EarUtils.noopAdminModeCallback);
            deployment.forceProductionToAdmin(deploymentContext);
        }
    }

    private void deactivate(DeploymentContext deploymentContext) {
        try {
            Deployment deployment = this.findDeployment();
            if (deployment != null && DeployHelper.isAdminState(deployment)) {
                if (BasicDeployment.isDebugEnabled()) {
                    BasicDeployment.debug("Deactivating base deployment " + this.name);
                }
                deployment.deactivate(deploymentContext);
            }
        }
        catch (Throwable throwable) {
            DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
            SlaveDeployerLogger.logSetActivationStateFailedLoggable((String)this.name, (boolean)false, (Exception)((Object)deploymentException)).log();
        }
    }

    public void unprepare() {
        Deployment deployment;
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug(" unpreparing application  - " + this.name);
        }
        if ((deployment = this.findDeployment()) != null && DeployHelper.isPreparedState(deployment)) {
            try {
                DeploymentContextImpl deploymentContextImpl;
                if (this.task == null || this.task.getDeploymentContext() == null) {
                    deploymentContextImpl = DeployHelper.createDeploymentContext(this.deploymentMBean);
                    deploymentContextImpl.setStaticDeploymentOperation(true);
                } else {
                    deploymentContextImpl = this.task.getDeploymentContext();
                }
                deployment.unprepare(deploymentContextImpl);
            }
            catch (Throwable throwable) {
                SlaveDeployerLogger.logUnprepareFailed((String)this.name, (Exception)((Object)DeployHelper.convertThrowable(throwable)));
            }
        }
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug(" unprepared application  - " + this.name);
        }
    }

    public void remove() {
        this.remove(true);
    }

    public void remove(boolean bl) {
        block5: {
            try {
                boolean bl2;
                if (bl && !(bl2 = this.removeStagedFiles())) {
                    Loggable loggable = SlaveDeployerLogger.logRemoveStagedFilesFailedLoggable((String)this.name, (String)this.localAppFileOrDir.toString());
                    loggable.log();
                }
                if (BasicDeployment.isDebugEnabled()) {
                    BasicDeployment.debug(" removing basic deployment  - " + this.name);
                }
                this.removeDeployment();
                OrderedDeployments.removeBasicDeployment(this.deploymentMBean);
                if (BasicDeployment.isDebugEnabled()) {
                    BasicDeployment.debug(" removed basic deployment  - " + this.name);
                }
            }
            catch (Throwable throwable) {
                if (!BasicDeployment.isDebugEnabled()) break block5;
                BasicDeployment.debug("Unexpected exception while removing a deployment");
                throwable.printStackTrace();
            }
        }
    }

    protected static void debug(String string) {
        weblogic.deploy.common.Debug.deploymentDebug(string);
    }

    protected static boolean isDebugEnabled() {
        return weblogic.deploy.common.Debug.isDeploymentDebugEnabled();
    }

    public boolean isInternalApp() {
        return this.deploymentMBean instanceof AppDeploymentMBean && ((AppDeploymentMBean)this.deploymentMBean).isInternalApp();
    }

    public BasicDeploymentMBean getDeploymentMBean() {
        return this.deploymentMBean;
    }

    public void activateFromServerLifecycle() throws Exception {
        if (this.deploymentMBean instanceof AppDeploymentMBean && !DeployHelper.isOkToTransition((AppDeploymentMBean)this.deploymentMBean, server, "STATE_ADMIN")) {
            return;
        }
        Deployment deployment = this.findDeployment();
        if (deployment == null) {
            return;
        }
        try {
            try {
                DeploymentContextImpl deploymentContextImpl = this.task == null || this.task.getDeploymentContext() == null ? DeployHelper.createDeploymentContext(this.deploymentMBean) : this.task.getDeploymentContext();
                deploymentContextImpl.setAdminModeTransition(true);
                deploymentContextImpl.setStaticDeploymentOperation(true);
                this.startLifecycleStateManager();
                this.activate(deploymentContextImpl);
            }
            catch (Exception exception) {
                try {
                    this.unprepare();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.getState() != null) {
                    this.getState().setCurrentState("STATE_FAILED", true);
                }
                throw exception;
            }
            Object var5_4 = null;
            this.finishLifecycleStateManager();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.finishLifecycleStateManager();
            throw throwable;
        }
    }

    public void adminToProductionFromServerLifecycle() throws DeploymentException {
        Deployment deployment;
        if (this.deploymentMBean instanceof AppDeploymentMBean && !DeployHelper.isOkToTransition((AppDeploymentMBean)this.deploymentMBean, server, "STATE_ACTIVE")) {
            return;
        }
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug("AdminToRunning for app=" + this.name);
        }
        if ((deployment = this.findDeployment()) == null) {
            return;
        }
        if (!TargetHelper.isTargetedLocaly(this.deploymentMBean)) {
            if (BasicDeployment.isDebugEnabled()) {
                BasicDeployment.debug("server not targeted");
            }
            return;
        }
        DeploymentContextImpl deploymentContextImpl = this.task == null || this.task.getDeploymentContext() == null ? DeployHelper.createDeploymentContext(this.deploymentMBean) : this.task.getDeploymentContext();
        deploymentContextImpl.setStaticDeploymentOperation(true);
        try {
            try {
                this.startLifecycleStateManager();
                deployment.adminToProduction(deploymentContextImpl);
            }
            catch (Throwable throwable) {
                try {
                    this.deactivate(deploymentContextImpl);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    this.unprepare();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                this.removeDeployment();
                DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
                SlaveDeployerLogger.logTransitionAppFromAdminToRunningFailed((String)ApplicationVersionUtils.getDisplayName(this.deploymentMBean), (Throwable)((Object)deploymentException));
                throw deploymentException;
            }
            Object var6_3 = null;
            this.finishLifecycleStateManager();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.finishLifecycleStateManager();
            throw throwable;
        }
    }

    public void productionToAdminFromServerLifecycle(boolean bl) throws DeploymentException {
        Deployment deployment;
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug("RunningToAdmin for app=" + this.name + ", graceful=" + bl);
        }
        if ((deployment = this.findDeployment()) == null) {
            return;
        }
        try {
            block7: {
                try {
                    DeploymentContextImpl deploymentContextImpl = this.task == null || this.task.getDeploymentContext() == null ? DeployHelper.createDeploymentContext(this.deploymentMBean) : this.task.getDeploymentContext();
                    deploymentContextImpl.setAdminModeTransition(true);
                    deploymentContextImpl.setStaticDeploymentOperation(true);
                    this.startLifecycleStateManager();
                    if (bl) {
                        this.gracefulProductionToAdmin(deployment, deploymentContextImpl);
                        break block7;
                    }
                    this.forceProductionToAdmin(deployment, 0L, deploymentContextImpl);
                }
                catch (Throwable throwable) {
                    DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
                    SlaveDeployerLogger.logTransitionAppFromRunningToAdminFailed((String)ApplicationVersionUtils.getDisplayName(this.deploymentMBean), (Throwable)((Object)deploymentException));
                    throw deploymentException;
                }
            }
            Object var6_5 = null;
            this.finishLifecycleStateManager();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.finishLifecycleStateManager();
            throw throwable;
        }
    }

    public void deactivateFromServerLifecycle() throws Exception {
        Deployment deployment = this.findDeployment();
        if (deployment == null) {
            return;
        }
        try {
            try {
                DeploymentContextImpl deploymentContextImpl = this.task == null || this.task.getDeploymentContext() == null ? DeployHelper.createDeploymentContext(this.deploymentMBean) : this.task.getDeploymentContext();
                deploymentContextImpl.setAdminModeTransition(true);
                deploymentContextImpl.setStaticDeploymentOperation(true);
                this.startLifecycleStateManager();
                this.deactivate(deploymentContextImpl);
            }
            catch (Exception exception) {
                try {
                    this.unprepare();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw exception;
            }
            Object var5_4 = null;
            this.finishLifecycleStateManager();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.finishLifecycleStateManager();
            throw throwable;
        }
    }

    protected void startLifecycleStateManager() {
        if (!(this.deploymentMBean instanceof AppDeploymentMBean)) {
            return;
        }
        if (((AppDeploymentMBean)this.deploymentMBean).isInternalApp()) {
            return;
        }
        this.setStateRef(new DeploymentState(this.deploymentMBean.getName(), "__Lifecycle_taskid__", 0));
        this.ml = ListenerFactory.createListener(this.getDeploymentMBean(), "__Lifecycle_taskid__", this.state);
        this.deploymentManager.addModuleListener(this.ml);
    }

    protected void finishLifecycleStateManager() {
        if (this.ml != null) {
            this.deploymentManager.removeModuleListener(this.ml);
        }
        this.relayState();
        this.setStateRef(null);
        this.ml = null;
    }

    protected final void relayState() {
        if (this.state == null) {
            return;
        }
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug("Relaying updated state for app, " + this.state.getId() + " to " + this.state.getCurrentState());
        }
        if (this.state.getTarget() == null) {
            this.state.setTarget(TargetUtils.findLocalTarget(this.deploymentMBean, server).getName());
        }
        if (!ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            AppRuntimeStateManager.getManager().updateState(this.state.getId(), this.state);
        }
        DeploymentManager.getInstance().relayStatus(-1L, this.state);
    }

    protected final void setStagingOnRuntimeState(int n) {
        try {
            AppRuntimeStateManager.getManager().setStagingState(this.deploymentMBean.getName(), new String[]{serverName}, n, this.isInternalApp());
        }
        catch (ManagementException managementException) {
            managementException.printStackTrace();
        }
    }

    public final void relayStagingState(int n) {
        this.setStagingOnRuntimeState(n);
        DeploymentState deploymentState = this.getState();
        if (deploymentState != null) {
            deploymentState.setStagingState(n);
            this.relayState();
        }
    }

    public boolean needRetirement() {
        this.gracefulAdminModeHandler.remove();
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug("needRetirement for " + this.getName() + "=" + !this.gracefulAdminModeHandler.isInterrupted());
        }
        return !this.gracefulAdminModeHandler.isInterrupted();
    }

    public boolean hasPendingGraceful() {
        return this.gracefulAdminModeHandler.hasPending();
    }

    public boolean isGracefulInterrupted() {
        return this.gracefulAdminModeHandler.isInterrupted();
    }

    final File getLocalAppFileOrDir() {
        return this.localAppFileOrDir;
    }

    public void resetMBean(BasicDeploymentMBean basicDeploymentMBean) {
        this.deploymentMBean = basicDeploymentMBean;
    }

    public void setStateRef(DeploymentState deploymentState) {
        this.state = deploymentState;
        AppContainerInvoker appContainerInvoker = (AppContainerInvoker)this.findDeployment();
        if (appContainerInvoker != null) {
            appContainerInvoker.setStateRef(this.state);
        }
    }

    protected void setState(DeploymentState deploymentState) {
        this.state = deploymentState;
    }

    public DeploymentState getState() {
        return this.state;
    }

    protected void fireVetoableDeploymentEvent() throws Throwable {
        try {
            BasicDeploymentMBean basicDeploymentMBean = this.getDeploymentMBean();
            if (basicDeploymentMBean == null) {
                return;
            }
            DeploymentEventManager.sendVetoableDeploymentEvent(VetoableDeploymentEvent.create(this, VetoableDeploymentEvent.APP_DEPLOY, basicDeploymentMBean, true, false, null, TargetHelper.getTargetNames(basicDeploymentMBean.getTargets())));
        }
        catch (ManagementException managementException) {
            throw ManagementException.unWrapExceptions((Throwable)managementException);
        }
    }

    public final int getStagingState() {
        TargetMBean targetMBean = TargetUtils.findLocalTarget(this.deploymentMBean, server);
        int n = AppRuntimeStateManager.getManager().getStagingState(this.deploymentMBean.getName(), targetMBean.getName());
        if (targetMBean instanceof ClusterMBean && n < 0) {
            if (BasicDeployment.isDebugEnabled()) {
                BasicDeployment.debug(" Trying to find Staging State On Application '" + this.deploymentMBean.getName() + "' for target : " + serverName);
            }
            n = AppRuntimeStateManager.getManager().getStagingState(this.deploymentMBean.getName(), serverName);
        }
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug(" Staging State On Application '" + this.deploymentMBean.getName() + "' : " + n);
        }
        return n;
    }

    public ApplicationRuntimeState getAppRuntimeState() {
        return AppRuntimeStateManager.getManager().get(this.appId);
    }

    public final void initDataUpdate(DataUpdateRequestInfo dataUpdateRequestInfo) {
        Debug.assertion((this.localData != null ? 1 : 0) != 0);
        this.localData.initDataUpdate(dataUpdateRequestInfo);
    }

    public final void prepareDataUpdate(String string) throws DeploymentException {
        this.localData.prepareDataUpdate(string);
    }

    public final void commitDataUpdate() throws DeploymentException {
        this.localData.commitDataUpdate();
    }

    public void cancelDataUpdate(long l) {
        this.localData.cancelDataUpdate(l);
    }

    public void closeDataUpdate(long l, boolean bl) {
        this.localData.closeDataUpdate(l, bl);
    }

    public abstract void updateDescriptorsPathInfo();

    protected final Data getLocalData() {
        return this.localData;
    }

    protected abstract Data createLocalData();

    protected void stageFilesForStatic() throws DeploymentException {
        this.initDataUpdate(new DataUpdateRequestInfo(){

            public List getDeltaFiles() {
                return new ArrayList();
            }

            public long getRequestId() {
                return 0L;
            }

            public boolean isStatic() {
                return true;
            }

            public boolean isDelete() {
                return false;
            }

            public boolean isPlanUpdate() {
                return false;
            }
        });
        this.prepareDataUpdate(null);
        this.commitDataUpdate();
    }

    public boolean isAppStaged() {
        return this.localData.isStagingEnabled();
    }

    public boolean removeStagedFiles() {
        return this.localData.removeStagedFiles();
    }

    public final long getArchiveTimeStamp() {
        ApplicationRuntimeState applicationRuntimeState;
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug(" Getting archive timestamp for app " + this.appId);
        }
        if ((applicationRuntimeState = AppRuntimeStateManager.getManager().get(this.appId)) == null || applicationRuntimeState.getDeploymentVersion() == null) {
            return 0L;
        }
        long l = applicationRuntimeState.getDeploymentVersion().getArchiveTimeStamp();
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug(" Returning archive timestamp for app " + this.appId + " = " + l);
        }
        return l;
    }

    public final long getPlanTimeStamp() {
        ApplicationRuntimeState applicationRuntimeState;
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug(" Getting plan timestamp for app " + this.appId);
        }
        if ((applicationRuntimeState = AppRuntimeStateManager.getManager().get(this.appId)) == null || applicationRuntimeState.getDeploymentVersion() == null) {
            return 0L;
        }
        long l = applicationRuntimeState.getDeploymentVersion().getPlanTimeStamp();
        if (BasicDeployment.isDebugEnabled()) {
            BasicDeployment.debug(" Returning plan timestamp for app " + this.appId + " = " + l);
        }
        return l;
    }

    private class GracefulAdminModeHandler {
        private AdminModeCallback pending;
        private boolean interrupted = false;

        private GracefulAdminModeHandler() {
        }

        private synchronized AdminModeCallback create() {
            if (this.pending != null) {
                return null;
            }
            this.pending = new AdminModeCallback();
            return this.pending;
        }

        private synchronized void remove(AdminModeCallback adminModeCallback) {
            if (adminModeCallback == this.pending) {
                this.pending = null;
            }
        }

        private synchronized void remove() {
            this.pending = null;
        }

        private synchronized void notifyPending() {
            if (this.pending == null) {
                return;
            }
            if (BasicDeployment.isDebugEnabled()) {
                BasicDeployment.debug("GracefulAdminModeHandler.notifyPending for: " + BasicDeployment.this.getName());
            }
            this.interrupted = true;
            this.pending.stop();
        }

        private synchronized boolean hasPending() {
            return this.pending != null;
        }

        private synchronized boolean isInterrupted() {
            return this.interrupted;
        }
    }

    private class AdminModeCallback
    implements Deployment.AdminModeCallback {
        private boolean completed = false;

        private AdminModeCallback() {
        }

        public synchronized void stop() {
            this.notify();
        }

        public synchronized void completed() {
            this.completed = true;
            this.notify();
        }

        public synchronized void waitForCompletion(long l) {
            block4: {
                if (this.completed) {
                    return;
                }
                try {
                    this.wait(l * 1000L);
                    if (BasicDeployment.isDebugEnabled()) {
                        BasicDeployment.debug("AdminModeCallback.waitForCompletion done for: " + BasicDeployment.this.getName());
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!BasicDeployment.isDebugEnabled()) break block4;
                    BasicDeployment.debug("AdminModeCallback.waitForCompletion interrupted for: " + BasicDeployment.this.getName());
                }
            }
        }
    }
}

