/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.enterprise.deploy.shared.ModuleType;
import weblogic.application.Deployment;
import weblogic.application.internal.DeploymentStateChecker;
import weblogic.application.utils.TargetUtils;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.targetserver.AppContainerInvoker;
import weblogic.deploy.internal.targetserver.AppDeployment;
import weblogic.deploy.internal.targetserver.BasicDeployment;
import weblogic.deploy.internal.targetserver.DeploymentContextImpl;
import weblogic.deploy.internal.targetserver.SystemResourceDeployment;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.DeployerRuntimeTextTextFormatter;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.AppRuntimeStateRuntimeMBean;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.NestedThrowable;

public class DeployHelper {
    private static final String CONFIG_DIR_PREFIX = DomainDir.getRootDir() + File.separator + "config" + File.separator;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static String getTaskName(int n) {
        return DeployHelper.getTaskName(n, null);
    }

    public static String getTaskName(int n, Locale locale) {
        String string = null;
        DeployerRuntimeTextTextFormatter deployerRuntimeTextTextFormatter = null;
        deployerRuntimeTextTextFormatter = locale == null ? DeployerRuntimeTextTextFormatter.getInstance() : DeployerRuntimeTextTextFormatter.getInstance((Locale)locale);
        switch (n) {
            case 1: {
                string = deployerRuntimeTextTextFormatter.messageActivate();
                break;
            }
            case 3: {
                string = deployerRuntimeTextTextFormatter.messageDeactivate();
                break;
            }
            case 4: {
                string = deployerRuntimeTextTextFormatter.messageRemove();
                break;
            }
            case 5: {
                string = deployerRuntimeTextTextFormatter.messageUnprepare();
                break;
            }
            case 2: {
                string = deployerRuntimeTextTextFormatter.messagePrepare();
                break;
            }
            case 9: {
                string = deployerRuntimeTextTextFormatter.messageRedeploy();
                break;
            }
            case 6: {
                string = deployerRuntimeTextTextFormatter.messageDistribute();
                break;
            }
            case 7: {
                string = deployerRuntimeTextTextFormatter.messageStart();
                break;
            }
            case 8: {
                string = deployerRuntimeTextTextFormatter.messageStop();
                break;
            }
            case 10: {
                string = deployerRuntimeTextTextFormatter.messageUpdate();
                break;
            }
            case 11: {
                string = deployerRuntimeTextTextFormatter.messageDeploy();
                break;
            }
            case 13: {
                string = deployerRuntimeTextTextFormatter.messageRetire();
            }
        }
        return string;
    }

    public static String getStagingMode(String string, AppDeploymentMBean appDeploymentMBean) {
        String string2 = appDeploymentMBean.getStagingMode();
        if (string2 == null || string2.length() == 0) {
            string2 = DeployHelper.getServerStagingMode(string);
        }
        return string2;
    }

    public static String getServerStagingMode(String string) {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        ServerMBean serverMBean = runtimeAccess.getDomain().lookupServer(string);
        String string2 = serverMBean.getStagingMode();
        if (string2 != null && string2.length() != 0) {
            return string2;
        }
        return DeployHelper.determineDefaultStagingMode(string);
    }

    public static String determineDefaultStagingMode(String string) {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (null == runtimeAccess) {
            return ServerMBean.DEFAULT_STAGE;
        }
        String string2 = AdminServer.adminServerName == null || AdminServer.adminServerName.equals(string) ? "nostage" : "stage";
        return string2;
    }

    public static DeploymentException convertThrowable(Throwable throwable) {
        if (Debug.isDeploymentDebugEnabled()) {
            throwable.printStackTrace();
        }
        String string = SlaveDeployerLogger.logUnexpectedThrowableLoggable().getMessage();
        return DeployHelper.handleException(throwable, string);
    }

    public static BasicDeployment createDeployment(BasicDeploymentMBean basicDeploymentMBean) {
        if (basicDeploymentMBean instanceof AppDeploymentMBean) {
            return new AppDeployment((AppDeploymentMBean)basicDeploymentMBean);
        }
        return new SystemResourceDeployment((SystemResourceMBean)basicDeploymentMBean);
    }

    public static void logAndThrow(Loggable loggable) throws DeploymentException {
        loggable.log();
        throw new DeploymentException(loggable.getMessage());
    }

    public static void throwUnexpected(Throwable throwable) throws DeploymentException {
        throw DeployHelper.convertThrowable(throwable);
    }

    public static void debug(String string) {
        Debug.deploymentDebug(string);
    }

    public static boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    public static boolean isModuleType(TargetInfoMBean targetInfoMBean, ModuleType moduleType) {
        return moduleType != null && moduleType.toString().equals(targetInfoMBean.getModuleType());
    }

    public static String getSourcePath(BasicDeploymentMBean basicDeploymentMBean) {
        String string = null;
        if (basicDeploymentMBean instanceof AppDeploymentMBean) {
            string = ((AppDeploymentMBean)basicDeploymentMBean).getAbsoluteSourcePath();
        } else if (basicDeploymentMBean instanceof SystemResourceMBean) {
            string = CONFIG_DIR_PREFIX + ((SystemResourceMBean)basicDeploymentMBean).getDescriptorFileName();
        } else {
            throw new weblogic.utils.AssertionError("DeploymentMBean should be either AppDeployment/SystemResourceMBean");
        }
        return string;
    }

    public static int getState(Deployment deployment) {
        if (deployment instanceof AppContainerInvoker) {
            return DeployHelper.getState(((AppContainerInvoker)deployment).getDelegate());
        }
        if (deployment instanceof DeploymentStateChecker) {
            return ((DeploymentStateChecker)deployment).getState();
        }
        throw new AssertionError((Object)("Deployment must be an instanceof DeploymentStateChecker. Got - " + deployment.getClass()));
    }

    public static boolean isPreparedState(Deployment deployment) {
        return DeployHelper.getState(deployment) == 1;
    }

    public static boolean isAdminState(Deployment deployment) {
        return DeployHelper.getState(deployment) == 2;
    }

    public static boolean isActiveState(Deployment deployment) {
        return DeployHelper.getState(deployment) == 3;
    }

    public static String getStagingModeFromOptions(DeploymentData deploymentData) {
        String string = null;
        DeploymentOptions deploymentOptions = deploymentData.getDeploymentOptions();
        if (deploymentOptions != null) {
            string = deploymentOptions.getStageMode();
        }
        return string;
    }

    public static boolean isOkToTransition(AppDeploymentMBean appDeploymentMBean, ServerMBean serverMBean, String string) {
        if (appDeploymentMBean.isInternalApp()) {
            return true;
        }
        Set set = DeployHelper.getAllTargets(appDeploymentMBean);
        String string2 = null;
        for (TargetMBean targetMBean : set) {
            if (!TargetUtils.isDeployedLocally(new TargetMBean[]{targetMBean})) continue;
            String string3 = AppRuntimeStateManager.getManager().getIntendedState(appDeploymentMBean.getName(), targetMBean.getName());
            if (string2 == null) {
                string2 = string3;
            }
            if (!DeployHelper.less(string2, string3)) continue;
            string2 = string3;
        }
        if (string2 == null) {
            try {
                AppRuntimeStateManager.getManager().setState(appDeploymentMBean.getName(), DeployHelper.getAllTargetNames(set).toArray(new String[0]), "STATE_ACTIVE");
            }
            catch (ManagementException managementException) {
                // empty catch block
            }
            return true;
        }
        return string.equals(string2) || !DeployHelper.less(string2, string);
    }

    private static Set getAllTargetNames(Set set) {
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (TargetMBean targetMBean : set) {
            hashSet.add(targetMBean.getName());
        }
        return hashSet;
    }

    public static Set getAllTargetNames(BasicDeploymentMBean basicDeploymentMBean) {
        Set set = DeployHelper.getAllTargets(basicDeploymentMBean);
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (TargetMBean targetMBean : set) {
            hashSet.add(targetMBean.getName());
        }
        return hashSet;
    }

    public static Set getAllTargets(BasicDeploymentMBean basicDeploymentMBean) {
        HashSet hashSet = new HashSet();
        DeployHelper.addFromMbean(basicDeploymentMBean, hashSet);
        SubDeploymentMBean[] subDeploymentMBeanArray = basicDeploymentMBean.getSubDeployments();
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            DeployHelper.addFromMbean(subDeploymentMBeanArray[i], hashSet);
            SubDeploymentMBean[] subDeploymentMBeanArray2 = basicDeploymentMBean.getSubDeployments();
            for (int j = 0; j < subDeploymentMBeanArray2.length; ++j) {
                DeployHelper.addFromMbean(subDeploymentMBeanArray2[j], hashSet);
            }
        }
        return hashSet;
    }

    private static void addFromMbean(TargetInfoMBean targetInfoMBean, Set set) {
        TargetMBean[] targetMBeanArray = targetInfoMBean.getTargets();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            set.add(targetMBeanArray[i]);
        }
    }

    public static boolean less(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        for (int i = 0; i < AppRuntimeStateRuntimeMBean.appStateDefs.length; ++i) {
            if (string.equals(AppRuntimeStateRuntimeMBean.appStateDefs[i])) {
                return true;
            }
            if (!string2.equals(AppRuntimeStateRuntimeMBean.appStateDefs[i])) continue;
            return false;
        }
        return false;
    }

    public static DeploymentException handleException(Throwable throwable, String string) {
        if (throwable instanceof DeploymentException) {
            return (DeploymentException)((Object)throwable);
        }
        if (throwable instanceof ManagementException) {
            ManagementException managementException = (ManagementException)throwable;
            Throwable throwable2 = managementException.getNested();
            DeploymentException deploymentException = throwable2 != null ? new DeploymentException(managementException.getMessage(), throwable2) : new DeploymentException(managementException.getMessage());
            deploymentException.setStackTrace(managementException.getStackTrace());
            return deploymentException;
        }
        DeployHelper.assertForNullMessage(string);
        return new DeploymentException(string, DeployHelper.getWrappedException(throwable));
    }

    private static void assertForNullMessage(String string) {
        if (string != null && string.length() != 0) {
            return;
        }
        throw new weblogic.utils.AssertionError(" ************* CONSTRUCTING EXCEPTION WITH NULL MESSAGE ********** ");
    }

    private static Throwable getWrappedException(Throwable throwable) {
        Throwable throwable2 = throwable instanceof NestedThrowable ? ((NestedThrowable)throwable).getNested() : throwable.getCause();
        if (throwable2 == null) {
            return throwable;
        }
        return DeployHelper.getWrappedException(throwable2);
    }

    public static DeploymentContextImpl createDeploymentContext(BasicDeploymentMBean basicDeploymentMBean) throws DeploymentException {
        try {
            String string = null;
            if (basicDeploymentMBean != null) {
                string = basicDeploymentMBean.getDeploymentPrincipalName();
            }
            if (string != null) {
                PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
                AuthenticatedSubject authenticatedSubject = principalAuthenticator.impersonateIdentity(string, null);
                return new DeploymentContextImpl(authenticatedSubject);
            }
            return new DeploymentContextImpl(SubjectUtils.getAnonymousSubject());
        }
        catch (Exception exception) {
            throw new DeploymentException(exception);
        }
    }

    private static boolean isInternalClass(Object object) {
        String string = object.getClass().getPackage().getName();
        String[] stringArray = new String[]{"java.", "javax.", "weblogic."};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private static Throwable handleUnTranferableCause(Throwable throwable, int n) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (n == 10) {
            return throwable;
        }
        if (throwable.getCause() != null) {
            Throwable throwable2 = throwable.getCause();
            if (!DeployHelper.isInternalClass(throwable2)) {
                Constructor<?> constructor = throwable.getClass().getConstructor(String.class);
                Throwable throwable3 = (Throwable)constructor.newInstance(throwable.getMessage() + ":" + throwable2.getClass().getCanonicalName() + ":" + throwable2.getMessage());
                throwable3.setStackTrace(throwable2.getStackTrace());
                return throwable3;
            }
            Throwable throwable4 = DeployHelper.handleUnTranferableCause(throwable2, n + 1);
            if (throwable4 != throwable2) {
                Constructor<?> constructor = throwable.getClass().getConstructor(String.class);
                Throwable throwable5 = (Throwable)constructor.newInstance(throwable.getMessage());
                throwable5.initCause(throwable4);
                throwable5.setStackTrace(throwable.getStackTrace());
                return throwable5;
            }
        }
        return throwable;
    }

    public static DeploymentException convertThrowableForTransfer(Throwable throwable) {
        if (Debug.isDeploymentDebugEnabled()) {
            throwable.printStackTrace();
        }
        if (throwable instanceof DeploymentException) {
            try {
                if (throwable.getCause() != null) {
                    return (DeploymentException)((Object)DeployHelper.handleUnTranferableCause(throwable, 0));
                }
                return (DeploymentException)((Object)throwable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string = SlaveDeployerLogger.logUnexpectedThrowableLoggable().getMessage();
        return DeployHelper.handleException(throwable, string);
    }

    static /* synthetic */ AuthenticatedSubject access$000() {
        return kernelId;
    }

    static class AdminServer {
        static String adminServerName = ManagementService.getRuntimeAccess(DeployHelper.access$000()).getAdminServerName();

        AdminServer() {
        }
    }
}

