/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver;

import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.AggregateDeploymentVersion;
import weblogic.deploy.internal.Deployment;
import weblogic.deploy.internal.DeploymentVersion;
import weblogic.deploy.internal.InternalDeploymentData;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.DeploymentServiceDispatcher;
import weblogic.deploy.internal.targetserver.operations.AbstractOperation;
import weblogic.deploy.internal.targetserver.operations.ActivateOperation;
import weblogic.deploy.internal.targetserver.operations.DynamicUpdateOperation;
import weblogic.deploy.internal.targetserver.operations.RedeployOperation;
import weblogic.deploy.internal.targetserver.operations.RemoveOperation;
import weblogic.deploy.internal.targetserver.operations.RetireOperation;
import weblogic.deploy.internal.targetserver.operations.StartOperation;
import weblogic.deploy.internal.targetserver.operations.StopOperation;
import weblogic.deploy.internal.targetserver.operations.UnprepareOperation;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.deploy.service.DeploymentContext;
import weblogic.deploy.service.DeploymentRequest;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;

public class DeploymentManager {
    private DeploymentServiceDispatcher dispatcher;
    private AggregateDeploymentVersion targetServerAggregateDeploymentVersion;
    private final String serverName = ManagementService.getPropertyService(kernelId).getServerName();
    private final boolean isAdminServer = ManagementService.getPropertyService(kernelId).isAdminServer();
    private Map requestInfoTable = new HashMap();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private ServerRuntimeMBean serverBean;

    private DeploymentManager() {
    }

    public static DeploymentManager getInstance() {
        return Maker.MANAGER;
    }

    private void debug(String string) {
        Debug.deploymentDebug(string);
    }

    private boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    public void initialize() {
        this.dispatcher = DeploymentServiceDispatcher.getInstance();
        this.targetServerAggregateDeploymentVersion = AggregateDeploymentVersion.createAggregateDeploymentVersion();
        this.dispatcher.initialize("Application", this.targetServerAggregateDeploymentVersion, this);
    }

    public void shutdown() {
        if (this.dispatcher != null) {
            this.dispatcher.shutdown();
        }
    }

    public void addOrUpdateTargetDeploymentVersion(String string, DeploymentVersion deploymentVersion) {
        if (!this.isAdminServer) {
            this.getTargetServerAggregateDeploymentsVersion().addOrUpdateDeploymentVersion(string, deploymentVersion);
        }
    }

    public void removeTargetDeploymentVersionFor(String string) {
        if (!this.isAdminServer) {
            this.getTargetServerAggregateDeploymentsVersion().removeDeploymentVersionFor(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdateDeploymentContext(DeploymentContext deploymentContext) {
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        long l = deploymentRequest.getId();
        DeploymentRequestInfo deploymentRequestInfo = new DeploymentRequestInfo(l, deploymentContext);
        Map map = this.requestInfoTable;
        synchronized (map) {
            try {
                if (this.requestInfoTable.get(new Long(l)) != null) {
                    if (this.isDebugEnabled()) {
                        this.debug("DeploymentManagerT: prepare already received for request '" + l + "' - ignoring this request");
                    }
                    return;
                }
                this.requestInfoTable.put(new Long(l), deploymentRequestInfo);
                this.createOperations(deploymentContext);
            }
            catch (Throwable throwable) {
                this.dispatcher.notifyContextUpdateFailed(l, throwable);
                return;
            }
        }
        if (this.isDebugEnabled()) {
            this.debug("DeploymentManagerT: notifying 'context updated' for request '" + l + "'");
        }
        this.dispatcher.notifyContextUpdated(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePrepare(DeploymentContext deploymentContext) {
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        long l = deploymentRequest.getId();
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (deploymentRequestInfo == null) {
            if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: handlePrepare received for request '" + l + " that has already completed");
            }
            String string = DeployerRuntimeLogger.requestCompletedOrCancelled((long)l);
            this.dispatcher.notifyPrepareFailure(l, new Exception(string));
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug("DeploymentManagerT: handlePrepare for request: " + l);
        }
        try {
            block16: {
                try {
                    boolean bl = this.assignToPreOrPostDeploymentHandlerList(deploymentRequestInfo);
                    if (bl) {
                        if (this.isDebugEnabled()) {
                            this.debug("DeploymentManagerT: handlePrepare handling 'preDeploymentHandlerList' of size " + deploymentRequestInfo.preDeploymentHandlerList.size() + " for request '" + l + "'");
                        }
                        this.prepareDeploymentList(deploymentRequestInfo.preDeploymentHandlerList, deploymentContext);
                        if (deploymentRequestInfo.postDeploymentHandlerList.size() == 0) {
                            if (this.isDebugEnabled()) {
                                this.debug("DeploymentManagerT: notifying 'prepare' success for request '" + l + "'");
                            }
                            this.dispatcher.notifyPrepareSuccess(l);
                        } else if (this.isDebugEnabled()) {
                            this.debug("DeploymentManagerT: will await for 'configPrepareCompleted' callback to process 'prepare' of postDeploymentHandler list for request '" + l + "'");
                        }
                        break block16;
                    }
                    if (deploymentRequestInfo.postDeploymentHandlerList.size() > 0) {
                        if (this.isDebugEnabled()) {
                            this.debug("DeploymentManagerT: handlePrepare handling 'postDeploymentHandlerList' of size " + deploymentRequestInfo.postDeploymentHandlerList.size() + " for request '" + l + "'");
                        }
                        this.prepareDeploymentList(deploymentRequestInfo.postDeploymentHandlerList, deploymentContext);
                    }
                    if (this.isDebugEnabled()) {
                        this.debug("DeploymentManagerT: notifying 'prepare' success for request '" + l + "'");
                    }
                    this.dispatcher.notifyPrepareSuccess(l);
                }
                catch (Throwable throwable) {
                    this.removeSystemResourcesFromRestartList(deploymentRequestInfo);
                    this.dispatcher.notifyPrepareFailure(l, throwable);
                    Object var8_9 = null;
                    deploymentRequestInfo.configPrepareCompletedLatch.countDown();
                }
            }
            Object var8_8 = null;
            deploymentRequestInfo.configPrepareCompletedLatch.countDown();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            deploymentRequestInfo.configPrepareCompletedLatch.countDown();
            throw throwable;
        }
    }

    private boolean assignToPreOrPostDeploymentHandlerList(DeploymentRequestInfo deploymentRequestInfo) {
        boolean bl = false;
        DeploymentRequest deploymentRequest = deploymentRequestInfo.context.getDeploymentRequest();
        Iterator iterator = deploymentRequest.getDeployments("Application");
        if (iterator != null) {
            while (iterator.hasNext()) {
                Deployment deployment = (Deployment)iterator.next();
                if (this.targetedToThisServer(deployment)) {
                    if (deployment.isBeforeDeploymentHandler() && deployment.isDeploy()) {
                        bl = true;
                        if (this.isDebugEnabled()) {
                            this.debug("DeploymentManagerT: adding '" + deployment + "' to pre " + " DeploymentHandler list for request '" + deploymentRequest.getId() + "'");
                        }
                        deploymentRequestInfo.preDeploymentHandlerList.add(deployment);
                        continue;
                    }
                    if (this.isDebugEnabled()) {
                        this.debug("DeploymentManagerT: adding '" + deployment + "' to post " + " DeploymentHandler list for request '" + deploymentRequest.getId() + "'");
                    }
                    deploymentRequestInfo.postDeploymentHandlerList.add(deployment);
                    continue;
                }
                if (!this.isDebugEnabled()) continue;
                this.debug("DeploymentManagerT: application deployment: " + deployment + " of request id: " + deploymentRequest.getId() + " not targeted on " + " this server");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentRequestInfo getDeploymentRequestInfo(long l) {
        Map map = this.requestInfoTable;
        synchronized (map) {
            return (DeploymentRequestInfo)this.requestInfoTable.get(new Long(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommit(DeploymentContext deploymentContext) {
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        long l = deploymentRequest.getId();
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (deploymentRequestInfo == null) {
            if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: handleCommit received for request '" + l + " that has already completed");
            }
            String string = DeployerRuntimeLogger.requestCompletedOrCancelled((long)l);
            this.notifyCommitFailure(l, null, new Exception(string));
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug("DeploymentManagerT: handleCommit for request: " + l);
        }
        boolean bl = false;
        Iterator iterator = null;
        try {
            block18: {
                try {
                    iterator = deploymentRequest.getDeployments("Application");
                    if (iterator == null) {
                        if (this.isDebugEnabled()) {
                            this.debug("DeploymentManagerT: handleCommit - no deployments to 'commit' - notifying 'commit' success for request '" + l + "'");
                        }
                        this.notifyCommitSuccess(l, deploymentRequestInfo);
                        break block18;
                    }
                    bl = this.processDeploymentsForCommit(iterator, deploymentRequest);
                    if (bl) {
                        if (this.isDebugEnabled()) {
                            this.debug("DeploymentManagerT: handleCommit handling 'preDeploymentHandlerList' of size " + deploymentRequestInfo.preDeploymentHandlerList.size() + " for request '" + l + "'");
                        }
                        this.activateDeploymentList(deploymentRequestInfo.preDeploymentHandlerList, deploymentRequestInfo);
                        if (deploymentRequestInfo.postDeploymentHandlerList.size() == 0) {
                            if (this.isDebugEnabled()) {
                                this.debug("DeploymentManagerT: notifying 'commit' success for request '" + l + "'");
                            }
                            this.notifyCommitSuccess(l, deploymentRequestInfo);
                        } else if (this.isDebugEnabled()) {
                            this.debug("DeploymentManagerT: will await for 'configCommitCompleted' callback to process 'commit' of postDeploymentHandler list for request '" + l + "'");
                        }
                        break block18;
                    }
                    if (deploymentRequestInfo.postDeploymentHandlerList.size() > 0) {
                        if (this.isDebugEnabled()) {
                            this.debug("DeploymentManagerT: handleCommit handling 'postDeploymentHandlerList' of size " + deploymentRequestInfo.postDeploymentHandlerList.size() + " for request '" + l + "'");
                        }
                        this.activateDeploymentList(deploymentRequestInfo.postDeploymentHandlerList, deploymentRequestInfo);
                    }
                    if (this.isDebugEnabled()) {
                        this.debug("DeploymentManagerT: notifying 'commit' success for request '" + l + "'");
                    }
                    this.notifyCommitSuccess(l, deploymentRequestInfo);
                }
                catch (Throwable throwable) {
                    this.notifyCommitFailure(l, deploymentRequestInfo, throwable);
                    Object var10_9 = null;
                    deploymentRequestInfo.configCommitCompletedLatch.countDown();
                }
            }
            Object var10_8 = null;
            deploymentRequestInfo.configCommitCompletedLatch.countDown();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            deploymentRequestInfo.configCommitCompletedLatch.countDown();
            throw throwable;
        }
    }

    private final ServerRuntimeMBean getServerBean() {
        if (this.serverBean == null) {
            this.serverBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        }
        return this.serverBean;
    }

    private boolean requiresRestart(String string) {
        return this.getServerBean().isRestartPendingForSystemResource(string);
    }

    private boolean processDeploymentsForCommit(Iterator iterator, DeploymentRequest deploymentRequest) {
        boolean bl = false;
        while (iterator.hasNext()) {
            Deployment deployment = (Deployment)iterator.next();
            if (this.targetedToThisServer(deployment)) {
                if (!deployment.isBeforeDeploymentHandler() || !deployment.isDeploy()) continue;
                bl = true;
                continue;
            }
            String string = deployment.getDeploymentTaskRuntimeId();
            if (string == null) continue;
            this.sendTaskCompletedNotification(deploymentRequest.getId(), string);
        }
        return bl;
    }

    public void handleCancel(DeploymentContext deploymentContext) {
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        long l = deploymentRequest.getId();
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (deploymentRequestInfo == null) {
            this.notifyCancelSuccess(l, deploymentRequestInfo);
            return;
        }
        try {
            if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: handleCancel for request: " + deploymentRequest.getId());
            }
            this.removeSystemResourcesFromRestartList(deploymentRequestInfo);
            Iterator iterator = deploymentRequest.getDeployments("Application");
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Deployment deployment = (Deployment)iterator.next();
                    this.handleDeploymentCancel(deployment, deploymentRequestInfo);
                }
            }
            if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: notifying 'cancel' success for request '" + l + "'");
            }
            this.notifyCancelSuccess(l, deploymentRequestInfo);
        }
        catch (Throwable throwable) {
            this.notifyCancelFailure(l, deploymentRequestInfo, throwable);
        }
    }

    public void relayStatus(long l, Serializable serializable) {
        if (this.isDebugEnabled()) {
            this.debug("DeploymentManagerT: notifying status '" + serializable + "' for " + " request '" + l + "'");
        }
        this.dispatcher.notifyStatusUpdate(l, serializable);
    }

    public void configPrepareCompleted(DeploymentContext deploymentContext) {
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        long l = deploymentRequest.getId();
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (deploymentRequestInfo == null) {
            return;
        }
        try {
            if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: configPrepareCompleted about to await " + deploymentRequest.getTimeoutInterval() + " millis for request '" + l + "'");
            }
            deploymentRequestInfo.configPrepareCompletedLatch.await(deploymentRequest.getTimeoutInterval(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isDebugEnabled()) {
            this.debug("DeploymentManagerT: configPrepareCompleted for request '" + l + "'");
        }
        try {
            if (deploymentRequestInfo.preDeploymentHandlerList.size() > 0 && deploymentRequestInfo.postDeploymentHandlerList.size() > 0) {
                if (this.isDebugEnabled()) {
                    this.debug("DeploymentManagerT: configPrepareCompleted handling 'postDeploymentHandlerList' of size " + deploymentRequestInfo.postDeploymentHandlerList.size() + " for request '" + l + "'");
                }
                this.prepareDeploymentList(deploymentRequestInfo.postDeploymentHandlerList, deploymentContext);
                if (this.isDebugEnabled()) {
                    this.debug("DeploymentManagerT: notifying 'prepare' success for request '" + l + "'");
                }
                this.dispatcher.notifyPrepareSuccess(l);
            }
        }
        catch (Throwable throwable) {
            if (this.isDebugEnabled()) {
                Debug.deploymentLogger.debug("DeploymentManagerT: configPrepareCompleted encountered an exception: " + StackTraceUtils.throwable2StackTrace((Throwable)throwable) + " for request '" + l + "' notifying 'prepare' failure");
            }
            this.removeSystemResourcesFromRestartList(deploymentRequestInfo);
            this.dispatcher.notifyPrepareFailure(l, new Exception(throwable));
        }
    }

    public void configCommitCompleted(DeploymentContext deploymentContext) {
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        long l = deploymentRequest.getId();
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (deploymentRequestInfo == null) {
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug("DeploymentManagerT: configCommitCompleted for request " + l + "'");
        }
        try {
            if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: configCommitCompleted about to await " + deploymentRequest.getTimeoutInterval() + " millis for request '" + l + "'");
            }
            deploymentRequestInfo.configCommitCompletedLatch.await(deploymentRequest.getTimeoutInterval(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            if (deploymentRequestInfo.preDeploymentHandlerList.size() > 0 && deploymentRequestInfo.postDeploymentHandlerList.size() > 0) {
                if (this.isDebugEnabled()) {
                    this.debug("DeploymentManagerT: configCommitCompleted handling 'postDeploymentHandlerList' of size " + deploymentRequestInfo.postDeploymentHandlerList.size() + " for request '" + l + "'");
                }
                this.activateDeploymentList(deploymentRequestInfo.postDeploymentHandlerList, deploymentRequestInfo);
                if (this.isDebugEnabled()) {
                    this.debug("DeploymentManagerT: notifying 'commit' success for request '" + l + "'");
                }
                this.notifyCommitSuccess(l, deploymentRequestInfo);
            }
        }
        catch (Throwable throwable) {
            if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: notifying 'commit' failure for request '" + l + "' due to '" + throwable.toString());
            }
            this.notifyCommitFailure(l, deploymentRequestInfo, throwable);
        }
    }

    private void sendTaskCompletedNotification(long l, String string) {
        DeploymentState deploymentState = new DeploymentState("?", string, 0);
        deploymentState.setTaskState(3);
        this.relayStatus(l, deploymentState);
    }

    private void handleDeploymentPrepare(Deployment deployment, DeploymentRequestInfo deploymentRequestInfo) throws Throwable {
        AbstractOperation abstractOperation;
        if (deploymentRequestInfo == null) {
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug("handleDeploymentPrepare for deployment: " + deployment);
        }
        if ((abstractOperation = (AbstractOperation)deploymentRequestInfo.operationsMap.get(deployment.getDeploymentTaskRuntimeId())) == null) {
            throw new DeploymentException("Cannot find operation for deployment : " + deployment);
        }
        if (abstractOperation.getDeploymentMBean() instanceof SystemResourceMBean && deployment.requiresRestart()) {
            if (this.isDebugEnabled()) {
                this.debug("handleDeploymentPrepare: adding SystemResource '" + abstractOperation.getDeploymentMBean().getName() + "' to pending restart " + "list on server");
            }
            this.getServerBean().addPendingRestartSystemResource(abstractOperation.getDeploymentMBean().getName());
            deploymentRequestInfo.systemResourcesToBeRestarted.add(abstractOperation.getDeploymentMBean());
        }
        abstractOperation.prepare();
    }

    private void removeSystemResourcesFromRestartList(DeploymentRequestInfo deploymentRequestInfo) {
        if (deploymentRequestInfo == null) {
            return;
        }
        if (!deploymentRequestInfo.systemResourcesToBeRestarted.isEmpty()) {
            for (SystemResourceMBean systemResourceMBean : deploymentRequestInfo.systemResourcesToBeRestarted) {
                if (this.isDebugEnabled()) {
                    this.debug("removing SystemResource '" + systemResourceMBean.getName() + "' from pending restart " + "list on server");
                }
                this.getServerBean().removePendingRestartSystemResource(systemResourceMBean.getName());
            }
        }
    }

    private void updateRuntimeStateAndAggregateVersion(String string, DeploymentVersion deploymentVersion, boolean bl) throws ManagementException {
        if (!this.isAdminServer) {
            if (bl) {
                if (this.isDebugEnabled()) {
                    this.debug("Updating runtime state and aggregate deployment version component on target server for " + string);
                }
                AppRuntimeStateManager.getManager().updateState(string, deploymentVersion);
                this.addOrUpdateTargetDeploymentVersion(string, deploymentVersion);
            } else {
                if (this.isDebugEnabled()) {
                    this.debug("Removing runtime state and aggregate deployment version component on target server for " + string);
                }
                AppRuntimeStateManager.getManager().remove(string);
                this.removeTargetDeploymentVersionFor(string);
            }
        }
    }

    private void handleDeploymentCommit(Deployment deployment, AbstractOperation abstractOperation) throws Throwable {
        InternalDeploymentData internalDeploymentData = abstractOperation.getInternalDeploymentData();
        String string = deployment.getIdentity();
        if (internalDeploymentData == null || abstractOperation.getDeploymentMBean() == null) {
            if (this.isDebugEnabled()) {
                this.debug("Nothing to do to commit deployment :" + string + " associated with request id: " + deployment.getDeploymentRequestId());
            }
            DeploymentState deploymentState = new DeploymentState("?", deployment.getDeploymentTaskRuntimeId(), 0);
            deploymentState.setTaskState(3);
            this.relayStatus(deployment.getDeploymentRequestId(), deploymentState);
            return;
        }
        String string2 = internalDeploymentData.getDeploymentName();
        BasicDeploymentMBean basicDeploymentMBean = abstractOperation.getDeploymentMBean();
        if (basicDeploymentMBean != null) {
            abstractOperation.commit();
            int n = abstractOperation.getOperationType();
            if (!abstractOperation.isControlOperation()) {
                boolean bl = basicDeploymentMBean instanceof AppDeploymentMBean && n != 4;
                this.updateRuntimeStateAndAggregateVersion(deployment.getIdentity(), deployment.getProposedDeploymentVersion(), bl);
            }
        } else {
            if (this.isDebugEnabled()) {
                this.debug("Nothing to do to deploy app :" + string2);
            }
            DeploymentState deploymentState = new DeploymentState("?", string, 0);
            deploymentState.setTaskState(2);
            this.relayStatus(deployment.getDeploymentRequestId(), deploymentState);
            String string3 = DeployerRuntimeLogger.nothingToCommit((String)ApplicationVersionUtils.getDisplayName(abstractOperation.getDeploymentMBean()), (String)this.serverName);
            throw new ManagementException(string3);
        }
    }

    private boolean targetedToThisServer(Deployment deployment) {
        String[] stringArray = deployment.getTargets();
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        ClusterMBean clusterMBean = serverMBean.getCluster();
        boolean bl = clusterMBean != null;
        for (int i = 0; i < stringArray.length; ++i) {
            Set set;
            if (this.serverName.equals(stringArray[i])) {
                return true;
            }
            if (!bl || !(set = clusterMBean.getServerNames()).contains(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private void handleDeploymentCancel(Deployment deployment, DeploymentRequestInfo deploymentRequestInfo) throws Throwable {
        if (!this.targetedToThisServer(deployment)) {
            if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: notifying 'cancel' success for request '" + deployment.getDeploymentRequestId() + "'");
            }
            return;
        }
        if (deploymentRequestInfo == null) {
            if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: nothing to cancel on request '" + deployment.getDeploymentRequestId() + "' since there" + " is no requestInfo available");
            }
            return;
        }
        AbstractOperation abstractOperation = (AbstractOperation)deploymentRequestInfo.operationsMap.get(deployment.getDeploymentTaskRuntimeId());
        if (abstractOperation == null) {
            if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: nothing to cancel on request '" + deployment.getDeploymentRequestId() + "' since there" + " is no operation available");
            }
            return;
        }
        abstractOperation.cancel();
    }

    private AggregateDeploymentVersion getTargetServerAggregateDeploymentsVersion() {
        if (this.targetServerAggregateDeploymentVersion != null) {
            this.targetServerAggregateDeploymentVersion = AggregateDeploymentVersion.createAggregateDeploymentVersion();
        }
        return this.targetServerAggregateDeploymentVersion;
    }

    private AbstractOperation createOperation(Deployment deployment, DeploymentRequestInfo deploymentRequestInfo) throws Exception {
        DeploymentContext deploymentContext = deploymentRequestInfo.context;
        String string = deployment.getDeploymentTaskRuntimeId();
        InternalDeploymentData internalDeploymentData = deployment.getInternalDeploymentData();
        if (internalDeploymentData == null) {
            if (this.isDebugEnabled()) {
                this.debug("Nothing to do to deploy '" + deployment + "'");
            }
            String string2 = DeployerRuntimeLogger.nothingToDoForTask((String)string);
            throw new Exception(string2);
        }
        int n = internalDeploymentData.getDeploymentOperation();
        String string3 = internalDeploymentData.getDeploymentName();
        if (this.isDebugEnabled()) {
            this.debug(" +++ ctxt Obj = " + deploymentContext + " type " + deploymentContext.getClass().getName());
        }
        DomainMBean domainMBean = (DomainMBean)deploymentContext.getContextComponent("PROPOSED_CONFIGURATION");
        boolean bl = this.requiresRestart(string3);
        long l = deployment.getDeploymentRequestId();
        AuthenticatedSubject authenticatedSubject = deploymentContext.getDeploymentRequest().getInitiator();
        if (this.isDebugEnabled()) {
            this.debug("Creating target server deploy operation '" + DeployHelper.getTaskName(n) + "' for '" + "[" + string + "]" + string3 + "' initiated by '" + authenticatedSubject);
        }
        switch (n) {
            case 7: {
                BasicDeploymentMBean basicDeploymentMBean = this.findDeploymentMBean(domainMBean, string3, n, false);
                return new StartOperation(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
            }
            case 1: 
            case 6: 
            case 11: {
                BasicDeploymentMBean basicDeploymentMBean = this.findDeploymentMBean(domainMBean, string3, n, true);
                AbstractOperation abstractOperation = new ActivateOperation(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl).refine();
                if (abstractOperation instanceof RedeployOperation && n != 6) {
                    abstractOperation = ((RedeployOperation)abstractOperation).refine();
                }
                return abstractOperation;
            }
            case 10: {
                BasicDeploymentMBean basicDeploymentMBean = this.findDeploymentMBean(domainMBean, string3, n, true);
                return new DynamicUpdateOperation(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl).refine();
            }
            case 9: {
                BasicDeploymentMBean basicDeploymentMBean = this.findDeploymentMBean(domainMBean, string3, n, true);
                return new RedeployOperation(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl).refine();
            }
            case 3: 
            case 8: {
                BasicDeploymentMBean basicDeploymentMBean = this.findDeploymentMBean(domainMBean, string3, n, false);
                return new StopOperation(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
            }
            case 5: {
                BasicDeploymentMBean basicDeploymentMBean = this.findDeploymentMBean(domainMBean, string3, n, false);
                return new UnprepareOperation(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
            }
            case 4: {
                BasicDeploymentMBean basicDeploymentMBean = this.findDeploymentMBean(domainMBean, string3, n, false);
                return new RemoveOperation(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
            }
            case 13: {
                BasicDeploymentMBean basicDeploymentMBean = this.findDeploymentMBean(domainMBean, string3, n, false);
                return new RetireOperation(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
            }
        }
        throw new AssertionError((Object)("Invalid Deployment operation provided " + internalDeploymentData.getDeploymentOperation()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRequest(DeploymentRequestInfo deploymentRequestInfo) {
        Map map = this.requestInfoTable;
        synchronized (map) {
            if (deploymentRequestInfo != null) {
                long l = deploymentRequestInfo.theRequestId;
                if (this.isDebugEnabled()) {
                    this.debug("DeploymentManagerT: resetting request: " + l + "'");
                }
                deploymentRequestInfo.preDeploymentHandlerList.clear();
                deploymentRequestInfo.postDeploymentHandlerList.clear();
                deploymentRequestInfo.operationsMap.clear();
                deploymentRequestInfo.context = null;
                deploymentRequestInfo.configPrepareCompletedLatch.countDown();
                deploymentRequestInfo.configCommitCompletedLatch.countDown();
                this.requestInfoTable.remove(new Long(l));
            }
        }
    }

    private BasicDeploymentMBean getDeploymentMBean(DomainMBean domainMBean, String string) {
        BasicDeploymentMBean basicDeploymentMBean = null;
        if (domainMBean != null) {
            basicDeploymentMBean = ApplicationVersionUtils.getDeployment(domainMBean, string);
        }
        return basicDeploymentMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDeploymentList(ArrayList arrayList, DeploymentContext deploymentContext) throws Throwable {
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        long l = deploymentRequest.getId();
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            if (arrayList != null && arrayList.size() > 0) {
                if (this.isDebugEnabled()) {
                    this.debug("DeploymentManagerT: prepareDeploymentList - handling deployment list of size: " + arrayList.size() + " for request '" + l + "'");
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    Deployment deployment = (Deployment)arrayList.get(i);
                    this.handleDeploymentPrepare(deployment, deploymentRequestInfo);
                }
            } else if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: prepareDeploymentList - nothing to do since list is empty for request '" + l + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateDeploymentList(ArrayList arrayList, DeploymentRequestInfo deploymentRequestInfo) throws Throwable {
        long l = deploymentRequestInfo.context.getDeploymentRequest().getId();
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            if (arrayList != null && arrayList.size() > 0) {
                if (this.isDebugEnabled()) {
                    this.debug("DeploymentManagerT: activateDeploymentList - handling deployment list of size: " + arrayList.size() + " for request '" + l + "'");
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    Deployment deployment = (Deployment)arrayList.get(i);
                    this.handleDeploymentCommit(deployment, (AbstractOperation)deploymentRequestInfo.operationsMap.get(deployment.getDeploymentTaskRuntimeId()));
                }
            } else if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: activateDeploymentList - nothing to do since list is empty for request '" + l + "'");
            }
        }
    }

    private void assertDeploymentMBeanIsNonNull(DomainMBean domainMBean, BasicDeploymentMBean basicDeploymentMBean, String string, String string2) throws DeploymentException {
        if (basicDeploymentMBean == null) {
            if (this.isDebugEnabled()) {
                this.debug(string2 + ": Could not find mbean for " + string);
            }
            Loggable loggable = DeployerRuntimeLogger.logNullDeploymentMBeanLoggable((String)string2, (String)string);
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
    }

    private BasicDeploymentMBean findDeploymentMBean(DomainMBean domainMBean, String string, int n, boolean bl) throws DeploymentException {
        BasicDeploymentMBean basicDeploymentMBean;
        String string2 = DeployHelper.getTaskName(n);
        if (bl) {
            if (this.isDebugEnabled()) {
                this.debug(string2 + ": Trying to find mbean for " + string + " in proposed domain");
            }
            if ((basicDeploymentMBean = this.getDeploymentMBean(domainMBean, string)) != null) {
                if (this.isDebugEnabled()) {
                    this.debug(string2 + ": Found MBean for " + string + " in proposed domain");
                }
                return basicDeploymentMBean;
            }
        }
        DomainMBean domainMBean2 = ManagementService.getRuntimeAccess(kernelId).getDomain();
        if (this.isDebugEnabled()) {
            this.debug(string2 + ": Trying to find mbean for " + string + " in runtime domain");
        }
        basicDeploymentMBean = this.getDeploymentMBean(domainMBean2, string);
        this.assertDeploymentMBeanIsNonNull(domainMBean2, basicDeploymentMBean, string, string2);
        if (this.isDebugEnabled()) {
            this.debug(string2 + ": Found mbean for " + string + " in runtime domain");
        }
        return basicDeploymentMBean;
    }

    private void createOperations(DeploymentContext deploymentContext) throws Exception {
        Iterator iterator;
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        long l = deploymentRequest.getId();
        DeploymentRequestInfo deploymentRequestInfo = this.getDeploymentRequestInfo(l);
        if (deploymentRequestInfo == null) {
            if (this.isDebugEnabled()) {
                this.debug("DeploymentManagerT: createOperations() for request '" + l + " after prepare completed");
            }
            String string = DeployerRuntimeLogger.requestCompletedOrCancelled((long)l);
            this.dispatcher.notifyPrepareFailure(l, new Exception(string));
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug("DeploymentManagerT: createOperations() for request: " + l);
        }
        if ((iterator = deploymentRequest.getDeployments("Application")) != null) {
            while (iterator.hasNext()) {
                Deployment deployment = (Deployment)iterator.next();
                if (this.targetedToThisServer(deployment)) {
                    AbstractOperation abstractOperation = this.createOperation(deployment, deploymentRequestInfo);
                    abstractOperation.stageFilesFromAdminServer(deployment.getDataTransferHandlerType());
                    deploymentRequestInfo.operationsMap.put(deployment.getDeploymentTaskRuntimeId(), abstractOperation);
                    if (!this.isDebugEnabled()) continue;
                    this.debug("DeploymentManagerT.createOperations(): created operation for deployment: " + deployment + " of request id " + deploymentRequest.getId() + " targeted on this server " + abstractOperation);
                    continue;
                }
                if (!this.isDebugEnabled()) continue;
                this.debug("DeploymentManagerT.createOperations(): application deployment: " + deployment + " of request id: " + deploymentRequest.getId() + " not targeted on this server");
            }
        }
    }

    private void notifyCommitSuccess(long l, DeploymentRequestInfo deploymentRequestInfo) {
        this.resetRequest(deploymentRequestInfo);
        this.dispatcher.notifyCommitSuccess(l);
    }

    private void notifyCommitFailure(long l, DeploymentRequestInfo deploymentRequestInfo, Throwable throwable) {
        this.resetRequest(deploymentRequestInfo);
        this.dispatcher.notifyCommitFailure(l, (Throwable)((Object)DeployHelper.convertThrowableForTransfer(throwable)));
    }

    private void notifyCancelSuccess(long l, DeploymentRequestInfo deploymentRequestInfo) {
        this.resetRequest(deploymentRequestInfo);
        this.dispatcher.notifyCancelSuccess(l);
    }

    private void notifyCancelFailure(long l, DeploymentRequestInfo deploymentRequestInfo, Throwable throwable) {
        this.resetRequest(deploymentRequestInfo);
        this.dispatcher.notifyCancelFailure(l, (Throwable)((Object)DeployHelper.convertThrowable(throwable)));
    }

    private static class DeploymentRequestInfo {
        private final long theRequestId;
        private DeploymentContext context;
        private Map operationsMap;
        private ArrayList preDeploymentHandlerList;
        private ArrayList postDeploymentHandlerList;
        private Set systemResourcesToBeRestarted = new HashSet();
        private CountDownLatch configPrepareCompletedLatch;
        private CountDownLatch configCommitCompletedLatch;

        private DeploymentRequestInfo(long l, DeploymentContext deploymentContext) {
            this.theRequestId = l;
            this.context = deploymentContext;
            this.operationsMap = new HashMap();
            this.preDeploymentHandlerList = new ArrayList();
            this.postDeploymentHandlerList = new ArrayList();
            this.configPrepareCompletedLatch = new CountDownLatch(1);
            this.configCommitCompletedLatch = new CountDownLatch(1);
        }
    }

    static class Maker {
        static final DeploymentManager MANAGER = new DeploymentManager();

        Maker() {
        }
    }
}

