/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.Deployment;
import weblogic.deploy.internal.targetserver.DeploymentManager;
import weblogic.deploy.service.DeploymentContext;
import weblogic.deploy.service.DeploymentReceiver;
import weblogic.deploy.service.Version;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.management.ManagementException;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.provider.MSIService;

public final class DeploymentServiceDispatcher
implements DeploymentReceiver {
    private String identity;
    private final DeploymentService service = DeploymentService.getDeploymentService();
    private DeploymentManager deploymentManager;

    private DeploymentServiceDispatcher() {
    }

    public static DeploymentServiceDispatcher getInstance() {
        return Maker.instance;
    }

    private void debug(String string) {
        Debug.deploymentDebug(string);
    }

    public void initialize(String string, Version version2, DeploymentManager deploymentManager) {
        this.identity = string;
        this.deploymentManager = deploymentManager;
        try {
            DeploymentContext deploymentContext = this.service.registerHandler(version2, this);
            this.synchStateWithAdmin(deploymentContext, string);
        }
        catch (Throwable throwable) {
            if (Debug.isDeploymentDebugEnabled()) {
                this.debug("Error registering DeploymentReceiver for '" + string + "' with DeploymentService due to " + throwable);
            }
            MSIService.getMSIService().setAdminServerAvailable(false);
            try {
                AppRuntimeStateManager.getManager().loadStartupState(null);
            }
            catch (ManagementException managementException) {
                managementException.printStackTrace();
            }
        }
    }

    private void synchStateWithAdmin(DeploymentContext deploymentContext, String string) throws ManagementException {
        Iterator iterator = deploymentContext.getDeploymentRequest().getDeployments(string);
        boolean bl = false;
        while (iterator.hasNext()) {
            Map map;
            Deployment deployment = (Deployment)iterator.next();
            if (deployment == null || !deployment.isSyncWithAdmin() || (map = deployment.getSyncWithAdminState()) == null) continue;
            AppRuntimeStateManager.getManager().loadStartupState(map);
            bl = true;
        }
        if (!bl) {
            AppRuntimeStateManager.getManager().loadStartupState(null);
        }
    }

    public final void shutdown() {
        this.service.unregisterHandler(this.getHandlerIdentity());
    }

    public final void notifyContextUpdated(long l) {
        this.service.notifyContextUpdated(l, this.getHandlerIdentity());
    }

    public final void notifyContextUpdateFailed(long l, Throwable throwable) {
        this.service.notifyContextUpdateFailed(l, this.getHandlerIdentity(), throwable);
    }

    public final void notifyPrepareSuccess(long l) {
        this.service.notifyPrepareSuccess(l, this.getHandlerIdentity());
    }

    public final void notifyPrepareFailure(long l, Throwable throwable) {
        this.service.notifyPrepareFailure(l, this.getHandlerIdentity(), throwable);
    }

    public final void notifyCommitSuccess(long l) {
        this.service.notifyCommitSuccess(l, this.getHandlerIdentity());
    }

    public final void notifyCommitFailure(long l, Throwable throwable) {
        this.service.notifyCommitFailure(l, this.getHandlerIdentity(), throwable);
    }

    public final void notifyCancelSuccess(long l) {
        this.service.notifyCancelSuccess(l, this.getHandlerIdentity());
    }

    public final void notifyCancelFailure(long l, Throwable throwable) {
        this.service.notifyCancelFailure(l, this.getHandlerIdentity(), throwable);
    }

    public final void notifyStatusUpdate(long l, Serializable serializable) {
        this.service.notifyStatusUpdate(l, this.getHandlerIdentity(), serializable);
    }

    public final String getHandlerIdentity() {
        return this.identity;
    }

    public void updateDeploymentContext(DeploymentContext deploymentContext) {
        this.deploymentManager.handleUpdateDeploymentContext(deploymentContext);
    }

    public final void prepare(DeploymentContext deploymentContext) {
        this.deploymentManager.handlePrepare(deploymentContext);
    }

    public final void commit(DeploymentContext deploymentContext) {
        this.deploymentManager.handleCommit(deploymentContext);
    }

    public final void cancel(DeploymentContext deploymentContext) {
        this.deploymentManager.handleCancel(deploymentContext);
    }

    public final void prepareCompleted(DeploymentContext deploymentContext, String string) {
        if (string.equals("Configuration")) {
            this.deploymentManager.configPrepareCompleted(deploymentContext);
        }
    }

    public final void commitCompleted(DeploymentContext deploymentContext, String string) {
        if (string.equals("Configuration")) {
            this.deploymentManager.configCommitCompleted(deploymentContext);
        }
    }

    static class Maker {
        static final DeploymentServiceDispatcher instance = new DeploymentServiceDispatcher();

        Maker() {
        }
    }
}

