/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.Collection;
import java.util.TreeMap;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.DeploymentOrder;
import weblogic.deploy.internal.targetserver.BasicDeployment;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.ArrayUtils;

public class OrderedDeployments {
    private static final TreeMap deployments = new TreeMap(DeploymentOrder.COMPARATOR);
    private static PropertyChangeListener changeListener;
    private static final AuthenticatedSubject kernelId;

    public static Collection getDeployments() {
        return deployments.values();
    }

    public static BasicDeployment getOrCreateBasicDeployment(BasicDeploymentMBean basicDeploymentMBean) {
        if (basicDeploymentMBean == null) {
            return null;
        }
        BasicDeployment basicDeployment = (BasicDeployment)deployments.get(basicDeploymentMBean);
        if (basicDeployment == null) {
            basicDeployment = DeployHelper.createDeployment(basicDeploymentMBean);
            OrderedDeployments.addDeployment(basicDeploymentMBean, basicDeployment);
            OrderedDeployments.registerChangeListenerIfNeeded();
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("OrderedDeployments cannot find " + basicDeploymentMBean + ", created AppDeployment=" + basicDeployment);
                if (basicDeploymentMBean instanceof AppDeploymentMBean) {
                    Debug.deploymentDebug(basicDeploymentMBean + " isActive=" + ApplicationVersionUtils.isActiveVersion((AppDeploymentMBean)basicDeploymentMBean));
                }
            }
        } else if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("OrderedDeployments found " + basicDeploymentMBean + ", AppDeployment=" + basicDeployment);
            if (basicDeploymentMBean instanceof AppDeploymentMBean) {
                Debug.deploymentDebug(basicDeploymentMBean + " isActive=" + ApplicationVersionUtils.isActiveVersion((AppDeploymentMBean)basicDeploymentMBean));
            }
        }
        return basicDeployment;
    }

    public static void removeBasicDeployment(BasicDeploymentMBean basicDeploymentMBean) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("OrderedDeployments remove " + basicDeploymentMBean);
            if (basicDeploymentMBean instanceof AppDeploymentMBean) {
                Debug.deploymentDebug(basicDeploymentMBean + " isActive=" + ApplicationVersionUtils.isActiveVersion((AppDeploymentMBean)basicDeploymentMBean));
            }
        }
        OrderedDeployments.removeDeployment(basicDeploymentMBean);
    }

    public static void addDeployment(Object object, Object object2) {
        deployments.put(object, object2);
        if (object instanceof BasicDeploymentMBean) {
            BasicDeploymentMBean basicDeploymentMBean = (BasicDeploymentMBean)object;
            int n = basicDeploymentMBean.getDeploymentOrder();
            DeploymentOrder.addToDeploymentOrderCache((BasicDeploymentMBean)object, n);
        }
    }

    public static void removeDeployment(Object object) {
        deployments.remove(object);
        if (object instanceof BasicDeploymentMBean) {
            DeploymentOrder.removeFromDeploymentOrderCache((BasicDeploymentMBean)object);
        }
    }

    private static DomainMBean getDomain() {
        return ManagementService.getRuntimeAccess(kernelId).getDomain();
    }

    private static void refreshBasicDeployment(BasicDeploymentMBean basicDeploymentMBean) {
        if (basicDeploymentMBean == null) {
            return;
        }
        BasicDeployment basicDeployment = (BasicDeployment)deployments.get(basicDeploymentMBean);
        if (basicDeployment == null) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("OrderedDeployments refresh rtTreeBean=" + basicDeploymentMBean + " cannot find BasicDeployment");
            }
            return;
        }
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("OrderedDeployments refresh rtTreeBean=" + basicDeploymentMBean + ", basicDep=" + basicDeployment);
        }
        BasicDeploymentMBean basicDeploymentMBean2 = basicDeployment.getDeploymentMBean();
        OrderedDeployments.removeDeployment(basicDeploymentMBean2);
        basicDeployment.resetMBean(basicDeploymentMBean);
        OrderedDeployments.addDeployment(basicDeploymentMBean, basicDeployment);
    }

    private static void registerChangeListenerIfNeeded() {
        if (changeListener == null) {
            changeListener = new BasicDeploymentChangeListener();
            OrderedDeployments.getDomain().addPropertyChangeListener(changeListener);
        }
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private static class BasicDeploymentChangeListener
    implements PropertyChangeListener {
        private BasicDeploymentChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent != null && propertyChangeEvent.getNewValue() instanceof BasicDeploymentMBean[]) {
                ArrayUtils.computeDiff((Object[])((Object[])propertyChangeEvent.getOldValue()), (Object[])((Object[])propertyChangeEvent.getNewValue()), (ArrayUtils.DiffHandler)new ArrayUtils.DiffHandler(){

                    public void addObject(Object object) {
                        OrderedDeployments.refreshBasicDeployment((BasicDeploymentMBean)object);
                    }

                    public void removeObject(Object object) {
                    }
                });
            }
        }
    }
}

