/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver;

import java.io.File;
import java.io.IOException;
import weblogic.deploy.api.internal.utils.InstallDir;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;

public final class StagingDirectory {
    private InstallDir root;
    private String dir;
    private boolean hasPlan;

    public StagingDirectory(String string, String string2, String string3) throws IOException {
        this.assertNameIsNotNull(string2);
        this.assertDirIsNotNull(string3);
        this.hasPlan = string != null;
        this.dir = string3;
        this.root = new InstallDir(string2, this.dir);
        this.root.setAppDir(new File(this.dir));
        if (string != null) {
            this.root.setPlan(new File(this.root.getConfigDir(), new File(string).getName()));
        }
    }

    private void assertDirIsNotNull(String string) {
        String string2 = DeployerRuntimeLogger.nullStagingDirectory();
        if (string == null) {
            throw new IllegalArgumentException(string2);
        }
    }

    private void assertNameIsNotNull(String string) {
        String string2 = DeployerRuntimeLogger.nullName();
        if (string == null) {
            throw new IllegalArgumentException(string2);
        }
    }

    public String getRoot() {
        return this.dir;
    }

    public String getSource() {
        return this.root.getArchive().getAbsolutePath();
    }

    public String getPlan() {
        return this.hasPlan ? this.root.getPlan().getAbsolutePath() : null;
    }

    public String getPlanDir() {
        return this.hasPlan ? this.root.getConfigDir().getAbsolutePath() : null;
    }
}

