/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver;

import java.io.IOException;
import weblogic.application.Deployment;
import weblogic.deploy.internal.targetserver.BasicDeployment;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.DeploymentContextImpl;
import weblogic.deploy.internal.targetserver.datamanagement.AppData;
import weblogic.deploy.internal.targetserver.datamanagement.Data;
import weblogic.deploy.internal.targetserver.operations.AbstractOperation;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.deploy.internal.SlaveDeployerLogger;

public class SystemResourceDeployment
extends BasicDeployment {
    public SystemResourceDeployment(SystemResourceMBean systemResourceMBean) {
        super(systemResourceMBean);
    }

    public void verifyAppVersionSecurity(AbstractOperation abstractOperation) throws DeploymentException {
    }

    public void prepare() throws IOException, DeploymentException {
        if (SystemResourceDeployment.isDebugEnabled()) {
            SystemResourceDeployment.debug("Preparing " + this.name);
        }
        try {
            try {
                DeploymentContextImpl deploymentContextImpl;
                this.fireVetoableDeploymentEvent();
                this.stageFilesForStatic();
                Deployment deployment = this.createDeployment(this.deploymentMBean, null);
                if (this.task == null || this.task.getDeploymentContext() == null) {
                    deploymentContextImpl = DeployHelper.createDeploymentContext(this.deploymentMBean);
                    deploymentContextImpl.setStaticDeploymentOperation(true);
                } else {
                    deploymentContextImpl = this.task.getDeploymentContext();
                }
                deployment.prepare(deploymentContextImpl);
            }
            catch (Throwable throwable) {
                this.removeDeployment();
                DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
                SlaveDeployerLogger.logIntialPrepareApplicationFailedLoggable((String)this.name, (Exception)((Object)deploymentException)).log();
                throw deploymentException;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    public void updateDescriptorsPathInfo() {
    }

    public void removeDeployment() {
        this.deploymentManager.removeDeployment(this.deploymentMBean.getName());
    }

    protected final Data createLocalData() {
        BasicDeploymentMBean basicDeploymentMBean = this.getDeploymentMBean();
        return new AppData(basicDeploymentMBean, this, "staged", DeployHelper.getSourcePath(basicDeploymentMBean), null);
    }
}

