/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.datamanagement;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import weblogic.deploy.compatibility.NotificationBroadcaster;
import weblogic.deploy.internal.targetserver.BasicDeployment;
import weblogic.deploy.internal.targetserver.datamanagement.AppDataDeleteUpdate;
import weblogic.deploy.internal.targetserver.datamanagement.AppDataUpdate;
import weblogic.deploy.internal.targetserver.datamanagement.Data;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdate;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdateRequestInfo;
import weblogic.deploy.internal.targetserver.datamanagement.ModuleRedeployDataUpdate;
import weblogic.deploy.internal.targetserver.datamanagement.ModuleRedeployDataUpdateRequestInfo;
import weblogic.deploy.internal.targetserver.datamanagement.PlanDataUpdate;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.DomainDir;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.deploy.internal.MBeanConverter;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.FileUtils;

public class AppData
extends Data {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String serverName = ManagementService.getRuntimeAccess(kernelId).getServerName();
    private String appName = null;
    private String appVersionIdentifier = null;
    private String appId = null;
    private String appRootLocation = null;
    private String stageLocation = null;
    private String originalPlanPath = null;
    private String relativePlanPath = null;
    private BasicDeployment deployment = null;
    private final boolean isAppDeployment;
    private File srcFile = null;

    public AppData(BasicDeploymentMBean basicDeploymentMBean, BasicDeployment basicDeployment, String string, String string2, String string3) {
        super(string2, string3, string);
        this.deployment = basicDeployment;
        this.appId = basicDeploymentMBean.getName();
        this.isAppDeployment = basicDeploymentMBean instanceof AppDeploymentMBean;
        this.setAppRootLocation(basicDeploymentMBean);
        if (this.isAppDeployment) {
            AppDeploymentMBean appDeploymentMBean = (AppDeploymentMBean)basicDeploymentMBean;
            this.appName = appDeploymentMBean.getApplicationName();
            this.appVersionIdentifier = appDeploymentMBean.getVersionIdentifier();
            this.originalPlanPath = appDeploymentMBean.getLocalPlanPath();
            this.srcFile = this.isStagingEnabled() || "external_stage".equals(string) ? new File(this.getLocation()) : new File(appDeploymentMBean.getAbsoluteSourcePath());
        } else {
            this.appName = basicDeploymentMBean.getName();
            this.srcFile = new File(this.getLocation());
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVersionIdentifier() {
        return this.appVersionIdentifier;
    }

    protected DataUpdate createDataUpdate(DataUpdateRequestInfo dataUpdateRequestInfo) {
        Object object;
        if (dataUpdateRequestInfo.isDelete()) {
            if (this.isStagingEnabled()) {
                return new AppDataDeleteUpdate(this, dataUpdateRequestInfo);
            }
            return null;
        }
        boolean bl = false;
        if (this.isStagingEnabled()) {
            if (dataUpdateRequestInfo instanceof ModuleRedeployDataUpdateRequestInfo) {
                return new ModuleRedeployDataUpdate(this, dataUpdateRequestInfo);
            }
            if (dataUpdateRequestInfo.isPlanUpdate()) {
                return new PlanDataUpdate(this, dataUpdateRequestInfo);
            }
            if (AppData.isDebugEnabled()) {
                AppData.debug(" createDataUpdate - staging location: " + this.getLocation());
            }
            if (!((File)(object = new File(this.getLocation()))).exists()) {
                bl = true;
            } else if (!this.isAppDeployment) {
                bl = false;
            } else if (dataUpdateRequestInfo.isStatic()) {
                int n = this.deployment.getStagingState();
                if (!this.isRestageOnlyOnRedeploy()) {
                    if (n < 1) {
                        bl = true;
                        if (AppData.isDebugEnabled()) {
                            AppData.debug(" createDataUpdate - needs restage stagingState: " + n);
                        }
                    } else {
                        long l = this.deployment.getArchiveTimeStamp();
                        long l2 = this.deployment.getPlanTimeStamp();
                        if (AppData.isDebugEnabled()) {
                            AppData.debug(" createDataUpdate - check if needs restage archive ts: " + l + " loc.lastModified: " + ((File)object).lastModified());
                        }
                        if (l > 0L && ((File)object).lastModified() <= l) {
                            bl = true;
                        } else if (this.originalPlanPath != null) {
                            File file = new File(this.originalPlanPath);
                            if (AppData.isDebugEnabled()) {
                                AppData.debug(" createDataUpdate - check if needs restage plan ts: " + l2 + " plan.lastModified: " + file.lastModified());
                            }
                            if (!file.exists() || l2 > 0L && file.lastModified() <= l2) {
                                bl = true;
                            }
                        }
                    }
                }
            } else {
                bl = true;
            }
        }
        if (AppData.isDebugEnabled()) {
            AppData.debug(" +++ [" + this + "] needsRestage : " + bl);
        }
        if (bl) {
            object = new AppDataUpdate(this, dataUpdateRequestInfo);
            return object;
        }
        return null;
    }

    public final String getRootLocation() {
        return this.appRootLocation;
    }

    public final String getPlanPath() {
        return this.originalPlanPath;
    }

    public final String getRelativePlanPath() throws IOException {
        if (this.relativePlanPath == null || this.relativePlanPath.length() == 0) {
            if (!this.isStagingEnabled()) {
                if (AppData.isDebugEnabled()) {
                    AppData.debug(" getRelativePlanPath():nostage - returning original plan path :" + this.originalPlanPath);
                }
                this.relativePlanPath = this.originalPlanPath;
            } else {
                if (this.originalPlanPath == null) {
                    return null;
                }
                File file = new File(this.originalPlanPath);
                if (AppData.isDebugEnabled()) {
                    AppData.debug(" getRelativePlanPath(): plan file name : " + file.getAbsolutePath());
                }
                File file2 = new File(this.getRootLocation());
                if (AppData.isDebugEnabled()) {
                    AppData.debug(" getRelativePlanPath(): application root dir : " + file2);
                }
                String string = AppData.createRelativePath(file2, file);
                if (AppData.isDebugEnabled()) {
                    AppData.debug(" getRelativePlanPath(): Created relative path for plan file : " + string);
                }
                this.relativePlanPath = string;
            }
        }
        return this.relativePlanPath;
    }

    public final void updateDescriptorsPathInfo(BasicDeploymentMBean basicDeploymentMBean) {
        if (this.isAppDeployment && basicDeploymentMBean instanceof AppDeploymentMBean) {
            this.originalPlanPath = ((AppDeploymentMBean)basicDeploymentMBean).getLocalPlanPath();
            this.relativePlanPath = null;
        }
    }

    public void releaseLock(long l) {
    }

    public boolean removeStagedFiles() {
        if (this.isAppDeployment && this.isStagingEnabled()) {
            File file = null;
            file = new File(this.getRootLocation());
            if (file.exists()) {
                String string;
                boolean bl;
                File file2 = new File(this.stageLocation);
                File file3 = file;
                File file4 = null;
                do {
                    file4 = file3.getParentFile();
                    bl = FileUtils.remove((File)file3);
                    file3 = file4;
                } while (bl && !file2.equals(file3) && file3.listFiles().length == 0);
                String string2 = string = bl ? " Removed staged files for deployment  - " + this.appName + " successfully" : " Couldn't remove staged files for app deployment  - " + this.appName;
                if (AppData.isDebugEnabled()) {
                    AppData.debug(string);
                }
                if (!bl) {
                    this.dumpFiles(file, "");
                }
                return bl;
            }
            if (AppData.isDebugEnabled()) {
                AppData.debug(" Staging directory '" + file + "' does not exists. " + "So, nothing to remove here.");
            }
        }
        return true;
    }

    public File getSourceFile() {
        return this.srcFile;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("(appId=");
        stringBuffer.append(this.appId).append(")");
        return stringBuffer.toString();
    }

    protected final void prePrepareDataUpdate() {
        NotificationBroadcaster.sendAppNotification("distributing", this.appId, null);
    }

    protected final void preCommitDataUpdate() throws DeploymentException {
        DataUpdate dataUpdate = this.getCurrentDataUpate();
        if (!(dataUpdate instanceof AppDataUpdate)) {
            return;
        }
        if (dataUpdate != null && ((AppDataUpdate)dataUpdate).isFullUpdate()) {
            boolean bl = this.removeStagedFiles();
            File file = new File(this.getLocation());
            if (!bl && file.exists()) {
                this.deployment.relayStagingState(0);
                Loggable loggable = SlaveDeployerLogger.logRemoveStagedFilesFailedLoggable((String)this.appName, (String)file.toString());
                throw new DeploymentException(loggable.getMessage());
            }
        }
    }

    protected void postCommitDataUpdate() {
        NotificationBroadcaster.sendAppNotification("distributed", this.appId, null);
        this.deployment.relayStagingState(1);
        if (this.isAppDeployment) {
            MBeanConverter.addStagedTarget((AppDeploymentMBean)this.deployment.getDeploymentMBean(), serverName);
        }
    }

    protected void onFailure(Throwable throwable) {
        super.onFailure(throwable);
        this.deployment.relayStagingState(0);
    }

    public void deleteFile(String string, long l) {
    }

    public File getFileFor(long l, String string) {
        return null;
    }

    protected final boolean isSystemResource() {
        return !this.isAppDeployment;
    }

    private static String createRelativePath(File file, File file2) throws IOException {
        boolean bl = AppData.isDebugEnabled();
        String string = file.getCanonicalPath();
        if (bl) {
            AppData.debug(" createRelativePath(): given baseFile: " + string);
        }
        String string2 = file2.getCanonicalPath();
        if (bl) {
            AppData.debug(" createRelativePath(): given givenURI: " + string2);
        }
        int n = string2.indexOf(string);
        if (bl) {
            AppData.debug(" createRelativePath(): indexOf givenURI in given baseFile: " + n);
        }
        if (n == -1) {
            throw new AssertionError((Object)("uri '" + string2 + "' is not sub dir of" + "'" + string + "'"));
        }
        String string3 = string2.substring(string.length() + 1, string2.indexOf(file2.getName()));
        if (bl) {
            AppData.debug(" createRelativePath(): relative rootPath of givenURI : " + string3);
        }
        String string4 = string3 + file2.getName();
        if (bl) {
            AppData.debug(" createRelativePath(): returning result : " + string4);
        }
        return string4;
    }

    private void setAppRootLocation(BasicDeploymentMBean basicDeploymentMBean) {
        if (!this.isStagingEnabled()) {
            this.appRootLocation = null;
        }
        if (this.isAppDeployment) {
            this.appRootLocation = ((AppDeploymentMBean)basicDeploymentMBean).getRootStagingDir();
            this.stageLocation = ManagementService.getRuntimeAccess(kernelId).getServer().getStagingDirectoryName();
        } else {
            this.appRootLocation = DomainDir.getConfigDir();
        }
    }

    private boolean isRestageOnlyOnRedeploy() {
        return ManagementService.getRuntimeAccess(kernelId).getDomain().getDeploymentConfiguration().isRestageOnlyOnRedeploy();
    }
}

