/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.datamanagement;

import java.io.File;
import java.io.IOException;
import java.util.List;
import weblogic.deploy.common.DeploymentConstants;
import weblogic.deploy.internal.targetserver.datamanagement.AppData;
import weblogic.deploy.internal.targetserver.datamanagement.AppDataTransferRequestImpl;
import weblogic.deploy.internal.targetserver.datamanagement.Data;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdate;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdateRequestInfo;
import weblogic.deploy.service.DataStream;
import weblogic.deploy.service.DataTransferHandler;
import weblogic.deploy.service.DataTransferRequest;
import weblogic.deploy.service.FileDataStream;
import weblogic.deploy.service.datatransferhandlers.DataHandlerManager;
import weblogic.j2ee.J2EEUtils;
import weblogic.management.DeploymentException;

public class AppDataUpdate
extends DataUpdate
implements DeploymentConstants {
    private boolean isFullDataUpdate = false;
    private boolean isPlanUpdate = false;

    public AppDataUpdate(Data data, DataUpdateRequestInfo dataUpdateRequestInfo) {
        super(data, dataUpdateRequestInfo);
        List list = dataUpdateRequestInfo.getDeltaFiles();
        boolean bl = this.isFullDataUpdate = list == null || list.isEmpty();
        if (AppDataUpdate.isDebugEnabled()) {
            AppDataUpdate.debug(" +++ isFileDataUpdate : " + this.isFullDataUpdate);
        }
        this.isPlanUpdate = dataUpdateRequestInfo.isPlanUpdate();
        if (AppDataUpdate.isDebugEnabled()) {
            AppDataUpdate.debug(" +++ isPlanUpdate : " + this.isPlanUpdate);
        }
    }

    protected final void doDownload(String string) throws DeploymentException {
        DataTransferRequest dataTransferRequest = this.createDataTransferRequest();
        try {
            DataTransferHandler dataTransferHandler = DataHandlerManager.getHandler(string);
            this.setDownloadedStream(dataTransferHandler.getDataAsStream(dataTransferRequest));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new DeploymentException("Exception occured while downloading files", iOException);
        }
    }

    protected void doCancel() {
        this.restore();
    }

    protected void doClose(boolean bl) {
        if (!bl) {
            this.restore();
        }
        this.deleteBackup();
    }

    protected DataTransferRequest createDataTransferRequest() {
        AppData appData = this.getLocalAppData();
        return new AppDataTransferRequestImpl(appData.getAppName(), appData.getAppVersionIdentifier(), this.getRequestId(), this.getRequestedFiles(), appData.getLockPath(), this.isPlanUpdate);
    }

    protected void deleteFile(String string) {
    }

    protected File getFileFor(String string) {
        return null;
    }

    protected final boolean isFullUpdate() {
        if (AppDataUpdate.isDebugEnabled()) {
            AppDataUpdate.debug(" +++ isFullUpdate() : " + this.isFullDataUpdate);
        }
        return this.isFullDataUpdate;
    }

    protected void end() {
    }

    protected AppData getLocalAppData() {
        return (AppData)this.getLocalData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocalData(DataStream dataStream) throws IOException {
        boolean bl;
        String string = dataStream.getName();
        boolean bl2 = bl = this.isFullUpdate() || this.getLocalAppData().isSystemResource() || string.endsWith("wl_app_desc.jar") || string.endsWith("wl_app_src.jar");
        if (AppDataUpdate.isDebugEnabled()) {
            AppDataUpdate.debug("updateLocalData(): isSpecial : " + bl);
        }
        if (!bl) {
            super.updateLocalData(dataStream);
            return;
        }
        try {
            File file = new File(this.getLocalAppData().isSystemResource() ? this.getLocalAppData().getRootLocation() : (string.endsWith("wl_app_desc.jar") ? this.getLocalAppData().getRootLocation() : this.getLocalAppData().getLocation()));
            if (AppDataUpdate.isDebugEnabled()) {
                AppDataUpdate.debug(" +++ destFile : " + file.getAbsolutePath());
            }
            if (AppDataUpdate.isValidJ2EEArchive(dataStream) || !dataStream.isZip()) {
                if (AppDataUpdate.isDebugEnabled()) {
                    AppDataUpdate.debug(" +++ isValidJ2EEArchive or stream is not zip.....");
                }
                this.copy(dataStream.getInputStream(), file);
            } else if (dataStream instanceof FileDataStream) {
                this.extract(((FileDataStream)dataStream).getFile(), file);
            } else {
                this.extract(dataStream.getInputStream(), file);
            }
            Object var6_5 = null;
            dataStream.close();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            dataStream.close();
            throw throwable;
        }
    }

    private static boolean isValidJ2EEArchive(DataStream dataStream) {
        String string = dataStream.getName();
        if (string.endsWith("wl_app_src.jar") || string.endsWith("wl_app_desc.jar")) {
            return false;
        }
        return J2EEUtils.isValidArchiveName(string) && dataStream.isZip();
    }
}

