/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.datamanagement;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import weblogic.deploy.common.Debug;
import weblogic.management.DomainDir;
import weblogic.utils.FileUtils;
import weblogic.utils.StackTraceUtils;

final class ConfigBackupRecoveryManager {
    private static final String CONFIG_DIRECTORY = "config";
    private static final String CONFIG_BAK_DIRECTORY = "config_bak" + File.separator;
    private static final String CONFIG_PREV_DIRECTORY = "config_prev" + File.separator;
    private static final String CONFIG_PREV_BAK_DIRECTORY = "config_prev_bak" + File.separator;
    private static final String DELETED_FILE_INDEX = CONFIG_BAK_DIRECTORY + File.separator + "__deleted_files_index__";
    private static final String DOMAIN_ROOT = DomainDir.getRootDir();
    private static final String DOMAIN_BAK_ROOT = DomainDir.getServersDir() + File.separator + "domain_bak";
    private boolean configBakSavedToConfigPrev;

    ConfigBackupRecoveryManager() {
    }

    static ConfigBackupRecoveryManager getInstance() {
        return Maker.singleton;
    }

    void handleBackup(File file, String string) throws IOException {
        this.saveConfigPrevToConfigPrevBak();
        if (file.exists()) {
            this.saveFileToConfigBakDir(file, string);
        } else {
            this.appendToDeletedFilesIndex(string);
        }
    }

    void restoreFromBackup() throws IOException {
        if (this.isDebugEnabled()) {
            this.debug("Restoring from backup: " + CONFIG_BAK_DIRECTORY);
        }
        this.deleteAddedFiles();
        File file = new File(DOMAIN_BAK_ROOT, CONFIG_BAK_DIRECTORY);
        if (file.exists()) {
            File file2 = new File(DOMAIN_ROOT, CONFIG_DIRECTORY);
            String[] stringArray = file.list();
            if (stringArray != null && stringArray.length > 0) {
                FileUtils.copy((File)file, (File)file2);
            }
            this.deleteConfigBakDir();
        }
        this.restoreConfigPrevFromConfigPrevBakDir();
        this.deleteConfigPrevBakDir();
        this.configBakSavedToConfigPrev = false;
        if (this.isDebugEnabled()) {
            this.debug("Restored from backup");
        }
    }

    void deleteConfigBakFile(String string) {
        File file = new File(DOMAIN_BAK_ROOT, CONFIG_BAK_DIRECTORY + string);
        if (!file.exists()) {
            return;
        }
        this.deleteFileOrDir(file);
    }

    void saveConfigBakDirToConfigPrevDir() throws IOException {
        File file = new File(DOMAIN_BAK_ROOT, CONFIG_BAK_DIRECTORY);
        File file2 = new File(DOMAIN_BAK_ROOT, CONFIG_PREV_DIRECTORY);
        if (!file.exists()) {
            return;
        }
        this.renameFileOrDir(file, file2);
        this.deleteConfigPrevBakDir();
        this.configBakSavedToConfigPrev = false;
    }

    private final void debug(String string) {
        Debug.deploymentDebug(string);
    }

    private final boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    private void saveFileToConfigBakDir(File file, String string) throws IOException {
        try {
            this.copyFileToConfigBakDir(string, file);
        }
        catch (Throwable throwable) {
            this.deleteConfigPrevBakDir();
            throw new IOException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }

    private void saveConfigPrevToConfigPrevBak() throws IOException {
        if (!this.configBakSavedToConfigPrev) {
            this.saveConfigPrevDirToConfigPrevBakDir();
            this.cleanConfigBakDir();
            this.configBakSavedToConfigPrev = true;
        }
    }

    private void copyFileToConfigBakDir(String string, File file) throws IOException {
        String string2 = string.startsWith(CONFIG_DIRECTORY) ? string.substring(CONFIG_DIRECTORY.length() + 1) : string;
        String string3 = CONFIG_BAK_DIRECTORY + string2;
        File file2 = new File(DOMAIN_BAK_ROOT, string3);
        try {
            if (this.isDebugEnabled()) {
                this.debug("Saving file : '" + file.getCanonicalPath() + "' to: '" + file2.getCanonicalPath() + "'");
            }
            FileUtils.copy((File)file, (File)file2);
        }
        catch (Throwable throwable) {
            if (this.isDebugEnabled()) {
                this.debug("Back up failed due to " + throwable.getMessage() + " " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            this.deleteConfigBakFile(string2);
            throw new IOException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }

    private void saveConfigPrevDirToConfigPrevBakDir() throws IOException {
        this.deleteConfigPrevBakDir();
        File file = new File(DOMAIN_BAK_ROOT, CONFIG_PREV_BAK_DIRECTORY);
        File file2 = new File(DOMAIN_BAK_ROOT, CONFIG_PREV_DIRECTORY);
        this.renameFileOrDir(file2, file);
    }

    private void appendToDeletedFilesIndex(String string) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            File file;
            this.saveConfigPrevToConfigPrevBak();
            File file2 = new File(DOMAIN_BAK_ROOT, CONFIG_BAK_DIRECTORY);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if (!(file = new File(DOMAIN_BAK_ROOT, DELETED_FILE_INDEX)).exists()) {
                file.createNewFile();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(file, true));
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        catch (Throwable throwable) {
            this.deleteConfigPrevBakDir();
            throw new IOException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAddedFiles() throws IOException {
        File file = new File(DOMAIN_BAK_ROOT, DELETED_FILE_INDEX);
        if (!file.exists()) {
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string = bufferedReader.readLine()) != null) {
                FileUtils.remove((File)new File(DOMAIN_ROOT, string));
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        FileUtils.remove((File)file);
    }

    private void cleanConfigBakDir() {
        File file = new File(DOMAIN_BAK_ROOT, CONFIG_BAK_DIRECTORY);
        if (file.exists()) {
            FileUtils.remove((File)file, (FileFilter)FileUtils.STAR);
        }
    }

    private void deleteConfigBakDir() {
        File file = new File(DOMAIN_BAK_ROOT, CONFIG_BAK_DIRECTORY);
        this.deleteFileOrDir(file);
    }

    private void deleteConfigPrevBakDir() {
        File file = new File(DOMAIN_BAK_ROOT, CONFIG_PREV_BAK_DIRECTORY);
        if (!file.exists()) {
            return;
        }
        this.deleteFileOrDir(file);
    }

    private void deleteFileOrDir(File file) {
        if (file.exists()) {
            FileUtils.remove((File)file);
        }
    }

    private boolean renameFileOrDir(File file, File file2) throws IOException {
        if (!file.exists()) {
            if (this.isDebugEnabled()) {
                this.debug("Cannot rename '" + file.getCanonicalPath() + "' as it " + "does not exist");
            }
            return false;
        }
        boolean bl = file.renameTo(file2);
        if (bl) {
            if (this.isDebugEnabled()) {
                this.debug("Renamed '" + file.getCanonicalPath() + "' to: '" + file2.getCanonicalPath());
            }
        } else if (this.isDebugEnabled()) {
            this.debug("Failed to rename '" + file.getCanonicalPath() + "' to: " + file2.getCanonicalPath());
        }
        return bl;
    }

    private void restoreConfigPrevFromConfigPrevBakDir() throws IOException {
        File file = new File(DOMAIN_BAK_ROOT, CONFIG_PREV_DIRECTORY);
        File file2 = new File(DOMAIN_BAK_ROOT, CONFIG_PREV_BAK_DIRECTORY);
        if (!file2.exists()) {
            return;
        }
        this.renameFileOrDir(file2, file);
    }

    private static class Maker {
        private static final ConfigBackupRecoveryManager singleton = new ConfigBackupRecoveryManager();

        private Maker() {
        }
    }
}

