/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.datamanagement;

import java.io.File;
import weblogic.deploy.internal.targetserver.datamanagement.ConfigDataUpdate;
import weblogic.deploy.internal.targetserver.datamanagement.Data;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdate;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdateRequestInfo;
import weblogic.management.DeploymentException;
import weblogic.management.DomainDir;

public class ConfigData
extends Data {
    private String rootLocation = DomainDir.getRootDir();

    public ConfigData(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    protected DataUpdate createDataUpdate(DataUpdateRequestInfo dataUpdateRequestInfo) {
        return this.isStagingEnabled() ? new ConfigDataUpdate(this, dataUpdateRequestInfo) : null;
    }

    public final String getRootLocation() {
        return this.rootLocation;
    }

    public boolean removeStagedFiles() {
        return true;
    }

    public File getSourceFile() {
        return new File(this.getLocation());
    }

    protected final void preCommitDataUpdate() throws DeploymentException {
        if (ConfigData.isDebugEnabled()) {
            ConfigData.debug(" Commiting DataUpdate for : " + this);
        }
    }

    protected void postCommitDataUpdate() {
        if (ConfigData.isDebugEnabled()) {
            ConfigData.debug(" Committed DataUpdate for : " + this);
        }
    }

    protected void onFailure(Throwable throwable) {
        if (ConfigData.isDebugEnabled()) {
            ConfigData.debug(" Failure occured : " + this);
        }
        super.onFailure(throwable);
    }

    public final void deleteFile(String string, long l) {
        DataUpdate dataUpdate = this.getDataUpdate(l);
        if (dataUpdate == null) {
            return;
        }
        dataUpdate.deleteFile(string);
    }

    public final void releaseLock(long l) {
        DataUpdate dataUpdate = this.getDataUpdate(l);
        if (dataUpdate == null) {
            return;
        }
        ((ConfigDataUpdate)dataUpdate).releaseLock();
    }

    public final File getFileFor(long l, String string) {
        DataUpdate dataUpdate = this.getDataUpdate(l);
        if (dataUpdate == null) {
            return new File(this.getRootLocation(), string);
        }
        return dataUpdate.getFileFor(string);
    }
}

