/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.datamanagement;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.deploy.internal.targetserver.datamanagement.ConfigBackupRecoveryManager;
import weblogic.deploy.internal.targetserver.datamanagement.ConfigData;
import weblogic.deploy.internal.targetserver.datamanagement.ConfigDataTransferRequestImpl;
import weblogic.deploy.internal.targetserver.datamanagement.Data;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdate;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdateRequestInfo;
import weblogic.deploy.service.DataStream;
import weblogic.deploy.service.DataTransferHandler;
import weblogic.deploy.service.FileDataStream;
import weblogic.deploy.service.MultiDataStream;
import weblogic.deploy.service.datatransferhandlers.DataHandlerManager;
import weblogic.management.DeploymentException;
import weblogic.management.DomainDir;
import weblogic.management.deploy.internal.DeploymentManagerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.FileUtils;
import weblogic.utils.StackTraceUtils;

public class ConfigDataUpdate
extends DataUpdate {
    private static final int LOCK_WAIT_TIME_INTERVAL = Integer.parseInt(System.getProperty("weblogic.deploy.FileLockWaitTimeInterval", "100"));
    private static final String BOOTING_SERVER_LOCK = "BOOTING_SERVER_LOCK";
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final ConfigBackupRecoveryManager backupManager = ConfigBackupRecoveryManager.getInstance();
    private CopyLockInfo copyLockInfo = null;

    public ConfigDataUpdate(Data data, DataUpdateRequestInfo dataUpdateRequestInfo) {
        super(data, dataUpdateRequestInfo);
    }

    protected final void doDownload(String string) throws DeploymentException {
        CopyLockInfo copyLockInfo = new CopyLockInfo(this.getLocalData().getLockPath(), this.getRequestId());
        this.setCopyLock(copyLockInfo);
        if (copyLockInfo != null && !copyLockInfo.isUpdateNeeded()) {
            copyLockInfo.release();
            if (ConfigDataUpdate.isDebugEnabled()) {
                ConfigDataUpdate.debug("Not preparing '" + this + "' - since some other server acquired lock");
            }
            return;
        }
        ConfigData configData = this.getLocalConfigData();
        ConfigDataTransferRequestImpl configDataTransferRequestImpl = new ConfigDataTransferRequestImpl(this.getRequestId(), this.getRequestedFiles(), configData.getLockPath());
        try {
            DataTransferHandler dataTransferHandler = DataHandlerManager.getHandler(string);
            ReadOnlyMultiDataStream readOnlyMultiDataStream = new ReadOnlyMultiDataStream(dataTransferHandler.getDataAsStream(configDataTransferRequestImpl));
            this.setDownloadedStream(readOnlyMultiDataStream);
            this.handleBackup(readOnlyMultiDataStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new DeploymentException("Exception occured while downloading files", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doUpdate() throws DeploymentException {
        CopyLockInfo copyLockInfo = this.getCopyLock();
        if (copyLockInfo != null && !copyLockInfo.isUpdateNeeded()) {
            if (ConfigDataUpdate.isDebugEnabled()) {
                ConfigDataUpdate.debug("Not committing '" + this + "' - since some other server acquired lock");
            }
            return;
        }
        FileLock fileLock = null;
        try {
            fileLock = this.acquireFileLock(this.getLocalData().getLockPath());
            super.doUpdate();
            this.releaseFileLock(fileLock);
        }
        catch (Throwable throwable) {
            this.releaseFileLock(fileLock);
            throw throwable;
        }
    }

    protected void doCancel() {
        this.restoreFromBackup();
    }

    protected void doClose(boolean bl) {
        CopyLockInfo copyLockInfo;
        if (bl) {
            this.saveBackupToPrev();
        }
        if ((copyLockInfo = this.getCopyLock()) != null) {
            copyLockInfo.release();
            copyLockInfo.removeFile();
        }
        this.setCopyLock(null);
    }

    public final void releaseLock() {
        CopyLockInfo copyLockInfo = this.getCopyLock();
        if (copyLockInfo != null) {
            copyLockInfo.release();
        }
    }

    protected final File getFileFor(String string) {
        if (string == null) {
            throw new NullPointerException("targetPath null");
        }
        File file = null;
        MultiDataStream multiDataStream = this.getDownloadedStream();
        if (multiDataStream != null) {
            Iterator iterator = multiDataStream.getDataStreams();
            while (iterator.hasNext()) {
                DataStream dataStream = (DataStream)iterator.next();
                if (!dataStream.getName().equals(string)) continue;
                if (!(dataStream instanceof FileDataStream)) break;
                file = ((FileDataStream)dataStream).getFile();
            }
        }
        if (file == null) {
            file = new File(this.getLocalData().getRootLocation(), string);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deleteFile(String string) {
        if (string == null) {
            return;
        }
        File file = new File(this.getLocalData().getRootLocation(), string);
        CopyLockInfo copyLockInfo = this.getCopyLock();
        if (copyLockInfo != null && !copyLockInfo.isUpdateNeeded()) {
            if (ConfigDataUpdate.isDebugEnabled()) {
                ConfigDataUpdate.debug("Not deleting file '" + file.getAbsolutePath() + "' for '" + this + "' - since copy lock acquired by some other server");
            }
            return;
        }
        if (ConfigDataUpdate.isDebugEnabled()) {
            ConfigDataUpdate.debug("Deleting file " + file.getAbsolutePath());
        }
        FileLock fileLock = null;
        boolean bl = false;
        try {
            fileLock = this.acquireFileLock(this.getLocalData().getLockPath());
            bl = file.delete();
            this.releaseFileLock(fileLock);
        }
        catch (Throwable throwable) {
            this.releaseFileLock(fileLock);
            throw throwable;
        }
        if (!bl) {
            file.deleteOnExit();
            DeploymentManagerLogger.logDeleteFileFailed(string);
        } else if (ConfigDataUpdate.isDebugEnabled()) {
            ConfigDataUpdate.debug("Deleted file " + file.getAbsolutePath());
        }
    }

    private ConfigData getLocalConfigData() {
        return (ConfigData)this.getLocalData();
    }

    private final void saveBackupToPrev() {
        CopyLockInfo copyLockInfo = this.getCopyLock();
        if (copyLockInfo != null && !copyLockInfo.isUpdateNeeded()) {
            if (ConfigDataUpdate.isDebugEnabled()) {
                ConfigDataUpdate.debug("Not saving config_bak dir to config_prev dir for '" + this + "' - since copy lock acquired by some other server");
            }
            return;
        }
        try {
            if (ConfigDataUpdate.isDebugEnabled()) {
                ConfigDataUpdate.debug("Saving config_bak dir to config_prev dir.");
            }
            backupManager.saveConfigBakDirToConfigPrevDir();
            if (ConfigDataUpdate.isDebugEnabled()) {
                ConfigDataUpdate.debug("Saving config_bak dir to config_prev dir - completed.");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private final void restoreFromBackup() {
        CopyLockInfo copyLockInfo = this.getCopyLock();
        if (copyLockInfo != null && !copyLockInfo.isUpdateNeeded()) {
            if (ConfigDataUpdate.isDebugEnabled()) {
                ConfigDataUpdate.debug("Not restoring from config_bak dir for '" + this + "' - " + "since copy lock acquired by some other server");
            }
            return;
        }
        try {
            if (ConfigDataUpdate.isDebugEnabled()) {
                ConfigDataUpdate.debug("Restoring from config_bak dir.");
            }
            backupManager.restoreFromBackup();
            if (ConfigDataUpdate.isDebugEnabled()) {
                ConfigDataUpdate.debug("Restoring from config_bak dir. - completed");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static File copyDataStreamToTempFile(DataStream dataStream, String string) throws IOException {
        if (dataStream instanceof FileDataStream) {
            File file = ((FileDataStream)dataStream).getFile();
            if (file.getName().startsWith("wl_comp")) {
                return file;
            }
            return ConfigDataUpdate.copyStreamToTempFile(dataStream.getInputStream(), string);
        }
        return ConfigDataUpdate.copyStreamToTempFile(dataStream.getInputStream(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyStreamToTempFile(InputStream inputStream, String string) throws IOException {
        File file = new File(DomainDir.getRootDir(), string);
        File file2 = null;
        String string2 = file.getName();
        if (string2.length() < 3) {
            string2 = string2 + "aaa".substring(string2.length());
        }
        try {
            file2 = File.createTempFile(string2, "new");
        }
        catch (IOException iOException) {
            file2 = File.createTempFile(string2, "new", new File(DomainDir.getRootDir()));
        }
        file2.deleteOnExit();
        try {
            FileUtils.writeToFile((InputStream)inputStream, (File)file2);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file2;
    }

    private void setCopyLock(CopyLockInfo copyLockInfo) {
        this.copyLockInfo = copyLockInfo;
    }

    private CopyLockInfo getCopyLock() {
        return this.copyLockInfo;
    }

    private String getCopyLockFileName(long l) {
        boolean bl;
        File file = new File(DomainDir.getTempDir());
        if (!file.exists()) {
            file.mkdirs();
        }
        boolean bl2 = bl = !ManagementService.isRuntimeAccessInitialized();
        if (ConfigDataUpdate.isDebugEnabled()) {
            ConfigDataUpdate.debug(" Is Server Booting.... : " + bl);
        }
        String string = bl ? BOOTING_SERVER_LOCK : Long.toString(l);
        return DomainDir.getPathRelativeTempDir((String)(string + ".lok"));
    }

    private FileLock acquireFileLock(String string) {
        if (string == null) {
            return null;
        }
        FileLock fileLock = null;
        String string2 = this.getLocalData().getRootLocation() + File.separator + string;
        fileLock = this.acquireFileLock(new File(string2));
        return fileLock;
    }

    private FileLock acquireFileLock(File file) {
        FileLock fileLock = ConfigDataUpdate.getFileLock(file);
        if (ConfigDataUpdate.isDebugEnabled()) {
            ConfigDataUpdate.debug(" Acquired FileLock on '" + file.getAbsolutePath() + "' -- " + System.currentTimeMillis());
        }
        return fileLock;
    }

    public static FileLock getFileLock(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileChannel fileChannel = fileOutputStream.getChannel();
            if (ConfigDataUpdate.isDebugEnabled()) {
                ConfigDataUpdate.debug("Trying to get lock for File: " + file.getAbsolutePath() + " with channel : " + fileChannel);
            }
            return ConfigDataUpdate.getFileLock(fileChannel, 300000L);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private static FileLock getFileLock(FileChannel fileChannel, long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        FileLock fileLock = null;
        while (fileLock == null && l2 <= l3) {
            block11: {
                if (ConfigDataUpdate.isDebugEnabled()) {
                    ConfigDataUpdate.debug("Trying to get lock channel: '" + fileChannel + "' currentTime: " + l2 + ", timeoutTime: " + l3);
                }
                try {
                    fileLock = fileChannel.tryLock();
                }
                catch (Throwable throwable) {
                    if (!ConfigDataUpdate.isDebugEnabled()) break block11;
                    ConfigDataUpdate.debug("Experienced Exception while c.tryLock() and it is ignored :: " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                }
            }
            if (fileLock != null) continue;
            long l4 = l3 - l2;
            try {
                long l5 = LOCK_WAIT_TIME_INTERVAL;
                if (ConfigDataUpdate.isDebugEnabled()) {
                    ConfigDataUpdate.debug("Sleeping for '" + l5 + "' ...");
                }
                Thread.sleep(l4 > l5 ? l5 : l4);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l2 = System.currentTimeMillis();
        }
        if (fileLock == null) {
            if (ConfigDataUpdate.isDebugEnabled()) {
                ConfigDataUpdate.debug("Could not get lock on channel: '" + fileChannel + "'.");
            }
            DeploymentManagerLogger.logCouldNotGetFileLock();
        } else if (ConfigDataUpdate.isDebugEnabled()) {
            ConfigDataUpdate.debug("Got lock on channel: '" + fileChannel + "' : " + fileLock);
        }
        return fileLock;
    }

    private void releaseFileLock(FileLock fileLock) {
        if (fileLock != null) {
            try {
                if (ConfigDataUpdate.isDebugEnabled()) {
                    ConfigDataUpdate.debug(" Releasing FileLock : " + fileLock + " -- " + System.currentTimeMillis());
                }
                fileLock.release();
                fileLock.channel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final void handleBackup(MultiDataStream multiDataStream) throws IOException {
        CopyLockInfo copyLockInfo = this.getCopyLock();
        if (copyLockInfo != null && !copyLockInfo.isUpdateNeeded()) {
            if (ConfigDataUpdate.isDebugEnabled()) {
                ConfigDataUpdate.debug("Not taking backup for update '" + this + "' - since copy lock acquired by some other server");
            }
            return;
        }
        for (String string : ConfigDataUpdate.getAllTargetPaths(multiDataStream)) {
            File file = new File(this.getLocalData().getRootLocation(), string);
            try {
                if (ConfigDataUpdate.isDebugEnabled()) {
                    ConfigDataUpdate.debug("Saving file '" + file.getAbsolutePath() + "' to config_bak");
                }
                backupManager.handleBackup(file, string);
                if (!ConfigDataUpdate.isDebugEnabled()) continue;
                ConfigDataUpdate.debug("Saved file '" + file.getAbsolutePath() + "' to config_bak");
            }
            catch (IOException iOException) {
                backupManager.deleteConfigBakFile(string);
                this.restoreFromBackup();
                throw iOException;
            }
        }
    }

    private static List getAllTargetPaths(MultiDataStream multiDataStream) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (multiDataStream != null) {
            Iterator iterator = multiDataStream.getDataStreams();
            while (iterator.hasNext()) {
                DataStream dataStream = (DataStream)iterator.next();
                arrayList.add(dataStream.getName());
            }
        }
        return arrayList;
    }

    private class DelegatingFileDataStream
    extends DelegatingDataStream
    implements FileDataStream {
        private File referringFile;

        DelegatingFileDataStream(DataStream dataStream) throws IOException {
            super(dataStream);
            this.referringFile = null;
            this.referringFile = ConfigDataUpdate.copyDataStreamToTempFile(dataStream, this.getName());
        }

        public File getFile() {
            if (this.referringFile != null) {
                return this.referringFile;
            }
            if (this.delegate instanceof FileDataStream) {
                return ((FileDataStream)this.delegate).getFile();
            }
            return null;
        }

        public int getLength() throws IOException {
            File file = this.getFile();
            return file != null ? (int)file.length() : 0;
        }

        public InputStream getInputStream() throws IOException {
            if (this.referringFile != null) {
                return new FileInputStream(this.referringFile);
            }
            return super.getInputStream();
        }

        public void close() {
            if (this.referringFile != null) {
                if (DataUpdate.isDebugEnabled()) {
                    DataUpdate.debug("Removing temporary file : " + this.referringFile.getAbsolutePath());
                }
                this.referringFile.delete();
            } else {
                super.close();
            }
        }
    }

    private class DelegatingDataStream
    implements DataStream {
        protected final DataStream delegate;

        DelegatingDataStream(DataStream dataStream) {
            this.delegate = dataStream;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public boolean isZip() {
            return this.delegate.isZip();
        }

        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        public void close() {
            this.delegate.close();
        }
    }

    private class ReadOnlyMultiDataStream
    implements MultiDataStream {
        List allStreams = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ReadOnlyMultiDataStream(MultiDataStream multiDataStream) throws IOException {
            FileLock fileLock = null;
            try {
                if (ManagementService.getPropertyService(KERNEL_ID).isAdminServer()) {
                    fileLock = ConfigDataUpdate.this.acquireFileLock(ConfigDataUpdate.this.getLocalData().getLockPath());
                }
                Iterator iterator = multiDataStream.getDataStreams();
                while (iterator.hasNext()) {
                    DataStream dataStream = (DataStream)iterator.next();
                    String string = dataStream.getName();
                    final String string2 = string.startsWith("pending") ? "config" + string.substring("pending".length()) : string;
                    this.allStreams.add(new DelegatingFileDataStream((FileDataStream)dataStream){

                        public String getName() {
                            return string2;
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                ConfigDataUpdate.this.releaseFileLock(fileLock);
                throw throwable;
            }
            ConfigDataUpdate.this.releaseFileLock(fileLock);
        }

        public int getSize() {
            return this.allStreams.size();
        }

        public Iterator getDataStreams() {
            return this.allStreams.iterator();
        }

        public Iterator getInputStreams() throws IOException {
            ArrayList<InputStream> arrayList = new ArrayList<InputStream>();
            Iterator iterator = this.getDataStreams();
            while (iterator.hasNext()) {
                arrayList.add(((DataStream)iterator.next()).getInputStream());
            }
            return arrayList.iterator();
        }

        public void close() {
            Iterator iterator = this.getDataStreams();
            while (iterator.hasNext()) {
                DataStream dataStream = (DataStream)iterator.next();
                dataStream.close();
            }
        }

        public void addDataStream(DataStream dataStream) {
            throw new UnsupportedOperationException("[ReadOnly].addDataStream(DataStream) unsupported");
        }

        public void addFileDataStream(String string, File file, boolean bl) {
            throw new UnsupportedOperationException("[ReadOnly].addFileDataStream(String, File, boolean) unsupported");
        }

        public void addFileDataStream(String string, boolean bl) {
            throw new UnsupportedOperationException("[ReadOnly].addFileDataStream(String, boolean) unsupported");
        }

        public void removeDataStream(DataStream dataStream) {
            throw new UnsupportedOperationException("[ReadOnly].removeDataStream(DataStream) unsupported");
        }
    }

    private final class CopyLockInfo {
        boolean updateIsNeeded = false;
        FileLock copyLock = null;
        File targetFile = null;

        protected CopyLockInfo(String string, long l) {
            this.copyLock = this.acquireCopyLock(string, l);
            if (DataUpdate.isDebugEnabled()) {
                DataUpdate.debug("Got lock on '" + this.targetFile.getAbsolutePath() + "' == " + System.currentTimeMillis());
            }
        }

        protected FileLock getLock() {
            return this.copyLock;
        }

        protected boolean isUpdateNeeded() {
            return this.updateIsNeeded;
        }

        protected void release() {
            if (this.copyLock == null) {
                return;
            }
            ConfigDataUpdate.this.releaseFileLock(this.copyLock);
            this.copyLock = null;
            if (DataUpdate.isDebugEnabled()) {
                DataUpdate.debug(" Released lock on '" + this.targetFile.getAbsolutePath() + "' == " + System.currentTimeMillis());
            }
        }

        protected void removeFile() {
            if (this.targetFile.exists()) {
                this.targetFile.delete();
                if (DataUpdate.isDebugEnabled()) {
                    DataUpdate.debug(" Removed file '" + this.targetFile.getAbsolutePath() + "'");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileLock acquireCopyLock(String string, long l) {
            FileLock fileLock = ConfigDataUpdate.this.acquireFileLock(string);
            try {
                String string2 = ConfigDataUpdate.this.getCopyLockFileName(l);
                this.targetFile = new File(string2);
                this.targetFile.deleteOnExit();
                if (this.targetFile.exists()) {
                    ConfigDataUpdate.this.releaseFileLock(fileLock);
                    fileLock = null;
                    this.updateIsNeeded = false;
                } else {
                    this.updateIsNeeded = true;
                }
                if (DataUpdate.isDebugEnabled()) {
                    DataUpdate.debug("Is update required : " + this.updateIsNeeded);
                }
                FileLock fileLock2 = ConfigDataUpdate.this.acquireFileLock(this.targetFile);
                return fileLock2;
            }
            finally {
                ConfigDataUpdate.this.releaseFileLock(fileLock);
            }
        }
    }
}

