/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.datamanagement;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdate;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdateRequestInfo;
import weblogic.management.DeploymentException;
import weblogic.utils.Debug;

public abstract class Data {
    private static final String INDENT = "  ";
    private String location;
    private String lockPath;
    private boolean stagingEnabled;
    private String stagingMode = null;
    private Map dataUpdates = new HashMap();
    private DataUpdate currentDataUpdate = null;

    protected Data(String string, String string2) {
        this(string, string2, false);
    }

    protected Data(String string, String string2, boolean bl) {
        this.location = string;
        this.lockPath = string2;
        this.stagingEnabled = bl;
    }

    protected Data(String string, String string2, String string3) {
        this.location = string;
        this.lockPath = string2;
        this.stagingMode = string3;
        this.stagingEnabled = "stage".equals(this.stagingMode);
    }

    public final String getLocation() {
        return this.location;
    }

    public final String getLockPath() {
        return this.lockPath;
    }

    public final boolean isStagingEnabled() {
        return this.stagingEnabled;
    }

    public String getStagingMode() {
        return this.stagingMode;
    }

    protected final DataUpdate getCurrentDataUpate() {
        return this.currentDataUpdate;
    }

    public void initDataUpdate(DataUpdateRequestInfo dataUpdateRequestInfo) {
        DataUpdate dataUpdate = this.createDataUpdate(dataUpdateRequestInfo);
        if (dataUpdate == null) {
            return;
        }
        this.setCurrentDataUpdate(dataUpdate);
    }

    public final void prepareDataUpdate(String string) throws DeploymentException {
        try {
            DataUpdate dataUpdate = this.getCurrentDataUpate();
            if (dataUpdate == null) {
                return;
            }
            this.prePrepareDataUpdate();
            dataUpdate.download(string);
            this.postPrepareDataUpdate();
        }
        catch (Throwable throwable) {
            this.resetOnFailure(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void commitDataUpdate() throws DeploymentException {
        try {
            try {
                DataUpdate dataUpdate = this.getCurrentDataUpate();
                if (dataUpdate == null) {
                    Object var3_3 = null;
                    this.setCurrentDataUpdate(null);
                    return;
                }
                this.preCommitDataUpdate();
                dataUpdate.update();
                this.postCommitDataUpdate();
            }
            catch (Throwable throwable) {
                this.resetOnFailure(throwable);
                Object var3_5 = null;
                this.setCurrentDataUpdate(null);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.setCurrentDataUpdate(null);
            throw throwable;
        }
        Object var3_4 = null;
        this.setCurrentDataUpdate(null);
    }

    public final void cancelDataUpdate(long l) {
        DataUpdate dataUpdate = this.getDataUpdate(l);
        if (dataUpdate == null) {
            return;
        }
        dataUpdate.cancel();
        this.closeDataUpdate(l, false);
    }

    public void closeDataUpdate(long l, boolean bl) {
        DataUpdate dataUpdate = this.getDataUpdate(l);
        if (dataUpdate == null) {
            return;
        }
        dataUpdate.close(bl);
        this.removeDataUpdate(l);
    }

    public abstract void releaseLock(long var1);

    public abstract boolean removeStagedFiles();

    public abstract File getSourceFile();

    protected abstract DataUpdate createDataUpdate(DataUpdateRequestInfo var1);

    protected abstract String getRootLocation();

    protected void prePrepareDataUpdate() {
        if (Data.isDebugEnabled()) {
            Data.debug(" Preparing DataUpdate for : " + this);
        }
    }

    protected void postPrepareDataUpdate() {
        if (Data.isDebugEnabled()) {
            Data.debug(" Prepared DataUpdate for : " + this);
        }
    }

    protected void preCommitDataUpdate() throws DeploymentException {
        if (Data.isDebugEnabled()) {
            Data.debug(" Commiting DataUpdate for : " + this);
        }
    }

    protected void postCommitDataUpdate() {
        if (Data.isDebugEnabled()) {
            Data.debug(" Committed DataUpdate for : " + this);
        }
    }

    protected void onFailure(Throwable throwable) {
        this.closeCurrentDataUpdate();
        this.setCurrentDataUpdate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DataUpdate getDataUpdate(long l) {
        if (Data.isDebugEnabled()) {
            Data.debug(" dataUpdates.get(" + l + ")");
        }
        Map map = this.dataUpdates;
        synchronized (map) {
            return (DataUpdate)this.dataUpdates.get(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void putDataUpdate(long l, DataUpdate dataUpdate) {
        if (Data.isDebugEnabled()) {
            Data.debug(" dataUpdates.put(" + l + " = " + dataUpdate);
        }
        Map map = this.dataUpdates;
        synchronized (map) {
            this.dataUpdates.put(l, dataUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeDataUpdate(long l) {
        if (Data.isDebugEnabled()) {
            Data.debug(" dataUpdates.remove(" + l + ")");
        }
        Map map = this.dataUpdates;
        synchronized (map) {
            DataUpdate dataUpdate = (DataUpdate)this.dataUpdates.remove(l);
            if (dataUpdate != null && dataUpdate == this.currentDataUpdate) {
                this.currentDataUpdate = null;
            }
        }
    }

    protected void dumpFiles(File file, String string) {
        if (Data.isDebugEnabled()) {
            File[] fileArray;
            Data.debug(string + file);
            if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    String string2 = string + INDENT;
                    this.dumpFiles(fileArray[i], string2);
                }
            }
        }
    }

    public abstract void deleteFile(String var1, long var2);

    public abstract File getFileFor(long var1, String var3);

    private void resetOnFailure(Throwable throwable) throws DeploymentException {
        Debug.assertion((throwable != null ? 1 : 0) != 0);
        this.onFailure(throwable);
        throw DeployHelper.convertThrowable(throwable);
    }

    protected static void debug(String string) {
        weblogic.deploy.common.Debug.deploymentDebug(string);
    }

    protected static boolean isDebugEnabled() {
        return weblogic.deploy.common.Debug.isDeploymentDebugEnabled();
    }

    private void closeCurrentDataUpdate() {
        DataUpdate dataUpdate = this.getCurrentDataUpate();
        if (dataUpdate != null) {
            this.cancelDataUpdate(dataUpdate.getRequestId());
            this.setCurrentDataUpdate(null);
        }
    }

    private void setCurrentDataUpdate(DataUpdate dataUpdate) {
        this.currentDataUpdate = dataUpdate;
        if (this.currentDataUpdate != null) {
            this.putDataUpdate(this.currentDataUpdate.getRequestId(), dataUpdate);
        }
    }
}

