/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.datamanagement;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.targetserver.datamanagement.Data;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdateRequestInfo;
import weblogic.deploy.service.DataStream;
import weblogic.deploy.service.FileDataStream;
import weblogic.deploy.service.MultiDataStream;
import weblogic.management.DeploymentException;
import weblogic.utils.FileUtils;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.jars.JarFileUtils;

public abstract class DataUpdate {
    public static final int STATE_UNINITIALIZED = -1;
    public static final int STATE_INITIALIZED = 0;
    public static final int STATE_PREPARED = 1;
    public static final int STATE_COMMITTED = 2;
    private int state = -1;
    private List requestedFiles = null;
    private MultiDataStream downloadedStream = null;
    private long requestId = 0L;
    private Data localData = null;

    protected DataUpdate(Data data, DataUpdateRequestInfo dataUpdateRequestInfo) {
        this.init(data, dataUpdateRequestInfo);
    }

    public final void download(String string) throws DeploymentException {
        int n = this.getState();
        if (n != 0) {
            throw new IllegalStateException("Invalid state transition - download on : " + this);
        }
        if (DataUpdate.isDebugEnabled()) {
            DataUpdate.debug(" +++ DataUpdate.download() - preparing data update on : " + this);
        }
        this.doDownload(string);
        if (DataUpdate.isDebugEnabled()) {
            DataUpdate.debug(" +++ DataUpdate.download() - prepared data update on : " + this);
        }
        this.setState(1);
    }

    public final void update() throws DeploymentException {
        int n = this.getState();
        if (n != 1) {
            throw new IllegalStateException("Invalid state transition - commit on " + this);
        }
        if (DataUpdate.isDebugEnabled()) {
            DataUpdate.debug(" +++ DataUpdate.commit() - committing data update on : " + this);
        }
        this.doUpdate();
        if (DataUpdate.isDebugEnabled()) {
            DataUpdate.debug(" +++ DataUpdate.commit() - committed data update on : " + this);
        }
        this.setState(2);
    }

    public final void cancel() {
        int n = this.getState();
        if (n < 1) {
            return;
        }
        if (DataUpdate.isDebugEnabled()) {
            DataUpdate.debug(" +++ DataUpdate.cancel() - cancelling data update on : " + this);
        }
        this.doCancel();
        if (DataUpdate.isDebugEnabled()) {
            DataUpdate.debug(" +++ DataUpdate.cancel() - cancelling data update on : " + this);
        }
    }

    public final void close(boolean bl) {
        if (DataUpdate.isDebugEnabled()) {
            DataUpdate.debug(" +++ DataUpdate.close() - closing data update on : " + this);
        }
        this.doClose(bl);
        if (DataUpdate.isDebugEnabled()) {
            DataUpdate.debug(" +++ DataUpdate.close() - closed data update on : " + this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("(localData=");
        stringBuffer.append(this.localData).append(", state=").append(this.getStateAsString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected final MultiDataStream getDownloadedStream() {
        if (this.getState() < 1) {
            throw new IllegalStateException("Cannot get downloaded stream since update is not prepared");
        }
        return this.downloadedStream;
    }

    protected final List getRequestedFiles() {
        if (this.getState() < 0) {
            throw new IllegalStateException("Cannot get requested files since update is not prepared");
        }
        return this.requestedFiles;
    }

    protected final long getRequestId() {
        if (this.getState() < 0) {
            throw new IllegalStateException("Cannot get requestId since update is not prepared");
        }
        return this.requestId;
    }

    protected final Data getLocalData() {
        if (this.getState() < 0) {
            throw new IllegalStateException("Cannot get local data since update is not prepared");
        }
        return this.localData;
    }

    protected final void setLocalData(Data data) {
        this.localData = data;
    }

    protected final void setRequestId(long l) {
        this.requestId = l;
    }

    protected final void setRequestedFiles(List list) {
        this.requestedFiles = new ArrayList();
        this.requestedFiles.addAll(list);
    }

    protected final void setDownloadedStream(MultiDataStream multiDataStream) {
        this.downloadedStream = multiDataStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocalData(DataStream dataStream) throws IOException {
        try {
            String string = dataStream.getName();
            File file = new File(this.getLocalData().getLocation(), string);
            this.copyOrExtractTo(dataStream, file);
            Object var5_4 = null;
            dataStream.close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dataStream.close();
            throw throwable;
        }
    }

    protected final void copyOrExtractTo(DataStream dataStream, File file) throws IOException {
        boolean bl = dataStream.isZip();
        if (bl) {
            boolean bl2 = bl = !file.exists() || file.isDirectory();
        }
        if (DataUpdate.isDebugEnabled()) {
            DataUpdate.debug("copyOrExtractTo() : needsExtract = " + bl);
        }
        if (dataStream instanceof FileDataStream) {
            File file2 = ((FileDataStream)dataStream).getFile();
            if (bl) {
                if (DataUpdate.isDebugEnabled()) {
                    DataUpdate.debug("copyOrExtractTo() : extracting '" + file2.getAbsolutePath() + "' - '" + file.getAbsolutePath() + "'");
                }
                this.extract(file2, file);
            } else {
                if (DataUpdate.isDebugEnabled()) {
                    DataUpdate.debug("copyOrExtractTo() : copying '" + file2.getAbsolutePath() + "' - '" + file.getAbsolutePath() + "'");
                }
                this.copy(dataStream.getInputStream(), file);
            }
        } else {
            InputStream inputStream = dataStream.getInputStream();
            if (bl) {
                this.extract(inputStream, file);
            } else {
                this.copy(inputStream, file);
            }
        }
    }

    protected final void extract(File file, File file2) throws IOException {
        try {
            JarFileUtils.extract((File)file, (File)file2);
        }
        catch (IOException iOException) {
            DataUpdate.debug(" Exception occured while copying to '" + file2.getAbsolutePath() + " :: " + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
            throw iOException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void extract(InputStream inputStream, File file) throws IOException {
        try {
            try {
                JarFileUtils.extract((InputStream)inputStream, (File)file);
            }
            catch (IOException iOException) {
                DataUpdate.debug(" Exception occured while copying to '" + file.getAbsolutePath() + " :: " + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
                throw iOException;
            }
            Object var5_3 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        return;
    }

    protected final void copy(File file, File file2) throws IOException {
        try {
            FileUtils.copy((File)file, (File)file2);
        }
        catch (IOException iOException) {
            DataUpdate.debug(" Exception occured while copying to '" + file2.getAbsolutePath() + " :: " + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
            throw iOException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void copy(InputStream inputStream, File file) throws IOException {
        try {
            try {
                boolean bl;
                if (DataUpdate.isDebugEnabled()) {
                    DataUpdate.debug("copy() : toFile: " + file.getAbsolutePath());
                }
                File file2 = file.getParentFile();
                if (DataUpdate.isDebugEnabled()) {
                    DataUpdate.debug("copy() : parent: " + file.getAbsolutePath());
                }
                if (!(bl = file2.exists())) {
                    bl = file2.mkdirs();
                }
                if (!bl) {
                    throw new IOException("Could not create parent directory : " + file2.getAbsolutePath());
                }
                FileUtils.writeToFile((InputStream)inputStream, (File)file);
                if (DataUpdate.isDebugEnabled()) {
                    DataUpdate.debug("copy() : wrote to : " + file);
                }
            }
            catch (IOException iOException) {
                DataUpdate.debug(" Exception occured while copying to '" + file.getAbsolutePath() + " :: " + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
                throw iOException;
            }
            Object var6_6 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        return;
    }

    protected void doInit(Data data, DataUpdateRequestInfo dataUpdateRequestInfo) {
        this.setLocalData(data);
        this.setRequestedFiles(dataUpdateRequestInfo.getDeltaFiles());
        this.setRequestId(dataUpdateRequestInfo.getRequestId());
    }

    protected abstract void doDownload(String var1) throws DeploymentException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doUpdate() throws DeploymentException {
        MultiDataStream multiDataStream = null;
        try {
            try {
                multiDataStream = this.getDownloadedStream();
                if (multiDataStream == null) {
                    Object var5_2 = null;
                    if (multiDataStream == null) return;
                    multiDataStream.close();
                    return;
                }
                this.backup();
                Iterator iterator = multiDataStream.getDataStreams();
                while (iterator.hasNext()) {
                    DataStream dataStream = (DataStream)iterator.next();
                    this.updateLocalData(dataStream);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.restore();
                throw new DeploymentException("Exception occured while copying files", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (multiDataStream == null) throw throwable;
            multiDataStream.close();
            throw throwable;
        }
        Object var5_3 = null;
        if (multiDataStream == null) return;
        multiDataStream.close();
    }

    protected abstract void doCancel();

    protected abstract void doClose(boolean var1);

    protected abstract void deleteFile(String var1);

    protected abstract File getFileFor(String var1);

    protected static void debug(String string) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug(string);
        }
    }

    protected static boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    protected void backup() {
    }

    protected void restore() {
    }

    protected void deleteBackup() {
    }

    private final void init(Data data, DataUpdateRequestInfo dataUpdateRequestInfo) {
        int n = this.getState();
        if (n != -1) {
            throw new IllegalStateException("Invalid state transition - init on : " + this);
        }
        if (DataUpdate.isDebugEnabled()) {
            DataUpdate.debug(" +++ DataUpdate.init() - initializing data update with Data=" + data + ", files=" + dataUpdateRequestInfo.getDeltaFiles() + ", requestId=" + dataUpdateRequestInfo.getRequestId() + " : " + this);
        }
        this.doInit(data, dataUpdateRequestInfo);
        if (DataUpdate.isDebugEnabled()) {
            DataUpdate.debug(" +++ DataUpdate.init() - initialized data update on : " + this);
        }
        this.setState(0);
    }

    private final void setState(int n) {
        boolean bl = false;
        switch (n) {
            case 2: {
                if (this.state == 1) break;
                bl = true;
                break;
            }
            case 1: {
                if (this.state == 0) break;
                bl = true;
                break;
            }
            case 0: {
                if (this.state == -1) break;
                bl = true;
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state '" + n + "'");
            }
        }
        if (bl) {
            throw new IllegalStateException("Invalid state transition from " + this.state + " --> " + n);
        }
        this.state = n;
    }

    private final int getState() {
        return this.state;
    }

    private final String getStateAsString() {
        return this.getStateAsString(this.state);
    }

    private final String getStateAsString(int n) {
        switch (n) {
            case 2: {
                return "STATE_COMMITTED";
            }
            case 1: {
                return "STATE_PREPARED";
            }
            case 0: {
                return "STATE_INITIALIZED";
            }
            case -1: {
                return "STATE_UNINITIALIZED";
            }
        }
        throw new IllegalStateException("Invalid state");
    }
}

