/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.datamanagement;

import java.io.File;
import java.io.IOException;
import weblogic.deploy.internal.targetserver.datamanagement.AppDataUpdate;
import weblogic.deploy.internal.targetserver.datamanagement.Data;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdateRequestInfo;
import weblogic.utils.FileUtils;
import weblogic.utils.jars.JarFileUtils;

public class PlanDataUpdate
extends AppDataUpdate {
    private static final String stagePlanDir = "plan";
    private boolean isPlanExistsPreviously = false;
    private boolean isRestored = false;
    private boolean isBackupFileDeleted = false;
    private File backupFile = null;

    public PlanDataUpdate(Data data, DataUpdateRequestInfo dataUpdateRequestInfo) {
        super(data, dataUpdateRequestInfo);
    }

    protected void backup() {
        if (PlanDataUpdate.isDebugEnabled()) {
            PlanDataUpdate.debug(" +++ PlanDataUpdate.backup() : taking existing plan dir backup");
        }
        this.takePlanDirBackup();
    }

    protected void restore() {
        if (PlanDataUpdate.isDebugEnabled()) {
            PlanDataUpdate.debug(" +++ PlanDataUpdate.restore() : restoring plan dir from backup");
        }
        if (!this.isRestored) {
            this.restorePlanDir();
        }
    }

    protected void deleteBackup() {
        if (PlanDataUpdate.isDebugEnabled()) {
            PlanDataUpdate.debug(" +++ PlanDataUpdate.deleteBackup() : deleting backup file");
        }
        if (!this.isBackupFileDeleted && this.backupFile != null) {
            this.isBackupFileDeleted = FileUtils.remove((File)this.backupFile);
        }
    }

    private void takePlanDirBackup() {
        try {
            File file = this.getPlanDir();
            if (file.exists()) {
                this.isPlanExistsPreviously = true;
                this.backupFile = File.createTempFile(stagePlanDir, ".jar", this.getAppRoot());
                JarFileUtils.createJarFileFromDirectory((File)this.backupFile, (File)file, (boolean)false);
            } else {
                this.isPlanExistsPreviously = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorePlanDir() {
        this.removeCurrentPlanDir();
        if (this.isPlanExistsPreviously) {
            File file = this.getPlanDir();
            file.mkdirs();
            if (!file.exists()) {
                return;
            }
            if (this.backupFile.exists()) {
                try {
                    try {
                        JarFileUtils.extract((File)this.backupFile, (File)file);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Object var4_3 = null;
                        this.deleteBackup();
                    }
                    Object var4_2 = null;
                    this.deleteBackup();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.deleteBackup();
                    throw throwable;
                }
            }
        }
        this.isRestored = true;
    }

    private boolean removeCurrentPlanDir() {
        File file = this.getPlanDir();
        if (file.exists()) {
            return FileUtils.remove((File)file);
        }
        return false;
    }

    private File getPlanDir() {
        return new File(this.getAppRoot(), stagePlanDir);
    }

    private File getAppRoot() {
        String string = this.getLocalAppData().getRootLocation();
        return new File(string);
    }
}

