/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.operations;

import java.io.IOException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import weblogic.application.Deployment;
import weblogic.application.ModuleListener;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.application.utils.TargetUtils;
import weblogic.deploy.beans.factory.InvalidTargetException;
import weblogic.deploy.common.Debug;
import weblogic.deploy.container.NonFatalDeploymentException;
import weblogic.deploy.event.BaseDeploymentEvent;
import weblogic.deploy.event.DeploymentEvent;
import weblogic.deploy.event.DeploymentEventManager;
import weblogic.deploy.event.VetoableDeploymentEvent;
import weblogic.deploy.internal.InternalDeploymentData;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.targetserver.BasicDeployment;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.DeploymentContextImpl;
import weblogic.deploy.internal.targetserver.DeploymentManager;
import weblogic.deploy.internal.targetserver.OrderedDeployments;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.deploy.internal.targetserver.state.ListenerFactory;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.DeploymentServerService;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public abstract class AbstractOperation {
    private boolean completed;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    protected static final ServerMBean server = ManagementService.getRuntimeAccess(kernelId).getServer();
    private ModuleListener ml;
    protected static final String serverName = server.getName();
    protected static final ClusterMBean cluster = server.getCluster();
    protected static final DeploymentManager deploymentManager = DeploymentManager.getInstance();
    protected final long requestId;
    protected final String taskId;
    protected final InternalDeploymentData internalDeploymentData;
    protected final DeploymentData deploymentData;
    protected final BasicDeployment app;
    protected int operation;
    protected Deployment appcontainer;
    protected final BasicDeploymentMBean mbean;
    protected DomainMBean proposedDomain;
    private static weblogic.application.DeploymentManager appctrManager = weblogic.application.DeploymentManager.getDeploymentManager();
    private DeploymentState state;
    protected AuthenticatedSubject initiator;
    protected DeploymentContextImpl deploymentContext;
    protected boolean requiresRestart = false;
    protected boolean controlOperation = false;

    protected AbstractOperation(long l, String string, InternalDeploymentData internalDeploymentData, BasicDeploymentMBean basicDeploymentMBean, DomainMBean domainMBean, AuthenticatedSubject authenticatedSubject, boolean bl) throws DeploymentException {
        this.requestId = l;
        this.taskId = string;
        if (basicDeploymentMBean == null) {
            DeploymentException deploymentException = new DeploymentException("Attempt to create " + this.getClass().getName() + " with a null BasicDeploymentMBean. RequestId:'" + l + "' and taskId: '" + string + "'");
            this.complete(2, (Exception)((Object)deploymentException));
            throw deploymentException;
        }
        if (!DeploymentServerService.isStarted()) {
            Loggable loggable = DeployerRuntimeLogger.logDeploymentServiceNotStartedLoggable((String)ApplicationVersionUtils.getDisplayName(basicDeploymentMBean), (String)string);
            DeploymentException deploymentException = new DeploymentException(loggable.getMessage());
            this.complete(2, (Exception)((Object)deploymentException));
            throw deploymentException;
        }
        this.internalDeploymentData = internalDeploymentData;
        this.mbean = basicDeploymentMBean;
        this.deploymentData = internalDeploymentData.getExternalDeploymentData();
        this.proposedDomain = domainMBean;
        this.initiator = authenticatedSubject;
        this.requiresRestart = bl;
        if (this.deploymentContext == null) {
            this.deploymentContext = new DeploymentContextImpl(authenticatedSubject);
            this.deploymentContext.setProposedDomain(domainMBean);
            this.deploymentContext.setRequiresRestart(bl);
        }
        this.deploymentContext.setUserSuppliedTargets(this.getTargets());
        this.app = OrderedDeployments.getOrCreateBasicDeployment(this.mbean);
        if (this.app != null) {
            this.app.setTask(this);
            this.app.resetMBean(this.mbean);
            this.deploymentContext.setAppStaged(this.app.isAppStaged());
        } else if (this.isDebugEnabled()) {
            this.debug("BasicDeployment is null for " + basicDeploymentMBean.getName());
        }
    }

    private void setTargetsFromConfig() {
        if (!this.deploymentData.isTargetsFromConfig()) {
            this.deploymentData.setTargetsFromConfig(this.deploymentData.getAllModuleTargets().isEmpty() && this.deploymentData.getAllSubModuleTargets().isEmpty());
        }
    }

    protected DeploymentState getState() {
        return this.state;
    }

    public DomainMBean getProposedDomain() {
        return this.proposedDomain;
    }

    public DeploymentContextImpl getDeploymentContext() {
        return this.deploymentContext;
    }

    public long getRequestId() {
        return this.requestId;
    }

    protected DomainMBean getDomain() {
        if (this.proposedDomain != null) {
            return this.proposedDomain;
        }
        return ManagementService.getRuntimeAccess(kernelId).getDomain();
    }

    protected BasicDeploymentMBean getMBean() {
        return this.mbean;
    }

    public BasicDeploymentMBean getDeploymentMBean() {
        return this.mbean;
    }

    public int getNotificationLevel() {
        if (this.internalDeploymentData != null) {
            return this.internalDeploymentData.getNotificationLevel();
        }
        return 1;
    }

    public InternalDeploymentData getInternalDeploymentData() {
        return this.internalDeploymentData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void prepare() throws DeploymentException {
        if (!this.isDeploymentRequestValidForCurrentServer()) {
            return;
        }
        this.dumpOperation();
        this.deploymentContext.setDeploymentOperation(this.operation);
        this.addContainerListener();
        try {
            this.fireVetoableDeploymentEvent();
            this.doPrepare();
            if (!this.isSupportingServer()) {
                this.relayState(1, null);
            }
            Object var2_1 = null;
            this.removeContainerListener();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.removeContainerListener();
            throw throwable;
        }
    }

    private void dumpOperation() {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.debug("DeploymentData: " + this.deploymentData);
        this.debug("Proposed Mbean: ");
        if (this.mbean == null) {
            this.debug("   removed");
        } else {
            this.dumpModuleTargetInfo(this.mbean);
        }
    }

    private void dumpModuleTargetInfo(ConfigurationMBean configurationMBean) {
        this.dumpTargetsForModule((TargetInfoMBean)configurationMBean);
        SubDeploymentMBean[] subDeploymentMBeanArray = configurationMBean instanceof BasicDeploymentMBean ? ((BasicDeploymentMBean)configurationMBean).getSubDeployments() : ((SubDeploymentMBean)configurationMBean).getSubDeployments();
        if (subDeploymentMBeanArray != null) {
            for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
                SubDeploymentMBean subDeploymentMBean = subDeploymentMBeanArray[i];
                this.dumpModuleTargetInfo(subDeploymentMBean);
            }
        }
    }

    private void dumpTargetsForModule(TargetInfoMBean targetInfoMBean) {
        String string = "";
        TargetMBean[] targetMBeanArray = targetInfoMBean.getTargets();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            string = string + targetMBean.getName();
        }
        this.debug("Module: " + targetInfoMBean.getName() + ", Targets: " + string);
    }

    public void stageFilesFromAdminServer(String string) throws DeploymentException {
        this.prepareDataUpdate(string);
    }

    protected void ensureAppContainerSet() throws DeploymentException {
        if (this.appcontainer == null) {
            this.appcontainer = this.getApplication().findDeployment();
        }
    }

    protected void doPrepare() throws DeploymentException {
    }

    protected final void setupPrepare() throws DeploymentException {
        try {
            boolean bl = true;
            this.getApplication().verifyLocalApp();
            if (this.isAppDeployment() && bl) {
                this.compatibilityProcessor();
            }
        }
        catch (Throwable throwable) {
            DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
            throw deploymentException;
        }
    }

    protected void compatibilityProcessor() throws DeploymentException {
    }

    public final boolean isAppDeployment() {
        return this.mbean instanceof AppDeploymentMBean;
    }

    public final boolean isInternalApp() {
        return this.mbean instanceof AppDeploymentMBean && ((AppDeploymentMBean)this.mbean).isInternalApp();
    }

    public final void commit() throws DeploymentException {
        if (this.completed) {
            return;
        }
        if (!this.isDeploymentRequestValidForCurrentServer()) {
            this.complete(3, null);
            return;
        }
        this.dumpOperation();
        this.addContainerListener();
        try {
            try {
                this.doCommit();
            }
            catch (Throwable throwable) {
                DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
                this.complete(2, (Exception)((Object)deploymentException));
                SlaveDeployerLogger.logCommitUpdateFailedLoggable((String)("" + this.operation), (String)this.app.getName()).log();
                throw deploymentException;
            }
            Object var4_1 = null;
            this.removeContainerListener();
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.removeContainerListener();
            throw throwable;
        }
    }

    public final void cancel() throws DeploymentException {
        if (!this.isCancelNecessary()) {
            return;
        }
        if (this.completed) {
            return;
        }
        if (!this.isDeploymentRequestValidForCurrentServer()) {
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug("Operation.cancel() started for requestId : " + this.requestId);
        }
        this.addContainerListener();
        try {
            try {
                this.doCancel();
            }
            catch (Throwable throwable) {
                Loggable loggable = SlaveDeployerLogger.logCancelFailedLoggable((String)this.taskId, (String)serverName);
                throw new DeploymentException(loggable.getMessage(), throwable);
            }
            Object var4_1 = null;
            this.removeContainerListener();
            this.completed = true;
            if (this.isDebugEnabled()) {
                this.debug("Operation.cancel() finished for requestId : " + this.requestId);
            }
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.removeContainerListener();
            this.completed = true;
            if (this.isDebugEnabled()) {
                this.debug("Operation.cancel() finished for requestId : " + this.requestId);
            }
            throw throwable;
        }
    }

    private void addContainerListener() {
        this.state = new DeploymentState(this.mbean.getName(), this.taskId, this.getNotificationLevel());
        TargetMBean targetMBean = TargetUtils.findLocalTarget(this.mbean, server);
        this.state.setTarget(targetMBean.getName());
        this.ml = ListenerFactory.createListener(this.getDeploymentMBean(), this.taskId, this.state);
        if (this.isDebugEnabled()) {
            this.debug("Adding " + this.ml);
        }
        appctrManager.addModuleListener(this.ml);
        this.getApplication().setStateRef(this.state);
    }

    private void removeContainerListener() {
        if (this.isDebugEnabled()) {
            this.debug("Removing " + this.ml);
        }
        appctrManager.removeModuleListener(this.ml);
        this.ml = null;
    }

    protected ModuleListener getListener() {
        return this.ml;
    }

    protected void doCommit() throws IOException, DeploymentException {
    }

    protected void doCancel() {
    }

    protected boolean isCancelNecessary() {
        return true;
    }

    protected final void silentCancelOnPrepareFailure() {
        try {
            this.doCancel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void complete(int n, Exception object) {
        boolean bl;
        this.completed = true;
        boolean bl2 = bl = n != 2;
        if (!bl) {
            if (object == null) {
                object = new DeploymentException("Task failed with unknown reason");
            }
            Loggable loggable = SlaveDeployerLogger.logTaskFailedLoggable((String)Long.toString(this.requestId), (String)this.taskId, (Exception)object);
            loggable.log();
            this.cancelDataUpdate();
        }
        this.closeDataUpdate(bl);
        if (!this.isSupportingServer()) {
            this.relayState(n, (Exception)object);
        }
        this.fireDeploymentEvent();
    }

    protected final void silentRemove(Deployment deployment) {
        try {
            deployment.remove(this.deploymentContext);
        }
        catch (DeploymentException deploymentException) {
            SlaveDeployerLogger.logOperationFailed((String)"Remove", (String)this.getMBean().getName(), (Exception)((Object)deploymentException));
        }
    }

    private void relayState(int n, Exception exception) {
        block9: {
            if (this.state == null) {
                return;
            }
            this.state.setTaskState(n);
            this.state.setException(exception);
            TargetMBean targetMBean = TargetUtils.findLocalTarget(this.mbean, server);
            if (this.state.getTarget() == null) {
                this.state.setTarget(targetMBean.getName());
            }
            try {
                String string;
                if (n == 2 && exception != null && !(exception instanceof NonFatalDeploymentException)) {
                    int n2 = 0;
                    this.state.setStagingState(n2);
                    AppRuntimeStateManager.getManager().setStagingState(this.mbean.getName(), new String[]{targetMBean.getName()}, n2, this.isInternalApp());
                }
                String string2 = string = this.deploymentData == null ? this.state.getIntendedState() : this.deploymentData.getIntendedState();
                if (!this.isAppDeleted()) {
                    AppRuntimeStateManager.getManager().setState(this.mbean.getName(), new String[]{targetMBean.getName()}, string);
                }
                if (this.isDebugEnabled()) {
                    this.debug("Updated intended state for " + this.mbean.getName() + " to " + string);
                }
            }
            catch (ManagementException managementException) {
                if (!this.isDebugEnabled()) break block9;
                this.debug("Failed to update intended state for " + this.mbean.getName());
            }
        }
        if (!ManagementService.getRuntimeAccess(kernelId).isAdminServer() && !this.isAppDeleted()) {
            AppRuntimeStateManager.getManager().updateState(this.mbean.getName(), this.state);
        }
        if (this.isDebugEnabled()) {
            this.debug("Relaying updated state for app, " + this.state.getId() + " to " + this.state.getCurrentState() + ", taskState: " + this.state.getTaskState());
        }
        deploymentManager.relayStatus(this.requestId, this.state);
    }

    protected String[] getFiles() {
        return this.internalDeploymentData != null ? this.deploymentData.getFiles() : null;
    }

    public BasicDeployment getApplication() {
        return this.app;
    }

    public String getTaskId() {
        return this.taskId;
    }

    protected void debug(String string) {
        Debug.deploymentDebug(this.getDebugPrefix() + string);
    }

    private String getDebugPrefix() {
        String string = this.getClass().getName();
        string = string.substring(this.getClass().getPackage().getName().length() + 1);
        return "[op=" + string + ",task=" + this.taskId + "]";
    }

    protected boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    protected boolean isAdminMode() {
        return this.deploymentData != null && this.deploymentData.getDeploymentOptions() != null && this.deploymentData.getDeploymentOptions().isTestMode();
    }

    protected boolean isAppContainerActive(Deployment deployment) {
        if (deployment == null) {
            return false;
        }
        int n = this.getState(deployment);
        return n == 3 || n == 4 || n == 2;
    }

    protected void activate(Deployment deployment) throws DeploymentException {
        boolean bl = this.isAdminMode() || this.isServerInAdminMode();
        this.deploymentContext.setAdminModeTransition(bl);
        if (this.getState(deployment) == 1) {
            deployment.activate(this.deploymentContext);
        }
    }

    protected boolean isGracefulProductionToAdmin() {
        return this.deploymentData != null && this.deploymentData.getDeploymentOptions() != null && this.deploymentData.getDeploymentOptions().isGracefulProductionToAdmin();
    }

    private boolean isIgnoreSessions() {
        return this.deploymentData != null && this.deploymentData.getDeploymentOptions() != null && this.deploymentData.getDeploymentOptions().isGracefulIgnoreSessions();
    }

    private int getRMIGracePeriod() {
        if (this.deploymentData == null || this.deploymentData.getDeploymentOptions() == null) {
            return -1;
        }
        return this.deploymentData.getDeploymentOptions().getRMIGracePeriodSecs();
    }

    protected void gracefulProductionToAdmin(Deployment deployment) throws DeploymentException {
        boolean bl = this.isIgnoreSessions();
        boolean bl2 = this.isAdminMode();
        int n = this.getRMIGracePeriod();
        this.deploymentContext.setAdminModeTransition(bl2);
        this.deploymentContext.setIgnoreSessions(bl);
        this.deploymentContext.setRMIGracePeriodSecs(n);
        this.getApplication().gracefulProductionToAdmin(deployment, this.deploymentContext);
    }

    protected void forceProductionToAdmin(Deployment deployment) throws DeploymentException {
        boolean bl = this.isAdminMode();
        this.deploymentContext.setAdminModeTransition(bl);
        this.getApplication().forceProductionToAdmin(deployment, this.getForceUndeployTimeoutSecs(), this.deploymentContext);
    }

    protected boolean isNewApplication() {
        if (this.deploymentData == null) {
            return false;
        }
        return this.deploymentData.isNewApplication();
    }

    protected String[] getModules() {
        if (this.deploymentData == null) {
            return null;
        }
        return this.deploymentData.getModules();
    }

    protected String[] getTargets() {
        if (this.deploymentData == null) {
            return null;
        }
        return this.deploymentData.getTargets();
    }

    protected final boolean isTargetListContainsCurrentServer() {
        String string;
        if (this.deploymentData == null) {
            return false;
        }
        DomainMBean domainMBean = this.proposedDomain != null ? this.proposedDomain : ManagementService.getRuntimeAccess(kernelId).getDomain();
        Set set = null;
        try {
            set = this.deploymentData.getAllTargetedServers(this.deploymentData.getAllLogicalTargets(), domainMBean);
        }
        catch (InvalidTargetException invalidTargetException) {
            invalidTargetException.printStackTrace();
            set = Collections.EMPTY_SET;
        }
        if (this.isDebugEnabled()) {
            this.debug(" +++ TargetList : " + set);
        }
        return set.contains(string = server.getName());
    }

    protected final boolean isAppTargetedToCurrentServer() {
        return TargetHelper.isAppTargetedToCurrentServer(this.mbean);
    }

    protected long getForceUndeployTimeoutSecs() {
        if (this.deploymentData == null) {
            return 0L;
        }
        if (this.deploymentData.getDeploymentOptions() == null) {
            return 0L;
        }
        return this.deploymentData.getDeploymentOptions().getForceUndeployTimeout();
    }

    protected void silentDeactivate(Deployment deployment) {
        try {
            deployment.deactivate(this.deploymentContext);
        }
        catch (DeploymentException deploymentException) {
            SlaveDeployerLogger.logOperationFailed((String)"Deactivate", (String)this.getMBean().getName(), (Exception)((Object)deploymentException));
        }
    }

    protected void silentUnprepare(Deployment deployment) {
        try {
            deployment.unprepare(this.deploymentContext);
        }
        catch (DeploymentException deploymentException) {
            SlaveDeployerLogger.logOperationFailed((String)"Unprepare", (String)this.getMBean().getName(), (Exception)((Object)deploymentException));
        }
    }

    protected void silentProductionToAdmin(Deployment deployment) {
        try {
            if (this.isGracefulProductionToAdmin()) {
                this.gracefulProductionToAdmin(deployment);
            } else {
                this.forceProductionToAdmin(deployment);
            }
        }
        catch (DeploymentException deploymentException) {
            SlaveDeployerLogger.logOperationFailed((String)"ProductionToAdmin", (String)this.getMBean().getName(), (Exception)((Object)deploymentException));
        }
    }

    protected void silentStop(Deployment deployment, String[] stringArray) {
        try {
            this.deploymentContext.setUpdatedResourceURIs(stringArray);
            deployment.stop(this.deploymentContext);
        }
        catch (DeploymentException deploymentException) {
            SlaveDeployerLogger.logOperationFailed((String)"Stop", (String)this.getMBean().getName(), (Exception)((Object)deploymentException));
            if (this.getState(deployment) == 3) {
                this.silentProductionToAdmin(deployment);
            }
            this.silentDeactivate(deployment);
            this.silentUnprepare(deployment);
        }
    }

    protected final void stop(Deployment deployment, String[] stringArray) throws DeploymentException {
        if (!this.isAppContainerActive(deployment)) {
            return;
        }
        try {
            this.deploymentContext.setUpdatedResourceURIs(stringArray);
            deployment.stop(this.deploymentContext);
        }
        catch (DeploymentException deploymentException) {
            SlaveDeployerLogger.logOperationFailed((String)"Stop", (String)this.getMBean().getName(), (Exception)((Object)deploymentException));
            if (deploymentException instanceof NonFatalDeploymentException) {
                throw deploymentException;
            }
            if (this.getState(deployment) == 3) {
                this.silentProductionToAdmin(deployment);
            }
            this.silentDeactivate(deployment);
            this.silentUnprepare(deployment);
        }
    }

    protected int getState(Deployment deployment) {
        return DeployHelper.getState(deployment);
    }

    protected boolean isAdminState(Deployment deployment) {
        return DeployHelper.isAdminState(deployment);
    }

    protected void fireVetoableDeploymentEvent() throws DeploymentException {
        if (!this.isAppDeployment() || ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            return;
        }
        BaseDeploymentEvent.EventType eventType = null;
        switch (this.operation) {
            case 1: {
                eventType = VetoableDeploymentEvent.APP_ACTIVATE;
                break;
            }
            case 9: 
            case 11: {
                eventType = VetoableDeploymentEvent.APP_DEPLOY;
                break;
            }
            case 7: {
                eventType = VetoableDeploymentEvent.APP_START;
                break;
            }
            case 4: {
                eventType = VetoableDeploymentEvent.APP_UNDEPLOY;
                break;
            }
        }
        if (eventType != null) {
            try {
                DeploymentEventManager.sendVetoableDeploymentEvent(VetoableDeploymentEvent.create(this, eventType, (AppDeploymentMBean)this.getApplication().getDeploymentMBean(), this.isNewApplication(), this.getModules(), this.getTargets()));
            }
            catch (DeploymentException deploymentException) {
                this.complete(2, (Exception)((Object)deploymentException));
                throw deploymentException;
            }
        }
    }

    private void fireDeploymentEvent() {
        if (!this.isAppDeployment() || ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            return;
        }
        BaseDeploymentEvent.EventType eventType = null;
        switch (this.operation) {
            case 1: {
                eventType = DeploymentEvent.APP_ACTIVATED;
                break;
            }
            case 11: {
                eventType = DeploymentEvent.APP_DEPLOYED;
                break;
            }
            case 9: 
            case 10: {
                eventType = DeploymentEvent.APP_REDEPLOYED;
                break;
            }
            case 7: {
                eventType = DeploymentEvent.APP_STARTED;
                break;
            }
            case 4: {
                if (!this.isAppDeleted()) break;
                eventType = DeploymentEvent.APP_DELETED;
                break;
            }
        }
        if (eventType != null) {
            DeploymentEventManager.sendDeploymentEvent(DeploymentEvent.create(this, eventType, (AppDeploymentMBean)this.getApplication().getDeploymentMBean(), this.getModules(), this.getTargets()));
        }
    }

    protected boolean isAppDeleted() {
        if (!this.isAppDeployment()) {
            return false;
        }
        DomainMBean domainMBean = this.getProposedDomain();
        BasicDeploymentMBean basicDeploymentMBean = this.getApplication().getDeploymentMBean();
        return domainMBean != null && basicDeploymentMBean != null && domainMBean.lookupAppDeployment(basicDeploymentMBean.getName()) == null;
    }

    protected boolean isServerInAdminMode() {
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        return serverRuntimeMBean != null && serverRuntimeMBean.getStateVal() == 17;
    }

    protected final boolean isAppSystemResource() {
        return this.mbean instanceof SystemResourceMBean;
    }

    protected boolean isDeploymentRequestValidForCurrentServer() {
        boolean bl = this.isTargetListContainsCurrentServer();
        if (this.isDebugEnabled()) {
            this.debug(" +++ Supplied TargetList contains current server : " + bl);
        }
        boolean bl2 = this.isAppTargetedToCurrentServer();
        if (this.isDebugEnabled()) {
            this.debug(" +++ Application targeted to current server : " + bl2);
        }
        if (bl || bl2) {
            return true;
        }
        return !this.isAppSystemResource();
    }

    public final int getOperationType() {
        return this.operation;
    }

    public final boolean isControlOperation() {
        return this.controlOperation;
    }

    protected void initDataUpdate() throws DeploymentException {
    }

    protected final void prepareDataUpdate(String string) throws DeploymentException {
        this.initDataUpdate();
        this.getApplication().prepareDataUpdate(string);
    }

    protected final void commitDataUpdate() throws DeploymentException {
        this.getApplication().commitDataUpdate();
    }

    protected final void cancelDataUpdate() {
        this.getApplication().cancelDataUpdate(this.getRequestId());
    }

    protected final void closeDataUpdate(boolean bl) {
        this.getApplication().closeDataUpdate(this.getRequestId(), bl);
    }

    private boolean isSupportingServer() {
        if (this.isTargetListContainsCurrentServer()) {
            return false;
        }
        if (!(this.mbean instanceof AppDeploymentMBean)) {
            return false;
        }
        if (cluster == null) {
            return false;
        }
        Set set = TargetHelper.getAllTargetedServers(this.mbean);
        return !set.contains(serverName);
    }
}

