/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.operations;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import weblogic.application.Deployment;
import weblogic.application.internal.DeploymentStateChecker;
import weblogic.deploy.internal.InternalDeploymentData;
import weblogic.deploy.internal.targetserver.AppDeployment;
import weblogic.deploy.internal.targetserver.BasicDeployment;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdateRequestInfo;
import weblogic.deploy.internal.targetserver.operations.AbstractOperation;
import weblogic.deploy.internal.targetserver.operations.RedeployOperation;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.deploy.internal.MBeanConverter;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;

public class ActivateOperation
extends AbstractOperation {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    boolean isFailedInPrepareValidation = false;

    public ActivateOperation(long l, String string, InternalDeploymentData internalDeploymentData, BasicDeploymentMBean basicDeploymentMBean, DomainMBean domainMBean, AuthenticatedSubject authenticatedSubject, boolean bl) throws DeploymentException {
        super(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
        this.operation = 1;
    }

    public AbstractOperation refine() throws DeploymentException {
        BasicDeployment basicDeployment = this.getApplication();
        if (basicDeployment == null) {
            String string = SlaveDeployerLogger.logFailedToFindDeploymentLoggable((String)this.internalDeploymentData.getDeploymentName()).getMessage();
            throw new AssertionError(string);
        }
        this.appcontainer = basicDeployment.findDeployment();
        if (this.appcontainer == null) {
            return this;
        }
        return new RedeployOperation(this.requestId, this.taskId, this.internalDeploymentData, this.mbean, this.proposedDomain, this.initiator, this.requiresRestart);
    }

    protected void compatibilityProcessor() throws DeploymentException {
        MBeanConverter.setupNew81MBean((AppDeploymentMBean)this.mbean);
    }

    protected void doPrepare() throws DeploymentException {
        this.validatePrepare();
        if (this.isDebugEnabled()) {
            this.debug("Preparing application " + this.getApplication().getName());
        }
        if (this.isAdminState() && !this.isAdminMode()) {
            return;
        }
        try {
            this.commitDataUpdate();
            this.setupPrepare();
            this.createAndPrepareContainer();
            this.resetPendingRestartForSystemResource();
        }
        catch (Throwable throwable) {
            this.silentCancelOnPrepareFailure();
            DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
            this.complete(2, (Exception)((Object)deploymentException));
            throw deploymentException;
        }
    }

    protected void doCommit() throws IOException, DeploymentException {
        this.appcontainer = this.getApplication().findDeployment();
        if (this.internalDeploymentData.getDeploymentOperation() != 6) {
            this.activateDeployment();
        }
        this.complete(3, null);
    }

    protected void doCancel() {
        if (this.appcontainer != null) {
            int n = this.getState(this.appcontainer);
            if (n == 1) {
                if (this.isDebugEnabled()) {
                    this.debug("ActivateOperation: Invoking unprepare() on Container.");
                }
                this.silentUnprepare(this.appcontainer);
                if (this.isDebugEnabled()) {
                    this.debug("ActivateOperation: Invoking unprepare() on Container.");
                }
            }
            this.silentRemove(this.appcontainer);
        }
        this.getApplication().remove();
    }

    protected boolean isCancelNecessary() {
        return !this.isFailedInPrepareValidation;
    }

    protected void activateDeployment() throws DeploymentException {
        if (this.appcontainer != null) {
            if (this.isDebugEnabled()) {
                this.debug(" ActivateOperation - Activating application " + this.getApplication().getName());
            }
            try {
                this.activate(this.appcontainer);
            }
            catch (DeploymentException deploymentException) {
                this.recoverOnActivateFailure(this.appcontainer);
                throw deploymentException;
            }
            if (this.getState(this.appcontainer) == 3) {
                return;
            }
            if (!this.isAdminMode()) {
                try {
                    if (this.isServerInAdminMode()) {
                        if (this.getApplication().getState() != null) {
                            this.getApplication().getState().setIntendedState("STATE_ACTIVE");
                        }
                    } else {
                        this.appcontainer.adminToProduction(this.deploymentContext);
                    }
                }
                catch (DeploymentException deploymentException) {
                    this.silentDeactivate(this.appcontainer);
                    this.recoverOnActivateFailure(this.appcontainer);
                    throw deploymentException;
                }
            }
        }
    }

    protected void recoverOnActivateFailure(Deployment deployment) {
        this.silentUnprepare(deployment);
        this.silentRemove(deployment);
        this.getApplication().remove();
        if (this.getApplication().getState() != null) {
            this.getApplication().getState().setCurrentState("STATE_FAILED", true);
        }
    }

    protected void unprepareDeployment() throws DeploymentException {
        if (this.appcontainer != null) {
            if (this.isDebugEnabled()) {
                this.debug(" ActivateOperation - unpreparing application " + this.getApplication().getName());
            }
            this.appcontainer.unprepare(this.deploymentContext);
        }
    }

    protected void createAndPrepareContainer() throws DeploymentException {
        if (this.isDebugEnabled()) {
            this.debug(" Creating application container for " + this.getApplication().getName());
        }
        this.appcontainer = this.getApplication().createDeployment(this.mbean, this.getState());
        this.initializeDeploymentPlan();
        boolean bl = this.isAdminMode();
        this.deploymentContext.setAdminModeTransition(bl);
        this.appcontainer.prepare(this.deploymentContext);
    }

    protected boolean isAdminState() {
        if (this.appcontainer == null) {
            this.appcontainer = this.getApplication().findDeployment();
        }
        return this.appcontainer != null && this.isAdminState(this.appcontainer);
    }

    private void initializeDeploymentPlan() throws DeploymentException {
        if (this.isAppDeployment() && this.mbean != null) {
            AppDeployment appDeployment = (AppDeployment)this.getApplication();
            String string = ((AppDeploymentMBean)this.mbean).getPlanPath();
            DeploymentPlanBean deploymentPlanBean = appDeployment.parsePlan();
            ((AppDeploymentMBean)this.mbean).setDeploymentPlanDescriptor(deploymentPlanBean);
        }
    }

    protected void validatePrepare() throws DeploymentException {
        this.appcontainer = this.getApplication().findDeployment();
        if (this.appcontainer != null && this.getState(this.appcontainer) > 0) {
            String string = SlaveDeployerLogger.illegalStateForDeploy((String)DeploymentStateChecker.state2String(this.getState(this.appcontainer)));
            this.isFailedInPrepareValidation = true;
            throw new DeploymentException(string);
        }
    }

    public void initDataUpdate() throws DeploymentException {
        this.getApplication().initDataUpdate(new DataUpdateRequestInfo(){

            public List getDeltaFiles() {
                return new ArrayList();
            }

            public long getRequestId() {
                return ActivateOperation.this.requestId;
            }

            public boolean isStatic() {
                return false;
            }

            public boolean isDelete() {
                return false;
            }

            public boolean isPlanUpdate() {
                return false;
            }
        });
    }

    protected void resetPendingRestartForSystemResource() {
        if (this.mbean instanceof SystemResourceMBean) {
            ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
            serverRuntimeMBean.removePendingRestartSystemResource(this.mbean.getName());
        }
    }
}

