/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.operations;

import weblogic.deploy.internal.InternalDeploymentData;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.operations.AbstractOperation;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;

public class DeactivateOperation
extends AbstractOperation {
    protected int cbTag;

    public DeactivateOperation(long l, String string, InternalDeploymentData internalDeploymentData, BasicDeploymentMBean basicDeploymentMBean, DomainMBean domainMBean, AuthenticatedSubject authenticatedSubject, boolean bl) throws DeploymentException {
        super(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
        this.operation = 3;
        this.controlOperation = true;
    }

    protected void doCommit() throws DeploymentException {
        try {
            this.deactivate();
            this.complete(3, null);
        }
        catch (ManagementException managementException) {
            throw DeployHelper.convertThrowable(managementException);
        }
    }

    protected void deactivate() throws DeploymentException {
        if (this.isDebugEnabled()) {
            this.debug(" Deactivating application = " + this.getApplication().getName());
        }
        this.appcontainer = this.getApplication().findDeployment();
        if (this.appcontainer != null) {
            // empty if block
        }
        if (this.appcontainer != null) {
            int n = this.getState(this.appcontainer);
            if (this.isGracefulProductionToAdmin()) {
                if (n == 3) {
                    this.gracefulProductionToAdmin(this.appcontainer);
                }
            } else if (n == 3 || n == 2 && this.getApplication().hasPendingGraceful()) {
                this.forceProductionToAdmin(this.appcontainer);
            }
            if (this.getState(this.appcontainer) == 2) {
                this.appcontainer.deactivate(this.deploymentContext);
            }
        }
    }

    protected boolean isDeploymentRequestValidForCurrentServer() {
        return this.isTargetListContainsCurrentServer();
    }
}

