/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.operations;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import weblogic.application.ModuleListener;
import weblogic.deploy.internal.InternalDeploymentData;
import weblogic.deploy.internal.targetserver.AppDeployment;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdateRequestInfo;
import weblogic.deploy.internal.targetserver.operations.AbstractOperation;
import weblogic.deploy.internal.targetserver.operations.RedeployOperation;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.deploy.DeployerRuntimeTextTextFormatter;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.MBeanConverter;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class DynamicUpdateOperation
extends AbstractOperation {
    private String[] files = new String[0];
    private final Map subModuleTargets;
    private DeploymentPlanBean dpb = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public DynamicUpdateOperation(long l, String string, InternalDeploymentData internalDeploymentData, BasicDeploymentMBean basicDeploymentMBean, DomainMBean domainMBean, AuthenticatedSubject authenticatedSubject, boolean bl) throws DeploymentException {
        super(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
        if (this.deploymentData == null || !this.deploymentData.hasFiles() && !this.deploymentData.hasSubModuleTargets()) {
            throw new AssertionError();
        }
        this.files = this.deploymentData.hasFiles() ? this.deploymentData.getFiles() : null;
        this.subModuleTargets = this.deploymentData.getAllSubModuleTargets();
        this.appcontainer = this.getApplication().findDeployment();
        this.operation = internalDeploymentData == null ? 9 : internalDeploymentData.getDeploymentOperation();
    }

    protected void compatibilityProcessor() throws DeploymentException {
        MBeanConverter.reconcile81MBeans(this.deploymentData, (AppDeploymentMBean)this.mbean);
    }

    public AbstractOperation refine() throws DeploymentException {
        if (this.isAppContainerActive(this.appcontainer)) {
            return this;
        }
        this.internalDeploymentData.setDeploymentOperation(6);
        return new RedeployOperation(this.requestId, this.taskId, this.internalDeploymentData, this.mbean, this.proposedDomain, this.initiator, this.requiresRestart);
    }

    public void doPrepare() throws DeploymentException {
        if (this.isDebugEnabled()) {
            this.debug("DynamicUpdateOperation: prepare called.");
        }
        try {
            this.commitDataUpdate();
            this.setupPrepare();
            this.ensureAppContainerSet();
            if (this.isASystemResourceRequiringRestart()) {
                if (this.isDebugEnabled()) {
                    this.debug("System Resource '" + this.mbean.getName() + "' requires a " + "restart for the changes to take effect - prepare returning " + "without further validation");
                }
                if (this.getState() != null) {
                    this.getState().setCurrentState(((Object)ModuleListener.STATE_UPDATE_PENDING).toString());
                }
                return;
            }
            if (!this.subModuleTargets.isEmpty()) {
                this.convertSubModuleTargetsToFiles();
            }
            this.initializeDeploymentPlan();
            if (this.isDebugEnabled()) {
                this.debug("Files: " + Arrays.asList(this.files));
            }
            this.deploymentContext.setUpdatedResourceURIs(this.files);
            this.appcontainer.prepareUpdate(this.deploymentContext);
        }
        catch (Throwable throwable) {
            this.silentCancelOnPrepareFailure();
            DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
            this.complete(2, (Exception)((Object)deploymentException));
            throw deploymentException;
        }
    }

    private void initializeDeploymentPlan() throws DeploymentException {
        if (this.isAppDeployment() && this.operation == 10 && this.mbean != null) {
            this.dpb = ((AppDeployment)this.getApplication()).parsePlan();
            ((AppDeploymentMBean)this.mbean).setDeploymentPlanDescriptor(this.dpb);
        }
    }

    private void convertSubModuleTargetsToFiles() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.files != null) {
            arrayList.addAll(Arrays.asList((Object[])this.files));
        }
        for (String string : this.subModuleTargets.keySet()) {
            Map map = (Map)this.subModuleTargets.get(string);
            for (String string2 : map.keySet()) {
                if (string.equals("_the_standalone_module")) {
                    arrayList.add(string2);
                    continue;
                }
                arrayList.add(string + '/' + string2);
            }
        }
        this.files = arrayList.toArray(new String[arrayList.size()]);
    }

    private final boolean isASystemResourceRequiringRestart() {
        ServerRuntimeMBean serverRuntimeMBean;
        return this.mbean instanceof SystemResourceMBean && ((serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime()).isRestartRequired() || serverRuntimeMBean.isRestartPendingForSystemResource(this.mbean.getName()));
    }

    protected void doCommit() throws IOException, DeploymentException {
        if (this.isASystemResourceRequiringRestart()) {
            if (this.isDebugEnabled()) {
                this.debug("System Resource '" + this.mbean.getName() + "' requires a " + "restart for the changes to take effect - commit returning " + "without proceeding further");
            }
            if (this.getState() != null) {
                this.getState().setCurrentState(((Object)ModuleListener.STATE_ACTIVE).toString());
            }
        } else {
            this.deploymentContext.setUpdatedResourceURIs(this.files);
            if (this.isDebugEnabled()) {
                this.debug("DynamicUpdateOperation: Invoking activateUpdate() on Container.");
            }
            this.appcontainer.activateUpdate(this.deploymentContext);
        }
        this.complete(3, null);
    }

    protected final void doCancel() {
        if (this.appcontainer == null) {
            return;
        }
        this.cancelDataUpdate();
        int n = this.getState(this.appcontainer);
        if (n == 4) {
            this.deploymentContext.setUpdatedResourceURIs(this.files);
            if (this.isDebugEnabled()) {
                this.debug("DynamicUpdateOperation: Invoking rollbackUpdate() on Container.");
            }
            this.appcontainer.rollbackUpdate(this.deploymentContext);
            if (this.isDebugEnabled()) {
                this.debug("DynamicUpdateOperation: rollbackUpdate() on Container finished.");
            }
        }
    }

    protected void initDataUpdate() throws DeploymentException {
        try {
            boolean bl;
            final ArrayList<String> arrayList = new ArrayList<String>();
            if (this.files != null) {
                arrayList.addAll(Arrays.asList(this.files));
            }
            if (this.isDebugEnabled()) {
                this.debug("DynamicUpdateOperation.initDataUpdate: delta-files : " + arrayList);
            }
            if (bl = this.deploymentData.isPlanUpdate()) {
                if (!(this.getApplication() instanceof AppDeployment)) {
                    throw new DeploymentException("PlanUpdate cannot be applied for SystemResources");
                }
                AppDeployment appDeployment = (AppDeployment)this.getApplication();
                appDeployment.updateDescriptorsPathInfo();
                String string = appDeployment.getRelativePlanPath();
                if (string == null || string.length() == 0) {
                    throw new DeploymentException("Application " + appDeployment.getName() + " does not contain plan path to update");
                }
                if (this.isDebugEnabled()) {
                    this.debug("DynamicUpdateOperation: deltaFiles is : " + arrayList + " : " + arrayList.getClass().getName());
                }
                arrayList.add(string);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            final boolean bl2 = this.deploymentData != null && this.deploymentData.getDelete();
            this.getApplication().initDataUpdate(new DataUpdateRequestInfo(){

                public List getDeltaFiles() {
                    return arrayList;
                }

                public long getRequestId() {
                    return DynamicUpdateOperation.this.requestId;
                }

                public boolean isStatic() {
                    return false;
                }

                public boolean isDelete() {
                    return bl2;
                }

                public boolean isPlanUpdate() {
                    return bl;
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new DeploymentException("Error occured while initiating data update", iOException);
        }
    }

    protected void ensureAppContainerSet() throws DeploymentException {
        super.ensureAppContainerSet();
        if (this.appcontainer == null) {
            Loggable loggable = DeployerRuntimeLogger.logNullAppLoggable((String)this.mbean.getName(), (String)DeployerRuntimeTextTextFormatter.getInstance().messageRedeploy());
            loggable.log();
            DeploymentException deploymentException = new DeploymentException(loggable.getMessage());
            this.complete(2, (Exception)((Object)deploymentException));
            throw deploymentException;
        }
    }
}

