/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import weblogic.deploy.container.NonFatalDeploymentException;
import weblogic.deploy.internal.InternalDeploymentData;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.datamanagement.ModuleRedeployDataUpdateRequestInfo;
import weblogic.deploy.internal.targetserver.operations.ActivateOperation;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.internal.MBeanConverter;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;

public class ModuleRedeployOperation
extends ActivateOperation {
    private final String[] moduleIds;

    public ModuleRedeployOperation(long l, String string, InternalDeploymentData internalDeploymentData, BasicDeploymentMBean basicDeploymentMBean, DomainMBean domainMBean, String[] stringArray, AuthenticatedSubject authenticatedSubject, boolean bl) throws DeploymentException {
        super(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
        this.moduleIds = stringArray;
        this.appcontainer = this.getApplication().findDeployment();
        this.operation = 9;
    }

    protected void compatibilityProcessor() throws DeploymentException {
        MBeanConverter.reconcile81MBeans(this.deploymentData, (AppDeploymentMBean)this.mbean);
    }

    protected void doPrepare() throws DeploymentException {
        if (this.isDebugEnabled()) {
            this.debug("ModuleRedeployOperation: prepare called.");
        }
        this.ensureAppContainerSet();
        if (this.appcontainer == null) {
            super.doPrepare();
        } else {
            if (!this.isAppContainerActive(this.appcontainer)) {
                Loggable loggable = SlaveDeployerLogger.logInvalidStateForRedeployLoggable((String)this.getApplication().getName());
                loggable.log();
                DeploymentException deploymentException = new DeploymentException(loggable.getMessage());
                this.complete(2, (Exception)((Object)deploymentException));
                throw deploymentException;
            }
            this.moduleLevelRedeploy();
        }
    }

    protected final void doCancel() {
        if (this.appcontainer != null) {
            if (this.isDebugEnabled()) {
                this.debug("ModuleRedeployOperation: Invoking undeploy on Container.");
            }
            this.silentProductionToAdmin(this.appcontainer);
            this.silentDeactivate(this.appcontainer);
            this.silentUnprepare(this.appcontainer);
            this.silentRemove(this.appcontainer);
            if (this.isDebugEnabled()) {
                this.debug("ModuleRedeployOperation: undeploy on Container finished.");
            }
        }
        this.getApplication().remove(false);
    }

    protected void doCommit() throws DeploymentException, IOException {
        this.appcontainer = this.getApplication().findDeployment();
        if (this.appcontainer != null && this.getState(this.appcontainer) == 1) {
            super.doCommit();
        } else {
            this.complete(3, null);
        }
    }

    public void initDataUpdate() throws DeploymentException {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList(this.moduleIds));
            this.getApplication().initDataUpdate(new ModuleRedeployDataUpdateRequestInfo(arrayList, this.requestId));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw DeployHelper.convertThrowable(throwable);
        }
    }

    private void moduleLevelRedeploy() throws DeploymentException {
        try {
            this.deploymentContext.setUpdatedResourceURIs(this.moduleIds);
            this.appcontainer.stop(this.deploymentContext);
            this.commitDataUpdate();
            this.setupPrepare();
            this.appcontainer.start(this.deploymentContext);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof NonFatalDeploymentException)) {
                this.silentCancelOnPrepareFailure();
            }
            DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
            this.complete(2, (Exception)((Object)deploymentException));
            throw deploymentException;
        }
    }
}

