/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.operations;

import java.security.AccessController;
import java.util.Set;
import weblogic.application.Deployment;
import weblogic.application.utils.TargetUtils;
import weblogic.deploy.internal.InternalDeploymentData;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.targetserver.AppDeployment;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.operations.AbstractOperation;
import weblogic.deploy.internal.targetserver.operations.ActivateOperation;
import weblogic.deploy.internal.targetserver.operations.DynamicUpdateOperation;
import weblogic.deploy.internal.targetserver.operations.ModuleRedeployOperation;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.MBeanConverter;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;

public class RedeployOperation
extends ActivateOperation {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final String[] moduleIds;

    public RedeployOperation(long l, String string, InternalDeploymentData internalDeploymentData, BasicDeploymentMBean basicDeploymentMBean, DomainMBean domainMBean, AuthenticatedSubject authenticatedSubject, boolean bl) throws DeploymentException {
        super(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
        this.operation = 9;
        this.appcontainer = this.getApplication().findDeployment();
        this.moduleIds = TargetHelper.getModulesForTarget(this.deploymentData, domainMBean);
    }

    public AbstractOperation refine() throws DeploymentException {
        String[] stringArray;
        boolean bl = false;
        if (this.deploymentData != null && !(bl = this.deploymentData.hasFiles())) {
            stringArray = this.deploymentData.getGlobalTargets();
            boolean bl2 = stringArray != null && stringArray.length > 0;
            boolean bl3 = bl = !bl2 && this.deploymentData.hasSubModuleTargets();
        }
        if (bl && this.moduleIds != null) {
            stringArray = SlaveDeployerLogger.logBothStaticFileRedeployAndModuleRedeployLoggable().getMessage();
            throw new DeploymentException((String)stringArray);
        }
        if (bl && this.isAppContainerActive(this.appcontainer)) {
            return new DynamicUpdateOperation(this.requestId, this.taskId, this.internalDeploymentData, this.mbean, this.proposedDomain, this.initiator, this.requiresRestart);
        }
        if (this.moduleIds != null && !bl) {
            return new ModuleRedeployOperation(this.requestId, this.taskId, this.internalDeploymentData, this.mbean, this.proposedDomain, this.moduleIds, this.initiator, this.requiresRestart);
        }
        return this;
    }

    protected void createAndPrepareContainer() throws DeploymentException {
        this.appcontainer = this.getApplication().createDeployment(this.mbean, this.getState());
        this.initializeDeploymentPlan();
        this.appcontainer.prepare(this.deploymentContext);
    }

    protected void doPrepare() throws DeploymentException {
        this.validatePrepare();
        this.ensureAppContainerSet();
        if (this.isDebugEnabled()) {
            this.debug("Preparing application " + this.getApplication().getName());
        }
        if (this.isAdminState() && !this.isAdminMode()) {
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug(" Redeploying " + this.getApplication().getName());
        }
        if (this.appcontainer != null) {
            this.unprepareDeployment(this.appcontainer);
        }
        try {
            this.commitDataUpdate();
            this.setupPrepare();
            this.createAndPrepareContainer();
            this.resetPendingRestartForSystemResource();
        }
        catch (Throwable throwable) {
            if (this.isDebugEnabled()) {
                this.debug(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            this.silentCancelOnPrepareFailure();
            DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
            this.complete(2, (Exception)((Object)deploymentException));
            throw deploymentException;
        }
    }

    protected final void doCancel() {
        if (this.appcontainer != null) {
            if (this.isDebugEnabled()) {
                this.debug("RedeployOperation: Invoking undeploy on Container.");
            }
            this.unprepareDeployment(this.appcontainer);
            this.silentRemove(this.appcontainer);
            if (this.isDebugEnabled()) {
                this.debug("RedeployOperation: undeploy on Container finished.");
            }
        }
        this.getApplication().remove(false);
    }

    protected void validatePrepare() throws DeploymentException {
        if (this.internalDeploymentData.getDeploymentOperation() == 6 && this.getState(this.appcontainer) > 2) {
            String string = SlaveDeployerLogger.logInvalidDistributeLoggable((String)this.mbean.getName()).getMessage();
            this.isFailedInPrepareValidation = true;
            throw new DeploymentException(string);
        }
    }

    private void initializeDeploymentPlan() throws DeploymentException {
        if (this.isAppDeployment() && this.mbean != null) {
            AppDeployment appDeployment = (AppDeployment)this.getApplication();
            DeploymentPlanBean deploymentPlanBean = appDeployment.parsePlan();
            ((AppDeploymentMBean)this.mbean).setDeploymentPlanDescriptor(deploymentPlanBean);
        }
    }

    protected void compatibilityProcessor() throws DeploymentException {
        MBeanConverter.reconcile81MBeans(this.deploymentData, (AppDeploymentMBean)this.mbean);
    }

    private void unprepareDeployment(Deployment deployment) {
        if (this.getState(deployment) == 3) {
            this.silentProductionToAdmin(deployment);
        }
        if (this.getState(deployment) > 1) {
            this.silentDeactivate(deployment);
        }
        if (this.getState(deployment) >= 1) {
            this.silentUnprepare(deployment);
        }
        if (!this.isHomogenousDeployment()) {
            this.relayState();
        } else {
            try {
                AppRuntimeStateManager.getManager().remove(this.mbean.getName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void recoverOnActivateFailure(Deployment deployment) {
        this.silentUnprepare(deployment);
    }

    private void relayState() {
        String string;
        TargetMBean targetMBean = TargetUtils.findLocalTarget(this.mbean, server);
        if (this.getState().getTarget() == null) {
            this.getState().setTarget(targetMBean.getName());
        }
        String string2 = string = this.deploymentData == null ? this.getState().getIntendedState() : this.deploymentData.getIntendedState();
        if (!ManagementService.getRuntimeAccess(kernelId).isAdminServer() && !this.isAppDeleted()) {
            AppRuntimeStateManager.getManager().updateStateForRedeployOperationOnCluster(this.mbean.getName(), this.getState());
        }
        if (this.isDebugEnabled()) {
            this.debug("Relaying updated state for app, " + this.getState().getId() + " to " + this.getState().getCurrentState() + ", taskState: " + this.getState().getTaskState());
        }
        deploymentManager.relayStatus(this.requestId, this.getState());
    }

    private boolean isHomogenousDeployment() {
        if (!(this.mbean instanceof AppDeploymentMBean)) {
            return true;
        }
        if (cluster == null) {
            return true;
        }
        Set set = cluster.getServerNames();
        Set set2 = TargetHelper.getAllTargetedServers(this.mbean);
        return set2.containsAll(set);
    }
}

