/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.operations;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import weblogic.deploy.beans.factory.InvalidTargetException;
import weblogic.deploy.internal.InternalDeploymentData;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.targetserver.operations.DeactivateOperation;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.MBeanConverter;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;

public final class RemoveOperation
extends DeactivateOperation {
    private final String[] moduleIds;
    private String[] subModuleIds;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public RemoveOperation(long l, String string, InternalDeploymentData internalDeploymentData, BasicDeploymentMBean basicDeploymentMBean, DomainMBean domainMBean, AuthenticatedSubject authenticatedSubject, boolean bl) throws DeploymentException {
        super(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
        this.operation = 4;
        this.moduleIds = TargetHelper.getNonGlobalModules(this.deploymentData, this.getApplication(), domainMBean);
        this.subModuleIds = TargetHelper.getNonGlobalSubModules(this.deploymentData, this.getApplication());
        this.dumpModuleInfo();
        this.controlOperation = false;
    }

    private void dumpModuleInfo() {
        String string;
        int n;
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.moduleIds != null) {
            this.debug("Module Ids:");
            for (n = 0; n < this.moduleIds.length; ++n) {
                string = this.moduleIds[n];
                this.debug("  " + string);
            }
        }
        if (this.subModuleIds != null) {
            this.debug("SubModule Ids:");
            for (n = 0; n < this.subModuleIds.length; ++n) {
                string = this.subModuleIds[n];
                this.debug("  " + string);
            }
        }
    }

    protected void compatibilityProcessor() {
        MBeanConverter.remove81MBean((AppDeploymentMBean)this.mbean);
    }

    protected void doCommit() throws DeploymentException {
        boolean bl;
        boolean bl2 = true;
        if (cluster != null && !(bl = this.isFullRemoveFromCluster())) {
            bl2 = false;
            if (!this.isTargetListContainsCurrentServer()) {
                return;
            }
        }
        bl = this.isFullRemove();
        this.appcontainer = this.getApplication().findDeployment();
        if (this.isDebugEnabled()) {
            this.debug("RemoveOperation.doCommit for " + this.getApplication().getName());
        }
        if (this.appcontainer != null) {
            if (!bl) {
                this.stop(this.appcontainer, this.moduleIds);
            } else {
                this.removeDeployment();
            }
        } else if (this.isDebugEnabled()) {
            this.debug("RemoveOperation.doCommit: No app container found for " + this.getApplication().getName());
        }
        if (bl) {
            this.getApplication().remove(bl2);
            this.appcontainer = null;
        }
        this.complete(3, null);
        if (bl && !ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            try {
                AppRuntimeStateManager.getManager().remove(this.mbean.getName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean isFullRemove() {
        boolean bl = this.moduleIds == null && this.subModuleIds == null;
        boolean bl2 = bl = bl && (this.deploymentData.hasModuleTargets() || this.deploymentData.getGlobalTargets().length != 0 || !this.deploymentData.hasSubModuleTargets());
        if (this.isDebugEnabled()) {
            this.debug("isFullRemove set to : " + bl);
        }
        return bl;
    }

    protected final boolean isDeploymentRequestValidForCurrentServer() {
        Object object;
        if (this.isTargetListContainsCurrentServer()) {
            if (this.isDebugEnabled()) {
                this.debug("TargetList Contains Current Server");
            }
            return true;
        }
        String[] stringArray = this.deploymentData.getGlobalTargets();
        if (cluster != null) {
            object = cluster.getServerNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!object.contains(stringArray[i])) continue;
                return true;
            }
        }
        if (!(this.mbean instanceof AppDeploymentMBean)) {
            return false;
        }
        object = (AppDeploymentMBean)this.mbean;
        Set set = TargetHelper.getAllTargetedServers((BasicDeploymentMBean)object);
        boolean bl = false;
        if (cluster != null) {
            String string = cluster.getName();
            ServerMBean[] serverMBeanArray = cluster.getServers();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return true;
            }
            String[] stringArray2 = new String[serverMBeanArray.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = serverMBeanArray[i].getName();
            }
            List<String> list = Arrays.asList(stringArray);
            List<String> list2 = Arrays.asList(stringArray2);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (set.containsAll(list2)) {
                arrayList.addAll(list2);
            } else {
                for (Object e : set) {
                    if (!list2.contains(e)) continue;
                    arrayList.add((String)e);
                }
            }
            if (this.isDebugEnabled()) {
                this.debug("pinned servers " + arrayList);
                this.debug("listOfTargetsInRequest " + list);
                this.debug("mbean targets " + set);
            }
            return list.containsAll(arrayList);
        }
        return false;
    }

    private boolean isFullRemoveFromCluster() {
        Debug.assertion((cluster != null ? 1 : 0) != 0);
        if (!this.isFullRemove()) {
            return false;
        }
        if (this.deploymentData.isTargetsFromConfig()) {
            return true;
        }
        TargetMBean[] targetMBeanArray = this.mbean.getTargets();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            arrayList.addAll(targetMBeanArray[i].getServerNames());
        }
        String[] stringArray = this.deploymentData.getGlobalTargets();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.remove(stringArray[i]);
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        try {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(Arrays.asList(stringArray));
            Set set = this.deploymentData.getAllTargetedServers(hashSet);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.remove(iterator.next());
            }
        }
        catch (InvalidTargetException invalidTargetException) {
            // empty catch block
        }
        return arrayList.isEmpty();
    }

    private void removeDeployment() {
        try {
            this.deactivate();
        }
        catch (DeploymentException deploymentException) {
            SlaveDeployerLogger.logOperationFailed((String)"Deactivate", (String)this.getMBean().getName(), (Exception)((Object)deploymentException));
        }
        if (this.appcontainer != null) {
            if (this.getState(this.appcontainer) >= 1) {
                this.silentUnprepare(this.appcontainer);
            }
            this.silentRemove(this.appcontainer);
        }
    }
}

