/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import weblogic.application.Deployment;
import weblogic.application.internal.DeploymentStateChecker;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.container.NonFatalDeploymentException;
import weblogic.deploy.internal.InternalDeploymentData;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.operations.ActivateOperation;
import weblogic.deploy.internal.targetserver.state.TargetModuleState;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.utils.StackTraceUtils;

public class StartOperation
extends ActivateOperation {
    private String[] moduleIds = null;
    private boolean isModuleLevelStart = false;

    public StartOperation(long l, String string, InternalDeploymentData internalDeploymentData, BasicDeploymentMBean basicDeploymentMBean, DomainMBean domainMBean, AuthenticatedSubject authenticatedSubject, boolean bl) throws DeploymentException {
        super(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
        this.operation = 7;
        DeploymentOptions deploymentOptions = this.deploymentData.getDeploymentOptions();
        if (deploymentOptions == null || !deploymentOptions.isDisableModuleLevelStartStop()) {
            this.moduleIds = TargetHelper.getModulesForTarget(this.deploymentData, domainMBean);
        }
        if (!this.isDistributed()) {
            throw new DeploymentException("Application must be distributed before a start operation.");
        }
        this.controlOperation = true;
    }

    private boolean isDistributed() {
        return true;
    }

    protected void createAndPrepareContainer() throws DeploymentException {
        this.appcontainer = this.getApplication().findDeployment();
        if (this.appcontainer != null && this.moduleIds != null) {
            String[] stringArray = this.getFilteredModIds();
            this.deploymentContext.setUpdatedResourceURIs(stringArray);
            if (stringArray.length == 0) {
                return;
            }
            this.appcontainer.start(this.deploymentContext);
            this.isModuleLevelStart = true;
            return;
        }
        if (this.isAdminState() && !this.isAdminMode()) {
            return;
        }
        if (this.appcontainer != null && this.getState(this.appcontainer) >= 1) {
            return;
        }
        super.createAndPrepareContainer();
    }

    protected void doPrepare() throws DeploymentException {
        this.validatePrepare();
        if (this.isDebugEnabled()) {
            this.debug("Preparing application " + this.getApplication().getName());
        }
        try {
            this.setupPrepare();
            this.createAndPrepareContainer();
        }
        catch (Throwable throwable) {
            if (this.isDebugEnabled()) {
                this.debug("Preparing application " + this.getApplication().getName() + " Failed and Exception is : " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            if (!(throwable instanceof NonFatalDeploymentException)) {
                this.silentCancelOnPrepareFailure();
            }
            DeploymentException deploymentException = DeployHelper.convertThrowable(throwable);
            this.complete(2, (Exception)((Object)deploymentException));
            throw deploymentException;
        }
    }

    protected void validatePrepare() throws DeploymentException {
        int n;
        this.appcontainer = this.getApplication().findDeployment();
        if (this.appcontainer != null && ((n = this.getState(this.appcontainer)) == 4 || n == 3 && this.isAdminMode())) {
            String string = DeployerRuntimeLogger.illegalStateForStart((String)DeploymentStateChecker.state2String(n));
            this.isFailedInPrepareValidation = true;
            throw new DeploymentException(string);
        }
    }

    protected void doCommit() throws IOException, DeploymentException {
        Deployment deployment = this.getApplication().findDeployment();
        if (this.isModuleLevelStart || this.getState(deployment) == 3) {
            this.complete(3, null);
        } else {
            super.doCommit();
        }
    }

    protected final void doCancel() {
        if (this.appcontainer != null) {
            if (this.isDebugEnabled()) {
                this.debug("StartOperation: Invoking undeploy on Container.");
            }
            if (this.getState(this.appcontainer) == 3) {
                this.silentProductionToAdmin(this.appcontainer);
            }
            if (this.getState(this.appcontainer) > 1) {
                this.silentDeactivate(this.appcontainer);
            }
            if (this.getState(this.appcontainer) >= 1) {
                this.silentUnprepare(this.appcontainer);
            }
            this.silentRemove(this.appcontainer);
            if (this.isDebugEnabled()) {
                this.debug("StartOperation: undeploy on Container finished.");
            }
        }
        this.getApplication().remove(false);
    }

    protected final boolean isDeploymentRequestValidForCurrentServer() {
        return this.isTargetListContainsCurrentServer();
    }

    private String[] getFilteredModIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map = this.app.getAppRuntimeState().getModules();
        Map map2 = this.deploymentData.getAllModuleTargets();
        block0: for (int i = 0; i < this.moduleIds.length; ++i) {
            if (map.get(this.moduleIds[i]) == null || map2.get(this.moduleIds[i]) == null) continue;
            Map map3 = (Map)map.get(this.moduleIds[i]);
            String[] stringArray = (String[])map2.get(this.moduleIds[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                Object v;
                Map map4 = null;
                if (map3.get(stringArray[j]) == null || (v = (map4 = (Map)map3.get(stringArray[j])).get(serverName)) == null) continue;
                TargetModuleState targetModuleState = null;
                if (v instanceof TargetModuleState) {
                    targetModuleState = (TargetModuleState)v;
                } else if (v instanceof Map) {
                    targetModuleState = (TargetModuleState)((Map)v).get(serverName);
                }
                if (this.isDebugEnabled() && targetModuleState != null) {
                    this.debug("Module: " + this.moduleIds[i] + " state is " + targetModuleState.getCurrentState());
                }
                if (!"STATE_NEW".equals(targetModuleState.getCurrentState())) continue;
                arrayList.add(this.moduleIds[i]);
                continue block0;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public void initDataUpdate() throws DeploymentException {
    }
}

