/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.operations;

import weblogic.deploy.internal.InternalDeploymentData;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.targetserver.operations.AbstractOperation;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.DeployerRuntimeTextTextFormatter;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;

public final class UnprepareOperation
extends AbstractOperation {
    protected int cbTag;
    private final String[] moduleIds;

    public UnprepareOperation(long l, String string, InternalDeploymentData internalDeploymentData, BasicDeploymentMBean basicDeploymentMBean, DomainMBean domainMBean, AuthenticatedSubject authenticatedSubject, boolean bl) throws DeploymentException {
        super(l, string, internalDeploymentData, basicDeploymentMBean, domainMBean, authenticatedSubject, bl);
        this.operation = 5;
        this.moduleIds = TargetHelper.getModulesForTarget(this.deploymentData, domainMBean);
        this.controlOperation = true;
    }

    protected void doPrepare() throws DeploymentException {
        this.ensureAppContainerSet();
    }

    protected void doCommit() throws DeploymentException {
        if (this.appcontainer != null) {
            if (this.getState(this.appcontainer) >= 1) {
                if (this.moduleIds != null) {
                    this.stop(this.appcontainer, this.moduleIds);
                } else {
                    if (this.getState(this.appcontainer) == 3) {
                        if (this.isGracefulProductionToAdmin()) {
                            this.gracefulProductionToAdmin(this.appcontainer);
                        } else {
                            this.forceProductionToAdmin(this.appcontainer);
                        }
                    }
                    if (!this.isAdminMode()) {
                        if (this.isAdminState(this.appcontainer)) {
                            this.silentDeactivate(this.appcontainer);
                        }
                        this.silentUnprepare(this.appcontainer);
                    }
                }
            }
        } else {
            SlaveDeployerLogger.logNoDeployment((String)DeployerRuntimeTextTextFormatter.getInstance().messageStop(), (String)this.mbean.getName());
        }
        this.complete(3, null);
    }
}

