/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.state;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import weblogic.application.ModuleListenerCtx;
import weblogic.application.SubModuleListenerCtx;
import weblogic.application.utils.TargetUtils;
import weblogic.deploy.compatibility.NotificationBroadcaster;
import weblogic.deploy.internal.targetserver.state.AppTransition;
import weblogic.deploy.internal.targetserver.state.ModuleTransition;
import weblogic.deploy.internal.targetserver.state.TargetModuleState;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class DeploymentState
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Map tms = new HashMap();
    private String appId;
    private String taskID;
    private int notifLevel;
    private String state;
    private int taskState;
    private Exception exception;
    private String target;
    private String intendedState;
    private int stagingState = -1;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private transient ArrayList xitions = new ArrayList();
    private String serverName = ManagementService.getRuntimeAccess(kernelId).getServerName();

    public DeploymentState() {
    }

    public DeploymentState(String string, String string2, int n) {
        this.appId = string;
        this.taskID = string2;
        this.notifLevel = n;
    }

    public String toString() {
        return super.toString() + "[" + "appid=" + this.appId + ",taskid=" + this.taskID + ",state=" + this.state + "]";
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getId() {
        return this.appId;
    }

    public String getCurrentState() {
        return this.state;
    }

    public void setCurrentState(String string) {
        this.state = string;
    }

    public void setCurrentState(String string, boolean bl) {
        this.setCurrentState(string);
        if (bl) {
            TargetModuleState[] targetModuleStateArray = this.getTargetModules();
            for (int i = 0; i < targetModuleStateArray.length; ++i) {
                targetModuleStateArray[i].setCurrentState(string);
            }
        }
    }

    public String getIntendedState() {
        return this.intendedState;
    }

    public void setIntendedState(String string) {
        this.intendedState = string;
    }

    public int getStagingState() {
        return this.stagingState;
    }

    public void setStagingState(int n) {
        this.stagingState = n;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    private void setTarget(ModuleListenerCtx moduleListenerCtx) {
        if (moduleListenerCtx instanceof SubModuleListenerCtx) {
            TargetMBean targetMBean = TargetUtils.findLocalServerTarget(((SubModuleListenerCtx)((Object)moduleListenerCtx)).getSubModuleTargets());
            if (targetMBean != null) {
                this.setTarget(targetMBean.getName());
            }
        } else {
            this.setTarget(moduleListenerCtx.getTarget().getName());
        }
    }

    public void addAppXition(String string) {
        if (this.notifLevel >= 1) {
            this.xitions.add(new AppTransition(string, new Date().getTime(), this.serverName));
        }
    }

    public Object[] getTransitions() {
        return this.xitions.toArray(new Object[this.xitions.size()]);
    }

    public TargetModuleState[] getTargetModules() {
        Collection collection = this.tms.values();
        TargetModuleState[] targetModuleStateArray = new TargetModuleState[collection.size()];
        return collection.toArray(targetModuleStateArray);
    }

    TargetModuleState addModuleTransition(ModuleListenerCtx moduleListenerCtx, String string, String string2, String string3, long l) {
        TargetModuleState targetModuleState = this.getOrCreateTargetModuleState(moduleListenerCtx);
        if (targetModuleState == null) {
            return null;
        }
        if (this.notifLevel >= 2 && NotificationBroadcaster.isRelevantToWLS81(string, string2)) {
            this.xitions.add(new ModuleTransition(string, string2, string3, l, targetModuleState));
        }
        if (this.getTarget() == null) {
            this.setTarget(moduleListenerCtx);
        }
        this.setIntendedState(string2);
        return targetModuleState;
    }

    TargetModuleState getOrCreateTargetModuleState(ModuleListenerCtx moduleListenerCtx) {
        if (moduleListenerCtx instanceof SubModuleListenerCtx) {
            return this.getOrCreateSubmoduleTargetState(moduleListenerCtx);
        }
        TargetModuleState targetModuleState = (TargetModuleState)this.tms.get(moduleListenerCtx.getModuleUri());
        if (null == targetModuleState) {
            TargetMBean targetMBean = moduleListenerCtx.getTarget();
            if (targetMBean == null) {
                return null;
            }
            targetModuleState = new TargetModuleState(moduleListenerCtx.getModuleUri(), moduleListenerCtx.getType(), targetMBean.getName(), targetMBean.getType(), this.serverName);
            this.tms.put(moduleListenerCtx.getModuleUri(), targetModuleState);
        }
        return targetModuleState;
    }

    private TargetModuleState getOrCreateSubmoduleTargetState(ModuleListenerCtx moduleListenerCtx) {
        SubModuleListenerCtx subModuleListenerCtx = (SubModuleListenerCtx)((Object)moduleListenerCtx);
        TargetMBean targetMBean = TargetUtils.findLocalServerTarget(subModuleListenerCtx.getSubModuleTargets());
        if (targetMBean == null) {
            return null;
        }
        TargetModuleState targetModuleState = new TargetModuleState(moduleListenerCtx.getModuleUri(), subModuleListenerCtx.getSubModuleName(), moduleListenerCtx.getType(), targetMBean.getName(), targetMBean.getType(), this.serverName);
        TargetModuleState targetModuleState2 = (TargetModuleState)this.tms.get(targetModuleState.getModuleId());
        if (targetModuleState2 == null) {
            this.tms.put(targetModuleState.getModuleId(), targetModuleState);
            targetModuleState2 = targetModuleState;
        }
        return targetModuleState2;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public int getTaskState() {
        return this.taskState;
    }

    public void setTaskState(int n) {
        this.taskState = n;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.tms);
        objectOutput.writeObject(this.appId);
        objectOutput.writeObject(this.taskID);
        objectOutput.writeInt(this.notifLevel);
        objectOutput.writeObject(this.state);
        objectOutput.writeInt(this.taskState);
        objectOutput.writeObject(this.exception);
        objectOutput.writeObject(this.target);
        objectOutput.writeObject(this.intendedState);
        objectOutput.writeInt(this.stagingState);
        objectOutput.writeObject(this.serverName);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Map map = (Map)objectInput.readObject();
        if (map != null) {
            this.tms.putAll(map);
        }
        this.appId = (String)objectInput.readObject();
        this.taskID = (String)objectInput.readObject();
        this.notifLevel = objectInput.readInt();
        this.state = (String)objectInput.readObject();
        this.taskState = objectInput.readInt();
        this.exception = (Exception)objectInput.readObject();
        this.target = (String)objectInput.readObject();
        this.intendedState = (String)objectInput.readObject();
        this.stagingState = objectInput.readInt();
        try {
            this.serverName = (String)objectInput.readObject();
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
    }
}

