/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.state;

import java.security.AccessController;
import java.util.Date;
import weblogic.application.ModuleListener;
import weblogic.application.ModuleListenerCtx;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.common.Debug;
import weblogic.deploy.compatibility.NotificationBroadcaster;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.deploy.internal.targetserver.state.TargetModuleState;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ModuleTransitionTracker
implements ModuleListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String serverName = ManagementService.getRuntimeAccess(kernelId).getServer().getName();
    private final AppDeploymentMBean mbean;
    private final String taskID;
    private final DeploymentState state;

    ModuleTransitionTracker(AppDeploymentMBean appDeploymentMBean, String string, DeploymentState deploymentState) {
        this.mbean = appDeploymentMBean;
        this.state = deploymentState;
        if (appDeploymentMBean.getAppMBean() == null && this.isDebugEnabled()) {
            this.debug("Listener: appmbean is NULL for:" + this);
        }
        this.taskID = string;
    }

    public void beginTransition(ModuleListenerCtx moduleListenerCtx, ModuleListener.State state, ModuleListener.State state2) {
        RuntimeAccess runtimeAccess;
        ApplicationMBean applicationMBean;
        if (!moduleListenerCtx.getApplicationId().equals(this.mbean.getApplicationIdentifier())) {
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug("Listener: begin " + moduleListenerCtx + " " + state + ">" + state2);
        }
        long l = new Date().getTime();
        TargetModuleState targetModuleState = this.state.addModuleTransition(moduleListenerCtx, ((Object)state).toString(), ((Object)state2).toString(), "begin", l);
        if (targetModuleState != null) {
            targetModuleState.setCurrentState(((Object)state).toString());
        }
        if ((applicationMBean = (runtimeAccess = ManagementService.getRuntimeAccess(kernelId)).getDomain().lookupApplication(this.mbean.getApplicationIdentifier())) != null && NotificationBroadcaster.isRelevantToWLS81(((Object)state).toString(), ((Object)state2).toString())) {
            applicationMBean.sendModuleNotification(serverName, moduleListenerCtx.getModuleUri(), "begin", ((Object)state).toString(), ((Object)state2).toString(), this.taskID, l);
        }
        DeployerRuntimeLogger.logStartTransition((String)this.getAppDisplayName(), (String)this.getModuleDisplayName(moduleListenerCtx.getModuleUri()), (String)((Object)state).toString(), (String)((Object)state2).toString(), (String)serverName);
    }

    public void endTransition(ModuleListenerCtx moduleListenerCtx, ModuleListener.State state, ModuleListener.State state2) {
        if (!moduleListenerCtx.getApplicationId().equals(this.mbean.getApplicationIdentifier())) {
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug("Listener: end " + moduleListenerCtx + " " + state + ">" + state2);
        }
        long l = new Date().getTime();
        TargetModuleState targetModuleState = this.state.addModuleTransition(moduleListenerCtx, ((Object)state).toString(), ((Object)state2).toString(), "end", l);
        if (targetModuleState != null) {
            targetModuleState.setCurrentState(((Object)state2).toString());
        } else if (this.isDebugEnabled()) {
            this.debug("Listener: module not locally targeted");
        }
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        ApplicationMBean applicationMBean = runtimeAccess.getDomain().lookupApplication(this.mbean.getApplicationIdentifier());
        if (applicationMBean != null && NotificationBroadcaster.isRelevantToWLS81(((Object)state).toString(), ((Object)state2).toString())) {
            applicationMBean.sendModuleNotification(serverName, moduleListenerCtx.getModuleUri(), "end", ((Object)state).toString(), ((Object)state2).toString(), this.taskID, l);
        }
        DeployerRuntimeLogger.logSuccessfulTransition((String)this.getAppDisplayName(), (String)this.getModuleDisplayName(moduleListenerCtx.getModuleUri()), (String)((Object)state).toString(), (String)((Object)state2).toString(), (String)serverName);
    }

    public void failedTransition(ModuleListenerCtx moduleListenerCtx, ModuleListener.State state, ModuleListener.State state2) {
        RuntimeAccess runtimeAccess;
        ApplicationMBean applicationMBean;
        if (!moduleListenerCtx.getApplicationId().equals(this.mbean.getApplicationIdentifier())) {
            return;
        }
        if (this.isDebugEnabled()) {
            this.debug("Listener: fail " + moduleListenerCtx + " " + state + ">" + state2);
        }
        long l = new Date().getTime();
        TargetModuleState targetModuleState = this.state.addModuleTransition(moduleListenerCtx, ((Object)state).toString(), ((Object)state2).toString(), "failed", l);
        if (targetModuleState != null) {
            targetModuleState.setCurrentState(((Object)state2).toString());
        }
        if ((applicationMBean = (runtimeAccess = ManagementService.getRuntimeAccess(kernelId)).getDomain().lookupApplication(this.mbean.getApplicationIdentifier())) != null && NotificationBroadcaster.isRelevantToWLS81(((Object)state).toString(), ((Object)state2).toString())) {
            applicationMBean.sendModuleNotification(serverName, moduleListenerCtx.getModuleUri(), "failed", ((Object)state).toString(), ((Object)state2).toString(), this.taskID, l);
        }
        DeployerRuntimeLogger.logFailedTransition((String)this.getAppDisplayName(), (String)this.getModuleDisplayName(moduleListenerCtx.getModuleUri()), (String)((Object)state).toString(), (String)((Object)state2).toString(), (String)serverName);
    }

    private String getAppDisplayName() {
        return ApplicationVersionUtils.getDisplayName(this.mbean.getName());
    }

    private String getModuleDisplayName(String string) {
        return ApplicationVersionUtils.getApplicationName(string);
    }

    public String toString() {
        return new StringBuffer("ModuleListener[appName= ").append(this.mbean.getName()).append("]").toString();
    }

    private void debug(String string) {
        Debug.deploymentDebug(string);
    }

    private boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }
}

