/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.internal.targetserver.state;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class TargetModuleState
implements Externalizable {
    private static final long serialVersionUID = 6815593282455552332L;
    private String moduleId;
    private String targetName;
    private String targetType;
    private String serverName;
    private String curState;
    private String type;
    private String submoduleId = null;

    public TargetModuleState() {
    }

    TargetModuleState(String string, String string2, String string3, String string4, String string5, String string6) {
        this(TargetModuleState.createName(string, string2), string3, string4, string5, string6);
        this.submoduleId = string2;
    }

    public TargetModuleState(String string, String string2, String string3, String string4, String string5) {
        this.moduleId = string;
        this.targetName = string3;
        this.targetType = string4;
        this.serverName = string5;
        this.type = string2;
    }

    public static String createName(String string, String string2) {
        return string2 + "[" + string + "]";
    }

    public static String extractModule(String string) {
        int n = string.indexOf("[");
        if (n == -1) {
            return string;
        }
        return string.substring(n, string.indexOf("]"));
    }

    public static String extractSubmodule(String string) {
        int n = string.indexOf("[");
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public String getCurrentState() {
        return this.curState;
    }

    public void setCurrentState(String string) {
        this.curState = string;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getType() {
        return this.type;
    }

    public String getSubmoduleId() {
        return this.submoduleId;
    }

    public boolean isSubmodule() {
        return this.getSubmoduleId() != null;
    }

    public String getParentModuleId() {
        if (!this.isSubmodule()) {
            return null;
        }
        return TargetModuleState.extractModule(this.getModuleId());
    }

    public boolean isLogicalTarget() {
        return !this.serverName.equals(this.targetName);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TargetModuleState[").append("ModuleId=").append(this.moduleId).append(",TargetName=").append(this.targetName).append("/").append(this.targetType);
        if (this.isLogicalTarget()) {
            stringBuffer.append("[").append(this.serverName).append("]");
        }
        stringBuffer.append(",State=").append(this.curState);
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.moduleId);
        objectOutput.writeObject(this.targetName);
        objectOutput.writeObject(this.targetType);
        objectOutput.writeObject(this.serverName);
        objectOutput.writeObject(this.curState);
        objectOutput.writeObject(this.type);
        objectOutput.writeObject(this.submoduleId);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.moduleId = (String)objectInput.readObject();
        this.targetName = (String)objectInput.readObject();
        this.targetType = (String)objectInput.readObject();
        this.serverName = (String)objectInput.readObject();
        this.curState = (String)objectInput.readObject();
        this.type = (String)objectInput.readObject();
        this.submoduleId = (String)objectInput.readObject();
    }
}

