/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.datatransferhandlers;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.List;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.targetserver.datamanagement.ModuleRedeployDataTransferRequestImpl;
import weblogic.deploy.service.AppDataTransferRequest;
import weblogic.deploy.service.ConfigDataTransferRequest;
import weblogic.deploy.service.DataTransferHandler;
import weblogic.deploy.service.DataTransferRequest;
import weblogic.deploy.service.MultiDataStream;
import weblogic.deploy.service.datatransferhandlers.DataStreamFactory;
import weblogic.deploy.service.datatransferhandlers.HttpDataTransferHandler;
import weblogic.deploy.service.datatransferhandlers.SourceCache;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.management.DomainDir;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class DataHandlerManager {
    public static final String HTTP_FILE_BASED_HANDLER = "HTTP";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private DataTransferHandler handler = null;

    public static DataHandlerManager getInstance() {
        return Maker.singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTransferHandler getHttpDataTransferHandler() {
        DataHandlerManager dataHandlerManager = this;
        synchronized (dataHandlerManager) {
            if (this.handler == null) {
                this.handler = ManagementService.getPropertyService(kernelId).isAdminServer() ? new LocalDataTransferHandler(HTTP_FILE_BASED_HANDLER) : new RemoteDataTransferHandler(HTTP_FILE_BASED_HANDLER);
            }
        }
        return this.handler;
    }

    public static DataTransferHandler getHandler(String string) throws IOException {
        DataTransferHandler dataTransferHandler;
        if (string == null) {
            string = HTTP_FILE_BASED_HANDLER;
        }
        if ((dataTransferHandler = DeploymentService.getDeploymentService().getDataTransferHandler(string)) == null) {
            throw new IOException(DeploymentServiceLogger.logNoDataHandlerRegisteredLoggable((String)string).getMessage());
        }
        return dataTransferHandler;
    }

    protected static void validateRequestType(DataTransferRequest dataTransferRequest) throws IOException {
        if (!(dataTransferRequest instanceof AppDataTransferRequest) && !(dataTransferRequest instanceof ConfigDataTransferRequest)) {
            throw new IOException("Invalid request type : " + dataTransferRequest.getClass().getName());
        }
    }

    private static MultiDataStream createDeploymentStream(BasicDeploymentMBean basicDeploymentMBean, AppDataTransferRequest appDataTransferRequest) throws IOException {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (!runtimeAccess.isAdminServer()) {
            throw new AssertionError((Object)"Cannot be invoked on managed server.");
        }
        if (appDataTransferRequest instanceof ModuleRedeployDataTransferRequestImpl) {
            List list = appDataTransferRequest.getFilePaths();
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("createMultiStream for " + basicDeploymentMBean.getName() + " moduleIds= " + list);
            }
            if (!(basicDeploymentMBean instanceof AppDeploymentMBean)) {
                throw new AssertionError((Object)"ModuleRedeploy cannot be applied for SystemResources");
            }
            return SourceCache.getSourceCache(basicDeploymentMBean).getAppDataLocationsForModuleIds(list, (AppDeploymentMBean)basicDeploymentMBean);
        }
        List list = appDataTransferRequest.getFilePaths();
        boolean bl = appDataTransferRequest.isPlanUpdate();
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("createMultiStream for " + basicDeploymentMBean.getName() + " urisOrFiles= " + list + ", isPlanUpdate=" + bl);
        }
        return SourceCache.getSourceCache(basicDeploymentMBean).getDataLocations(list, bl, basicDeploymentMBean);
    }

    private static MultiDataStream createConfigDataStream(ConfigDataTransferRequest configDataTransferRequest) throws IOException {
        List list = configDataTransferRequest.getFilePaths();
        if (list == null || list.isEmpty()) {
            throw new IOException("Got request with empty file paths");
        }
        File file = new File(DomainDir.getRootDir());
        MultiDataStream multiDataStream = DataStreamFactory.createMultiDataStream();
        for (String string : list) {
            File file2 = new File(file, string);
            multiDataStream.addFileDataStream(string, file2, false);
        }
        return multiDataStream;
    }

    private class RemoteDataTransferHandler
    implements DataTransferHandler {
        private DataTransferHandler delegate;

        private RemoteDataTransferHandler(String string) {
            if (!DataHandlerManager.HTTP_FILE_BASED_HANDLER.equals(string)) {
                throw new IllegalArgumentException("Unsupported handler type " + string);
            }
            this.delegate = new HttpDataTransferHandler();
        }

        public final String getType() {
            return this.delegate.getType();
        }

        public MultiDataStream getDataAsStream(DataTransferRequest dataTransferRequest) throws IOException {
            return this.delegate.getDataAsStream(dataTransferRequest);
        }
    }

    private class LocalDataTransferHandler
    extends RemoteDataTransferHandler {
        private LocalDataTransferHandler(String string) {
            super(string);
        }

        public MultiDataStream getDataAsStream(DataTransferRequest dataTransferRequest) throws IOException {
            DataHandlerManager.validateRequestType(dataTransferRequest);
            if (dataTransferRequest instanceof AppDataTransferRequest) {
                BasicDeploymentMBean basicDeploymentMBean;
                AppDataTransferRequest appDataTransferRequest = (AppDataTransferRequest)dataTransferRequest;
                String string = ApplicationVersionUtils.getApplicationId(appDataTransferRequest.getAppName(), appDataTransferRequest.getAppVersionIdentifier());
                long l = appDataTransferRequest.getRequestId();
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug(" LocalHandler.getDataAsStream() : handling application data request for application : " + appDataTransferRequest.getAppName() + " : request id : " + l);
                }
                if ((basicDeploymentMBean = AppDeploymentHelper.lookupBasicDeployment(string, l)) == null) {
                    throw new AssertionError((Object)("Could not find DeploymentMBean for '" + string + "' for deployment request '" + l + "'"));
                }
                return DataHandlerManager.createDeploymentStream(basicDeploymentMBean, appDataTransferRequest);
            }
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug(" LocalHandler.getDataAsStream() : handling config data request : " + dataTransferRequest.getFilePaths() + " : request id : " + dataTransferRequest.getRequestId());
            }
            return DataHandlerManager.createConfigDataStream((ConfigDataTransferRequest)dataTransferRequest);
        }
    }

    static class Maker {
        private static final DataHandlerManager singleton = new DataHandlerManager();

        Maker() {
        }
    }
}

