/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.datatransferhandlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import weblogic.deploy.service.DataStream;
import weblogic.deploy.service.FileDataStream;
import weblogic.deploy.service.MultiDataStream;
import weblogic.deploy.service.datatransferhandlers.MultiDataStreamImpl;

class DataStreamFactory {
    public static final int UNKNOWN_LENGTH = -1;
    public static final String UNKNOWN_LOCATION = "unknwown";

    DataStreamFactory() {
    }

    static DataStream createDataStream(final String string, final InputStream inputStream, final boolean bl) {
        return new DataStream(){

            public InputStream getInputStream() throws IOException {
                return inputStream;
            }

            public void close() {
            }

            public String getName() {
                return string;
            }

            public boolean isZip() {
                return bl;
            }
        };
    }

    static FileDataStream createFileDataStream(String string, boolean bl) {
        return DataStreamFactory.createFileDataStream(null, string, bl);
    }

    static FileDataStream createFileDataStream(String string, String string2, boolean bl) {
        return DataStreamFactory.createFileDataStream(string, new File(string2), bl);
    }

    static FileDataStream createFileDataStream(File file, boolean bl) {
        return DataStreamFactory.createFileDataStream(null, file, bl);
    }

    static FileDataStream createFileDataStream(final String string, final File file, final boolean bl) {
        return new FileDataStream(){

            public String getName() {
                return string == null ? file.getName() : string;
            }

            public File getFile() {
                return file;
            }

            public int getLength() throws IOException {
                this.validateFile();
                return (int)file.length();
            }

            public boolean isZip() {
                return bl;
            }

            public InputStream getInputStream() throws IOException {
                this.validateFile();
                return new FileInputStream(file);
            }

            public void close() {
            }

            private void validateFile() throws IOException {
                if (!file.exists()) {
                    throw new IOException("File '" + file.getAbsolutePath() + "' does not exist");
                }
            }
        };
    }

    static MultiDataStream createMultiDataStream() {
        return new MultiDataStreamImpl();
    }
}

