/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.datatransferhandlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.mail.internet.MimeUtility;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.DataTransferHandler;
import weblogic.deploy.service.DataTransferRequest;
import weblogic.deploy.service.MultiDataStream;
import weblogic.deploy.service.datatransferhandlers.DataHandlerManager;
import weblogic.deploy.service.datatransferhandlers.MultipartParser;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.transport.http.DeploymentServiceServlet;
import weblogic.deploy.utils.DeploymentServletConstants;
import weblogic.logging.Loggable;
import weblogic.management.provider.ManagementService;
import weblogic.management.servlet.ConnectionSigner;
import weblogic.protocol.URLManager;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public class HttpDataTransferHandler
implements DataTransferHandler,
DeploymentServletConstants {
    private static final AuthenticatedSubject KERNE_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private boolean gotSecret = false;
    private String userName;
    private String password;

    protected HttpDataTransferHandler() {
    }

    public final String getType() {
        return "HTTP";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MultiDataStream getDataAsStream(DataTransferRequest dataTransferRequest) throws IOException {
        MultiDataStream multiDataStream;
        DataHandlerManager.validateRequestType(dataTransferRequest);
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                httpURLConnection = this.createURLConnection();
                httpURLConnection.setRequestProperty("deployment_request_id", Long.toString(dataTransferRequest.getRequestId()));
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                WLObjectOutputStream wLObjectOutputStream = new WLObjectOutputStream((OutputStream)unsyncByteArrayOutputStream);
                wLObjectOutputStream.setReplacer(RemoteObjectReplacer.getReplacer());
                wLObjectOutputStream.writeObject(dataTransferRequest);
                wLObjectOutputStream.flush();
                httpURLConnection.setRequestProperty("Content-Length", "" + unsyncByteArrayOutputStream.size());
                httpURLConnection.connect();
                OutputStream outputStream = httpURLConnection.getOutputStream();
                unsyncByteArrayOutputStream.writeTo(outputStream);
                outputStream.flush();
                int n = httpURLConnection.getResponseCode();
                String string = httpURLConnection.getContentType();
                if (n != 200 || string == null) {
                    Loggable loggable = DeploymentServiceLogger.logExceptionWhileGettingDataAsStreamLoggable((long)dataTransferRequest.getRequestId(), (String)httpURLConnection.getHeaderField("ErrorMsg"));
                    throw new IOException(loggable.getMessage());
                }
                MultipartParser multipartParser = new MultipartParser(httpURLConnection, null);
                multiDataStream = multipartParser.getMultiDataStream();
                Object var11_13 = null;
                if (httpURLConnection == null) return multiDataStream;
            }
            catch (IOException iOException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Error occurred while while downloading file for request '");
                stringBuffer.append(dataTransferRequest);
                stringBuffer.append("'. ");
                stringBuffer.append("Underlying error is: ");
                stringBuffer.append(iOException.toString());
                if (!Debug.isServiceTransportDebugEnabled()) throw iOException;
                Debug.serviceHttpDebug(stringBuffer.toString());
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (httpURLConnection == null) throw throwable;
            try {
                httpURLConnection.disconnect();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return multiDataStream;
        }
        httpURLConnection.disconnect();
        return multiDataStream;
    }

    private HttpURLConnection createURLConnection() throws IOException {
        URL uRL = DeploymentServiceServlet.getURL();
        HttpURLConnection httpURLConnection = URLManager.createAdminHttpConnection(uRL);
        httpURLConnection.setRequestProperty("wl_request_type", HttpDataTransferHandler.mimeEncode("data_transfer_request"));
        if (ManagementService.isRuntimeAccessInitialized()) {
            ConnectionSigner.signConnection(httpURLConnection, KERNE_ID);
        } else {
            httpURLConnection.setRequestProperty("username", HttpDataTransferHandler.mimeEncode(this.getUserName()));
            httpURLConnection.setRequestProperty("password", HttpDataTransferHandler.mimeEncode(this.getUserCredential()));
        }
        httpURLConnection.setRequestProperty("serverName", HttpDataTransferHandler.mimeEncode(ManagementService.getPropertyService(KERNE_ID).getServerName()));
        httpURLConnection.setRequestProperty("server_version", PeerInfo.getPeerInfo().getVersionAsString());
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoOutput(true);
        return httpURLConnection;
    }

    private String getUserName() {
        this.initSecret();
        return this.userName;
    }

    private String getUserCredential() {
        this.initSecret();
        return this.password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSecret() {
        if (!this.gotSecret) {
            HttpDataTransferHandler httpDataTransferHandler = this;
            synchronized (httpDataTransferHandler) {
                if (this.gotSecret) {
                    return;
                }
                PrivilegedAction privilegedAction = new PrivilegedAction(){

                    public Object run() {
                        HttpDataTransferHandler.this.userName = ManagementService.getPropertyService(KERNE_ID).getTimestamp1();
                        HttpDataTransferHandler.this.password = ManagementService.getPropertyService(KERNE_ID).getTimestamp2();
                        return null;
                    }
                };
                SecurityServiceManager.runAs((AuthenticatedSubject)KERNE_ID, (AuthenticatedSubject)KERNE_ID, (PrivilegedAction)privilegedAction);
            }
            this.gotSecret = true;
        }
    }

    private static String mimeEncode(String string) {
        String string2 = null;
        try {
            string2 = MimeUtility.encodeText((String)string, (String)"UTF-8", null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }
}

