/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.datatransferhandlers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.deploy.service.DataStream;
import weblogic.deploy.service.MultiDataStream;
import weblogic.deploy.service.datatransferhandlers.DataStreamFactory;

final class MultiDataStreamImpl
implements MultiDataStream {
    private List dataStreams = new ArrayList();

    MultiDataStreamImpl() {
    }

    public int getSize() {
        return this.dataStreams.size();
    }

    public Iterator getDataStreams() {
        return this.dataStreams.iterator();
    }

    public Iterator getInputStreams() throws IOException {
        ArrayList<InputStream> arrayList = new ArrayList<InputStream>();
        Iterator iterator = this.getDataStreams();
        while (iterator.hasNext()) {
            arrayList.add(((DataStream)iterator.next()).getInputStream());
        }
        return arrayList.iterator();
    }

    public void close() {
        Iterator iterator = this.getDataStreams();
        while (iterator.hasNext()) {
            DataStream dataStream = (DataStream)iterator.next();
            dataStream.close();
        }
    }

    void addDataStream(String string, InputStream inputStream, boolean bl) {
        this.dataStreams.add(DataStreamFactory.createDataStream(string, inputStream, bl));
    }

    void addFileDataStream(String string, String string2, boolean bl) {
        this.addFileDataStream(string, new File(string2), bl);
    }

    void addFileDataStream(File file, boolean bl) {
        this.addFileDataStream(null, file, bl);
    }

    public void addFileDataStream(String string, boolean bl) {
        this.addFileDataStream(new File(string), bl);
    }

    public void addFileDataStream(String string, File file, boolean bl) {
        this.dataStreams.add(DataStreamFactory.createFileDataStream(string, file, bl));
    }

    public void addDataStream(DataStream dataStream) {
        this.dataStreams.add(dataStream);
    }

    public void removeDataStream(DataStream dataStream) {
        this.dataStreams.remove(dataStream);
    }
}

