/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.datatransferhandlers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.FileDataStream;
import weblogic.deploy.service.MultiDataStream;
import weblogic.utils.StringUtils;

public class MultipartHelper {
    public static final String FILES_HEADER_NAME = "files_header";
    public static final String NO_FILES = "total_files";
    public static final String FILE_NAME = "name";
    public static final String FILE_TYPE = "type";
    public static final String FILE_LENGTH = "length";
    public static final String DELIMITER = ";";
    public static final String DELIMITER1 = "=";
    public static final String EMPTY_RELATIVE_LOCATION = "NOT_SET";

    public static FileInfo[] parseFilesHeader(String string) {
        if (string == null) {
            throw new IllegalArgumentException("FilesHeader has invalid value");
        }
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)DELIMITER);
        if (MultipartHelper.isDebugEnabled()) {
            for (int i = 0; i < stringArray.length; ++i) {
                MultipartHelper.debugSay("splits[" + i + "] : " + stringArray[i]);
            }
        }
        FileInfo[] fileInfoArray = MultipartHelper.constructFileInfos(stringArray);
        if (MultipartHelper.isDebugEnabled()) {
            for (int i = 0; i < fileInfoArray.length; ++i) {
                MultipartHelper.debugSay("FileInfo[" + i + "] = " + fileInfoArray[i]);
            }
        }
        return fileInfoArray;
    }

    private static int getNoOfFiles(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(NO_FILES)) continue;
            String[] stringArray2 = StringUtils.splitCompletely((String)stringArray[i], (String)DELIMITER1);
            if (stringArray2.length != 2) {
                throw new IllegalArgumentException("Invalid number of files value");
            }
            return Integer.valueOf(stringArray2[1]);
        }
        throw new IllegalArgumentException("No numger of files sub header");
    }

    private static FileInfo[] constructFileInfos(String[] stringArray) {
        int n = MultipartHelper.getNoOfFiles(stringArray);
        FileInfo[] fileInfoArray = new FileInfo[n];
        int n2 = 0;
        FileInfo fileInfo = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(NO_FILES) != -1) continue;
            if (stringArray[i].indexOf(FILE_NAME) != -1) {
                fileInfoArray[n2] = new FileInfo();
                fileInfo = fileInfoArray[n2++];
                fileInfo.setName(MultipartHelper.getValue(stringArray[i]));
                continue;
            }
            if (stringArray[i].indexOf(FILE_TYPE) != -1) {
                fileInfo.setType(MultipartHelper.getValue(stringArray[i]));
                continue;
            }
            if (stringArray[i].indexOf(FILE_LENGTH) == -1) continue;
            long l = Long.valueOf(MultipartHelper.getValue(stringArray[i]));
            fileInfo.setSize(l);
        }
        return fileInfoArray;
    }

    private static String getValue(String string) {
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)DELIMITER1);
        if (stringArray.length < 2 || stringArray.length > 2) {
            throw new IllegalArgumentException("Invalid name value pair : " + string);
        }
        return stringArray[1];
    }

    static String constructFilesHeaderValue(List list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException(" files list is empty");
        }
        String[] stringArray = new String[list.size()];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NO_FILES).append(DELIMITER1);
        stringBuffer.append(stringArray.length).append(DELIMITER);
        for (File file : list) {
            stringBuffer.append(MultipartHelper.constructEachFileHeaderValue(file));
        }
        return stringBuffer.toString();
    }

    static String constructFilesHeaderValue(MultiDataStream multiDataStream) throws IOException {
        Iterator iterator = multiDataStream.getDataStreams();
        boolean bl = iterator.hasNext();
        if (!bl) {
            throw new IllegalArgumentException("files list is empty");
        }
        String[] stringArray = new String[multiDataStream.getSize()];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NO_FILES).append(DELIMITER1);
        stringBuffer.append(stringArray.length).append(DELIMITER);
        while (iterator.hasNext()) {
            FileDataStream fileDataStream = (FileDataStream)iterator.next();
            stringBuffer.append(MultipartHelper.constructEachHeaderValue(fileDataStream));
        }
        return stringBuffer.toString();
    }

    static String constructFilesHeaderValue(String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(new File(stringArray[i]));
        }
        return MultipartHelper.constructFilesHeaderValue(arrayList);
    }

    private static String constructEachHeaderValue(FileDataStream fileDataStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = fileDataStream.getName();
        String string2 = fileDataStream.isZip() ? "application/zip" : "text/plain";
        String string3 = Long.toString(fileDataStream.getLength());
        stringBuffer.append(FILE_NAME).append(DELIMITER1);
        stringBuffer.append(string).append(DELIMITER);
        stringBuffer.append(FILE_TYPE).append(DELIMITER1);
        stringBuffer.append(string2).append(DELIMITER);
        stringBuffer.append(FILE_LENGTH).append(DELIMITER1);
        stringBuffer.append(string3).append(DELIMITER);
        return stringBuffer.toString();
    }

    private static String constructEachFileHeaderValue(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(" File with name " + file.getName() + " does not exists");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(" File with name " + file.getName() + " is not a file");
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = file.getName();
        String string2 = string.endsWith(".jar") ? "application/zip" : "text/plain";
        String string3 = Long.toString(file.length());
        stringBuffer.append(FILE_NAME).append(DELIMITER1);
        stringBuffer.append(string).append(DELIMITER);
        stringBuffer.append(FILE_TYPE).append(DELIMITER1);
        stringBuffer.append(string2).append(DELIMITER);
        stringBuffer.append(FILE_LENGTH).append(DELIMITER1);
        stringBuffer.append(string3).append(DELIMITER);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = MultipartHelper.constructFilesHeaderValue(stringArray);
        MultipartHelper.debugSay("filesHeaderValue : " + string);
        MultipartHelper.parseFilesHeader(string);
    }

    private static boolean isDebugEnabled() {
        return Debug.isServiceHttpDebugEnabled();
    }

    private static void debugSay(String string) {
        Debug.serviceHttpDebug(" +++ " + string);
    }

    static class FileInfo {
        private String name;
        private String type;
        private long length;

        FileInfo() {
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            return this.length;
        }

        public void setType(String string) {
            this.type = string;
        }

        public boolean isZip() {
            return this.type.equals("application/zip");
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setSize(long l) {
            this.length = l;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("FileInfo(");
            stringBuffer.append("name=").append(this.name).append(",");
            stringBuffer.append("type=").append(this.type).append(",");
            stringBuffer.append("length=").append(this.length);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

