/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.datatransferhandlers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.security.AccessController;
import java.util.Locale;
import weblogic.deploy.common.Debug;
import weblogic.deploy.common.DeploymentConstants;
import weblogic.deploy.service.FileDataStream;
import weblogic.deploy.service.MultiDataStream;
import weblogic.deploy.service.datatransferhandlers.DataStreamFactory;
import weblogic.deploy.service.datatransferhandlers.MultipartHelper;
import weblogic.management.DomainDir;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class MultipartParser
implements DeploymentConstants {
    private static final int DEFAULT_MAX_POST_SIZE = 0x40000000;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private HttpURLConnection connection;
    private File dir;
    private int maxSize;
    private MultiDataStream streams = null;

    public MultipartParser(HttpURLConnection httpURLConnection, String string) throws IOException {
        this(httpURLConnection, string, 0x40000000);
    }

    public MultipartParser(HttpURLConnection httpURLConnection, String string, int n) throws IOException {
        if (httpURLConnection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        this.connection = httpURLConnection;
        this.maxSize = n;
        String string2 = DomainDir.getTempDirForServer((String)ManagementService.getPropertyService(kernelId).getServerName());
        this.dir = string != null ? new File(string2, string) : new File(string2);
        boolean bl = this.dir.exists();
        if (!bl) {
            bl = this.dir.mkdirs();
        }
        if (!bl) {
            throw new IllegalArgumentException("Could not create dir: " + this.dir);
        }
        if (!this.dir.isDirectory()) {
            throw new IllegalArgumentException("Not a dir: " + this.dir);
        }
        if (!this.dir.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + this.dir);
        }
        this.parseResponse();
    }

    MultiDataStream getMultiDataStream() {
        return this.streams;
    }

    private void parseResponse() throws IOException {
        int n = this.connection.getContentLength();
        if (n < 0) {
            throw new IOException("Posted content doesn't set it's Content-Length");
        }
        if (n > this.maxSize) {
            throw new IOException("Posted content exceeds max post size");
        }
        String string = this.connection.getContentType();
        if (string == null || !string.toLowerCase(Locale.US).startsWith("multipart/mixed")) {
            throw new IOException("Posted content type isn't multipart/x-mixed-replace");
        }
        String string2 = this.connection.getHeaderField("files_header");
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid files_header value");
        }
        MultipartHelper.FileInfo[] fileInfoArray = MultipartHelper.parseFilesHeader(string2);
        if (fileInfoArray == null || fileInfoArray.length == 0) {
            throw new IllegalArgumentException("No files to be read");
        }
        this.streams = this.readFiles(fileInfoArray, this.connection.getInputStream());
    }

    private MultiDataStream readFiles(MultipartHelper.FileInfo[] fileInfoArray, InputStream inputStream) throws IOException {
        MultiDataStream multiDataStream = DataStreamFactory.createMultiDataStream();
        for (int i = 0; i < fileInfoArray.length; ++i) {
            multiDataStream.addDataStream(this.readFile(fileInfoArray[i], inputStream));
        }
        return multiDataStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FileDataStream readFile(MultipartHelper.FileInfo fileInfo, InputStream inputStream) throws IOException {
        String string;
        File file;
        File file2;
        BufferedOutputStream bufferedOutputStream = null;
        int n = (int)fileInfo.getSize();
        if (Debug.isServiceHttpDebugEnabled()) {
            Debug.serviceDebug(" Reading file '" + fileInfo.getName() + "' with length : " + n);
        }
        if ((file2 = (file = File.createTempFile("wl_comp", string = fileInfo.isZip() ? ".jar" : ".txt", this.dir)).getParentFile()) != null) {
            boolean bl = file2.exists();
            if (!bl) {
                bl = file2.mkdirs();
            }
            if (!bl) {
                throw new IOException("Cannot create parent dir for '" + file.getAbsolutePath());
            }
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 8192);
            byte[] byArray = new byte[8192];
            int n2 = n < byArray.length ? n : byArray.length;
            int n3 = 0;
            while (n3 != n) {
                int n4 = inputStream.read(byArray, 0, n2);
                if (n4 == -1) {
                    throw new IOException("Reached EOF");
                }
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n4);
                int n5 = n - (n3 += n4);
                n2 = n5 < byArray.length ? n5 : byArray.length;
            }
            ((OutputStream)bufferedOutputStream).flush();
            Object var14_14 = null;
            if (bufferedOutputStream == null) return MultipartParser.createDataStream(fileInfo, file);
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (bufferedOutputStream == null) throw throwable;
            try {
                ((OutputStream)bufferedOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((OutputStream)bufferedOutputStream).close();
            return MultipartParser.createDataStream(fileInfo, file);
        }
        catch (IOException iOException) {}
        return MultipartParser.createDataStream(fileInfo, file);
    }

    private static FileDataStream createDataStream(final MultipartHelper.FileInfo fileInfo, final File file) {
        return new FileDataStream(){

            public String getName() {
                String string = fileInfo.getName();
                if (string == null || string.length() == 0) {
                    return file.getName();
                }
                return string;
            }

            public File getFile() {
                return file;
            }

            public int getLength() throws IOException {
                this.validateFile();
                return (int)file.length();
            }

            public boolean isZip() {
                return fileInfo.isZip();
            }

            public InputStream getInputStream() throws IOException {
                this.validateFile();
                return new FileInputStream(file);
            }

            public void close() {
                boolean bl = file.delete();
                if (Debug.isServiceHttpDebugEnabled()) {
                    if (bl) {
                        Debug.serviceDebug("Successfully deleted temp file : " + file.getAbsolutePath());
                    } else {
                        Debug.serviceDebug("Could not delete temp file : " + file.getAbsolutePath());
                    }
                }
            }

            private void validateFile() throws IOException {
                if (!file.exists()) {
                    throw new IOException("File '" + file.getAbsolutePath() + "' does not exist");
                }
            }
        };
    }
}

