/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.datatransferhandlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import weblogic.deploy.service.DataStream;
import weblogic.deploy.service.FileDataStream;
import weblogic.deploy.service.MultiDataStream;
import weblogic.deploy.service.datatransferhandlers.MultipartHelper;

public class MultipartResponse {
    HttpServletResponse res;
    ServletOutputStream out;
    MultiDataStream multiStream = null;

    public MultipartResponse(HttpServletResponse httpServletResponse, MultiDataStream multiDataStream) throws IOException {
        this.res = httpServletResponse;
        this.out = this.res.getOutputStream();
        this.multiStream = multiDataStream;
        this.init();
    }

    private void init() throws IOException {
        this.setupMultiFileResponse();
    }

    private void setupSingleFileResponse() throws IOException {
        DataStream dataStream = (DataStream)this.multiStream.getDataStreams().next();
        this.res.setContentType(dataStream.isZip() ? "application/zip" : "text/plain");
        this.res.setContentLength(((FileDataStream)dataStream).getLength());
    }

    private void setupMultiFileResponse() throws IOException {
        this.res.setContentType("multipart/mixed");
        int n = 0;
        Iterator iterator = this.multiStream.getDataStreams();
        while (iterator.hasNext()) {
            n += ((FileDataStream)iterator.next()).getLength();
        }
        this.res.setContentLength(n);
        String string = MultipartHelper.constructFilesHeaderValue(this.multiStream);
        this.res.setHeader("files_header", string);
    }

    public void write() throws IOException {
        this.res.setStatus(200);
        Iterator iterator = this.multiStream.getDataStreams();
        while (iterator.hasNext()) {
            DataStream dataStream = (DataStream)iterator.next();
            this.writeDataStream(dataStream);
        }
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeDataStream(DataStream dataStream) throws IOException {
        InputStream inputStream = null;
        try {
            int n;
            inputStream = dataStream.getInputStream();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                this.out.write(byArray, 0, n);
            }
            Object var6_5 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }
}

