/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.datatransferhandlers;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import weblogic.application.utils.EarUtils;
import weblogic.deploy.common.DeploymentConstants;
import weblogic.deploy.service.FileDataStream;
import weblogic.deploy.service.MultiDataStream;
import weblogic.deploy.service.datatransferhandlers.DataStreamFactory;
import weblogic.j2ee.J2EEUtils;
import weblogic.logging.Loggable;
import weblogic.management.DomainDir;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.FileUtils;
import weblogic.utils.jars.JarFileUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class SourceCache
implements DeploymentConstants {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String CONFIG_DIR_PREFIX = DomainDir.getRootDir() + File.separator + "config" + File.separator;
    private String appName = null;
    private File tempDirectory;
    private File rootDirectory;
    private String sourcePath = null;
    private String planPath = null;
    private String planDir = null;
    private String altDDPath = null;
    private String altWLDDPath = null;
    private boolean isSrcArchive = false;
    private boolean isSystemResource = false;
    private boolean isStandaloneModule = false;
    private HashMap jarCache = new HashMap();
    private static HashMap sourceCacheMap = new HashMap();

    public SourceCache(BasicDeploymentMBean basicDeploymentMBean, File file) throws IOException {
        this.appName = basicDeploymentMBean.getName();
        this.tempDirectory = new File(file, "_WL_TEMP_APP_DOWNLOADS" + File.separator + this.appName);
        boolean bl = this.tempDirectory.exists();
        if (!bl) {
            bl = this.tempDirectory.mkdirs();
        }
        if (!bl) {
            throw new IOException("Could not create temp location for application : " + this.appName);
        }
        if (basicDeploymentMBean instanceof AppDeploymentMBean) {
            AppDeploymentMBean appDeploymentMBean = (AppDeploymentMBean)basicDeploymentMBean;
            this.sourcePath = appDeploymentMBean.getAbsoluteSourcePath();
            this.rootDirectory = new File(this.sourcePath);
            this.planPath = appDeploymentMBean.getAbsolutePlanPath();
            this.planDir = appDeploymentMBean.getAbsolutePlanDir();
            this.altDDPath = appDeploymentMBean.getAltDescriptorPath();
            this.altWLDDPath = appDeploymentMBean.getAltWLSDescriptorPath();
            File file2 = new File(this.sourcePath);
            if (!file2.exists()) {
                throw new IOException("Invalid source path : " + file2.getAbsolutePath());
            }
            if (file2.isFile()) {
                if (J2EEUtils.isValidArchiveName(file2.getName())) {
                    this.isSrcArchive = true;
                } else if (J2EEUtils.isValidWLSModuleName(file2.getName())) {
                    this.isStandaloneModule = true;
                }
            }
        } else {
            this.sourcePath = new StringBuffer().append(CONFIG_DIR_PREFIX).append(((SystemResourceMBean)basicDeploymentMBean).getDescriptorFileName()).toString();
            this.rootDirectory = new File(DomainDir.getConfigDir());
            this.isSystemResource = true;
        }
    }

    public MultiDataStream getDataLocations(List list, boolean bl, BasicDeploymentMBean basicDeploymentMBean) throws IOException {
        if (this.isSystemResource) {
            return this.getSystemResourceDataLocations(list);
        }
        return this.getAppDataLocations(list, bl, (AppDeploymentMBean)basicDeploymentMBean);
    }

    public MultiDataStream getAppDataLocationsForModuleIds(List list, AppDeploymentMBean appDeploymentMBean) throws IOException {
        if (list == null || list.isEmpty()) {
            throw new IOException("Empty ModuleIds list");
        }
        if (this.isSrcArchive) {
            String string = DeployerRuntimeLogger.logPartialRedeployOfArchiveLoggable((String)this.appName).getMessage();
            throw new IOException(string);
        }
        String[] stringArray = new String[list.size()];
        File[] fileArray = EarUtils.getAppFiles(stringArray = list.toArray(stringArray), appDeploymentMBean);
        if (fileArray == null || fileArray.length == 0) {
            throw new IOException("Container did not find file locations for moduleIds '" + list + "'");
        }
        MultiDataStream multiDataStream = DataStreamFactory.createMultiDataStream();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            if (SourceCache.verifyIfFileIsIn(fileArray[i], this.rootDirectory)) {
                String string = SourceCache.getFilePathRelativeTo(fileArray[i], this.rootDirectory);
                File file = new File(this.rootDirectory, string);
                if (file.isDirectory()) {
                    multiDataStream.addFileDataStream(string, new File(this.getOrCreateJarForURI(string)), true);
                    continue;
                }
                multiDataStream.addFileDataStream(string, file, J2EEUtils.isValidArchiveName(file.getName()));
                continue;
            }
            arrayList.add(fileArray[i]);
        }
        if (!arrayList.isEmpty()) {
            multiDataStream.addFileDataStream(this.getTempDescsFilePath(), true);
        }
        return multiDataStream;
    }

    public String toString() {
        return new StringBuffer().append("SourceCache(").append(this.appName).append(")").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HashMap hashMap = this.jarCache;
        synchronized (hashMap) {
            Iterator iterator = this.jarCache.values().iterator();
            if (iterator == null || !iterator.hasNext()) {
                return;
            }
            while (iterator.hasNext()) {
                File file;
                String string = (String)iterator.next();
                if (string == null || !(file = new File(string)).exists()) continue;
                file.delete();
            }
            this.jarCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateCache(BasicDeploymentMBean basicDeploymentMBean) {
        SourceCache sourceCache = null;
        HashMap hashMap = sourceCacheMap;
        synchronized (hashMap) {
            sourceCache = (SourceCache)sourceCacheMap.remove(basicDeploymentMBean.getName());
        }
        if (sourceCache != null) {
            sourceCache.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDescriptorsInCache(AppDeploymentMBean appDeploymentMBean) {
        SourceCache sourceCache = null;
        HashMap hashMap = sourceCacheMap;
        synchronized (hashMap) {
            sourceCache = (SourceCache)sourceCacheMap.get(appDeploymentMBean.getName());
        }
        if (sourceCache != null) {
            sourceCache.updateDescriptors(appDeploymentMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SourceCache getSourceCache(BasicDeploymentMBean basicDeploymentMBean) throws IOException {
        HashMap hashMap = sourceCacheMap;
        synchronized (hashMap) {
            SourceCache sourceCache = (SourceCache)sourceCacheMap.get(basicDeploymentMBean.getName());
            if (sourceCache == null) {
                if (SourceCache.isDebugEnabled()) {
                    SourceCache.debugSay("Creating new source cache for " + basicDeploymentMBean);
                }
                File file = new File(DomainDir.getTempDirForServer((String)ManagementService.getPropertyService(kernelId).getServerName()));
                sourceCache = new SourceCache(basicDeploymentMBean, file);
                sourceCacheMap.put(basicDeploymentMBean.getName(), sourceCache);
            }
            return sourceCache;
        }
    }

    private MultiDataStream getAppDataLocations(List list, boolean bl, AppDeploymentMBean appDeploymentMBean) throws IOException {
        boolean bl2 = list == null || list.isEmpty() || this.isStandaloneModule;
        MultiDataStream multiDataStream = DataStreamFactory.createMultiDataStream();
        if (bl2) {
            multiDataStream.addDataStream(this.getTempSrcLocation());
            String string = this.getTempDescsFilePath();
            if (string != null) {
                multiDataStream.addFileDataStream(string, true);
            }
            return multiDataStream;
        }
        if (SourceCache.isDebugEnabled()) {
            SourceCache.debugSay(" +++ isPlanUpdate: " + bl);
            SourceCache.debugSay(" +++ uris passed : " + list);
        }
        if (bl) {
            multiDataStream.addFileDataStream(this.getTempDescsFilePath(), true);
            return multiDataStream;
        }
        String[] stringArray = new String[list.size()];
        stringArray = list.toArray(stringArray);
        SourceCache.validateDelta(stringArray, appDeploymentMBean);
        for (String string : list) {
            File file = new File(this.rootDirectory, string);
            if (file.isDirectory()) {
                multiDataStream.addFileDataStream(string, new File(this.getOrCreateJarForURI(string)), true);
                continue;
            }
            multiDataStream.addFileDataStream(string, file, J2EEUtils.isValidArchiveName(file.getName()));
        }
        return multiDataStream;
    }

    private static boolean isDebugEnabled() {
        return weblogic.deploy.common.Debug.isServiceHttpDebugEnabled();
    }

    private static void debugSay(String string) {
        weblogic.deploy.common.Debug.serviceHttpDebug(" +++ " + string);
    }

    private MultiDataStream getSystemResourceDataLocations(List list) throws IOException {
        Debug.assertion((boolean)this.isSystemResource);
        MultiDataStream multiDataStream = DataStreamFactory.createMultiDataStream();
        File file = new File(this.sourcePath);
        Debug.assertion((boolean)file.exists());
        multiDataStream.addFileDataStream(SourceCache.getRootPath(this.rootDirectory, file) + file.getName(), file, false);
        return multiDataStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrCreateJarForURI(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new AssertionError((Object)"URI cannot be null");
        }
        File file = this.rootDirectory;
        File file2 = new File(file, string);
        String string2 = null;
        HashMap hashMap = this.jarCache;
        synchronized (hashMap) {
            File file3;
            string2 = (String)this.jarCache.get(string);
            if (string2 != null && (file3 = new File(string2)).exists() && file3.lastModified() >= FileUtils.getLastModified((File)file2)) {
                return string2;
            }
            this.jarCache.remove(string);
            file3 = File.createTempFile("wl_comp", ".jar", this.tempDirectory);
            file3.deleteOnExit();
            JarFileUtils.createJarFileFromDirectory((File)file3, (File)file2, (boolean)false);
            string2 = file3.getAbsolutePath();
            this.jarCache.put(string, string2);
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDataStream getTempSrcLocation() throws IOException {
        File file = new File(this.sourcePath);
        if (this.isSrcArchive) {
            if (SourceCache.isDebugEnabled()) {
                SourceCache.debugSay("originalSrcFile : " + file.getAbsolutePath());
            }
            return DataStreamFactory.createFileDataStream(file.getName(), file, true);
        }
        if (!file.isDirectory()) {
            if (SourceCache.isDebugEnabled()) {
                SourceCache.debugSay("originalSrcFile : " + file.getAbsolutePath());
            }
            return DataStreamFactory.createFileDataStream("wl_app_src.jar", file, false);
        }
        HashMap hashMap = this.jarCache;
        synchronized (hashMap) {
            long l;
            long l2;
            File file2;
            String string = (String)this.jarCache.get("wl_app_src.jar");
            if (string != null && string.length() != 0 && (file2 = new File(string)).exists() && (l2 = file2.lastModified()) >= (l = FileUtils.getLastModified((File)file))) {
                if (SourceCache.isDebugEnabled()) {
                    SourceCache.debugSay("srcPath '" + this.sourcePath + "' not modified." + " returning : " + string);
                }
                return DataStreamFactory.createFileDataStream(file2, true);
            }
            if (SourceCache.isDebugEnabled()) {
                SourceCache.debugSay("srcPath '" + this.sourcePath + "' modified. re-constructing temp jar");
            }
            file2 = new File(this.tempDirectory, "wl_app_src.jar");
            JarFileUtils.createJarFileFromDirectory((File)file2, (File)file, (boolean)false);
            file2.deleteOnExit();
            string = file2.getAbsolutePath();
            this.jarCache.put("wl_app_src.jar", string);
            return DataStreamFactory.createFileDataStream(file2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTempDescsFilePath() throws IOException {
        if (this.planDir == null && this.planPath == null && this.altDDPath == null && this.altWLDDPath == null) {
            return null;
        }
        HashMap hashMap = this.jarCache;
        synchronized (hashMap) {
            File[] fileArray;
            String string = (String)this.jarCache.get("wl_app_desc.jar");
            if (string != null && string.length() != 0 && !this.areDescsModified(string)) {
                if (SourceCache.isDebugEnabled()) {
                    SourceCache.debugSay("descriptors not modified. returning : " + string);
                }
                return string;
            }
            if (SourceCache.isDebugEnabled()) {
                SourceCache.debugSay("descriptors modified. Re-constructing temp jar for descs");
            }
            File file = FileUtils.createTempDir((String)"DESC_DIR", (File)this.tempDirectory);
            File file2 = new File(file, "plan");
            if (this.planDir != null && this.planDir.length() != 0) {
                FileUtils.copyPreserveTimestamps((File)new File(this.planDir), (File)file2);
            }
            if (this.planPath != null && this.planPath.length() != 0) {
                boolean bl = file2.exists();
                if (!bl) {
                    bl = file2.mkdirs();
                }
                if (!bl) {
                    throw new IOException("Could not create temp location for planDir");
                }
                FileUtils.copyPreserveTimestamps((File)new File(this.planPath), (File)file2);
            }
            if (this.altDDPath != null && this.altDDPath.length() != 0) {
                FileUtils.copyPreserveTimestamps((File)new File(this.altDDPath), (File)file);
            }
            if (this.altWLDDPath != null && this.altWLDDPath.length() != 0) {
                FileUtils.copyPreserveTimestamps((File)new File(this.altWLDDPath), (File)file);
            }
            if ((fileArray = file.listFiles()) == null || fileArray.length == 0) {
                return null;
            }
            File file3 = new File(this.tempDirectory, "wl_app_desc.jar");
            JarFileUtils.createJarFileFromDirectory((File)file3, (File)file, (boolean)false);
            file3.deleteOnExit();
            FileUtils.remove((File)file);
            string = file3.getAbsolutePath();
            this.jarCache.put("wl_app_desc.jar", string);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areFilesPartOfSrc(List list) throws IOException {
        boolean bl;
        VirtualJarFile virtualJarFile = null;
        try {
            virtualJarFile = VirtualJarFactory.createVirtualJar((File)new File(this.sourcePath));
            for (String string : list) {
                Iterator iterator = virtualJarFile.getEntries(string);
                if (!iterator.hasNext()) break block10;
                bl = true;
                Object var8_7 = null;
                if (virtualJarFile == null) break block11;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (virtualJarFile != null) {
                try {
                    virtualJarFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        {
            block10: {
                block11: {
                    try {
                        virtualJarFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return bl;
            }
            continue;
        }
        Object var8_8 = null;
        if (virtualJarFile != null) {
            try {
                virtualJarFile.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDescriptors(AppDeploymentMBean appDeploymentMBean) {
        Debug.assertion((!this.isSystemResource ? 1 : 0) != 0);
        this.planPath = appDeploymentMBean.getAbsolutePlanPath();
        this.planDir = appDeploymentMBean.getAbsolutePlanDir();
        this.altDDPath = appDeploymentMBean.getAltDescriptorPath();
        this.altWLDDPath = appDeploymentMBean.getAltWLSDescriptorPath();
        HashMap hashMap = this.jarCache;
        synchronized (hashMap) {
            File file;
            String string = (String)this.jarCache.remove("wl_app_desc.jar");
            if (string != null && (file = new File(string)).exists()) {
                file.delete();
            }
        }
    }

    private boolean areDescsModified(String string) {
        if (this.planDir == null && this.planPath == null && this.altDDPath == null && this.altWLDDPath == null) {
            return false;
        }
        if (string == null) {
            return true;
        }
        File file = new File(string);
        if (!file.exists()) {
            return true;
        }
        long l = FileUtils.getLastModified((File)file);
        long l2 = this.getLastModifiedForDescs();
        return l2 > l;
    }

    private long getLastModifiedForDescs() {
        long[] lArray = new long[]{SourceCache.getLastModifiedForPath(this.planDir), SourceCache.getLastModifiedForPath(this.planPath), SourceCache.getLastModifiedForPath(this.altDDPath), SourceCache.getLastModifiedForPath(this.altWLDDPath)};
        long l = 0L;
        for (int i = 0; i < lArray.length; ++i) {
            long l2 = lArray[i];
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    private static long getLastModifiedForPath(String string) {
        File file;
        long l = 0L;
        if (string != null && (file = new File(string)).exists()) {
            l = FileUtils.getLastModified((File)file);
        }
        return l;
    }

    private static String getRootPath(File file, File file2) throws IOException {
        int n;
        String string = file.getCanonicalPath();
        if (SourceCache.isDebugEnabled()) {
            SourceCache.debugSay(" +++ baseLocation : " + string);
        }
        String string2 = file2.getCanonicalPath();
        if (SourceCache.isDebugEnabled()) {
            SourceCache.debugSay(" +++ givenURI : " + string2);
        }
        if ((n = string2.indexOf(string)) == -1) {
            throw new AssertionError((Object)("uri '" + string2 + "' is not sub dir of" + "'" + string + "'"));
        }
        String string3 = string2.substring(string.length() + 1, string2.indexOf(file2.getName()));
        if (SourceCache.isDebugEnabled()) {
            SourceCache.debugSay(" +++ rootPath : " + string3);
        }
        return string3;
    }

    private static String getFilePathRelativeTo(File file, File file2) throws IOException {
        String string;
        if (file == null || !file.exists()) {
            throw new IOException("Source is null or doesnot exist");
        }
        if (file2 == null || !file2.exists()) {
            throw new IOException("Root directory is null or doesnot exist");
        }
        String string2 = file.getCanonicalPath();
        if (!string2.startsWith(string = file2.getCanonicalPath())) {
            throw new IOException("SourcePath '" + string2 + "' does not start with '" + string + "'");
        }
        String string3 = string2.substring(string.length() + 1);
        return string3;
    }

    private static boolean verifyIfFileIsIn(File file, File file2) throws IOException {
        if (file == null || !file.exists()) {
            throw new IOException("Source is null or doesnot exist");
        }
        if (file2 == null || !file2.exists()) {
            throw new IOException("Root directory is null or doesnot exist");
        }
        if (!file2.isDirectory()) {
            throw new IOException("Root File is not a directory");
        }
        try {
            File file3;
            File file4 = file2.getCanonicalFile();
            File file5 = file;
            while ((file3 = file5.getParentFile()) != null) {
                if ((file3 = file3.getCanonicalFile()).equals(file4)) {
                    return true;
                }
                file5 = file5.getParentFile();
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static File[] validateDelta(String[] stringArray, AppDeploymentMBean appDeploymentMBean) throws IOException {
        if (stringArray == null) {
            return null;
        }
        File file = new File(appDeploymentMBean.getAbsoluteSourcePath());
        if (!file.isDirectory()) {
            Loggable loggable = DeployerRuntimeLogger.logPartialRedeployOfArchiveLoggable((String)appDeploymentMBean.getName());
            throw new IOException(loggable.getMessage());
        }
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (!file2.exists()) {
                Loggable loggable = DeployerRuntimeLogger.invalidDeltaLoggable((String)stringArray[i], (String)appDeploymentMBean.getApplicationName());
                throw new IOException(loggable.getMessage());
            }
            arrayList.add(file2);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }
}

