/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import weblogic.deploy.service.ChangeDescriptor;
import weblogic.deploy.service.Deployment;
import weblogic.deploy.service.Version;

public abstract class BaseDeploymentImpl
implements Deployment {
    private String identity;
    private String callbackHandlerId;
    private Version proposedVersion;
    private ArrayList targets;
    private ArrayList serversToBeStarted;
    private String dataTransferHandlerType;
    private ArrayList changeDescriptors;

    protected BaseDeploymentImpl() {
    }

    protected BaseDeploymentImpl(String string, String string2, Version version2, List list, List list2, String string3, List list3) {
        this.setIdentity(string);
        this.setCallbackHandlerId(string2);
        this.setProposedVersion(version2);
        this.setTargets(list);
        this.setServersToBeRestarted(list2);
        this.setDataTransferHandlerType(string3);
        this.setChangeDescriptors(list3);
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final void setIdentity(String string) {
        this.identity = string;
    }

    public final String getCallbackHandlerId() {
        return this.callbackHandlerId;
    }

    public final void setCallbackHandlerId(String string) {
        this.callbackHandlerId = string;
    }

    public final Version getProposedVersion() {
        return this.proposedVersion;
    }

    public final void setProposedVersion(Version version2) {
        this.proposedVersion = version2;
    }

    public final String[] getTargets() {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        String[] stringArray = new String[this.targets.size()];
        stringArray = this.targets.toArray(stringArray);
        return stringArray;
    }

    public final void setTargets(List list) {
        this.targets = new ArrayList();
        if (list != null) {
            this.targets.addAll(list);
        }
    }

    public final void addTarget(String string) {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        this.targets.add(string);
    }

    public final void removeTarget(String string) {
        if (this.targets != null) {
            this.targets.remove(string);
        }
    }

    public final String[] getServersToBeRestarted() {
        if (this.serversToBeStarted == null) {
            this.serversToBeStarted = new ArrayList();
        }
        String[] stringArray = new String[this.serversToBeStarted.size()];
        stringArray = this.serversToBeStarted.toArray(stringArray);
        return stringArray;
    }

    public final void setServersToBeRestarted(List list) {
        this.serversToBeStarted = new ArrayList();
        if (list != null) {
            this.serversToBeStarted.addAll(list);
        }
    }

    public final void addServerToBeRestarted(String string) {
        if (this.serversToBeStarted == null) {
            this.serversToBeStarted = new ArrayList();
        }
        this.serversToBeStarted.add(string);
    }

    public final void removeServerToBeRestarted(String string) {
        if (this.serversToBeStarted != null) {
            this.serversToBeStarted.remove(string);
        }
    }

    public final String getDataTransferHandlerType() {
        return this.dataTransferHandlerType;
    }

    public final void setDataTransferHandlerType(String string) {
        this.dataTransferHandlerType = string;
    }

    public final List getChangeDescriptors() {
        if (this.changeDescriptors == null) {
            this.changeDescriptors = new ArrayList();
        }
        return this.changeDescriptors;
    }

    public final void setChangeDescriptors(List list) {
        this.changeDescriptors = new ArrayList();
        if (list != null) {
            this.changeDescriptors.addAll(list);
        }
    }

    public final void addChangeDescriptor(ChangeDescriptor changeDescriptor) {
        if (this.changeDescriptors == null) {
            this.changeDescriptors = new ArrayList();
        }
        this.changeDescriptors.add(changeDescriptor);
    }

    public final void removeChangeDescriptor(ChangeDescriptor changeDescriptor) {
        if (this.changeDescriptors != null) {
            this.changeDescriptors.remove(changeDescriptor);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.identity);
        objectOutput.writeObject(this.callbackHandlerId);
        objectOutput.writeObject(this.proposedVersion);
        ArrayList arrayList = this.targets == null || this.targets.isEmpty() ? null : this.targets;
        objectOutput.writeObject(arrayList);
        ArrayList arrayList2 = this.serversToBeStarted == null || this.serversToBeStarted.isEmpty() ? null : this.serversToBeStarted;
        objectOutput.writeObject(arrayList2);
        objectOutput.writeObject(this.dataTransferHandlerType);
        ArrayList arrayList3 = this.changeDescriptors == null || this.changeDescriptors.isEmpty() ? null : this.changeDescriptors;
        objectOutput.writeObject(arrayList3);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setIdentity((String)objectInput.readObject());
        this.setCallbackHandlerId((String)objectInput.readObject());
        this.setProposedVersion((Version)objectInput.readObject());
        this.setTargets((List)objectInput.readObject());
        this.setServersToBeRestarted((List)objectInput.readObject());
        this.setDataTransferHandlerType((String)objectInput.readObject());
        this.setChangeDescriptors((List)objectInput.readObject());
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("[");
        stringBuffer.append(this.toPrettyString()).append("]");
        return stringBuffer.toString();
    }

    protected String toPrettyString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("id: ");
        stringBuffer.append(this.getIdentity());
        stringBuffer.append(", callback id: ");
        stringBuffer.append(this.getCallbackHandlerId());
        String[] stringArray = this.getTargets();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(", target[");
                stringBuffer.append(i);
                stringBuffer.append("] = ");
                stringBuffer.append(stringArray[i]);
            }
        }
        if (this.getProposedVersion() != null) {
            stringBuffer.append(", proposedVersion: ");
            stringBuffer.append(this.getProposedVersion().toString());
        }
        return stringBuffer.toString();
    }
}

