/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal;

import java.io.PrintWriter;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.adminserver.DeploymentManager;
import weblogic.deploy.service.DeploymentRequest;
import weblogic.deploy.service.DeploymentRequestSubTask;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.DeploymentRequestTaskRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBeanDelegate;
import weblogic.management.runtime.TaskRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class DeploymentRequestTaskRuntimeMBeanImpl
extends DomainRuntimeMBeanDelegate
implements DeploymentRequestTaskRuntimeMBean {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final DeploymentRequest deploymentRequest;
    private static final String TASK_NAME_PREFIX = "DREQ-";
    private final String description;
    private final long taskId;
    private int state;
    private HashMap failedTargetsMap = new HashMap();
    private Map deploymentSubTasks = new HashMap();
    private Set serversToBeRestarted;
    private final long beginTime = System.currentTimeMillis();
    private Exception lastException;
    private long endTime;
    private boolean failedWhilePreparingToStart = false;
    private boolean allSubTasksCompleted = false;

    public DeploymentRequestTaskRuntimeMBeanImpl(String string, DeploymentRequest deploymentRequest) throws ManagementException {
        super(TASK_NAME_PREFIX + deploymentRequest.getId(), false);
        this.description = string;
        this.deploymentRequest = deploymentRequest;
        this.taskId = deploymentRequest.getId();
        this.state = 0;
    }

    private static final void debug(String string) {
        Debug.serviceDebug(string);
    }

    private static final boolean isDebugEnabled() {
        return Debug.isServiceDebugEnabled();
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getStatus() {
        switch (this.state) {
            case 0: {
                return "STATE_INITIALIZING";
            }
            case 1: {
                return "STATE_INPROGRESS";
            }
            case 2: {
                return "STATE_SUCCESS";
            }
            case 3: {
                return "STATE_FAILED";
            }
            case 4: {
                return "STATE_CANCEL_SCHEDULED";
            }
            case 5: {
                return "STATE_CANCEL_INPROGRESS";
            }
            case 6: {
                return "STATE_CANCEL_COMPLETED";
            }
            case 7: {
                return "STATE_CANCEL_FAILED";
            }
            case 8: {
                return "STATE_COMMIT_FAILED";
            }
        }
        return "STATE_UNKNOWN";
    }

    public final boolean isRunning() {
        if (this.getDeploymentRequestSubTasks().size() <= 0) {
            return true;
        }
        for (Map.Entry entry : this.deploymentSubTasks.entrySet()) {
            DeploymentRequestSubTask deploymentRequestSubTask = (DeploymentRequestSubTask)entry.getValue();
            if (!deploymentRequestSubTask.isRunning()) continue;
            return true;
        }
        return false;
    }

    public final boolean isComplete() {
        if (this.getDeploymentRequestSubTasks().size() <= 0) {
            return true;
        }
        for (Map.Entry entry : this.deploymentSubTasks.entrySet()) {
            DeploymentRequestSubTask deploymentRequestSubTask = (DeploymentRequestSubTask)entry.getValue();
            if (deploymentRequestSubTask.isComplete()) continue;
            return false;
        }
        return true;
    }

    public final long getBeginTime() {
        return this.beginTime;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public final void setEndTime() {
        this.endTime = System.currentTimeMillis();
    }

    public final TaskRuntimeMBean[] getSubTasks() {
        return (TaskRuntimeMBean[])this.getDeploymentRequestSubTasks().keySet().toArray();
    }

    public final TaskRuntimeMBean getParentTask() {
        return this;
    }

    public final void cancel() throws Exception {
        if (this.deploymentSubTasks == null || this.deploymentSubTasks.size() <= 0) {
            throw new ManagementException(DeploymentServiceLogger.logNoTaskToCancelLoggable().getMessage());
        }
        boolean bl = this.getState() == 0;
        this.setState(4);
        this.prepareSubTasksForCancel();
        if (bl) {
            DeploymentManager.getInstance(kernelId).deploymentRequestCancelledBeforeStart(this.deploymentRequest);
        } else {
            DeploymentService.getDeploymentService().cancel(this.deploymentRequest);
        }
    }

    public final void printLog(PrintWriter printWriter) {
    }

    public final synchronized Exception getError() {
        if (this.lastException != null) {
            return this.lastException;
        }
        if (this.getDeploymentRequestSubTasks().size() <= 0) {
            return this.lastException;
        }
        for (Map.Entry entry : this.deploymentSubTasks.entrySet()) {
            DeploymentRequestSubTask deploymentRequestSubTask = (DeploymentRequestSubTask)entry.getValue();
            if (deploymentRequestSubTask.getError() == null) continue;
            this.lastException = deploymentRequestSubTask.getError();
            break;
        }
        return this.lastException;
    }

    public final boolean isSystemTask() {
        return false;
    }

    public final void setSystemTask(boolean bl) {
    }

    public final long getTaskId() {
        return this.taskId;
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int n) {
        this.state = n;
    }

    public final synchronized Map getFailedTargets() {
        if (this.failedTargetsMap.size() > 0 || this.getDeploymentRequestSubTasks().size() <= 0) {
            if (DeploymentRequestTaskRuntimeMBeanImpl.isDebugEnabled()) {
                DeploymentRequestTaskRuntimeMBeanImpl.debug("getFailedTargets returning: " + this.failedTargetsMap);
            }
            return (HashMap)this.failedTargetsMap.clone();
        }
        for (Map.Entry entry : this.getDeploymentRequestSubTasks().entrySet()) {
            DeploymentRequestSubTask deploymentRequestSubTask = (DeploymentRequestSubTask)entry.getValue();
            Map map = deploymentRequestSubTask.getFailedTargets();
            if (map == null || map.size() <= 0) continue;
            for (Map.Entry entry2 : map.entrySet()) {
                String string = (String)entry2.getKey();
                if (this.failedTargetsMap.containsKey(string)) continue;
                Exception exception = (Exception)entry2.getValue();
                if (DeploymentRequestTaskRuntimeMBeanImpl.isDebugEnabled()) {
                    DeploymentRequestTaskRuntimeMBeanImpl.debug("getFailedTargets adding target '" + string + "' and failure: " + exception + " to failed targets map");
                }
                this.failedTargetsMap.put(string, exception);
            }
        }
        if (DeploymentRequestTaskRuntimeMBeanImpl.isDebugEnabled()) {
            DeploymentRequestTaskRuntimeMBeanImpl.debug("getFailedTargets returning: " + this.failedTargetsMap);
        }
        return this.failedTargetsMap;
    }

    public final synchronized void addFailedTarget(String string, Exception exception) {
        this.failedTargetsMap.put(string, exception);
        if (DeploymentRequestTaskRuntimeMBeanImpl.isDebugEnabled()) {
            DeploymentRequestTaskRuntimeMBeanImpl.debug("addFailedTargets adding target '" + string + "' and failure: " + exception + " to failed targets map");
        }
        this.lastException = exception;
    }

    private final Set getRestartSet() {
        if (this.serversToBeRestarted == null) {
            this.serversToBeRestarted = new HashSet();
        }
        return this.serversToBeRestarted;
    }

    public final synchronized String[] getServersToBeRestarted() {
        String[] stringArray = new String[]{};
        return this.getRestartSet().toArray(stringArray);
    }

    public final synchronized void addServerToRestartSet(String string) {
        this.getRestartSet().add(string);
    }

    public final DeploymentRequest getDeploymentRequest() {
        return this.deploymentRequest;
    }

    private final Map getDeploymentRequestSubTasks() {
        return this.deploymentSubTasks;
    }

    public final void addDeploymentRequestSubTask(DeploymentRequestSubTask deploymentRequestSubTask, String string) {
        this.getDeploymentRequestSubTasks().put(string, deploymentRequestSubTask);
        deploymentRequestSubTask.setMyParent(this);
    }

    public final void start() throws ManagementException {
        this.prepareSubTasksForStart();
        this.startTaskIfNecessary();
    }

    public final void unregisterIfNoSubTasks() {
        if (this.getDeploymentRequestSubTasks().isEmpty()) {
            try {
                if (DeploymentRequestTaskRuntimeMBeanImpl.isDebugEnabled()) {
                    DeploymentRequestTaskRuntimeMBeanImpl.debug("Unregistering DeploymentRequestTaskRuntimeMBean : " + this);
                }
                this.unregister();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private final void prepareSubTasksForStart() throws ManagementException {
        try {
            for (Map.Entry entry : this.getDeploymentRequestSubTasks().entrySet()) {
                DeploymentRequestSubTask deploymentRequestSubTask = (DeploymentRequestSubTask)entry.getValue();
                deploymentRequestSubTask.prepareToStart();
            }
        }
        catch (ManagementException managementException) {
            this.failedWhilePreparingToStart = true;
            try {
                this.cancel();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw managementException;
        }
    }

    private void startTaskIfNecessary() {
        if (this.getDeploymentRequestSubTasks().size() > 0) {
            this.allSubTasksCompleted = true;
        }
        this.lastException = null;
        this.checkForPreStartErrors();
        if (this.lastException != null) {
            this.setState(3);
        } else if (this.allSubTasksCompleted) {
            if (DeploymentRequestTaskRuntimeMBeanImpl.isDebugEnabled()) {
                DeploymentRequestTaskRuntimeMBeanImpl.debug("All sub tasks complete for task '" + this.taskId + "'" + " - transitioning task to STATE_SUCCESS");
            }
            this.setState(2);
        } else {
            this.setState(1);
            DeploymentService.getDeploymentService().startDeploy(this.deploymentRequest);
        }
    }

    private final void checkForPreStartErrors() {
        for (Map.Entry entry : this.deploymentSubTasks.entrySet()) {
            DeploymentRequestSubTask deploymentRequestSubTask = (DeploymentRequestSubTask)entry.getValue();
            if (deploymentRequestSubTask.isRunning()) {
                this.allSubTasksCompleted = false;
                continue;
            }
            this.lastException = deploymentRequestSubTask.getError();
            if (this.lastException == null) continue;
            String string = ManagementService.getRuntimeAccess(kernelId).getServerName();
            this.addFailedTarget(string, this.lastException);
            return;
        }
    }

    private final void prepareSubTasksForCancel() throws Exception {
        for (Map.Entry entry : this.deploymentSubTasks.entrySet()) {
            DeploymentRequestSubTask deploymentRequestSubTask = (DeploymentRequestSubTask)entry.getValue();
            boolean bl = this.failedWhilePreparingToStart ? !deploymentRequestSubTask.isComplete() : true;
            boolean bl2 = bl;
            if (!bl2) continue;
            deploymentRequestSubTask.prepareToCancel();
        }
    }
}

