/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.service.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import weblogic.deploy.common.Debug;
import weblogic.deploy.service.ChangeDescriptor;
import weblogic.deploy.service.ChangeDescriptorFactory;
import weblogic.deploy.service.DataTransferHandler;
import weblogic.deploy.service.DataTransferHandlerExistsException;
import weblogic.deploy.service.DataTransferHandlerManager;
import weblogic.deploy.service.DeploymentContext;
import weblogic.deploy.service.DeploymentProvider;
import weblogic.deploy.service.DeploymentProviderManager;
import weblogic.deploy.service.DeploymentReceiver;
import weblogic.deploy.service.DeploymentReceiversCoordinator;
import weblogic.deploy.service.DeploymentRequest;
import weblogic.deploy.service.DeploymentRequestFactory;
import weblogic.deploy.service.DeploymentServiceCallbackHandler;
import weblogic.deploy.service.DeploymentServiceOperations;
import weblogic.deploy.service.InvalidCreateChangeDescriptorException;
import weblogic.deploy.service.RegistrationException;
import weblogic.deploy.service.RegistrationExistsException;
import weblogic.deploy.service.RequiresTaskMediatedStartException;
import weblogic.deploy.service.StatusListener;
import weblogic.deploy.service.StatusListenerManager;
import weblogic.deploy.service.StatusRelayer;
import weblogic.deploy.service.Version;
import weblogic.deploy.service.datatransferhandlers.DataHandlerManager;
import weblogic.deploy.service.internal.DeploymentServiceLogger;
import weblogic.deploy.service.internal.adminserver.AdminDeploymentService;
import weblogic.deploy.service.internal.targetserver.TargetDeploymentService;
import weblogic.deploy.service.internal.transport.CommonMessageReceiver;
import weblogic.deploy.service.internal.transport.CommonMessageSender;
import weblogic.management.ManagementException;
import weblogic.management.runtime.DeploymentRequestTaskRuntimeMBean;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.work.WorkManagerFactory;

public final class DeploymentService
extends AbstractServerService
implements DataTransferHandlerManager,
DeploymentRequestFactory,
DeploymentServiceOperations,
DeploymentReceiversCoordinator,
ChangeDescriptorFactory,
DeploymentProviderManager,
StatusListenerManager,
StatusRelayer {
    private static DeploymentService singleton;
    private static final byte DEPLOYMENT_SERVICE_VERSION = 2;
    private final AdminDeploymentService adminDelegate;
    private final TargetDeploymentService targetDelegate;
    private CommonMessageSender messageSender = null;
    private CommonMessageReceiver messageReceiver = null;
    private final Map dataTransferHandlers = new HashMap();

    public DeploymentService() {
        singleton = this;
        this.adminDelegate = AdminDeploymentService.getDeploymentService();
        this.targetDelegate = TargetDeploymentService.getDeploymentService();
    }

    public static DeploymentService getDeploymentService() {
        return singleton;
    }

    public final CommonMessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public final CommonMessageSender getMessageSender() {
        return this.messageSender;
    }

    public static final byte getVersionByte() {
        return 2;
    }

    private static final void debug(String string) {
        Debug.serviceDebug(string);
    }

    private static final boolean isDebugEnabled() {
        return Debug.isServiceDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerDataTransferHandler(DataTransferHandler dataTransferHandler) throws DataTransferHandlerExistsException {
        String string = dataTransferHandler.getType();
        Map map = this.dataTransferHandlers;
        synchronized (map) {
            if (this.dataTransferHandlers.get(string) != null) {
                throw new DataTransferHandlerExistsException(DeploymentServiceLogger.logDataHandlerExistsLoggable((String)string).getMessage());
            }
            this.dataTransferHandlers.put(string, dataTransferHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DataTransferHandler getDataTransferHandler(String string) {
        Map map = this.dataTransferHandlers;
        synchronized (map) {
            return (DataTransferHandler)this.dataTransferHandlers.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getRegisteredDataTransferHandlerTypes() {
        Map map = this.dataTransferHandlers;
        synchronized (map) {
            String[] stringArray = (String[])this.dataTransferHandlers.keySet().toArray();
            return stringArray;
        }
    }

    public final DeploymentRequest createDeploymentRequest() throws ManagementException {
        return this.adminDelegate.createDeploymentRequest();
    }

    public final void register(Version version2, DeploymentServiceCallbackHandler deploymentServiceCallbackHandler) throws RegistrationExistsException {
        this.adminDelegate.register(version2, deploymentServiceCallbackHandler);
    }

    public final DeploymentRequestTaskRuntimeMBean deploy(DeploymentRequest deploymentRequest) throws RequiresTaskMediatedStartException {
        return this.adminDelegate.deploy(deploymentRequest);
    }

    public final DeploymentRequestTaskRuntimeMBean startDeploy(DeploymentRequest deploymentRequest) {
        return this.adminDelegate.startDeploy(deploymentRequest);
    }

    public final void cancel(DeploymentRequest deploymentRequest) {
        this.adminDelegate.cancel(deploymentRequest);
    }

    public final void unregister(String string) {
        this.adminDelegate.unregister(string);
    }

    public final DeploymentContext registerHandler(Version version2, DeploymentReceiver deploymentReceiver) throws RegistrationException {
        return this.targetDelegate.registerHandler(version2, deploymentReceiver);
    }

    public final void unregisterHandler(String string) {
        this.targetDelegate.unregisterHandler(string);
    }

    public final void notifyContextUpdated(final long l, final String string) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                DeploymentService.this.targetDelegate.notifyContextUpdated(l, string);
            }
        });
    }

    public final void notifyContextUpdateFailed(final long l, final String string, final Throwable throwable) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                DeploymentService.this.targetDelegate.notifyContextUpdateFailed(l, string, throwable);
            }
        });
    }

    public final void notifyPrepareSuccess(final long l, final String string) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                DeploymentService.this.targetDelegate.notifyPrepareSuccess(l, string);
            }
        });
    }

    public final void notifyPrepareFailure(final long l, final String string, final Throwable throwable) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                DeploymentService.this.targetDelegate.notifyPrepareFailure(l, string, throwable);
            }
        });
    }

    public final void notifyCommitSuccess(final long l, final String string) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                DeploymentService.this.targetDelegate.notifyCommitSuccess(l, string);
            }
        });
    }

    public final void notifyCommitFailure(final long l, final String string, final Throwable throwable) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                DeploymentService.this.targetDelegate.notifyCommitFailure(l, string, throwable);
            }
        });
    }

    public final void notifyCancelSuccess(final long l, final String string) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                DeploymentService.this.targetDelegate.notifyCancelSuccess(l, string);
            }
        });
    }

    public final void notifyCancelFailure(final long l, final String string, final Throwable throwable) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                DeploymentService.this.targetDelegate.notifyCancelFailure(l, string, throwable);
            }
        });
    }

    public final void notifyStatusUpdate(final long l, final String string, final Serializable serializable) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                DeploymentService.this.targetDelegate.notifyStatusUpdate(l, string, serializable);
            }
        });
    }

    public final ChangeDescriptor createChangeDescriptor(String string, String string2, String string3, Serializable serializable) throws InvalidCreateChangeDescriptorException {
        return this.adminDelegate.createChangeDescriptor(string, string2, string3, serializable);
    }

    public final ChangeDescriptor createChangeDescriptor(String string, String string2, String string3, Serializable serializable, String string4) throws InvalidCreateChangeDescriptorException {
        return this.adminDelegate.createChangeDescriptor(string, string2, string3, serializable, string4);
    }

    public final ChangeDescriptor createChangeDescriptor(Serializable serializable, Serializable serializable2) {
        return this.adminDelegate.createChangeDescriptor(serializable, serializable2);
    }

    public final void registerDeploymentProvider(DeploymentProvider deploymentProvider) {
        this.adminDelegate.registerDeploymentProvider(deploymentProvider);
    }

    public final Set getRegisteredDeploymentProviders() {
        return this.adminDelegate.getRegisteredDeploymentProviders();
    }

    public void registerStatusListener(String string, StatusListener statusListener) {
        this.adminDelegate.registerStatusListener(string, statusListener);
    }

    public void unregisterStatusListener(String string) {
        this.adminDelegate.unregisterStatusListener(string);
    }

    public void relayStatus(String string, Serializable serializable) {
        this.targetDelegate.relayStatus(string, serializable);
    }

    public void relayStatus(long l, String string, Serializable serializable) {
        this.targetDelegate.relayStatus(l, string, serializable);
    }

    public final void start() throws ServiceFailureException {
        block5: {
            if (DeploymentService.isDebugEnabled()) {
                DeploymentService.debug("Starting DeploymentService");
            }
            this.messageSender = CommonMessageSender.getInstance();
            this.messageReceiver = CommonMessageReceiver.getInstance();
            this.messageSender.getDelegate().setLoopbackReceiver(this.messageReceiver.getDelegate());
            try {
                this.registerDataTransferHandler(DataHandlerManager.getInstance().getHttpDataTransferHandler());
            }
            catch (DataTransferHandlerExistsException dataTransferHandlerExistsException) {
                if (!Debug.isServiceDebugEnabled()) break block5;
                Debug.serviceLogger.debug("Data transfer handler for Http already registered");
            }
        }
        if (this.adminDelegate != null) {
            this.adminDelegate.start();
        }
        if (this.targetDelegate != null) {
            this.targetDelegate.start();
        }
    }

    public final void stop() throws ServiceFailureException {
        if (DeploymentService.isDebugEnabled()) {
            DeploymentService.debug("Stopping DeploymentService");
        }
        if (this.adminDelegate != null) {
            this.adminDelegate.stop();
        }
        if (this.targetDelegate != null) {
            this.targetDelegate.stop();
        }
    }

    public final void halt() throws ServiceFailureException {
        if (DeploymentService.isDebugEnabled()) {
            DeploymentService.debug("Halting DeploymentService");
        }
        if (this.adminDelegate != null) {
            this.adminDelegate.halt();
        }
        if (this.targetDelegate != null) {
            this.targetDelegate.halt();
        }
    }
}

